/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import java.awt.image.WritableRaster;

final class ColorIndexingTransform
implements Transform {
    private final byte[] colorTable;
    private final byte bits;

    public ColorIndexingTransform(byte[] byArray, byte by) {
        this.colorTable = byArray;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n15 = writableRaster.getWidth();
        int n16 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int i15 = 0; i15 < n16; ++i15) {
            for (int i16 = n15 - 1; i16 >= 0; --i16) {
                int n17 = 8 >> this.bits;
                int n18 = 1 << this.bits;
                int n19 = i16 / n18;
                int n25 = n17 * (i16 % n18);
                int n26 = writableRaster.getSample(n19, i15, 1);
                int n27 = n26 >> n25 & (1 << n17) - 1;
                System.arraycopy(this.colorTable, n27 * 4, byArray, 0, 4);
                writableRaster.setDataElements(i16, i15, byArray);
            }
        }
    }
}

