/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class ColorTransform
implements Transform {
    private final Raster data;
    private final byte bits;

    public ColorTransform(Raster raster, byte by) {
        this.data = raster;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n15 = writableRaster.getWidth();
        int n16 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int i15 = 0; i15 < n16; ++i15) {
            for (int i16 = 0; i16 < n15; ++i16) {
                this.data.getDataElements(i16 >> this.bits, i15 >> this.bits, byArray);
                ColorTransformElement colorTransformElement = new ColorTransformElement(byArray);
                writableRaster.getDataElements(i16, i15, byArray);
                colorTransformElement.inverseTransform(byArray);
                writableRaster.setDataElements(i16, i15, byArray);
            }
        }
    }

    private static void colorTransform(int n15, int n16, int n17, ColorTransformElement colorTransformElement, int[] nArray) {
        int n18 = n15;
        int n19 = n16;
        n19 += ColorTransform.colorTransformDelta((byte)colorTransformElement.green_to_blue, (byte)n17);
        nArray[0] = (n18 += ColorTransform.colorTransformDelta((byte)colorTransformElement.green_to_red, (byte)n17)) & 0xFF;
        nArray[1] = (n19 += ColorTransform.colorTransformDelta((byte)colorTransformElement.red_to_blue, (byte)n15)) & 0xFF;
    }

    private static byte colorTransformDelta(byte by, byte by4) {
        return (byte)(by * by4 >> 5);
    }

    private static final class ColorTransformElement {
        final int green_to_red;
        final int green_to_blue;
        final int red_to_blue;

        ColorTransformElement(byte[] byArray) {
            this.green_to_red = byArray[2];
            this.green_to_blue = byArray[1];
            this.red_to_blue = byArray[0];
        }

        private void inverseTransform(byte[] byArray) {
            int n15 = byArray[0];
            int n16 = byArray[2];
            n16 += ColorTransform.colorTransformDelta((byte)this.green_to_blue, byArray[1]);
            byArray[0] = (byte)(n15 & 0xFF);
            byArray[2] = (byte)((n16 += ColorTransform.colorTransformDelta((byte)this.red_to_blue, (byte)(n15 += ColorTransform.colorTransformDelta((byte)this.green_to_red, byArray[1])))) & 0xFF);
        }
    }
}

