/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.Win32File;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

final class Win32Lnk
extends File {
    private static final byte[] LNK_MAGIC = new byte[]{76, 0, 0, 0};
    private static final byte[] LNK_GUID = new byte[]{1, 20, 2, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    private final File target;
    private static final int FLAG_ITEM_ID_LIST = 1;
    private static final int FLAG_FILE_LOC_INFO = 2;
    private static final int FLAG_DESC_STRING = 4;
    private static final int FLAG_REL_PATH_STRING = 8;
    private static final int FLAG_WORKING_DIRECTORY = 16;
    private static final int FLAG_COMMAND_LINE_ARGS = 32;
    private static final int FLAG_ICON_FILENAME = 64;
    private static final int FLAG_ADDITIONAL_INFO = 128;

    private Win32Lnk(String string) throws IOException {
        super(string);
        File file2 = Win32Lnk.parse(this);
        if (file2 == this) {
            file2 = new File(string);
        }
        this.target = file2;
    }

    Win32Lnk(File file2) throws IOException {
        this(file2.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File parse(File file2) throws IOException {
        if (!file2.getName().endsWith(".lnk")) {
            return file2;
        }
        File file3 = file2;
        try (LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
            int n15;
            byte[] byArray = new byte[4];
            littleEndianDataInputStream.readFully(byArray);
            byte[] byArray2 = new byte[16];
            littleEndianDataInputStream.readFully(byArray2);
            if (!Arrays.equals(LNK_MAGIC, byArray) || !Arrays.equals(LNK_GUID, byArray2)) {
                File file4 = file2;
                return file4;
            }
            int n16 = littleEndianDataInputStream.readInt();
            littleEndianDataInputStream.readInt();
            littleEndianDataInputStream.skipBytes(48);
            if ((n16 & 1) != 0) {
                n15 = littleEndianDataInputStream.readShort();
                littleEndianDataInputStream.skipBytes(n15);
            }
            if ((n16 & 2) != 0) {
                n15 = littleEndianDataInputStream.readInt();
                littleEndianDataInputStream.readInt();
                int n17 = littleEndianDataInputStream.readInt();
                if ((n17 & 1) != 0) {
                    // empty if block
                }
                if ((n17 & 2) != 0) {
                    // empty if block
                }
                littleEndianDataInputStream.skipBytes(4);
                int n18 = littleEndianDataInputStream.readInt();
                littleEndianDataInputStream.skipBytes(n18 - 20);
                byte[] byArray3 = new byte[n15 - n18 - 1];
                littleEndianDataInputStream.readFully(byArray3, 0, byArray3.length);
                String string = new String(byArray3, 0, byArray3.length - 1);
                try {
                    file3 = Win32Lnk.parse(new File(string));
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new IOException("Cannot resolve cyclic link: " + stackOverflowError.getMessage());
                }
            }
            if ((n16 & 4) != 0) {
                n15 = littleEndianDataInputStream.readShort();
                byte[] byArray4 = new byte[n15];
                littleEndianDataInputStream.readFully(byArray4, 0, n15);
            }
            if ((n16 & 8) != 0) {
                n15 = littleEndianDataInputStream.readShort();
                byte[] byArray5 = new byte[n15];
                littleEndianDataInputStream.readFully(byArray5, 0, n15);
                String string = new String(byArray5, 0, n15);
                if (file3 == file2) {
                    try {
                        file3 = Win32Lnk.parse(new File(file2.getParentFile(), string));
                    }
                    catch (StackOverflowError stackOverflowError) {
                        throw new IOException("Cannot resolve cyclic link: " + stackOverflowError.getMessage());
                    }
                }
            }
            if ((n16 & 0x10) != 0) {
                // empty if block
            }
            if ((n16 & 0x20) != 0) {
                file3 = file2;
            }
            if ((n16 & 0x40) != 0) {
                // empty if block
            }
            if ((n16 & 0x80) != 0) {
                // empty if block
            }
        }
        return file3;
    }

    public File getTarget() {
        return this.target;
    }

    @Override
    public boolean isDirectory() {
        return this.target.isDirectory();
    }

    @Override
    public boolean canRead() {
        return this.target.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.target.canWrite();
    }

    @Override
    public boolean exists() {
        return this.target.exists();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.target.getCanonicalFile();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.target.getCanonicalPath();
    }

    @Override
    public boolean isFile() {
        return this.target.isFile();
    }

    @Override
    public boolean isHidden() {
        return this.target.isHidden();
    }

    @Override
    public long lastModified() {
        return this.target.lastModified();
    }

    @Override
    public long length() {
        return this.target.length();
    }

    @Override
    public String[] list() {
        return this.target.list();
    }

    @Override
    public String[] list(FilenameFilter filenameFilter) {
        return this.target.list(filenameFilter);
    }

    @Override
    public File[] listFiles() {
        return Win32File.wrap(this.target.listFiles());
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        return Win32File.wrap(this.target.listFiles(fileFilter));
    }

    @Override
    public File[] listFiles(FilenameFilter filenameFilter) {
        return Win32File.wrap(this.target.listFiles(filenameFilter));
    }

    @Override
    public boolean setLastModified(long l15) {
        return this.target.setLastModified(l15);
    }

    @Override
    public boolean setReadOnly() {
        return this.target.setReadOnly();
    }

    @Override
    public String toString() {
        if (this.target.equals(this)) {
            return super.toString();
        }
        return super.toString() + " -> " + this.target.toString();
    }
}

