/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends Publisher<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public FlowableFlatMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s15) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s15, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableFlatMap.subscribe(s15, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    public static <T, U> FlowableSubscriber<T> subscribe(Subscriber<? super U> s15, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        return new MergeSubscriber<T, U>(s15, mapper, delayErrors, maxConcurrency, bufferSize);
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<U>,
    Disposable {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        final int limit;
        final int bufferSize;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        long produced;
        int fusionMode;

        InnerSubscriber(MergeSubscriber<T, U> parent, int bufferSize, long id5) {
            this.id = id5;
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.limit = bufferSize >> 2;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(7);
                    if (m15 == 1) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                    }
                }
                s15.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(U t15) {
            if (this.fusionMode != 2) {
                this.parent.tryEmit(t15, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            this.parent.innerError(this, t15);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n15) {
            if (this.fusionMode != 1) {
                long p15 = this.produced + n15;
                if (p15 >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p15);
                } else {
                    this.produced = p15;
                }
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2117620485640801370L;
        final Subscriber<? super U> downstream;
        final Function<? super T, ? extends Publisher<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        final AtomicLong requested = new AtomicLong();
        Subscription upstream;
        long uniqueId;
        long lastId;
        int lastIndex;
        int scalarEmitted;
        final int scalarLimit;

        MergeSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.scalarLimit = Math.max(1, maxConcurrency >> 1);
            this.subscribers.lazySet(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) {
                        s15.request(Long.MAX_VALUE);
                    } else {
                        s15.request(this.maxConcurrency);
                    }
                }
            }
        }

        @Override
        public void onNext(T t15) {
            InnerSubscriber inner;
            Publisher<U> p15;
            if (this.done) {
                return;
            }
            try {
                p15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Publisher");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.cancel();
                this.onError(e15);
                return;
            }
            if (p15 instanceof Supplier) {
                Object u15;
                try {
                    u15 = ((Supplier)((Object)p15)).get();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.errors.tryAddThrowableOrReport(ex4);
                    this.drain();
                    return;
                }
                if (u15 != null) {
                    this.tryEmitScalar(u15);
                } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.upstream.request(this.scalarLimit);
                }
            } else if (this.addInner(inner = new InnerSubscriber(this, this.bufferSize, this.uniqueId++))) {
                p15.subscribe(inner);
            }
        }

        boolean addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b15;
            InnerSubscriber<?, ?>[] a15;
            do {
                if ((a15 = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n15 = a15.length;
                b15 = new InnerSubscriber[n15 + 1];
                System.arraycopy(a15, 0, b15, 0, n15);
                b15[n15] = inner;
            } while (!this.subscribers.compareAndSet(a15, b15));
            return true;
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b15;
            InnerSubscriber<?, ?>[] a15;
            do {
                int n15;
                if ((n15 = (a15 = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j15 = -1;
                for (int i15 = 0; i15 < n15; ++i15) {
                    if (a15[i15] != inner) continue;
                    j15 = i15;
                    break;
                }
                if (j15 < 0) {
                    return;
                }
                if (n15 == 1) {
                    b15 = EMPTY;
                    continue;
                }
                b15 = new InnerSubscriber[n15 - 1];
                System.arraycopy(a15, 0, b15, 0, j15);
                System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
            } while (!this.subscribers.compareAndSet(a15, b15));
        }

        SimpleQueue<U> getMainQueue() {
            SimplePlainQueue<U> q15 = this.queue;
            if (q15 == null) {
                q15 = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q15;
            }
            return q15;
        }

        void tryEmitScalar(U value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r15 = this.requested.get();
                SimpleQueue<U> q15 = this.queue;
                if (r15 != 0L && (q15 == null || q15.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r15 != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                        this.scalarEmitted = 0;
                        this.upstream.request(this.scalarLimit);
                    }
                } else {
                    if (q15 == null) {
                        q15 = this.getMainQueue();
                    }
                    if (!q15.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<U> q16 = this.getMainQueue();
                if (!q16.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r15 = this.requested.get();
                SimpleQueue q15 = inner.queue;
                if (r15 != 0L && (q15 == null || q15.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r15 != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.requestMore(1L);
                } else {
                    if (q15 == null) {
                        q15 = new SpscArrayQueue(this.bufferSize);
                        inner.queue = q15;
                    }
                    if (!q15.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q16 = inner.queue;
                if (q16 == null) {
                    q16 = new SpscArrayQueue(this.bufferSize);
                    inner.queue = q16;
                }
                if (!q16.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.done = true;
                if (!this.delayErrors) {
                    for (InnerSubscriber<?, ?> a15 : this.subscribers.getAndSet(CANCELLED)) {
                        a15.dispose();
                    }
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                SimplePlainQueue<U> q15;
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeAll();
                if (this.getAndIncrement() == 0 && (q15 = this.queue) != null) {
                    q15.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            boolean innerCompleted;
            Subscriber<U> child = this.downstream;
            int missed = 1;
            do {
                if (this.checkTerminate()) {
                    return;
                }
                SimplePlainQueue<U> svq = this.queue;
                long r15 = this.requested.get();
                boolean unbounded = r15 == Long.MAX_VALUE;
                long replenishMain = 0L;
                if (svq != null) {
                    long scalarEmission = 0L;
                    Object o15 = null;
                    while (r15 != 0L) {
                        o15 = svq.poll();
                        if (this.checkTerminate()) {
                            return;
                        }
                        if (o15 == null) break;
                        child.onNext(o15);
                        ++replenishMain;
                        ++scalarEmission;
                        --r15;
                    }
                    if (scalarEmission != 0L) {
                        r15 = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                    }
                }
                boolean d15 = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n15 = inner.length;
                if (d15 && (svq == null || svq.isEmpty()) && n15 == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                innerCompleted = false;
                if (n15 != 0) {
                    int i15;
                    int j15;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n15 <= index || inner[index].id != startId) {
                        if (n15 <= index) {
                            index = 0;
                        }
                        j15 = index;
                        for (i15 = 0; i15 < n15 && inner[j15].id != startId; ++i15) {
                            if (++j15 != n15) continue;
                            j15 = 0;
                        }
                        index = j15;
                        this.lastIndex = j15;
                        this.lastId = inner[j15].id;
                    }
                    j15 = index;
                    block5: for (i15 = 0; i15 < n15; ++i15) {
                        SimpleQueue q15;
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is4 = inner[j15];
                        Object o16 = null;
                        while ((q15 = is4.queue) != null) {
                            long produced = 0L;
                            while (r15 != 0L) {
                                if (this.checkTerminate()) {
                                    return;
                                }
                                try {
                                    o16 = q15.poll();
                                }
                                catch (Throwable ex4) {
                                    Exceptions.throwIfFatal(ex4);
                                    is4.dispose();
                                    this.errors.tryAddThrowableOrReport(ex4);
                                    if (!this.delayErrors) {
                                        this.upstream.cancel();
                                    }
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is4);
                                    innerCompleted = true;
                                    ++i15;
                                    continue block5;
                                }
                                if (o16 == null) break;
                                child.onNext(o16);
                                --r15;
                                ++produced;
                            }
                            if (produced != 0L) {
                                r15 = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                                is4.requestMore(produced);
                            }
                            if (r15 != 0L && o16 != null) continue;
                            break;
                        }
                        boolean innerDone = is4.done;
                        SimpleQueue innerQueue = is4.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is4);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++replenishMain;
                            innerCompleted = true;
                        }
                        if (r15 == 0L) break;
                        if (++j15 != n15) continue;
                        j15 = 0;
                    }
                    this.lastIndex = j15;
                    this.lastId = inner[j15].id;
                }
                if (replenishMain == 0L || this.cancelled) continue;
                this.upstream.request(replenishMain);
            } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                this.clearScalarQueue();
                return true;
            }
            if (!this.delayErrors && this.errors.get() != null) {
                this.clearScalarQueue();
                this.errors.tryTerminateConsumer(this.downstream);
                return true;
            }
            return false;
        }

        void clearScalarQueue() {
            SimplePlainQueue<U> q15 = this.queue;
            if (q15 != null) {
                q15.clear();
            }
        }

        void disposeAll() {
            InnerSubscriber<?, ?>[] a15 = this.subscribers.getAndSet(CANCELLED);
            if (a15 != CANCELLED) {
                for (InnerSubscriber<?, ?> inner : a15) {
                    inner.dispose();
                }
                this.errors.tryTerminateAndReport();
            }
        }

        void innerError(InnerSubscriber<T, U> inner, Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                inner.done = true;
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    for (InnerSubscriber<?, ?> a15 : this.subscribers.getAndSet(CANCELLED)) {
                        a15.dispose();
                    }
                }
                this.drain();
            }
        }
    }
}

