/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMapCompletable<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, ? extends CompletableSource> mapper;
    final int maxConcurrency;
    final boolean delayErrors;

    public FlowableFlatMapCompletable(Flowable<T> source, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        this.source.subscribe(new FlatMapCompletableMainSubscriber<T>(subscriber, this.mapper, this.delayErrors, this.maxConcurrency));
    }

    static final class FlatMapCompletableMainSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 8443155186132538303L;
        final Subscriber<? super T> downstream;
        final AtomicThrowable errors;
        final Function<? super T, ? extends CompletableSource> mapper;
        final boolean delayErrors;
        final CompositeDisposable set;
        final int maxConcurrency;
        Subscription upstream;
        volatile boolean cancelled;

        FlatMapCompletableMainSubscriber(Subscriber<? super T> subscriber, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = subscriber;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new CompositeDisposable();
            this.maxConcurrency = maxConcurrency;
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                int m15 = this.maxConcurrency;
                if (m15 == Integer.MAX_VALUE) {
                    s15.request(Long.MAX_VALUE);
                } else {
                    s15.request(m15);
                }
            }
        }

        @Override
        public void onNext(T value) {
            CompletableSource cs4;
            try {
                cs4 = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.cancel();
                this.onError(ex4);
                return;
            }
            this.getAndIncrement();
            InnerConsumer inner = new InnerConsumer();
            if (!this.cancelled && this.set.add(inner)) {
                cs4.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.cancelled = true;
                    this.upstream.cancel();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void request(long n15) {
        }

        @Override
        @Nullable
        public T poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }

        void innerComplete(InnerConsumer inner) {
            this.set.delete(inner);
            this.onComplete();
        }

        void innerError(InnerConsumer inner, Throwable e15) {
            this.set.delete(inner);
            this.onError(e15);
        }

        final class InnerConsumer
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerConsumer() {
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e15) {
                FlatMapCompletableMainSubscriber.this.innerError(this, e15);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }
        }
    }
}

