/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMergeWithMaybe<T>
extends AbstractFlowableWithUpstream<T, T> {
    final MaybeSource<? extends T> other;

    public FlowableMergeWithMaybe(Flowable<T> source, MaybeSource<? extends T> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        MergeWithObserver<? super T> parent = new MergeWithObserver<T>(subscriber);
        subscriber.onSubscribe(parent);
        this.source.subscribe(parent);
        this.other.subscribe(parent.otherObserver);
    }

    static final class MergeWithObserver<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4592979584110982903L;
        final Subscriber<? super T> downstream;
        final AtomicReference<Subscription> mainSubscription;
        final OtherObserver<T> otherObserver;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile SimplePlainQueue<T> queue;
        T singleItem;
        volatile boolean cancelled;
        volatile boolean mainDone;
        volatile int otherState;
        long emitted;
        int consumed;
        static final int OTHER_STATE_HAS_VALUE = 1;
        static final int OTHER_STATE_CONSUMED_OR_EMPTY = 2;

        MergeWithObserver(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.mainSubscription = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.prefetch = Flowable.bufferSize();
            this.limit = this.prefetch - (this.prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this.mainSubscription, s15, this.prefetch);
        }

        @Override
        public void onNext(T t15) {
            if (this.compareAndSet(0, 1)) {
                long e15 = this.emitted;
                if (this.requested.get() != e15) {
                    SimplePlainQueue<T> q15 = this.queue;
                    if (q15 == null || q15.isEmpty()) {
                        this.emitted = e15 + 1L;
                        this.downstream.onNext(t15);
                        int c15 = this.consumed + 1;
                        if (c15 == this.limit) {
                            this.consumed = 0;
                            this.mainSubscription.get().request(c15);
                        } else {
                            this.consumed = c15;
                        }
                    } else {
                        q15.offer(t15);
                    }
                } else {
                    SimplePlainQueue<T> q16 = this.getOrCreateQueue();
                    q16.offer(t15);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q17 = this.getOrCreateQueue();
                q17.offer(t15);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable ex4) {
            if (this.errors.tryAddThrowableOrReport(ex4)) {
                DisposableHelper.dispose(this.otherObserver);
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            BackpressureHelper.add(this.requested, n15);
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.mainSubscription);
            DisposableHelper.dispose(this.otherObserver);
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue = null;
                this.singleItem = null;
            }
        }

        void otherSuccess(T value) {
            if (this.compareAndSet(0, 1)) {
                long e15 = this.emitted;
                if (this.requested.get() != e15) {
                    this.emitted = e15 + 1L;
                    this.downstream.onNext(value);
                    this.otherState = 2;
                } else {
                    this.singleItem = value;
                    this.otherState = 1;
                    if (this.decrementAndGet() == 0) {
                        return;
                    }
                }
            } else {
                this.singleItem = value;
                this.otherState = 1;
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void otherError(Throwable ex4) {
            if (this.errors.tryAddThrowableOrReport(ex4)) {
                SubscriptionHelper.cancel(this.mainSubscription);
                this.drain();
            }
        }

        void otherComplete() {
            this.otherState = 2;
            this.drain();
        }

        SimplePlainQueue<T> getOrCreateQueue() {
            SimplePlainQueue<T> q15 = this.queue;
            if (q15 == null) {
                this.queue = q15 = new SpscArrayQueue<T>(Flowable.bufferSize());
            }
            return q15;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            Subscriber<T> actual = this.downstream;
            int missed = 1;
            long e15 = this.emitted;
            int c15 = this.consumed;
            int lim = this.limit;
            do {
                long r15 = this.requested.get();
                while (e15 != r15) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    int os4 = this.otherState;
                    if (os4 == 1) {
                        T v15 = this.singleItem;
                        this.singleItem = null;
                        this.otherState = 2;
                        os4 = 2;
                        actual.onNext(v15);
                        ++e15;
                        continue;
                    }
                    boolean d15 = this.mainDone;
                    SimplePlainQueue<T> q15 = this.queue;
                    Object v16 = q15 != null ? (Object)q15.poll() : null;
                    boolean bl4 = empty = v16 == null;
                    if (d15 && empty && os4 == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                    if (empty) break;
                    actual.onNext(v16);
                    ++e15;
                    if (++c15 != lim) continue;
                    c15 = 0;
                    this.mainSubscription.get().request(lim);
                }
                if (e15 == r15) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean d16 = this.mainDone;
                    SimplePlainQueue<T> q16 = this.queue;
                    boolean bl5 = empty = q16 == null || q16.isEmpty();
                    if (d16 && empty && this.otherState == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                }
                this.emitted = e15;
                this.consumed = c15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        static final class OtherObserver<T>
        extends AtomicReference<Disposable>
        implements MaybeObserver<T> {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithObserver<T> parent;

            OtherObserver(MergeWithObserver<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onSuccess(T t15) {
                this.parent.otherSuccess(t15);
            }

            @Override
            public void onError(Throwable e15) {
                this.parent.otherError(e15);
            }

            @Override
            public void onComplete() {
                this.parent.otherComplete();
            }
        }
    }
}

