/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableGenerate<T, S>
extends Observable<T> {
    final Supplier<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public ObservableGenerate(Supplier<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        S state;
        try {
            state = this.stateSupplier.get();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, observer);
            return;
        }
        GeneratorDisposable<T, S> gd5 = new GeneratorDisposable<T, S>(observer, this.generator, this.disposeState, state);
        observer.onSubscribe(gd5);
        gd5.run();
    }

    static final class GeneratorDisposable<T, S>
    implements Emitter<T>,
    Disposable {
        final Observer<? super T> downstream;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorDisposable(Observer<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.downstream = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        public void run() {
            S s15 = this.state;
            if (this.cancelled) {
                this.state = null;
                this.dispose(s15);
                return;
            }
            BiFunction<S, Emitter<T>, S> f15 = this.generator;
            do {
                if (this.cancelled) {
                    this.state = null;
                    this.dispose(s15);
                    return;
                }
                this.hasNext = false;
                try {
                    s15 = f15.apply(s15, this);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.state = null;
                    this.cancelled = true;
                    this.onError(ex4);
                    this.dispose(s15);
                    return;
                }
            } while (!this.terminate);
            this.cancelled = true;
            this.state = null;
            this.dispose(s15);
        }

        private void dispose(S s15) {
            try {
                this.disposeState.accept(s15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void onNext(T t15) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t15 == null) {
                    this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                } else {
                    this.hasNext = true;
                    this.downstream.onNext(t15);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.terminate) {
                RxJavaPlugins.onError(t15);
            } else {
                if (t15 == null) {
                    t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
                }
                this.terminate = true;
                this.downstream.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.downstream.onComplete();
            }
        }
    }
}

