/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFailureHandling;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFilterTry<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelFilterTry(ParallelFlowable<T> source, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.predicate = predicate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            Subscriber<? super T> a15 = subscribers[i15];
            parents[i15] = a15 instanceof ConditionalSubscriber ? new ParallelFilterConditionalSubscriber<T>((ConditionalSubscriber)a15, this.predicate, this.errorHandler) : new ParallelFilterSubscriber<T>(a15, this.predicate, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterConditionalSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final ConditionalSubscriber<? super T> downstream;

        ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (!this.done) {
                boolean b15;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b15 = this.predicate.test(t15);
                    }
                    catch (Throwable ex4) {
                        ParallelFailureHandling h15;
                        Exceptions.throwIfFatal(ex4);
                        try {
                            h15 = (ParallelFailureHandling)Objects.requireNonNull(this.errorHandler.apply(++retries, ex4), "The errorHandler returned a null ParallelFailureHandling");
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancel();
                            this.onError(new CompositeException(ex4, exc));
                            return false;
                        }
                        switch (h15) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex4);
                        return false;
                    }
                    break;
                }
                return b15 && this.downstream.tryOnNext(t15);
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static final class ParallelFilterSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final Subscriber<? super T> downstream;

        ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            if (!this.done) {
                boolean b15;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b15 = this.predicate.test(t15);
                    }
                    catch (Throwable ex4) {
                        ParallelFailureHandling h15;
                        Exceptions.throwIfFatal(ex4);
                        try {
                            h15 = (ParallelFailureHandling)Objects.requireNonNull(this.errorHandler.apply(++retries, ex4), "The errorHandler returned a null ParallelFailureHandling");
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancel();
                            this.onError(new CompositeException(ex4, exc));
                            return false;
                        }
                        switch (h15) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex4);
                        return false;
                    }
                    break;
                }
                if (b15) {
                    this.downstream.onNext(t15);
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }
    }

    static abstract class BaseFilterSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Predicate<? super T> predicate;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        BaseFilterSubscriber(Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.predicate = predicate;
            this.errorHandler = errorHandler;
        }

        @Override
        public final void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public final void cancel() {
            this.upstream.cancel();
        }

        @Override
        public final void onNext(T t15) {
            if (!this.tryOnNext(t15) && !this.done) {
                this.upstream.request(1L);
            }
        }
    }
}

