/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlattenIterable;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;

public final class ParallelFlatMapIterable<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    public ParallelFlatMapIterable(ParallelFlowable<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            parents[i15] = FlowableFlattenIterable.subscribe(subscribers[i15], this.mapper, this.prefetch);
        }
        this.source.subscribe(parents);
    }
}

