/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class UnicastProcessor<@NonNull T>
extends FlowableProcessor<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean done;
    Throwable error;
    final AtomicReference<Subscriber<? super T>> downstream;
    volatile boolean cancelled;
    final AtomicBoolean once;
    final BasicIntQueueSubscription<T> wip;
    final AtomicLong requested;
    boolean enableOperatorFusion;

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create() {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize(), null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(boolean delayError) {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize(), null, delayError);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint, @NonNull Runnable onTerminate) {
        return UnicastProcessor.create(capacityHint, onTerminate, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint, @NonNull Runnable onTerminate, boolean delayError) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, onTerminate, delayError);
    }

    UnicastProcessor(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(capacityHint);
        this.onTerminate = new AtomicReference<Runnable>(onTerminate);
        this.delayError = delayError;
        this.downstream = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueSubscription();
        this.requested = new AtomicLong();
    }

    void doTerminate() {
        Runnable r15 = this.onTerminate.getAndSet(null);
        if (r15 != null) {
            r15.run();
        }
    }

    void drainRegular(Subscriber<? super T> a15) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q15 = this.queue;
        boolean failFast = !this.delayError;
        do {
            long e15;
            long r15 = this.requested.get();
            for (e15 = 0L; r15 != e15; ++e15) {
                boolean empty;
                boolean d15 = this.done;
                T t15 = q15.poll();
                boolean bl4 = empty = t15 == null;
                if (this.checkTerminated(failFast, d15, empty, a15, q15)) {
                    return;
                }
                if (empty) break;
                a15.onNext(t15);
            }
            if (r15 == e15 && this.checkTerminated(failFast, this.done, q15.isEmpty(), a15, q15)) {
                return;
            }
            if (e15 == 0L || r15 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e15);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drainFused(Subscriber<? super T> a15) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q15 = this.queue;
        boolean bl4 = failFast = !this.delayError;
        do {
            if (this.cancelled) {
                this.downstream.lazySet(null);
                return;
            }
            boolean d15 = this.done;
            if (failFast && d15 && this.error != null) {
                q15.clear();
                this.downstream.lazySet(null);
                a15.onError(this.error);
                return;
            }
            a15.onNext(null);
            if (!d15) continue;
            this.downstream.lazySet(null);
            Throwable ex4 = this.error;
            if (ex4 != null) {
                a15.onError(ex4);
            } else {
                a15.onComplete();
            }
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Subscriber<? super T> a15 = this.downstream.get();
        while (true) {
            if (a15 != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a15);
                } else {
                    this.drainRegular(a15);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a15 = this.downstream.get();
        }
    }

    boolean checkTerminated(boolean failFast, boolean d15, boolean empty, Subscriber<? super T> a15, SpscLinkedArrayQueue<T> q15) {
        if (this.cancelled) {
            q15.clear();
            this.downstream.lazySet(null);
            return true;
        }
        if (d15) {
            if (failFast && this.error != null) {
                q15.clear();
                this.downstream.lazySet(null);
                a15.onError(this.error);
                return true;
            }
            if (empty) {
                Throwable e15 = this.error;
                this.downstream.lazySet(null);
                if (e15 != null) {
                    a15.onError(e15);
                } else {
                    a15.onComplete();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (this.done || this.cancelled) {
            s15.cancel();
        } else {
            s15.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.done || this.cancelled) {
            return;
        }
        this.queue.offer(t15);
        this.drain();
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.done || this.cancelled) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.error = t15;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            s15.onSubscribe(this.wip);
            this.downstream.set(s15);
            if (this.cancelled) {
                this.downstream.lazySet(null);
            } else {
                this.drain();
            }
        } else {
            EmptySubscription.error(new IllegalStateException("This processor allows only a single Subscriber"), s15);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.downstream.get() != null;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    final class UnicastQueueSubscription
    extends BasicIntQueueSubscription<T> {
        private static final long serialVersionUID = -4896760517184205454L;

        UnicastQueueSubscription() {
        }

        @Override
        @Nullable
        public T poll() {
            return UnicastProcessor.this.queue.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastProcessor.this.queue.isEmpty();
        }

        @Override
        public void clear() {
            UnicastProcessor.this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                UnicastProcessor.this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(UnicastProcessor.this.requested, n15);
                UnicastProcessor.this.drain();
            }
        }

        @Override
        public void cancel() {
            if (UnicastProcessor.this.cancelled) {
                return;
            }
            UnicastProcessor.this.cancelled = true;
            UnicastProcessor.this.doTerminate();
            UnicastProcessor.this.downstream.lazySet(null);
            if (UnicastProcessor.this.wip.getAndIncrement() == 0) {
                UnicastProcessor.this.downstream.lazySet(null);
                if (!UnicastProcessor.this.enableOperatorFusion) {
                    UnicastProcessor.this.queue.clear();
                }
            }
        }
    }
}

