/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.data.MethodHandleType;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import org.jetbrains.annotations.Nullable;

public class InvokeCustomNode
extends InvokeNode {
    private MethodInfo implMthInfo;
    private MethodHandleType handleType;
    private InsnNode callInsn;
    private boolean inlineInsn;
    private boolean useRef;

    public InvokeCustomNode(MethodInfo lambdaInfo, InsnData insn, boolean instanceCall, boolean isRange) {
        super(lambdaInfo, insn, InvokeType.CUSTOM, instanceCall, isRange);
    }

    private InvokeCustomNode(MethodInfo mth, InvokeType invokeType, int argsCount) {
        super(mth, invokeType, argsCount);
    }

    @Override
    public InsnNode copy() {
        InvokeCustomNode copy = new InvokeCustomNode(this.getCallMth(), this.getInvokeType(), this.getArgsCount());
        this.copyCommonParams(copy);
        copy.setImplMthInfo(this.implMthInfo);
        copy.setHandleType(this.handleType);
        copy.setCallInsn(this.callInsn);
        copy.setInlineInsn(this.inlineInsn);
        copy.setUseRef(this.useRef);
        return copy;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvokeCustomNode) || !super.isSame(obj)) {
            return false;
        }
        InvokeCustomNode other = (InvokeCustomNode)obj;
        return this.handleType == other.handleType && this.implMthInfo.equals(other.implMthInfo) && this.callInsn.isSame(other.callInsn) && this.inlineInsn == other.inlineInsn && this.useRef == other.useRef;
    }

    public MethodInfo getImplMthInfo() {
        return this.implMthInfo;
    }

    public void setImplMthInfo(MethodInfo implMthInfo) {
        this.implMthInfo = implMthInfo;
    }

    public MethodHandleType getHandleType() {
        return this.handleType;
    }

    public void setHandleType(MethodHandleType handleType) {
        this.handleType = handleType;
    }

    public InsnNode getCallInsn() {
        return this.callInsn;
    }

    public void setCallInsn(InsnNode callInsn) {
        this.callInsn = callInsn;
    }

    public boolean isInlineInsn() {
        return this.inlineInsn;
    }

    public void setInlineInsn(boolean inlineInsn) {
        this.inlineInsn = inlineInsn;
    }

    public boolean isUseRef() {
        return this.useRef;
    }

    public void setUseRef(boolean useRef) {
        this.useRef = useRef;
    }

    @Nullable
    public BaseInvokeNode getInvokeCall() {
        if (this.callInsn.getType() == InsnType.INVOKE) {
            return (BaseInvokeNode)this.callInsn;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnArg getInstanceArg() {
        return null;
    }

    @Override
    public boolean isStaticCall() {
        return true;
    }

    @Override
    public int getFirstArgOffset() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(InsnUtils.formatOffset(this.offset)).append(": INVOKE_CUSTOM ");
        if (this.getResult() != null) {
            sb5.append(this.getResult()).append(" = ");
        }
        this.appendArgs(sb5);
        this.appendAttributes(sb5);
        sb5.append("\n handle type: ").append((Object)this.handleType);
        sb5.append("\n lambda: ").append(this.implMthInfo);
        sb5.append("\n call insn: ").append(this.callInsn);
        return sb5.toString();
    }
}

