/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.FillArrayData;
import jadx.core.dex.instructions.FillArrayInsn;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchData;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.java.JsrNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="Process Instructions Visitor", desc="Init instructions info", runBefore={BlockSplitter.class})
public class ProcessInstructionsVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ProcessInstructionsVisitor.initJumps(mth, mth.getInstructions());
    }

    private static void initJumps(MethodNode mth, InsnNode[] insnByOffset) {
        block10: for (int offset = 0; offset < insnByOffset.length; ++offset) {
            InsnNode insn = insnByOffset[offset];
            if (insn == null) continue;
            switch (insn.getType()) {
                case SWITCH: {
                    int defCaseOffset;
                    SwitchInsn sw4 = (SwitchInsn)insn;
                    if (sw4.needData()) {
                        ProcessInstructionsVisitor.attachSwitchData(insnByOffset, offset, sw4);
                    }
                    if ((defCaseOffset = sw4.getDefaultCaseOffset()) != -1) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, defCaseOffset);
                    }
                    for (int target : sw4.getTargets()) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, target);
                    }
                    continue block10;
                }
                case IF: {
                    int next = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
                    if (next != -1) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, next);
                    }
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, ((IfNode)insn).getTarget());
                    continue block10;
                }
                case GOTO: {
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, ((GotoNode)insn).getTarget());
                    continue block10;
                }
                case JAVA_JSR: {
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, ((JsrNode)insn).getTarget());
                    int onRet = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
                    if (onRet == -1) continue block10;
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, onRet);
                    continue block10;
                }
                case INVOKE: {
                    if (insn.getResult() != null) continue block10;
                    ArgType retType = ((BaseInvokeNode)insn).getCallMth().getReturnType();
                    ProcessInstructionsVisitor.mergeMoveResult(insnByOffset, offset, insn, retType);
                    continue block10;
                }
                case STR_CONCAT: {
                    if (insn.getResult() != null) continue block10;
                    ProcessInstructionsVisitor.mergeMoveResult(insnByOffset, offset, insn, ArgType.STRING);
                    continue block10;
                }
                case FILLED_NEW_ARRAY: {
                    ArgType arrType = ((FilledNewArrayNode)insn).getArrayType();
                    ProcessInstructionsVisitor.mergeMoveResult(insnByOffset, offset, insn, arrType);
                    continue block10;
                }
                case FILL_ARRAY: {
                    FillArrayInsn fillArrayInsn = (FillArrayInsn)insn;
                    int target = fillArrayInsn.getTarget();
                    InsnNode arrDataInsn = ProcessInstructionsVisitor.getInsnAtOffset(insnByOffset, target);
                    if (arrDataInsn != null && arrDataInsn.getType() == InsnType.FILL_ARRAY_DATA) {
                        fillArrayInsn.setArrayData((FillArrayData)arrDataInsn);
                        ProcessInstructionsVisitor.removeInsn(insnByOffset, arrDataInsn);
                        continue block10;
                    }
                    throw new JadxRuntimeException("Payload for fill-array not found at " + InsnUtils.formatOffset(target));
                }
            }
        }
    }

    private static void attachSwitchData(InsnNode[] insnByOffset, int offset, SwitchInsn sw4) {
        int nextInsnOffset = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
        int dataTarget = sw4.getDataTarget();
        InsnNode switchDataInsn = ProcessInstructionsVisitor.getInsnAtOffset(insnByOffset, dataTarget);
        if (switchDataInsn == null || switchDataInsn.getType() != InsnType.SWITCH_DATA) {
            throw new JadxRuntimeException("Payload for switch not found at " + InsnUtils.formatOffset(dataTarget));
        }
        SwitchData data = (SwitchData)switchDataInsn;
        data.fixTargets(offset);
        sw4.attachSwitchData(data, nextInsnOffset);
        ProcessInstructionsVisitor.removeInsn(insnByOffset, switchDataInsn);
    }

    private static void mergeMoveResult(InsnNode[] insnByOffset, int offset, InsnNode insn, ArgType resType) {
        int nextInsnOffset = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
        if (nextInsnOffset == -1) {
            return;
        }
        InsnNode nextInsn = insnByOffset[nextInsnOffset];
        if (nextInsn.getType() != InsnType.MOVE_RESULT) {
            return;
        }
        RegisterArg moveRes = nextInsn.getResult();
        insn.setResult(moveRes.duplicate(resType));
        insn.copyAttributesFrom(nextInsn);
        ProcessInstructionsVisitor.removeInsn(insnByOffset, nextInsn);
    }

    private static void addJump(MethodNode mth, InsnNode[] insnByOffset, int offset, int target) {
        try {
            insnByOffset[target].addAttr(AType.JUMP, new JumpInfo(offset, target));
        }
        catch (Exception e15) {
            mth.addError("Failed to set jump: " + InsnUtils.formatOffset(offset) + " -> " + InsnUtils.formatOffset(target), e15);
        }
    }

    public static int getNextInsnOffset(InsnNode[] insnByOffset, int offset) {
        int len = insnByOffset.length;
        for (int i15 = offset + 1; i15 < len; ++i15) {
            InsnNode insnNode = insnByOffset[i15];
            if (insnNode == null || insnNode.getType() == InsnType.NOP) continue;
            return i15;
        }
        return -1;
    }

    @Nullable
    private static InsnNode getInsnAtOffset(InsnNode[] insnByOffset, int offset) {
        int len = insnByOffset.length;
        for (int i15 = offset; i15 < len; ++i15) {
            InsnNode insnNode = insnByOffset[i15];
            if (insnNode == null || insnNode.getType() == InsnType.NOP) continue;
            return insnNode;
        }
        return null;
    }

    private static void removeInsn(InsnNode[] insnByOffset, InsnNode insn) {
        insnByOffset[insn.getOffset()] = null;
    }
}

