/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.cellrenders;

import jadx.gui.treemodel.JNode;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class PathHighlightTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final boolean isDarkTheme;

    public PathHighlightTreeCellRenderer() {
        Color themeBackground = UIManager.getColor("Panel.background");
        this.isDarkTheme = UiUtils.isDarkTheme(themeBackground);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        int level = node.getLevel();
        float hue = (float)level * 0.1f % 1.0f;
        Color levelColor = Color.getHSBColor(hue, 0.1f, 0.95f);
        boolean onSelectionPath = false;
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath != null) {
            Object[] selectedPathNodes;
            for (Object pathNode : selectedPathNodes = selectionPath.getPath()) {
                if (pathNode != node) continue;
                onSelectionPath = true;
                break;
            }
        }
        if (onSelectionPath && !selected) {
            this.setForeground(this.isDarkTheme ? Color.decode("#70AEFF") : Color.decode("#0033B3"));
        } else if (!selected) {
            this.setBackground(levelColor);
            this.setBorder(BorderFactory.createEmptyBorder(2, level * 2 + 1, 2, 1));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(2, level * 2 + 1, 2, 1));
        }
        if (userObject instanceof JNode) {
            JNode jNode = (JNode)userObject;
            this.setText(jNode.makeLongString());
            this.setIcon(jNode.getIcon());
            this.setToolTipText(jNode.getTooltip());
        }
        return comp;
    }
}

