/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.aab.parsers;

import com.android.aapt.Resources;
import jadx.api.ICodeInfo;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.IResTableParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import jadx.plugins.input.aab.parsers.CommonProtoParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ResTableProtoParser
extends CommonProtoParser
implements IResTableParser {
    private final RootNode root;
    private ResourceStorage resStorage;
    private String baseFileName = "";

    public ResTableProtoParser(RootNode root) {
        this.root = root;
    }

    @Override
    public void setBaseFileName(String fileName) {
        this.baseFileName = fileName;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        this.resStorage = new ResourceStorage(this.root.getArgs().getSecurity());
        Resources.ResourceTable table = Resources.ResourceTable.parseFrom(FileUtils.streamToByteArray(inputStream));
        for (Resources.Package p15 : table.getPackageList()) {
            this.parse(p15);
        }
        this.resStorage.finish();
    }

    @Override
    public synchronized ResContainer decodeFiles() {
        ValuesParser vp4 = new ValuesParser(new BinaryXMLStrings(), this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp4, this.root.initManifestAttributes());
        ICodeInfo content = XmlGenUtils.makeXmlDump(this.root.makeCodeWriter(), this.resStorage);
        List<ResContainer> xmlFiles = resGen.makeResourcesXml(this.root.getArgs());
        return ResContainer.resourceTable(this.baseFileName, xmlFiles, content);
    }

    private void parse(Resources.Package p15) {
        String packageName = p15.getPackageName();
        this.resStorage.setAppPackage(packageName);
        List<Resources.Type> types = p15.getTypeList();
        for (Resources.Type type : types) {
            String typeName = type.getName();
            for (Resources.Entry entry : type.getEntryList()) {
                int id5 = p15.getPackageId().getId() << 24 | type.getTypeId().getId() << 16 | entry.getEntryId().getId();
                String entryName = entry.getName();
                for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                    String config = this.parse(configValue.getConfig());
                    ResourceEntry resEntry = new ResourceEntry(id5, packageName, typeName, entryName, config);
                    this.resStorage.add(resEntry);
                    ProtoValue protoValue = configValue.getValue().getValueCase() == Resources.Value.ValueCase.ITEM ? new ProtoValue(this.parse(configValue.getValue().getItem())) : this.parse(configValue.getValue().getCompoundValue());
                    resEntry.setProtoValue(protoValue);
                }
            }
        }
    }

    @Override
    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    @Override
    public BinaryXMLStrings getStrings() {
        return new BinaryXMLStrings();
    }
}

