/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.data.IClassData;
import jadx.plugins.input.java.JavaClassReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLoadResult
implements ICodeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLoadResult.class);
    private final List<JavaClassReader> readers;
    @Nullable
    private final Closeable closeable;

    public JavaLoadResult(List<JavaClassReader> readers) {
        this(readers, null);
    }

    public JavaLoadResult(List<JavaClassReader> readers, @Nullable Closeable closeable) {
        this.readers = readers;
        this.closeable = closeable;
    }

    @Override
    public void visitClasses(Consumer<IClassData> consumer) {
        for (JavaClassReader reader : this.readers) {
            try {
                consumer.accept(reader.loadClassData());
            }
            catch (Exception e15) {
                LOG.error("Failed to load class data for file: {}", (Object)reader.getFileName(), (Object)e15);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.readers.isEmpty();
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

