/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings.load;

import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.OrderedJadxPassInfo;
import jadx.api.plugins.pass.types.JadxDecompilePass;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.plugins.mappings.RenameMappingsData;
import jadx.plugins.mappings.utils.DalvikToJavaBytecodeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.mappingio.tree.MappingTreeView;

public class CodeMappingsPass
implements JadxDecompilePass {
    private Map<String, MappingTreeView.ClassMappingView> clsRenamesMap;

    @Override
    public JadxPassInfo getInfo() {
        return new OrderedJadxPassInfo("CodeMappings", "Apply mappings to method args and vars").before("CodeRenameVisitor");
    }

    @Override
    public void init(RootNode root) {
        RenameMappingsData data = RenameMappingsData.getData(root);
        if (data == null) {
            return;
        }
        MappingTreeView mappingTree = data.getMappings();
        this.updateMappingsMap(mappingTree);
        root.registerCodeDataUpdateListener(codeData -> this.updateMappingsMap(mappingTree));
    }

    @Override
    public boolean visit(ClassNode cls) {
        MappingTreeView.ClassMappingView classMapping = this.getMapping(cls);
        if (classMapping != null) {
            CodeMappingsPass.applyRenames(cls, classMapping);
        }
        cls.getInnerClasses().forEach(this::visit);
        return false;
    }

    @Override
    public void visit(MethodNode mth) {
    }

    private static void applyRenames(ClassNode cls, MappingTreeView.ClassMappingView classMapping) {
        for (MethodNode mth : cls.getMethods()) {
            MappingTreeView.MethodMappingView methodMapping;
            String methodName = mth.getMethodInfo().getName();
            String methodDesc = mth.getMethodInfo().getShortId().substring(methodName.length());
            List<SSAVar> ssaVars = mth.getSVars();
            if (ssaVars.isEmpty() || (methodMapping = classMapping.getMethod(methodName, methodDesc)) == null) continue;
            block1: for (MappingTreeView.MethodArgMappingView methodArgMappingView : methodMapping.getArgs()) {
                Integer mappingLvIndex = methodArgMappingView.getLvIndex();
                for (SSAVar ssaVar : ssaVars) {
                    Integer actualLvIndex = DalvikToJavaBytecodeUtils.getMethodArgLvIndex(ssaVar, mth);
                    if (!actualLvIndex.equals(mappingLvIndex)) continue;
                    ssaVar.getCodeVar().setName(methodArgMappingView.getDstName(0));
                    continue block1;
                }
            }
        }
    }

    private MappingTreeView.ClassMappingView getMapping(ClassNode cls) {
        if (this.clsRenamesMap == null || this.clsRenamesMap.isEmpty()) {
            return null;
        }
        String classPath = cls.getClassInfo().makeRawFullName().replace('.', '/');
        return this.clsRenamesMap.get(classPath);
    }

    private void updateMappingsMap(MappingTreeView mappings) {
        this.clsRenamesMap = new HashMap<String, MappingTreeView.ClassMappingView>();
        block0: for (MappingTreeView.ClassMappingView classMappingView : mappings.getClasses()) {
            for (MappingTreeView.MethodMappingView methodMappingView : classMappingView.getMethods()) {
                if (methodMappingView.getArgs().isEmpty() && methodMappingView.getVars().isEmpty()) continue;
                this.clsRenamesMap.put(classMappingView.getSrcName(), classMappingView);
                continue block0;
            }
        }
    }
}

