/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.analysis.DFA;
import org.antlr.misc.Utils;
import org.antlr.runtime.misc.Stats;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarReport {
    public static final String Version = "5";
    public static final String GRAMMAR_STATS_FILENAME = "grammar.stats";
    public static final String newline = System.getProperty("line.separator");
    public Grammar grammar;

    public GrammarReport(Grammar grammar) {
        this.grammar = grammar;
    }

    public static ReportData getReportData(Grammar g15) {
        String k15;
        ReportData data = new ReportData();
        data.version = Version;
        data.gname = g15.name;
        data.gtype = g15.getGrammarTypeString();
        data.language = (String)g15.getOption("language");
        data.output = (String)g15.getOption("output");
        if (data.output == null) {
            data.output = "none";
        }
        if ((k15 = (String)g15.getOption("k")) == null) {
            k15 = "none";
        }
        data.grammarLevelk = k15;
        String backtrack = (String)g15.getOption("backtrack");
        if (backtrack == null) {
            backtrack = "false";
        }
        data.grammarLevelBacktrack = backtrack;
        int totalNonSynPredProductions = 0;
        int totalNonSynPredRules = 0;
        Collection<Rule> rules = g15.getRules();
        for (Rule r15 : rules) {
            if (r15.name.toUpperCase().startsWith("synpred".toUpperCase())) continue;
            totalNonSynPredProductions += r15.numberOfAlts;
            ++totalNonSynPredRules;
        }
        data.numRules = totalNonSynPredRules;
        data.numOuterProductions = totalNonSynPredProductions;
        int numACyclicDecisions = g15.getNumberOfDecisions() - g15.getNumberOfCyclicDecisions();
        ArrayList<Integer> depths = new ArrayList<Integer>();
        int[] acyclicDFAStates = new int[numACyclicDecisions];
        int[] cyclicDFAStates = new int[g15.getNumberOfCyclicDecisions()];
        int acyclicIndex = 0;
        int cyclicIndex = 0;
        int numLL1 = 0;
        int blocksWithSynPreds = 0;
        int dfaWithSynPred = 0;
        int numDecisions = 0;
        int numCyclicDecisions = 0;
        for (int i15 = 1; i15 <= g15.getNumberOfDecisions(); ++i15) {
            Grammar.Decision d15 = g15.getDecision(i15);
            if (d15.dfa == null) continue;
            Rule r16 = d15.dfa.decisionNFAStartState.enclosingRule;
            if (r16.name.toUpperCase().startsWith("synpred".toUpperCase())) continue;
            ++numDecisions;
            if (GrammarReport.blockHasSynPred(d15.blockAST)) {
                ++blocksWithSynPreds;
            }
            if (d15.dfa.hasSynPred()) {
                ++dfaWithSynPred;
            }
            if (!d15.dfa.isCyclic()) {
                if (d15.dfa.isClassicDFA()) {
                    int maxk = d15.dfa.getMaxLookaheadDepth();
                    if (maxk == 1) {
                        ++numLL1;
                    }
                    depths.add(maxk);
                    continue;
                }
                acyclicDFAStates[acyclicIndex] = d15.dfa.getNumberOfStates();
                ++acyclicIndex;
                continue;
            }
            ++numCyclicDecisions;
            cyclicDFAStates[cyclicIndex] = d15.dfa.getNumberOfStates();
            ++cyclicIndex;
        }
        data.numLL1 = numLL1;
        data.numberOfFixedKDecisions = depths.size();
        data.mink = Stats.min(depths);
        data.maxk = Stats.max(depths);
        data.avgk = Stats.avg(depths);
        data.numberOfDecisionsInRealRules = numDecisions;
        data.numberOfDecisions = g15.getNumberOfDecisions();
        data.numberOfCyclicDecisions = numCyclicDecisions;
        data.blocksWithSynPreds = blocksWithSynPreds;
        data.decisionsWhoseDFAsUsesSynPreds = dfaWithSynPred;
        data.numTokens = g15.getTokenTypes().size();
        data.DFACreationWallClockTimeInMS = g15.DFACreationWallClockTimeInMS;
        data.numberOfSemanticPredicates = g15.numberOfSemanticPredicates;
        data.numberOfManualLookaheadOptions = g15.numberOfManualLookaheadOptions;
        data.numNonLLStarDecisions = g15.numNonLLStar;
        data.numNondeterministicDecisions = g15.setOfNondeterministicDecisionNumbers.size();
        data.numNondeterministicDecisionNumbersResolvedWithPredicates = g15.setOfNondeterministicDecisionNumbersResolvedWithPredicates.size();
        data.errors = ErrorManager.getErrorState().errors;
        data.warnings = ErrorManager.getErrorState().warnings;
        data.infos = ErrorManager.getErrorState().infos;
        data.blocksWithSemPreds = g15.blocksWithSemPreds.size();
        data.decisionsWhoseDFAsUsesSemPreds = g15.decisionsWhoseDFAsUsesSemPreds.size();
        return data;
    }

    public String toNotifyString() {
        StringBuilder buf = new StringBuilder();
        ReportData data = GrammarReport.getReportData(this.grammar);
        Field[] fields2 = ReportData.class.getDeclaredFields();
        int i15 = 0;
        for (Field f15 : fields2) {
            try {
                String s15;
                Object v15 = f15.get(data);
                String string = s15 = v15 != null ? v15.toString() : "null";
                if (i15 > 0) {
                    buf.append('\t');
                }
                buf.append(s15);
            }
            catch (Exception e15) {
                ErrorManager.internalError("Can't get data", e15);
            }
            ++i15;
        }
        return buf.toString();
    }

    public String getBacktrackingReport() {
        StringBuilder buf = new StringBuilder();
        buf.append("Backtracking report:");
        buf.append(newline);
        buf.append("Number of decisions that backtrack: ");
        buf.append(this.grammar.decisionsWhoseDFAsUsesSynPreds.size());
        buf.append(newline);
        buf.append(this.getDFALocations(this.grammar.decisionsWhoseDFAsUsesSynPreds));
        return buf.toString();
    }

    protected String getDFALocations(Set<DFA> dfas) {
        HashSet<Integer> decisions = new HashSet<Integer>();
        StringBuilder buf = new StringBuilder();
        for (DFA dfa : dfas) {
            if (decisions.contains(Utils.integer(dfa.decisionNumber))) continue;
            decisions.add(Utils.integer(dfa.decisionNumber));
            buf.append("Rule ");
            buf.append(dfa.decisionNFAStartState.enclosingRule.name);
            buf.append(" decision ");
            buf.append(dfa.decisionNumber);
            buf.append(" location ");
            GrammarAST decisionAST = dfa.decisionNFAStartState.associatedASTNode;
            buf.append(decisionAST.getLine());
            buf.append(":");
            buf.append(decisionAST.getCharPositionInLine());
            buf.append(newline);
        }
        return buf.toString();
    }

    public String toString() {
        return GrammarReport.toString(this.toNotifyString());
    }

    protected static ReportData decodeReportData(String dataS) {
        Field[] fields2;
        ReportData data = new ReportData();
        StringTokenizer st4 = new StringTokenizer(dataS, "\t");
        for (Field f15 : fields2 = ReportData.class.getDeclaredFields()) {
            String v15 = st4.nextToken();
            try {
                if (f15.getType() == String.class) {
                    f15.set(data, v15);
                    continue;
                }
                if (f15.getType() == Double.TYPE) {
                    f15.set(data, Double.valueOf(v15));
                    continue;
                }
                f15.set(data, Integer.valueOf(v15));
            }
            catch (Exception e15) {
                ErrorManager.internalError("Can't get data", e15);
            }
        }
        return data;
    }

    public static String toString(String notifyDataLine) {
        ReportData data = GrammarReport.decodeReportData(notifyDataLine);
        if (data == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ANTLR Grammar Report; Stats Version ");
        buf.append(data.version);
        buf.append('\n');
        buf.append("Grammar: ");
        buf.append(data.gname);
        buf.append('\n');
        buf.append("Type: ");
        buf.append(data.gtype);
        buf.append('\n');
        buf.append("Target language: ");
        buf.append(data.language);
        buf.append('\n');
        buf.append("Output: ");
        buf.append(data.output);
        buf.append('\n');
        buf.append("Grammar option k: ");
        buf.append(data.grammarLevelk);
        buf.append('\n');
        buf.append("Grammar option backtrack: ");
        buf.append(data.grammarLevelBacktrack);
        buf.append('\n');
        buf.append("Rules: ");
        buf.append(data.numRules);
        buf.append('\n');
        buf.append("Outer productions: ");
        buf.append(data.numOuterProductions);
        buf.append('\n');
        buf.append("Decisions: ");
        buf.append(data.numberOfDecisions);
        buf.append('\n');
        buf.append("Decisions (ignoring decisions in synpreds): ");
        buf.append(data.numberOfDecisionsInRealRules);
        buf.append('\n');
        buf.append("Fixed k DFA decisions: ");
        buf.append(data.numberOfFixedKDecisions);
        buf.append('\n');
        buf.append("Cyclic DFA decisions: ");
        buf.append(data.numberOfCyclicDecisions);
        buf.append('\n');
        buf.append("LL(1) decisions: ");
        buf.append(data.numLL1);
        buf.append('\n');
        buf.append("Min fixed k: ");
        buf.append(data.mink);
        buf.append('\n');
        buf.append("Max fixed k: ");
        buf.append(data.maxk);
        buf.append('\n');
        buf.append("Average fixed k: ");
        buf.append(data.avgk);
        buf.append('\n');
        buf.append("DFA creation time in ms: ");
        buf.append(data.DFACreationWallClockTimeInMS);
        buf.append('\n');
        buf.append("Decisions with available syntactic predicates (ignoring synpred rules): ");
        buf.append(data.blocksWithSynPreds);
        buf.append('\n');
        buf.append("Decision DFAs using syntactic predicates (ignoring synpred rules): ");
        buf.append(data.decisionsWhoseDFAsUsesSynPreds);
        buf.append('\n');
        buf.append("Number of semantic predicates found: ");
        buf.append(data.numberOfSemanticPredicates);
        buf.append('\n');
        buf.append("Decisions with semantic predicates: ");
        buf.append(data.blocksWithSemPreds);
        buf.append('\n');
        buf.append("Decision DFAs using semantic predicates: ");
        buf.append(data.decisionsWhoseDFAsUsesSemPreds);
        buf.append('\n');
        buf.append("Number of (likely) non-LL(*) decisions: ");
        buf.append(data.numNonLLStarDecisions);
        buf.append('\n');
        buf.append("Number of nondeterministic decisions: ");
        buf.append(data.numNondeterministicDecisions);
        buf.append('\n');
        buf.append("Number of nondeterministic decisions resolved with predicates: ");
        buf.append(data.numNondeterministicDecisionNumbersResolvedWithPredicates);
        buf.append('\n');
        buf.append("Number of manual or forced fixed lookahead k=value options: ");
        buf.append(data.numberOfManualLookaheadOptions);
        buf.append('\n');
        buf.append("Vocabulary size: ");
        buf.append(data.numTokens);
        buf.append('\n');
        buf.append("Number of errors: ");
        buf.append(data.errors);
        buf.append('\n');
        buf.append("Number of warnings: ");
        buf.append(data.warnings);
        buf.append('\n');
        buf.append("Number of infos: ");
        buf.append(data.infos);
        buf.append('\n');
        return buf.toString();
    }

    public static boolean blockHasSynPred(GrammarAST blockAST) {
        GrammarAST c15 = blockAST.findFirstType(90);
        GrammarAST c25 = blockAST.findFirstType(14);
        return c15 != null || c25 != null;
    }

    public static class ReportData {
        String version;
        String gname;
        String gtype;
        String language;
        int numRules;
        int numOuterProductions;
        int numberOfDecisionsInRealRules;
        int numberOfDecisions;
        int numberOfCyclicDecisions;
        int numberOfFixedKDecisions;
        int numLL1;
        int mink;
        int maxk;
        double avgk;
        int numTokens;
        long DFACreationWallClockTimeInMS;
        int numberOfSemanticPredicates;
        int numberOfManualLookaheadOptions;
        int numNonLLStarDecisions;
        int numNondeterministicDecisions;
        int numNondeterministicDecisionNumbersResolvedWithPredicates;
        int errors;
        int warnings;
        int infos;
        int blocksWithSynPreds;
        int decisionsWhoseDFAsUsesSynPreds;
        int blocksWithSemPreds;
        int decisionsWhoseDFAsUsesSemPreds;
        String output;
        String grammarLevelk;
        String grammarLevelBacktrack;
    }
}

