/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Objects;
import org.apache.commons.text.similarity.SimilarityInput;

final class SimilarityCharacterInput
implements SimilarityInput<Character> {
    private final CharSequence cs;

    SimilarityCharacterInput(CharSequence cs4) {
        if (cs4 == null) {
            throw new IllegalArgumentException("CharSequence");
        }
        this.cs = cs4;
    }

    @Override
    public Character at(int index) {
        return Character.valueOf(this.cs.charAt(index));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimilarityCharacterInput other = (SimilarityCharacterInput)obj;
        return Objects.equals(this.cs, other.cs);
    }

    public int hashCode() {
        return Objects.hash(this.cs);
    }

    @Override
    public int length() {
        return this.cs.length();
    }

    public String toString() {
        return this.cs.toString();
    }
}

