/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class PythonFoldParser
implements FoldParser {
    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        int tabSize = textArea.getTabSize();
        Stack<Integer> foldStartLeadingWhiteSpaceCounts = new Stack<Integer>();
        int currentNextFoldStart = 0;
        int currentLeadingWhiteSpaceCount = 0;
        try {
            for (int line = 0; line < lineCount; ++line) {
                Token t15 = textArea.getTokenListForLine(line);
                int leadingWhiteSpaceCount = PythonFoldParser.getLeadingWhiteSpaceCount(t15, tabSize);
                if (leadingWhiteSpaceCount == -1) continue;
                if (leadingWhiteSpaceCount == currentLeadingWhiteSpaceCount) {
                    currentNextFoldStart = t15.getOffset() + leadingWhiteSpaceCount;
                } else if (leadingWhiteSpaceCount > currentLeadingWhiteSpaceCount) {
                    while (PythonFoldParser.tokenHasLineContinuation(t15) && line < lineCount) {
                        t15 = textArea.getTokenListForLine(++line);
                    }
                    if (currentFold != null) {
                        currentFold = currentFold.createChild(0, currentNextFoldStart);
                    } else {
                        currentFold = new Fold(0, textArea, currentNextFoldStart);
                        folds.add(currentFold);
                    }
                    foldStartLeadingWhiteSpaceCounts.push(currentLeadingWhiteSpaceCount);
                    currentNextFoldStart = t15.getOffset() + leadingWhiteSpaceCount;
                } else {
                    currentNextFoldStart = t15.getOffset() + leadingWhiteSpaceCount;
                    int prevLine = line - 1;
                    while (TokenUtils.isBlankOrAllWhiteSpace(t15 = textArea.getTokenListForLine(prevLine--))) {
                    }
                    int endOffs = t15.getEndOffset() - 1;
                    boolean foundBlock = false;
                    while (currentFold != null && !foldStartLeadingWhiteSpaceCounts.isEmpty() && (Integer)foldStartLeadingWhiteSpaceCounts.peek() >= leadingWhiteSpaceCount) {
                        currentFold.setEndOffset(endOffs);
                        currentFold = currentFold.getParent();
                        foldStartLeadingWhiteSpaceCounts.pop();
                        foundBlock = true;
                    }
                    if (!foundBlock && currentFold != null && !currentFold.removeFromParent()) {
                        folds.remove(folds.size() - 1);
                    }
                }
                currentLeadingWhiteSpaceCount = leadingWhiteSpaceCount;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static boolean tokenHasLineContinuation(Token t15) {
        return (t15 = t15.getLastNonCommentNonWhitespaceToken()) != null && t15.isSingleChar('\\');
    }

    private static int getLeadingWhiteSpaceCount(Token t15, int tabSize) {
        if (t15 == null || t15.getType() == 13 || t15.getType() == 14) {
            return -1;
        }
        int count = 0;
        while (t15 != null && t15.isPaintable()) {
            if (!t15.isWhitespace()) {
                return t15.getType() == 1 ? -1 : count;
            }
            count += TokenUtils.getWhiteSpaceTokenLength(t15, tabSize, count);
            t15 = t15.getNextToken();
        }
        return -1;
    }
}

