/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class RTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    protected RTextArea textArea;
    private List<HighlightInfo> markAllHighlights = new ArrayList<HighlightInfo>();

    Object addMarkAllHighlight(int start, int end, Highlighter.HighlightPainter p15) throws BadLocationException {
        Document doc = this.textArea.getDocument();
        TextUI mapper = this.textArea.getUI();
        LayeredHighlightInfoImpl i15 = new LayeredHighlightInfoImpl();
        i15.setPainter(p15);
        ((HighlightInfoImpl)i15).p0 = doc.createPosition(start);
        ((HighlightInfoImpl)i15).p1 = doc.createPosition(end - 1);
        this.markAllHighlights.add(i15);
        mapper.damageRange(this.textArea, start, end);
        return i15;
    }

    void clearMarkAllHighlights() {
        for (HighlightInfo info : this.markAllHighlights) {
            this.repaintListHighlight(info);
        }
        this.markAllHighlights.clear();
    }

    @Override
    public void deinstall(JTextComponent c15) {
        this.textArea = null;
        this.markAllHighlights.clear();
    }

    public int getMarkAllHighlightCount() {
        return this.markAllHighlights.size();
    }

    public List<DocumentRange> getMarkAllHighlightRanges() {
        ArrayList<DocumentRange> list2 = new ArrayList<DocumentRange>(this.markAllHighlights.size());
        for (HighlightInfo info : this.markAllHighlights) {
            int start = info.getStartOffset();
            int end = info.getEndOffset() + 1;
            DocumentRange range = new DocumentRange(start, end);
            list2.add(range);
        }
        return list2;
    }

    @Override
    public void install(JTextComponent c15) {
        super.install(c15);
        this.textArea = (RTextArea)c15;
    }

    @Override
    public void paintLayeredHighlights(Graphics g15, int lineStart, int lineEnd, Shape viewBounds, JTextComponent editor, View view) {
        this.paintListLayered(g15, lineStart, lineEnd, viewBounds, editor, view, this.markAllHighlights);
        super.paintLayeredHighlights(g15, lineStart, lineEnd, viewBounds, editor, view);
    }

    protected void paintListLayered(Graphics g15, int lineStart, int lineEnd, Shape viewBounds, JTextComponent editor, View view, List<? extends HighlightInfo> highlights) {
        for (int i15 = highlights.size() - 1; i15 >= 0; --i15) {
            HighlightInfo tag = highlights.get(i15);
            if (!(tag instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
            int highlightStart = lhi.getStartOffset();
            int highlightEnd = lhi.getEndOffset() + 1;
            if ((lineStart >= highlightStart || lineEnd <= highlightStart) && (lineStart < highlightStart || lineStart >= highlightEnd)) continue;
            lhi.paintLayeredHighlights(g15, lineStart, lineEnd, viewBounds, editor, view);
        }
    }

    protected void repaintListHighlight(HighlightInfo info) {
        if (info instanceof LayeredHighlightInfoImpl) {
            LayeredHighlightInfoImpl lhi = (LayeredHighlightInfoImpl)info;
            if (lhi.width > 0 && lhi.height > 0) {
                this.textArea.repaint(lhi.x, lhi.y, lhi.width, lhi.height);
            }
        } else {
            TextUI ui4 = this.textArea.getUI();
            ui4.damageRange(this.textArea, info.getStartOffset(), info.getEndOffset());
        }
    }

    protected static class LayeredHighlightInfoImpl
    extends HighlightInfoImpl
    implements LayeredHighlightInfo {
        public int x;
        public int y;
        public int width;
        public int height;

        protected LayeredHighlightInfoImpl() {
        }

        void union(Shape bounds) {
            Rectangle alloc;
            if (bounds == null) {
                return;
            }
            Rectangle rectangle = alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = alloc.x;
                this.y = alloc.y;
                this.width = alloc.width;
                this.height = alloc.height;
            } else {
                this.width = Math.max(this.x + this.width, alloc.x + alloc.width);
                this.height = Math.max(this.y + this.height, alloc.y + alloc.height);
                this.x = Math.min(this.x, alloc.x);
                this.width -= this.x;
                this.y = Math.min(this.y, alloc.y);
                this.height -= this.y;
            }
        }

        @Override
        public void paintLayeredHighlights(Graphics g15, int p05, int p15, Shape viewBounds, JTextComponent editor, View view) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            p05 = Math.max(start, p05);
            p15 = Math.min(++end, p15);
            if (this.getColor() != null && this.getPainter() instanceof ChangeableHighlightPainter) {
                ((ChangeableHighlightPainter)this.getPainter()).setPaint(this.getColor());
            }
            this.union(((LayeredHighlighter.LayerPainter)this.getPainter()).paintLayer(g15, p05, p15, viewBounds, editor, view));
        }

        public String toString() {
            return "[LayeredHighlightInfo: x = " + this.x + ", y = " + this.y + ", width = " + this.width + ", height = " + this.height + ", p0 = " + this.getStartOffset() + ", p1 = " + this.getEndOffset() + "]";
        }
    }

    protected static class HighlightInfoImpl
    implements HighlightInfo {
        private Position p0;
        private Position p1;
        private Highlighter.HighlightPainter painter;

        protected HighlightInfoImpl() {
        }

        public Color getColor() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }

        public void setStartOffset(Position startOffset) {
            this.p0 = startOffset;
        }

        public void setEndOffset(Position endOffset) {
            this.p1 = endOffset;
        }

        public void setPainter(Highlighter.HighlightPainter painter) {
            this.painter = painter;
        }
    }

    public static interface HighlightInfo
    extends Highlighter.Highlight {
    }

    public static interface LayeredHighlightInfo
    extends HighlightInfo {
        public void paintLayeredHighlights(Graphics var1, int var2, int var3, Shape var4, JTextComponent var5, View var6);
    }
}

