/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Reduce the size of an image by an integer factor in each dimension
while performing averaging of an input neighborhood.


The output image size in each dimension is given by:

outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );

The algorithm implemented can be describe with the following equation
for 2D: \\[ \\mathsf{I}_{out}(x_o,x_1) =
\\frac{\\sum_{i=0}^{f_0}\\sum_{j=0}^{f_1}\\mathsf{I}_{in}(f_0
x_o+i,f_1 x_1+j)}{f_0 f_1} \\]

This filter is implemented so that the starting extent of the first
pixel of the output matches that of the input.

The change in image geometry from a 5x5 image binned by a factor of
2x2.

This code was contributed in the Insight Journal paper: "BinShrink: A
multi-resolution filter with cache efficient averaging" by Lowekamp
B., Chen D. https://doi.org/10.54294/p39qox
See:
 itk::simple::BinShrink for the procedural interface

 itk::BinShrinkImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinShrinkImageFilter.h
*/
public class BinShrinkImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinShrinkImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinShrinkImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinShrinkImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinShrinkImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinShrinkImageFilter::~BinShrinkImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinShrinkImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinShrinkImageFilter::BinShrinkImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinShrinkImageFilter() {
    this(SimpleITKJNI.new_BinShrinkImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinShrinkImageFilter::SetShrinkFactor(unsigned int s)

Custom public declarations

*/
public  void setShrinkFactor(long s) {
    SimpleITKJNI.BinShrinkImageFilter_setShrinkFactor(swigCPtr, this, s);
  }

  /**
Self&amp; itk::simple::BinShrinkImageFilter::SetShrinkFactors(std::vector&lt; unsigned int &gt; ShrinkFactors)

Set the shrink factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.

*/
public  void setShrinkFactors(VectorUInt32 ShrinkFactors) {
    SimpleITKJNI.BinShrinkImageFilter_setShrinkFactors(swigCPtr, this, VectorUInt32.getCPtr(ShrinkFactors), ShrinkFactors);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinShrinkImageFilter::GetShrinkFactors() const

Get the shrink factors.

*/
public  VectorUInt32 getShrinkFactors() {
    return new VectorUInt32(SimpleITKJNI.BinShrinkImageFilter_getShrinkFactors(swigCPtr, this), true);
  }

  /**
std::string itk::simple::BinShrinkImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinShrinkImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinShrinkImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinShrinkImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinShrinkImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinShrinkImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
