/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.Collection;
import java.util.Map;
import picocli.CommandLine;

class SubCommandListRenderer
implements CommandLine.IHelpSectionRenderer {
    SubCommandListRenderer() {
    }

    public String render(CommandLine.Help help) {
        CommandLine.Model.CommandSpec spec = help.commandSpec();
        if (spec.subcommands().isEmpty()) {
            return "";
        }
        CommandLine.Help.Column commands = new CommandLine.Help.Column(24, 2, CommandLine.Help.Column.Overflow.SPAN);
        CommandLine.Help.Column descriptions = new CommandLine.Help.Column(spec.usageMessage().width() - 24, 2, CommandLine.Help.Column.Overflow.WRAP);
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)help.colorScheme(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{commands, descriptions});
        textTable.setAdjustLineBreaksForWideCJKCharacters(spec.usageMessage().adjustLineBreaksForWideCJKCharacters());
        this.addHierarchy(spec.subcommands().values(), textTable, "");
        return textTable.toString();
    }

    private void addHierarchy(Collection<CommandLine> collection, CommandLine.Help.TextTable textTable, String indent) {
        collection.stream().distinct().forEach(subcommand -> {
            String names = String.join((CharSequence)", ", subcommand.getCommandSpec().names());
            String description = this.description(subcommand.getCommandSpec().usageMessage());
            textTable.addRowValues(new String[]{indent + names, description});
            Map subcommands = subcommand.getSubcommands();
            if (!subcommands.isEmpty()) {
                this.addHierarchy(subcommands.values(), textTable, indent + "  ");
            }
        });
    }

    private String description(CommandLine.Model.UsageMessageSpec usageMessage) {
        if (usageMessage.header().length > 0) {
            return usageMessage.header()[0];
        }
        if (usageMessage.description().length > 0) {
            return usageMessage.description()[0];
        }
        return "";
    }
}

