/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class BatchFetchQueue {
    private static final Logger LOG = CoreLogging.logger(BatchFetchQueue.class);
    private final PersistenceContext context;
    private @Nullable Map<EntityKey, SubselectFetch> subselectsByEntityKey;
    private @Nullable Map<String, LinkedHashSet<EntityKey>> batchLoadableEntityKeys;
    private @Nullable Map<String, LinkedHashMap<CollectionEntry, PersistentCollection<?>>> batchLoadableCollections;

    public BatchFetchQueue(PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys = null;
        this.batchLoadableCollections = null;
        this.subselectsByEntityKey = null;
    }

    public @Nullable SubselectFetch getSubselect(EntityKey key) {
        if (this.subselectsByEntityKey == null) {
            return null;
        }
        return this.subselectsByEntityKey.get(key);
    }

    public void addSubselect(EntityKey key, SubselectFetch subquery) {
        SubselectFetch previous;
        if (this.subselectsByEntityKey == null) {
            this.subselectsByEntityKey = CollectionHelper.mapOfSize(12);
        }
        if ((previous = this.subselectsByEntityKey.put(key, subquery)) != null && LOG.isDebugEnabled()) {
            LOG.debugf("SubselectFetch previously registered with BatchFetchQueue for `%s#s`", (Object)key.getEntityName(), key.getIdentifier());
        }
    }

    public void removeSubselect(EntityKey key) {
        if (this.subselectsByEntityKey != null) {
            this.subselectsByEntityKey.remove(key);
        }
    }

    public void addBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers())) {
            if (this.batchLoadableEntityKeys == null) {
                this.batchLoadableEntityKeys = CollectionHelper.mapOfSize(12);
            }
            this.batchLoadableEntityKeys.computeIfAbsent(key.getEntityName(), k -> CollectionHelper.linkedSetOfSize(8)).add(key);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers()) && this.batchLoadableEntityKeys != null && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            set.remove(key);
        }
    }

    public boolean containsEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable(this.context.getSession().getLoadQueryInfluencers()) && this.batchLoadableEntityKeys != null && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            return set.contains(key);
        }
        return false;
    }

    public <T> void collectBatchLoadableEntityIds(int domainBatchSize, IndexedConsumer<T> collector, @NonNull T loadingId, EntityMappingType entityDescriptor) {
        collector.accept(0, loadingId);
        if (this.batchLoadableEntityKeys == null) {
            return;
        }
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(entityDescriptor.getEntityName());
        if (set == null) {
            return;
        }
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        int batchPosition = 1;
        int end = -1;
        boolean checkForEnd = false;
        for (EntityKey key : set) {
            if (checkForEnd && batchPosition == end) {
                return;
            }
            if (identifierMapping.areEqual(loadingId, key.getIdentifier(), this.context.getSession())) {
                end = batchPosition;
            } else if (!this.isCached(key, entityDescriptor.getEntityPersister())) {
                collector.accept(batchPosition++, key.getIdentifier());
            }
            if (batchPosition != domainBatchSize) continue;
            batchPosition = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
    }

    public Object[] getBatchLoadableEntityIds(EntityMappingType entityDescriptor, Object loadingId, int maxBatchSize) {
        Object[] ids = new Object[maxBatchSize];
        ids[0] = loadingId;
        if (this.batchLoadableEntityKeys == null) {
            return ids;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(entityDescriptor.getEntityName());
        EntityPersister entityPersister = entityDescriptor.getEntityPersister();
        Type identifierType = entityPersister.getIdentifierType();
        if (set != null) {
            for (EntityKey key : set) {
                if (checkForEnd && i == end) {
                    return ids;
                }
                if (identifierType.isEqual(loadingId, key.getIdentifier())) {
                    end = i;
                } else if (!this.isCached(key, entityPersister)) {
                    ids[i++] = key.getIdentifier();
                }
                if (i != maxBatchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return ids;
    }

    public void addBatchLoadableCollection(PersistentCollection<?> collection, CollectionEntry ce) {
        CollectionPersister persister = ce.getLoadedPersister();
        assert (persister != null) : "@AssumeAssertion(nullness)";
        if (this.batchLoadableCollections == null) {
            this.batchLoadableCollections = CollectionHelper.mapOfSize(12);
        }
        this.batchLoadableCollections.computeIfAbsent(persister.getRole(), k -> CollectionHelper.linkedMapOfSize(16)).put(ce, collection);
    }

    public void removeBatchLoadableCollection(CollectionEntry ce) {
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map;
        CollectionPersister persister = ce.getLoadedPersister();
        assert (persister != null) : "@AssumeAssertion(nullness)";
        if (this.batchLoadableCollections != null && (map = this.batchLoadableCollections.get(persister.getRole())) != null) {
            map.remove(ce);
        }
    }

    public <T> void collectBatchLoadableCollectionKeys(int batchSize, IndexedConsumer<T> collector, @NonNull T keyBeingLoaded, PluralAttributeMapping pluralAttributeMapping) {
        collector.accept(0, keyBeingLoaded);
        if (this.batchLoadableCollections == null) {
            return;
        }
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map = this.batchLoadableCollections.get(pluralAttributeMapping.getNavigableRole().getFullPath());
        if (map == null) {
            return;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        for (Map.Entry<CollectionEntry, PersistentCollection<?>> me : map.entrySet()) {
            CollectionEntry ce = me.getKey();
            Object loadedKey = ce.getLoadedKey();
            PersistentCollection<?> collection = me.getValue();
            if (loadedKey == null) continue;
            if (collection.wasInitialized()) {
                throw new AssertionFailure("Encountered initialized collection in BatchFetchQueue");
            }
            if (checkForEnd && i == end) {
                return;
            }
            boolean isEqual = pluralAttributeMapping.getKeyDescriptor().areEqual(keyBeingLoaded, loadedKey, this.context.getSession());
            if (isEqual) {
                end = i;
            } else if (!this.isCached(loadedKey, pluralAttributeMapping.getCollectionDescriptor())) {
                collector.accept(i++, loadedKey);
            }
            if (i != batchSize) continue;
            i = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
    }

    public Object[] getCollectionBatch(CollectionPersister collectionPersister, Object id, int batchSize) {
        Object[] keys = new Object[batchSize];
        keys[0] = id;
        if (this.batchLoadableCollections == null) {
            return keys;
        }
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashMap<CollectionEntry, PersistentCollection<?>> map = this.batchLoadableCollections.get(collectionPersister.getRole());
        if (map != null) {
            for (Map.Entry<CollectionEntry, PersistentCollection<?>> me : map.entrySet()) {
                CollectionEntry ce = me.getKey();
                Object loadedKey = ce.getLoadedKey();
                PersistentCollection<?> collection = me.getValue();
                if (loadedKey == null) continue;
                if (collection.wasInitialized()) {
                    throw new AssertionFailure("Encountered initialized collection in BatchFetchQueue");
                }
                if (checkForEnd && i == end) {
                    return keys;
                }
                boolean isEqual = collectionPersister.getKeyType().isEqual(id, loadedKey, collectionPersister.getFactory());
                if (isEqual) {
                    end = i;
                } else if (!this.isCached(loadedKey, collectionPersister)) {
                    keys[i++] = loadedKey;
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return keys;
    }

    public SharedSessionContractImplementor getSession() {
        return this.context.getSession();
    }

    private boolean isCached(Object collectionKey, CollectionPersister persister) {
        SharedSessionContractImplementor session = this.getSession();
        if (session.getCacheMode().isGetEnabled() && persister.hasCache()) {
            CollectionDataAccess cache = persister.getCacheAccessStrategy();
            Object cacheKey = cache.generateCacheKey(collectionKey, persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, cacheKey, persister, (CachedDomainDataAccess)cache) != null;
        }
        return false;
    }

    private boolean isCached(EntityKey entityKey, EntityPersister persister) {
        SharedSessionContractImplementor session = this.getSession();
        if (session.getCacheMode().isGetEnabled() && persister.canReadFromCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(entityKey.getIdentifier(), persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, key, persister, (CachedDomainDataAccess)cache) != null;
        }
        return false;
    }
}

