/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.HardcodedLDAPAttributeMapper;

public class HardcodedLDAPAttributeMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "hardcoded-ldap-attribute-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getHelpText() {
        return "This mapper is supported just if syncRegistrations is enabled. When new user is registered in Keycloak, he will be written to the LDAP with the hardcoded value of some specified attribute.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)config).checkRequired("ldap.attribute.name", "LDAP Attribute Name").checkRequired("ldap.attribute.value", "LDAP Attribute Value");
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new HardcodedLDAPAttributeMapper(mapperModel, federationProvider);
    }

    static {
        ProviderConfigProperty attrName = HardcodedLDAPAttributeMapperFactory.createConfigProperty("ldap.attribute.name", "LDAP Attribute Name", "Name of the LDAP attribute, which will be added to the new user during registration", "String", null, true);
        ProviderConfigProperty attrValue = HardcodedLDAPAttributeMapperFactory.createConfigProperty("ldap.attribute.value", "LDAP Attribute Value", "Value of the LDAP attribute, which will be added to the new user during registration. You can either hardcode any value like 'foo' but you can also use some special tokens. Only supported token right now is '${RANDOM}' , which will be replaced with some randomly generated String.", "String", null, true);
        configProperties.add(attrName);
        configProperties.add(attrValue);
    }
}

