/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Go implementation file in order to allow an easy
 use of the 3MF Library

Interface version: 2.4.1

*/

package lib3mf

// #include <string.h>
import "C"

import (
	"errors"
	"fmt"
	"syscall"
	"unsafe"
)

type Lib3MFImplementation struct {
	Initialized                                                    bool
	DLLHandle                                                      syscall.Handle
	Lib3MF_writer_writetofile                                      uintptr
	Lib3MF_writer_getstreamsize                                    uintptr
	Lib3MF_writer_writetobuffer                                    uintptr
	Lib3MF_writer_writetocallback                                  uintptr
	Lib3MF_writer_setprogresscallback                              uintptr
	Lib3MF_writer_getdecimalprecision                              uintptr
	Lib3MF_writer_setdecimalprecision                              uintptr
	Lib3MF_writer_setstrictmodeactive                              uintptr
	Lib3MF_writer_getstrictmodeactive                              uintptr
	Lib3MF_writer_getwarning                                       uintptr
	Lib3MF_writer_getwarningcount                                  uintptr
	Lib3MF_writer_addkeywrappingcallback                           uintptr
	Lib3MF_writer_setcontentencryptioncallback                     uintptr
	Lib3MF_reader_readfromfile                                     uintptr
	Lib3MF_reader_readfrombuffer                                   uintptr
	Lib3MF_reader_readfromcallback                                 uintptr
	Lib3MF_reader_setprogresscallback                              uintptr
	Lib3MF_reader_addrelationtoread                                uintptr
	Lib3MF_reader_removerelationtoread                             uintptr
	Lib3MF_reader_setstrictmodeactive                              uintptr
	Lib3MF_reader_getstrictmodeactive                              uintptr
	Lib3MF_reader_getwarning                                       uintptr
	Lib3MF_reader_getwarningcount                                  uintptr
	Lib3MF_reader_addkeywrappingcallback                           uintptr
	Lib3MF_reader_setcontentencryptioncallback                     uintptr
	Lib3MF_packagepart_getpath                                     uintptr
	Lib3MF_packagepart_setpath                                     uintptr
	Lib3MF_resource_getresourceid                                  uintptr
	Lib3MF_resource_getuniqueresourceid                            uintptr
	Lib3MF_resource_packagepart                                    uintptr
	Lib3MF_resource_setpackagepart                                 uintptr
	Lib3MF_resource_getmodelresourceid                             uintptr
	Lib3MF_resourceiterator_movenext                               uintptr
	Lib3MF_resourceiterator_moveprevious                           uintptr
	Lib3MF_resourceiterator_getcurrent                             uintptr
	Lib3MF_resourceiterator_clone                                  uintptr
	Lib3MF_resourceiterator_count                                  uintptr
	Lib3MF_slicestackiterator_getcurrentslicestack                 uintptr
	Lib3MF_objectiterator_getcurrentobject                         uintptr
	Lib3MF_meshobjectiterator_getcurrentmeshobject                 uintptr
	Lib3MF_componentsobjectiterator_getcurrentcomponentsobject     uintptr
	Lib3MF_texture2diterator_getcurrenttexture2d                   uintptr
	Lib3MF_basematerialgroupiterator_getcurrentbasematerialgroup   uintptr
	Lib3MF_colorgroupiterator_getcurrentcolorgroup                 uintptr
	Lib3MF_texture2dgroupiterator_getcurrenttexture2dgroup         uintptr
	Lib3MF_compositematerialsiterator_getcurrentcompositematerials uintptr
	Lib3MF_multipropertygroupiterator_getcurrentmultipropertygroup uintptr
	Lib3MF_image3diterator_getcurrentimage3d uintptr
	Lib3MF_scalarfielditerator_getcurrentscalarfield uintptr
	Lib3MF_vector3dfielditerator_getcurrentvector3dfield uintptr
	Lib3MF_metadata_getnamespace uintptr
	Lib3MF_metadata_setnamespace uintptr
	Lib3MF_metadata_getname uintptr
	Lib3MF_metadata_setname uintptr
	Lib3MF_metadata_getkey uintptr
	Lib3MF_metadata_getmustpreserve uintptr
	Lib3MF_metadata_setmustpreserve uintptr
	Lib3MF_metadata_gettype uintptr
	Lib3MF_metadata_settype uintptr
	Lib3MF_metadata_getvalue uintptr
	Lib3MF_metadata_setvalue uintptr
	Lib3MF_metadatagroup_getmetadatacount uintptr
	Lib3MF_metadatagroup_getmetadata uintptr
	Lib3MF_metadatagroup_getmetadatabykey uintptr
	Lib3MF_metadatagroup_removemetadatabyindex uintptr
	Lib3MF_metadatagroup_removemetadata uintptr
	Lib3MF_metadatagroup_addmetadata uintptr
	Lib3MF_object_gettype uintptr
	Lib3MF_object_settype uintptr
	Lib3MF_object_getname uintptr
	Lib3MF_object_setname uintptr
	Lib3MF_object_getpartnumber uintptr
	Lib3MF_object_setpartnumber uintptr
	Lib3MF_object_ismeshobject uintptr
	Lib3MF_object_iscomponentsobject uintptr
	Lib3MF_object_isvalid uintptr
	Lib3MF_object_setattachmentasthumbnail uintptr
	Lib3MF_object_getthumbnailattachment uintptr
	Lib3MF_object_clearthumbnailattachment uintptr
	Lib3MF_object_getoutbox uintptr
	Lib3MF_object_getuuid uintptr
	Lib3MF_object_setuuid uintptr
	Lib3MF_object_getmetadatagroup uintptr
	Lib3MF_object_setslicesmeshresolution uintptr
	Lib3MF_object_getslicesmeshresolution uintptr
	Lib3MF_object_hasslices uintptr
	Lib3MF_object_clearslicestack uintptr
	Lib3MF_object_getslicestack uintptr
	Lib3MF_object_assignslicestack uintptr
	Lib3MF_meshobject_getvertexcount uintptr
	Lib3MF_meshobject_gettrianglecount uintptr
	Lib3MF_meshobject_getvertex uintptr
	Lib3MF_meshobject_setvertex uintptr
	Lib3MF_meshobject_addvertex uintptr
	Lib3MF_meshobject_getvertices uintptr
	Lib3MF_meshobject_gettriangle uintptr
	Lib3MF_meshobject_settriangle uintptr
	Lib3MF_meshobject_addtriangle uintptr
	Lib3MF_meshobject_gettriangleindices uintptr
	Lib3MF_meshobject_setobjectlevelproperty uintptr
	Lib3MF_meshobject_getobjectlevelproperty uintptr
	Lib3MF_meshobject_settriangleproperties uintptr
	Lib3MF_meshobject_gettriangleproperties uintptr
	Lib3MF_meshobject_setalltriangleproperties uintptr
	Lib3MF_meshobject_getalltriangleproperties uintptr
	Lib3MF_meshobject_clearallproperties uintptr
	Lib3MF_meshobject_setgeometry uintptr
	Lib3MF_meshobject_ismanifoldandoriented uintptr
	Lib3MF_meshobject_beamlattice uintptr
	Lib3MF_meshobject_volumedata uintptr
	Lib3MF_beamlattice_getminlength uintptr
	Lib3MF_beamlattice_setminlength uintptr
	Lib3MF_beamlattice_getclipping uintptr
	Lib3MF_beamlattice_setclipping uintptr
	Lib3MF_beamlattice_getrepresentation uintptr
	Lib3MF_beamlattice_setrepresentation uintptr
	Lib3MF_beamlattice_getballoptions uintptr
	Lib3MF_beamlattice_setballoptions uintptr
	Lib3MF_beamlattice_getbeamcount uintptr
	Lib3MF_beamlattice_getbeam uintptr
	Lib3MF_beamlattice_addbeam uintptr
	Lib3MF_beamlattice_setbeam uintptr
	Lib3MF_beamlattice_setbeams uintptr
	Lib3MF_beamlattice_getbeams uintptr
	Lib3MF_beamlattice_getballcount uintptr
	Lib3MF_beamlattice_getball uintptr
	Lib3MF_beamlattice_addball uintptr
	Lib3MF_beamlattice_setball uintptr
	Lib3MF_beamlattice_setballs uintptr
	Lib3MF_beamlattice_getballs uintptr
	Lib3MF_beamlattice_getbeamsetcount uintptr
	Lib3MF_beamlattice_addbeamset uintptr
	Lib3MF_beamlattice_getbeamset uintptr
	Lib3MF_scalarfield_getname uintptr
	Lib3MF_scalarfield_setname uintptr
	Lib3MF_scalarfield_isfromimage3d uintptr
	Lib3MF_scalarfield_isconstant uintptr
	Lib3MF_scalarfield_iscomposed uintptr
	Lib3MF_vector3dfield_getname uintptr
	Lib3MF_vector3dfield_setname uintptr
	Lib3MF_vector3dfield_isfromimage3d uintptr
	Lib3MF_vector3dfield_isconstant uintptr
	Lib3MF_vector3dfield_iscomposed uintptr
	Lib3MF_scalarfieldfromimage3d_getimage uintptr
	Lib3MF_scalarfieldfromimage3d_setimage uintptr
	Lib3MF_scalarfieldfromimage3d_setchannel uintptr
	Lib3MF_scalarfieldfromimage3d_getchannel uintptr
	Lib3MF_scalarfieldfromimage3d_setfilter uintptr
	Lib3MF_scalarfieldfromimage3d_getfilter uintptr
	Lib3MF_scalarfieldfromimage3d_settilestyles uintptr
	Lib3MF_scalarfieldfromimage3d_gettilestyles uintptr
	Lib3MF_scalarfieldfromimage3d_getoffset uintptr
	Lib3MF_scalarfieldfromimage3d_setoffset uintptr
	Lib3MF_scalarfieldfromimage3d_getscale uintptr
	Lib3MF_scalarfieldfromimage3d_setscale uintptr
	Lib3MF_scalarfieldconstant_getvalue uintptr
	Lib3MF_scalarfieldconstant_setvalue uintptr
	Lib3MF_scalarfieldcomposed_setmethod uintptr
	Lib3MF_scalarfieldcomposed_getmethod uintptr
	Lib3MF_scalarfieldcomposed_getfactor1 uintptr
	Lib3MF_scalarfieldcomposed_setfactor1 uintptr
	Lib3MF_scalarfieldcomposed_getfactor2 uintptr
	Lib3MF_scalarfieldcomposed_setfactor2 uintptr
	Lib3MF_scalarfieldcomposed_scalarfieldreference1 uintptr
	Lib3MF_scalarfieldcomposed_scalarfieldreference2 uintptr
	Lib3MF_scalarfieldcomposed_scalarfieldreferencemask uintptr
	Lib3MF_vector3dfieldfromimage3d_getimage uintptr
	Lib3MF_vector3dfieldfromimage3d_setimage uintptr
	Lib3MF_vector3dfieldfromimage3d_setfilter uintptr
	Lib3MF_vector3dfieldfromimage3d_getfilter uintptr
	Lib3MF_vector3dfieldfromimage3d_settilestyles uintptr
	Lib3MF_vector3dfieldfromimage3d_gettilestyles uintptr
	Lib3MF_vector3dfieldfromimage3d_getoffset uintptr
	Lib3MF_vector3dfieldfromimage3d_setoffset uintptr
	Lib3MF_vector3dfieldfromimage3d_getscale uintptr
	Lib3MF_vector3dfieldfromimage3d_setscale uintptr
	Lib3MF_vector3dfieldconstant_getvaluex uintptr
	Lib3MF_vector3dfieldconstant_setvaluex uintptr
	Lib3MF_vector3dfieldconstant_getvaluey uintptr
	Lib3MF_vector3dfieldconstant_setvaluey uintptr
	Lib3MF_vector3dfieldconstant_getvaluez uintptr
	Lib3MF_vector3dfieldconstant_setvaluez uintptr
	Lib3MF_vector3dfieldcomposed_setmethod uintptr
	Lib3MF_vector3dfieldcomposed_getmethod uintptr
	Lib3MF_vector3dfieldcomposed_setspace uintptr
	Lib3MF_vector3dfieldcomposed_getspace uintptr
	Lib3MF_vector3dfieldcomposed_getfactor1 uintptr
	Lib3MF_vector3dfieldcomposed_setfactor1 uintptr
	Lib3MF_vector3dfieldcomposed_getfactor2 uintptr
	Lib3MF_vector3dfieldcomposed_setfactor2 uintptr
	Lib3MF_vector3dfieldcomposed_vector3dfieldreference1 uintptr
	Lib3MF_vector3dfieldcomposed_vector3dfieldreference2 uintptr
	Lib3MF_vector3dfieldcomposed_scalarfieldreferencemask uintptr
	Lib3MF_fieldreference_getfieldresourceid uintptr
	Lib3MF_fieldreference_setfieldresourceid uintptr
	Lib3MF_fieldreference_gettransform uintptr
	Lib3MF_fieldreference_settransform uintptr
	Lib3MF_scalarfieldreference_setscalarfield uintptr
	Lib3MF_vector3dfieldreference_setvector3dfield uintptr
	Lib3MF_volumedataboundary_getsolidthreshold uintptr
	Lib3MF_volumedataboundary_setsolidthreshold uintptr
	Lib3MF_volumedatacomposite_getbasematerialgroup uintptr
	Lib3MF_volumedatacomposite_setbasematerialgroup uintptr
	Lib3MF_volumedatacomposite_getmaterialmappingcount uintptr
	Lib3MF_volumedatacomposite_getmaterialmapping uintptr
	Lib3MF_volumedatacomposite_addmaterialmapping uintptr
	Lib3MF_volumedatacomposite_removematerialmapping uintptr
	Lib3MF_volumedataproperty_getname uintptr
	Lib3MF_volumedataproperty_setisrequired uintptr
	Lib3MF_volumedataproperty_isrequired uintptr
	Lib3MF_volumedata_getboundary uintptr
	Lib3MF_volumedata_createnewboundary uintptr
	Lib3MF_volumedata_removeboundary uintptr
	Lib3MF_volumedata_getcomposite uintptr
	Lib3MF_volumedata_createnewcomposite uintptr
	Lib3MF_volumedata_removecomposite uintptr
	Lib3MF_volumedata_getcolor uintptr
	Lib3MF_volumedata_createnewcolor uintptr
	Lib3MF_volumedata_removecolor uintptr
	Lib3MF_volumedata_getpropertycount uintptr
	Lib3MF_volumedata_getproperty uintptr
	Lib3MF_volumedata_addpropertyfromscalarfield uintptr
	Lib3MF_volumedata_addpropertyfromvector3dfield uintptr
	Lib3MF_volumedata_removeproperty uintptr
	Lib3MF_component_getobjectresource uintptr
	Lib3MF_component_getobjectresourceid uintptr
	Lib3MF_component_getuuid uintptr
	Lib3MF_component_setuuid uintptr
	Lib3MF_component_hastransform uintptr
	Lib3MF_component_gettransform uintptr
	Lib3MF_component_settransform uintptr
	Lib3MF_componentsobject_addcomponent uintptr
	Lib3MF_componentsobject_getcomponent uintptr
	Lib3MF_componentsobject_getcomponentcount uintptr
	Lib3MF_beamset_setname uintptr
	Lib3MF_beamset_getname uintptr
	Lib3MF_beamset_setidentifier uintptr
	Lib3MF_beamset_getidentifier uintptr
	Lib3MF_beamset_getreferencecount uintptr
	Lib3MF_beamset_setreferences uintptr
	Lib3MF_beamset_getreferences uintptr
	Lib3MF_beamset_getballreferencecount uintptr
	Lib3MF_beamset_setballreferences uintptr
	Lib3MF_beamset_getballreferences uintptr
	Lib3MF_basematerialgroup_getcount uintptr
	Lib3MF_basematerialgroup_getallpropertyids uintptr
	Lib3MF_basematerialgroup_addmaterial uintptr
	Lib3MF_basematerialgroup_removematerial uintptr
	Lib3MF_basematerialgroup_getname uintptr
	Lib3MF_basematerialgroup_setname uintptr
	Lib3MF_basematerialgroup_setdisplaycolor uintptr
	Lib3MF_basematerialgroup_getdisplaycolor uintptr
	Lib3MF_colorgroup_getcount uintptr
	Lib3MF_colorgroup_getallpropertyids uintptr
	Lib3MF_colorgroup_addcolor uintptr
	Lib3MF_colorgroup_removecolor uintptr
	Lib3MF_colorgroup_setcolor uintptr
	Lib3MF_colorgroup_getcolor uintptr
	Lib3MF_texture2dgroup_getcount uintptr
	Lib3MF_texture2dgroup_getallpropertyids uintptr
	Lib3MF_texture2dgroup_addtex2coord uintptr
	Lib3MF_texture2dgroup_gettex2coord uintptr
	Lib3MF_texture2dgroup_removetex2coord uintptr
	Lib3MF_texture2dgroup_gettexture2d uintptr
	Lib3MF_compositematerials_getcount uintptr
	Lib3MF_compositematerials_getallpropertyids uintptr
	Lib3MF_compositematerials_getbasematerialgroup uintptr
	Lib3MF_compositematerials_addcomposite uintptr
	Lib3MF_compositematerials_removecomposite uintptr
	Lib3MF_compositematerials_getcomposite uintptr
	Lib3MF_multipropertygroup_getcount uintptr
	Lib3MF_multipropertygroup_getallpropertyids uintptr
	Lib3MF_multipropertygroup_addmultiproperty uintptr
	Lib3MF_multipropertygroup_setmultiproperty uintptr
	Lib3MF_multipropertygroup_getmultiproperty uintptr
	Lib3MF_multipropertygroup_removemultiproperty uintptr
	Lib3MF_multipropertygroup_getlayercount uintptr
	Lib3MF_multipropertygroup_addlayer uintptr
	Lib3MF_multipropertygroup_getlayer uintptr
	Lib3MF_multipropertygroup_removelayer uintptr
	Lib3MF_image3d_getname uintptr
	Lib3MF_image3d_setname uintptr
	Lib3MF_image3d_isimagestack uintptr
	Lib3MF_imagestack_getrowcount uintptr
	Lib3MF_imagestack_setrowcount uintptr
	Lib3MF_imagestack_getcolumncount uintptr
	Lib3MF_imagestack_setcolumncount uintptr
	Lib3MF_imagestack_getsheetcount uintptr
	Lib3MF_imagestack_getsheet uintptr
	Lib3MF_imagestack_setsheet uintptr
	Lib3MF_imagestack_createemptysheet uintptr
	Lib3MF_imagestack_createsheetfrombuffer uintptr
	Lib3MF_imagestack_createsheetfromfile uintptr
	Lib3MF_attachment_getpath uintptr
	Lib3MF_attachment_setpath uintptr
	Lib3MF_attachment_packagepart uintptr
	Lib3MF_attachment_getrelationshiptype uintptr
	Lib3MF_attachment_setrelationshiptype uintptr
	Lib3MF_attachment_writetofile uintptr
	Lib3MF_attachment_readfromfile uintptr
	Lib3MF_attachment_readfromcallback uintptr
	Lib3MF_attachment_getstreamsize uintptr
	Lib3MF_attachment_writetobuffer uintptr
	Lib3MF_attachment_readfrombuffer uintptr
	Lib3MF_texture2d_getattachment uintptr
	Lib3MF_texture2d_setattachment uintptr
	Lib3MF_texture2d_getcontenttype uintptr
	Lib3MF_texture2d_setcontenttype uintptr
	Lib3MF_texture2d_gettilestyleuv uintptr
	Lib3MF_texture2d_settilestyleuv uintptr
	Lib3MF_texture2d_getfilter uintptr
	Lib3MF_texture2d_setfilter uintptr
	Lib3MF_builditem_getobjectresource uintptr
	Lib3MF_builditem_getuuid uintptr
	Lib3MF_builditem_setuuid uintptr
	Lib3MF_builditem_getobjectresourceid uintptr
	Lib3MF_builditem_hasobjecttransform uintptr
	Lib3MF_builditem_getobjecttransform uintptr
	Lib3MF_builditem_setobjecttransform uintptr
	Lib3MF_builditem_getpartnumber uintptr
	Lib3MF_builditem_setpartnumber uintptr
	Lib3MF_builditem_getmetadatagroup uintptr
	Lib3MF_builditem_getoutbox uintptr
	Lib3MF_builditemiterator_movenext uintptr
	Lib3MF_builditemiterator_moveprevious uintptr
	Lib3MF_builditemiterator_getcurrent uintptr
	Lib3MF_builditemiterator_clone uintptr
	Lib3MF_builditemiterator_count uintptr
	Lib3MF_slice_setvertices uintptr
	Lib3MF_slice_getvertices uintptr
	Lib3MF_slice_getvertexcount uintptr
	Lib3MF_slice_addpolygon uintptr
	Lib3MF_slice_getpolygoncount uintptr
	Lib3MF_slice_setpolygonindices uintptr
	Lib3MF_slice_getpolygonindices uintptr
	Lib3MF_slice_getpolygonindexcount uintptr
	Lib3MF_slice_getztop uintptr
	Lib3MF_slicestack_getbottomz uintptr
	Lib3MF_slicestack_getslicecount uintptr
	Lib3MF_slicestack_getslice uintptr
	Lib3MF_slicestack_addslice uintptr
	Lib3MF_slicestack_getslicerefcount uintptr
	Lib3MF_slicestack_addslicestackreference uintptr
	Lib3MF_slicestack_getslicestackreference uintptr
	Lib3MF_slicestack_collapseslicereferences uintptr
	Lib3MF_slicestack_setownpath uintptr
	Lib3MF_slicestack_getownpath uintptr
	Lib3MF_consumer_getconsumerid uintptr
	Lib3MF_consumer_getkeyid uintptr
	Lib3MF_consumer_getkeyvalue uintptr
	Lib3MF_accessright_getconsumer uintptr
	Lib3MF_accessright_getwrappingalgorithm uintptr
	Lib3MF_accessright_getmgfalgorithm uintptr
	Lib3MF_accessright_getdigestmethod uintptr
	Lib3MF_contentencryptionparams_getencryptionalgorithm uintptr
	Lib3MF_contentencryptionparams_getkey uintptr
	Lib3MF_contentencryptionparams_getinitializationvector uintptr
	Lib3MF_contentencryptionparams_getauthenticationtag uintptr
	Lib3MF_contentencryptionparams_setauthenticationtag uintptr
	Lib3MF_contentencryptionparams_getadditionalauthenticationdata uintptr
	Lib3MF_contentencryptionparams_getdescriptor uintptr
	Lib3MF_contentencryptionparams_getkeyuuid uintptr
	Lib3MF_resourcedata_getpath uintptr
	Lib3MF_resourcedata_getencryptionalgorithm uintptr
	Lib3MF_resourcedata_getcompression uintptr
	Lib3MF_resourcedata_getadditionalauthenticationdata uintptr
	Lib3MF_resourcedatagroup_getkeyuuid uintptr
	Lib3MF_resourcedatagroup_addaccessright uintptr
	Lib3MF_resourcedatagroup_findaccessrightbyconsumer uintptr
	Lib3MF_resourcedatagroup_removeaccessright uintptr
	Lib3MF_keystore_addconsumer uintptr
	Lib3MF_keystore_getconsumercount uintptr
	Lib3MF_keystore_getconsumer uintptr
	Lib3MF_keystore_removeconsumer uintptr
	Lib3MF_keystore_findconsumer uintptr
	Lib3MF_keystore_getresourcedatagroupcount uintptr
	Lib3MF_keystore_addresourcedatagroup uintptr
	Lib3MF_keystore_getresourcedatagroup uintptr
	Lib3MF_keystore_removeresourcedatagroup uintptr
	Lib3MF_keystore_findresourcedatagroup uintptr
	Lib3MF_keystore_addresourcedata uintptr
	Lib3MF_keystore_removeresourcedata uintptr
	Lib3MF_keystore_findresourcedata uintptr
	Lib3MF_keystore_getresourcedatacount uintptr
	Lib3MF_keystore_getresourcedata uintptr
	Lib3MF_keystore_getuuid uintptr
	Lib3MF_keystore_setuuid uintptr
	Lib3MF_model_rootmodelpart uintptr
	Lib3MF_model_findorcreatepackagepart uintptr
	Lib3MF_model_setunit uintptr
	Lib3MF_model_getunit uintptr
	Lib3MF_model_getlanguage uintptr
	Lib3MF_model_setlanguage uintptr
	Lib3MF_model_querywriter uintptr
	Lib3MF_model_queryreader uintptr
	Lib3MF_model_gettexture2dbyid uintptr
	Lib3MF_model_getpropertytypebyid uintptr
	Lib3MF_model_getbasematerialgroupbyid uintptr
	Lib3MF_model_gettexture2dgroupbyid uintptr
	Lib3MF_model_getcompositematerialsbyid uintptr
	Lib3MF_model_getmultipropertygroupbyid uintptr
	Lib3MF_model_getmeshobjectbyid uintptr
	Lib3MF_model_getcomponentsobjectbyid uintptr
	Lib3MF_model_getcolorgroupbyid uintptr
	Lib3MF_model_getslicestackbyid uintptr
	Lib3MF_model_getbuilduuid uintptr
	Lib3MF_model_setbuilduuid uintptr
	Lib3MF_model_getbuilditems uintptr
	Lib3MF_model_getoutbox uintptr
	Lib3MF_model_getresources uintptr
	Lib3MF_model_getobjects uintptr
	Lib3MF_model_getmeshobjects uintptr
	Lib3MF_model_getcomponentsobjects uintptr
	Lib3MF_model_gettexture2ds uintptr
	Lib3MF_model_getbasematerialgroups uintptr
	Lib3MF_model_getcolorgroups uintptr
	Lib3MF_model_gettexture2dgroups uintptr
	Lib3MF_model_getcompositematerials uintptr
	Lib3MF_model_getmultipropertygroups uintptr
	Lib3MF_model_getslicestacks uintptr
	Lib3MF_model_getimage3ds uintptr
	Lib3MF_model_getscalarfields uintptr
	Lib3MF_model_getvector3dfields uintptr
	Lib3MF_model_mergetomodel uintptr
	Lib3MF_model_addmeshobject uintptr
	Lib3MF_model_addcomponentsobject uintptr
	Lib3MF_model_addslicestack uintptr
	Lib3MF_model_addtexture2dfromattachment uintptr
	Lib3MF_model_addbasematerialgroup uintptr
	Lib3MF_model_addcolorgroup uintptr
	Lib3MF_model_addtexture2dgroup uintptr
	Lib3MF_model_addcompositematerials uintptr
	Lib3MF_model_addmultipropertygroup uintptr
	Lib3MF_model_addimagestack uintptr
	Lib3MF_model_getimagestackbyid uintptr
	Lib3MF_model_addscalarfieldfromimage3d uintptr
	Lib3MF_model_addscalarfieldcomposed uintptr
	Lib3MF_model_addscalarfieldconstant uintptr
	Lib3MF_model_getscalarfieldbyid uintptr
	Lib3MF_model_getscalarfieldfromimage3dbyid uintptr
	Lib3MF_model_getscalarfieldcomposedbyid uintptr
	Lib3MF_model_getscalarfieldconstantbyid uintptr
	Lib3MF_model_addvector3dfieldfromimage3d uintptr
	Lib3MF_model_addvector3dfieldcomposed uintptr
	Lib3MF_model_addvector3dfieldconstant uintptr
	Lib3MF_model_getvector3dfieldbyid uintptr
	Lib3MF_model_getvector3dfieldfromimage3dbyid uintptr
	Lib3MF_model_getvector3dfieldcomposedbyid uintptr
	Lib3MF_model_getvector3dfieldconstantbyid uintptr
	Lib3MF_model_addbuilditem uintptr
	Lib3MF_model_removebuilditem uintptr
	Lib3MF_model_getmetadatagroup uintptr
	Lib3MF_model_addattachment uintptr
	Lib3MF_model_removeattachment uintptr
	Lib3MF_model_getattachment uintptr
	Lib3MF_model_findattachment uintptr
	Lib3MF_model_getattachmentcount uintptr
	Lib3MF_model_haspackagethumbnailattachment uintptr
	Lib3MF_model_createpackagethumbnailattachment uintptr
	Lib3MF_model_getpackagethumbnailattachment uintptr
	Lib3MF_model_removepackagethumbnailattachment uintptr
	Lib3MF_model_addcustomcontenttype uintptr
	Lib3MF_model_removecustomcontenttype uintptr
	Lib3MF_model_setrandomnumbercallback uintptr
	Lib3MF_model_getkeystore uintptr
	Lib3MF_getlibraryversion uintptr
	Lib3MF_getprereleaseinformation uintptr
	Lib3MF_getbuildinformation uintptr
	Lib3MF_getspecificationversion uintptr
	Lib3MF_createmodel uintptr
	Lib3MF_release uintptr
	Lib3MF_acquire uintptr
	Lib3MF_setjournal uintptr
	Lib3MF_getlasterror uintptr
	Lib3MF_getsymbollookupmethod uintptr
	Lib3MF_retrieveprogressmessage uintptr
	Lib3MF_rgbatocolor uintptr
	Lib3MF_floatrgbatocolor uintptr
	Lib3MF_colortorgba uintptr
	Lib3MF_colortofloatrgba uintptr
	Lib3MF_getidentitytransform uintptr
	Lib3MF_getuniformscaletransform uintptr
	Lib3MF_getscaletransform uintptr
	Lib3MF_gettranslationtransform uintptr
}

type Lib3MFImplementationHandle interface {
	Lib3MFHandle

	GetDLLInHandle() uintptr
	GetDLLOutHandle() uintptr
	GetWrapper() *Lib3MFImplementation
}

type Lib3MFImplementationHandleStruct struct {
	Implementation *Lib3MFImplementation
	DLLhandle      uintptr
}

func (handle *Lib3MFImplementationHandleStruct) Close() error {
	if handle.DLLhandle != 0 {
		if handle.Implementation == nil {
			return errors.New("Uninitialized DLL Implementation Handle")
		}

		dllhandle := handle.DLLhandle
		handle.DLLhandle = 0

		return handle.Implementation.CallFunction(handle.Implementation.Lib3MF_release, dllhandle)
	}

	return nil
}

func (handle *Lib3MFImplementationHandleStruct) IsValid() bool {
	return (handle.DLLhandle != 0)
}

func (handle *Lib3MFImplementationHandleStruct) GetDLLInHandle() uintptr {
	return handle.DLLhandle
}

func (handle *Lib3MFImplementationHandleStruct) GetDLLOutHandle() uintptr {
	return uintptr(unsafe.Pointer(&handle.DLLhandle))
}

func (handle *Lib3MFImplementationHandleStruct) GetWrapper() *Lib3MFImplementation {
	return handle.Implementation
}

func Int8OutValue(reference *int8) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Int8InValue(value int8) uintptr {
	return uintptr(value)
}
func Int16OutValue(reference *int16) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Int16InValue(value int16) uintptr {
	return uintptr(value)
}
func Int32OutValue(reference *int32) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Int32InValue(value int32) uintptr {
	return uintptr(value)
}
func Int64OutValue(reference *int64) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Int64InValue(value int64) uintptr {
	return uintptr(value)
}
func UInt8OutValue(reference *uint8) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func UInt8InValue(value uint8) uintptr {
	return uintptr(value)
}
func UInt16OutValue(reference *uint16) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func UInt16InValue(value uint16) uintptr {
	return uintptr(value)
}
func UInt32OutValue(reference *uint32) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func UInt32InValue(value uint32) uintptr {
	return uintptr(value)
}
func UInt64OutValue(reference *uint64) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func UInt64InValue(value uint64) uintptr {
	return uintptr(value)
}
func Float32OutValue(reference *float32) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Float32InValue(value float32) uintptr {
	return uintptr(value)
}
func Float64OutValue(reference *float64) uintptr {
	return uintptr(unsafe.Pointer(reference))
}
func Float64InValue(value float64) uintptr {
	return uintptr(value)
}
func StringInValue(value string) uintptr {
	bytePtr, err := syscall.BytePtrFromString(value)
	if err != nil {
		return 0
	}
	return uintptr(unsafe.Pointer(bytePtr))
}

func PtrOutValue(ptr *uintptr) uintptr {
	return uintptr(unsafe.Pointer(ptr))
}

func BytesOutValue(bytePtr *[]byte) uintptr {
	return uintptr(unsafe.Pointer(bytePtr))
}

func GetLib3MFErrorMessage(errorcode uint32) string {
	switch errorcode {
	case 1:
		return "NOTIMPLEMENTED"
	case 2:
		return "INVALIDPARAM"
	case 3:
		return "INVALIDCAST"
	case 4:
		return "BUFFERTOOSMALL"
	case 5:
		return "GENERICEXCEPTION"
	case 6:
		return "COULDNOTLOADLIBRARY"
	case 7:
		return "COULDNOTFINDLIBRARYEXPORT"
	case 8:
		return "INCOMPATIBLEBINARYVERSION"
	case 10:
		return "CALCULATIONABORTED"
	case 11:
		return "SHOULDNOTBECALLED"
	case 100:
		return "READERCLASSUNKNOWN"
	case 101:
		return "WRITERCLASSUNKNOWN"
	case 102:
		return "ITERATORINVALIDINDEX"
	case 103:
		return "INVALIDMODELRESOURCE"
	case 104:
		return "RESOURCENOTFOUND"
	case 105:
		return "INVALIDMODEL"
	case 106:
		return "INVALIDOBJECT"
	case 107:
		return "INVALIDMESHOBJECT"
	case 108:
		return "INVALIDCOMPONENTSOBJECT"
	case 109:
		return "INVALIDCOMPONENT"
	case 110:
		return "INVALIDBUILDITEM"
	case 111:
		return "INVALIDBASEMATERIALGROUP"
	case 112:
		return "INVALIDSLICESTACKRESOURCE"
	case 113:
		return "INVALIDTEXTURERESOURCE"
	case 114:
		return "INVALIDCOLORGROUP"
	case 115:
		return "INVALIDTEXTURE2DGROUP"
	case 116:
		return "INVALIDCOMPOSITEMATERIALS"
	case 117:
		return "INVALIDMULTIPROPERTYGROUP"
	case 120:
		return "INVALIDRESOURCEINDEX"
	case 121:
		return "ATTACHMENTNOTFOUND"
	case 130:
		return "FORBIDDENCYCLICREFERENCE"
	case 131:
		return "INVALIDATTACHMENTSTREAM"
	case 132:
		return "INVALIDPROPERTYCOUNT"
	case 140:
		return "UNKOWNPROGRESSIDENTIFIER"
	case 141:
		return "ELEMENTCOUNTEXCEEDSLIMIT"
	case 2000:
		return "BEAMLATTICE_INVALID_OBJECTTYPE"
	case 3000:
		return "INVALIDKEYSTORE"
	case 3001:
		return "INVALIDKEYSTORECONSUMER"
	case 3002:
		return "KEYSTORECONSUMERNOTFOUND"
	case 3003:
		return "KEYSTORERESOURCEDATANOTFOUND"
	case 3004:
		return "SECURECONTEXTNOTREGISTERED"
	default:
		return "unknown"
	}
}

func (implementation *Lib3MFImplementation) GetWrapperHandle(handle Lib3MFHandle) (Lib3MFImplementationHandle, error) {
	implementation_handle, ok := handle.(Lib3MFImplementationHandle)
	if ok {
		handle_implementation := implementation_handle.GetWrapper()
		if handle_implementation == implementation {
			return implementation_handle, nil
		}
		return nil, errors.New("Invalid Implementation for DLL handle.")
	}
	return nil, errors.New("Could not cast DLL handle.")
}

func (implementation *Lib3MFImplementation) Initialize(DLLFileName string) error {
	implementation.Initialized = false
	implementation.DLLHandle = 0

	dllHandle, err := syscall.LoadLibrary(DLLFileName)
	if err != nil {
		return err
	}

	implementation.Lib3MF_writer_writetofile, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_writetofile")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_writetofile: " + err.Error())
	}

	implementation.Lib3MF_writer_getstreamsize, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_getstreamsize")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_getstreamsize: " + err.Error())
	}

	implementation.Lib3MF_writer_writetobuffer, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_writetobuffer")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_writetobuffer: " + err.Error())
	}

	implementation.Lib3MF_writer_writetocallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_writetocallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_writetocallback: " + err.Error())
	}

	implementation.Lib3MF_writer_setprogresscallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_setprogresscallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_setprogresscallback: " + err.Error())
	}

	implementation.Lib3MF_writer_getdecimalprecision, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_getdecimalprecision")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_getdecimalprecision: " + err.Error())
	}

	implementation.Lib3MF_writer_setdecimalprecision, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_setdecimalprecision")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_setdecimalprecision: " + err.Error())
	}

	implementation.Lib3MF_writer_setstrictmodeactive, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_setstrictmodeactive")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_setstrictmodeactive: " + err.Error())
	}

	implementation.Lib3MF_writer_getstrictmodeactive, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_getstrictmodeactive")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_getstrictmodeactive: " + err.Error())
	}

	implementation.Lib3MF_writer_getwarning, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_getwarning")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_getwarning: " + err.Error())
	}

	implementation.Lib3MF_writer_getwarningcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_getwarningcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_getwarningcount: " + err.Error())
	}

	implementation.Lib3MF_writer_addkeywrappingcallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_addkeywrappingcallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_addkeywrappingcallback: " + err.Error())
	}

	implementation.Lib3MF_writer_setcontentencryptioncallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_writer_setcontentencryptioncallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_writer_setcontentencryptioncallback: " + err.Error())
	}

	implementation.Lib3MF_reader_readfromfile, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_readfromfile")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_readfromfile: " + err.Error())
	}

	implementation.Lib3MF_reader_readfrombuffer, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_readfrombuffer")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_readfrombuffer: " + err.Error())
	}

	implementation.Lib3MF_reader_readfromcallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_readfromcallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_readfromcallback: " + err.Error())
	}

	implementation.Lib3MF_reader_setprogresscallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_setprogresscallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_setprogresscallback: " + err.Error())
	}

	implementation.Lib3MF_reader_addrelationtoread, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_addrelationtoread")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_addrelationtoread: " + err.Error())
	}

	implementation.Lib3MF_reader_removerelationtoread, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_removerelationtoread")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_removerelationtoread: " + err.Error())
	}

	implementation.Lib3MF_reader_setstrictmodeactive, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_setstrictmodeactive")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_setstrictmodeactive: " + err.Error())
	}

	implementation.Lib3MF_reader_getstrictmodeactive, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_getstrictmodeactive")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_getstrictmodeactive: " + err.Error())
	}

	implementation.Lib3MF_reader_getwarning, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_getwarning")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_getwarning: " + err.Error())
	}

	implementation.Lib3MF_reader_getwarningcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_getwarningcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_getwarningcount: " + err.Error())
	}

	implementation.Lib3MF_reader_addkeywrappingcallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_addkeywrappingcallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_addkeywrappingcallback: " + err.Error())
	}

	implementation.Lib3MF_reader_setcontentencryptioncallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_reader_setcontentencryptioncallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_reader_setcontentencryptioncallback: " + err.Error())
	}

	implementation.Lib3MF_packagepart_getpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_packagepart_getpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_packagepart_getpath: " + err.Error())
	}

	implementation.Lib3MF_packagepart_setpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_packagepart_setpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_packagepart_setpath: " + err.Error())
	}

	implementation.Lib3MF_resource_getresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_resource_getresourceid")
	if err != nil {
		return errors.New("Could not get function lib3mf_resource_getresourceid: " + err.Error())
	}

	implementation.Lib3MF_resource_getuniqueresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_resource_getuniqueresourceid")
	if err != nil {
		return errors.New("Could not get function lib3mf_resource_getuniqueresourceid: " + err.Error())
	}

	implementation.Lib3MF_resource_packagepart, err = syscall.GetProcAddress(dllHandle, "lib3mf_resource_packagepart")
	if err != nil {
		return errors.New("Could not get function lib3mf_resource_packagepart: " + err.Error())
	}

	implementation.Lib3MF_resource_setpackagepart, err = syscall.GetProcAddress(dllHandle, "lib3mf_resource_setpackagepart")
	if err != nil {
		return errors.New("Could not get function lib3mf_resource_setpackagepart: " + err.Error())
	}

	implementation.Lib3MF_resource_getmodelresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_resource_getmodelresourceid")
	if err != nil {
		return errors.New("Could not get function lib3mf_resource_getmodelresourceid: " + err.Error())
	}

	implementation.Lib3MF_resourceiterator_movenext, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourceiterator_movenext")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourceiterator_movenext: " + err.Error())
	}

	implementation.Lib3MF_resourceiterator_moveprevious, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourceiterator_moveprevious")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourceiterator_moveprevious: " + err.Error())
	}

	implementation.Lib3MF_resourceiterator_getcurrent, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourceiterator_getcurrent")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourceiterator_getcurrent: " + err.Error())
	}

	implementation.Lib3MF_resourceiterator_clone, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourceiterator_clone")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourceiterator_clone: " + err.Error())
	}

	implementation.Lib3MF_resourceiterator_count, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourceiterator_count")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourceiterator_count: " + err.Error())
	}

	implementation.Lib3MF_slicestackiterator_getcurrentslicestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestackiterator_getcurrentslicestack")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestackiterator_getcurrentslicestack: " + err.Error())
	}

	implementation.Lib3MF_objectiterator_getcurrentobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_objectiterator_getcurrentobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_objectiterator_getcurrentobject: " + err.Error())
	}

	implementation.Lib3MF_meshobjectiterator_getcurrentmeshobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobjectiterator_getcurrentmeshobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobjectiterator_getcurrentmeshobject: " + err.Error())
	}

	implementation.Lib3MF_componentsobjectiterator_getcurrentcomponentsobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_componentsobjectiterator_getcurrentcomponentsobject: " + err.Error())
	}

	implementation.Lib3MF_texture2diterator_getcurrenttexture2d, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2diterator_getcurrenttexture2d")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2diterator_getcurrenttexture2d: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroupiterator_getcurrentbasematerialgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup: " + err.Error())
	}

	implementation.Lib3MF_colorgroupiterator_getcurrentcolorgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroupiterator_getcurrentcolorgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroupiterator_getcurrentcolorgroup: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroupiterator_getcurrenttexture2dgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup: " + err.Error())
	}

	implementation.Lib3MF_compositematerialsiterator_getcurrentcompositematerials, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerialsiterator_getcurrentcompositematerials")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerialsiterator_getcurrentcompositematerials: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroupiterator_getcurrentmultipropertygroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup: " + err.Error())
	}
	
	implementation.Lib3MF_image3diterator_getcurrentimage3d, err = syscall.GetProcAddress(dllHandle, "lib3mf_image3diterator_getcurrentimage3d")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_image3diterator_getcurrentimage3d: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfielditerator_getcurrentscalarfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfielditerator_getcurrentscalarfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfielditerator_getcurrentscalarfield: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfielditerator_getcurrentvector3dfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfielditerator_getcurrentvector3dfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfielditerator_getcurrentvector3dfield: " + err.Error())
	}
	
	implementation.Lib3MF_metadata_getnamespace, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_getnamespace")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_getnamespace: " + err.Error())
	}

	implementation.Lib3MF_metadata_setnamespace, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_setnamespace")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_setnamespace: " + err.Error())
	}

	implementation.Lib3MF_metadata_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_getname")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_getname: " + err.Error())
	}

	implementation.Lib3MF_metadata_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_setname")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_setname: " + err.Error())
	}

	implementation.Lib3MF_metadata_getkey, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_getkey")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_getkey: " + err.Error())
	}

	implementation.Lib3MF_metadata_getmustpreserve, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_getmustpreserve")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_getmustpreserve: " + err.Error())
	}

	implementation.Lib3MF_metadata_setmustpreserve, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_setmustpreserve")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_setmustpreserve: " + err.Error())
	}

	implementation.Lib3MF_metadata_gettype, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_gettype")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_gettype: " + err.Error())
	}

	implementation.Lib3MF_metadata_settype, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_settype")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_settype: " + err.Error())
	}

	implementation.Lib3MF_metadata_getvalue, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_getvalue")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_getvalue: " + err.Error())
	}

	implementation.Lib3MF_metadata_setvalue, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadata_setvalue")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadata_setvalue: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_getmetadatacount, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_getmetadatacount")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_getmetadatacount: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_getmetadata, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_getmetadata")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_getmetadata: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_getmetadatabykey, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_getmetadatabykey")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_getmetadatabykey: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_removemetadatabyindex, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_removemetadatabyindex")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_removemetadatabyindex: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_removemetadata, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_removemetadata")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_removemetadata: " + err.Error())
	}

	implementation.Lib3MF_metadatagroup_addmetadata, err = syscall.GetProcAddress(dllHandle, "lib3mf_metadatagroup_addmetadata")
	if err != nil {
		return errors.New("Could not get function lib3mf_metadatagroup_addmetadata: " + err.Error())
	}

	implementation.Lib3MF_object_gettype, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_gettype")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_gettype: " + err.Error())
	}

	implementation.Lib3MF_object_settype, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_settype")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_settype: " + err.Error())
	}

	implementation.Lib3MF_object_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getname")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getname: " + err.Error())
	}

	implementation.Lib3MF_object_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_setname")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_setname: " + err.Error())
	}

	implementation.Lib3MF_object_getpartnumber, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getpartnumber")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getpartnumber: " + err.Error())
	}

	implementation.Lib3MF_object_setpartnumber, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_setpartnumber")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_setpartnumber: " + err.Error())
	}

	implementation.Lib3MF_object_ismeshobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_ismeshobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_ismeshobject: " + err.Error())
	}

	implementation.Lib3MF_object_iscomponentsobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_iscomponentsobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_iscomponentsobject: " + err.Error())
	}

	implementation.Lib3MF_object_isvalid, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_isvalid")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_isvalid: " + err.Error())
	}

	implementation.Lib3MF_object_setattachmentasthumbnail, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_setattachmentasthumbnail")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_setattachmentasthumbnail: " + err.Error())
	}

	implementation.Lib3MF_object_getthumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getthumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getthumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_object_clearthumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_clearthumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_clearthumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_object_getoutbox, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getoutbox")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getoutbox: " + err.Error())
	}

	implementation.Lib3MF_object_getuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getuuid: " + err.Error())
	}

	implementation.Lib3MF_object_setuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_setuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_setuuid: " + err.Error())
	}

	implementation.Lib3MF_object_getmetadatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getmetadatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getmetadatagroup: " + err.Error())
	}

	implementation.Lib3MF_object_setslicesmeshresolution, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_setslicesmeshresolution")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_setslicesmeshresolution: " + err.Error())
	}

	implementation.Lib3MF_object_getslicesmeshresolution, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getslicesmeshresolution")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getslicesmeshresolution: " + err.Error())
	}

	implementation.Lib3MF_object_hasslices, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_hasslices")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_hasslices: " + err.Error())
	}

	implementation.Lib3MF_object_clearslicestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_clearslicestack")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_clearslicestack: " + err.Error())
	}

	implementation.Lib3MF_object_getslicestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_getslicestack")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_getslicestack: " + err.Error())
	}

	implementation.Lib3MF_object_assignslicestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_object_assignslicestack")
	if err != nil {
		return errors.New("Could not get function lib3mf_object_assignslicestack: " + err.Error())
	}

	implementation.Lib3MF_meshobject_getvertexcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_getvertexcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_getvertexcount: " + err.Error())
	}

	implementation.Lib3MF_meshobject_gettrianglecount, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_gettrianglecount")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_gettrianglecount: " + err.Error())
	}

	implementation.Lib3MF_meshobject_getvertex, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_getvertex")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_getvertex: " + err.Error())
	}

	implementation.Lib3MF_meshobject_setvertex, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_setvertex")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_setvertex: " + err.Error())
	}

	implementation.Lib3MF_meshobject_addvertex, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_addvertex")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_addvertex: " + err.Error())
	}

	implementation.Lib3MF_meshobject_getvertices, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_getvertices")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_getvertices: " + err.Error())
	}

	implementation.Lib3MF_meshobject_gettriangle, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_gettriangle")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_gettriangle: " + err.Error())
	}

	implementation.Lib3MF_meshobject_settriangle, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_settriangle")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_settriangle: " + err.Error())
	}

	implementation.Lib3MF_meshobject_addtriangle, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_addtriangle")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_addtriangle: " + err.Error())
	}

	implementation.Lib3MF_meshobject_gettriangleindices, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_gettriangleindices")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_gettriangleindices: " + err.Error())
	}

	implementation.Lib3MF_meshobject_setobjectlevelproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_setobjectlevelproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_setobjectlevelproperty: " + err.Error())
	}

	implementation.Lib3MF_meshobject_getobjectlevelproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_getobjectlevelproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_getobjectlevelproperty: " + err.Error())
	}

	implementation.Lib3MF_meshobject_settriangleproperties, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_settriangleproperties")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_settriangleproperties: " + err.Error())
	}

	implementation.Lib3MF_meshobject_gettriangleproperties, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_gettriangleproperties")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_gettriangleproperties: " + err.Error())
	}

	implementation.Lib3MF_meshobject_setalltriangleproperties, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_setalltriangleproperties")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_setalltriangleproperties: " + err.Error())
	}

	implementation.Lib3MF_meshobject_getalltriangleproperties, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_getalltriangleproperties")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_getalltriangleproperties: " + err.Error())
	}

	implementation.Lib3MF_meshobject_clearallproperties, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_clearallproperties")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_clearallproperties: " + err.Error())
	}

	implementation.Lib3MF_meshobject_setgeometry, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_setgeometry")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_setgeometry: " + err.Error())
	}

	implementation.Lib3MF_meshobject_ismanifoldandoriented, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_ismanifoldandoriented")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_ismanifoldandoriented: " + err.Error())
	}

	implementation.Lib3MF_meshobject_beamlattice, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_beamlattice")
	if err != nil {
		return errors.New("Could not get function lib3mf_meshobject_beamlattice: " + err.Error())
	}
	
	implementation.Lib3MF_meshobject_volumedata, err = syscall.GetProcAddress(dllHandle, "lib3mf_meshobject_volumedata")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_meshobject_volumedata: " + err.Error())
	}
	
	implementation.Lib3MF_beamlattice_getminlength, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getminlength")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getminlength: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setminlength, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setminlength")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setminlength: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getclipping, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getclipping")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getclipping: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setclipping, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setclipping")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setclipping: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getrepresentation, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getrepresentation")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getrepresentation: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setrepresentation, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setrepresentation")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setrepresentation: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getballoptions, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getballoptions")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getballoptions: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setballoptions, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setballoptions")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setballoptions: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getbeamcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getbeamcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getbeamcount: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getbeam, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getbeam")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getbeam: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_addbeam, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_addbeam")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_addbeam: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setbeam, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setbeam")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setbeam: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setbeams, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setbeams")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setbeams: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getbeams, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getbeams")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getbeams: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getballcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getballcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getballcount: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getball, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getball")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getball: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_addball, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_addball")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_addball: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setball, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setball")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setball: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_setballs, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_setballs")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_setballs: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getballs, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getballs")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getballs: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getbeamsetcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getbeamsetcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getbeamsetcount: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_addbeamset, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_addbeamset")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_addbeamset: " + err.Error())
	}

	implementation.Lib3MF_beamlattice_getbeamset, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamlattice_getbeamset")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamlattice_getbeamset: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfield_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfield_getname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfield_getname: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfield_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfield_setname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfield_setname: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfield_isfromimage3d, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfield_isfromimage3d")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfield_isfromimage3d: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfield_isconstant, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfield_isconstant")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfield_isconstant: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfield_iscomposed, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfield_iscomposed")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfield_iscomposed: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfield_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfield_getname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfield_getname: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfield_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfield_setname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfield_setname: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfield_isfromimage3d, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfield_isfromimage3d")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfield_isfromimage3d: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfield_isconstant, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfield_isconstant")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfield_isconstant: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfield_iscomposed, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfield_iscomposed")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfield_iscomposed: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_getimage, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_getimage")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_getimage: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_setimage, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_setimage")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_setimage: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_setchannel, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_setchannel")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_setchannel: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_getchannel, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_getchannel")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_getchannel: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_setfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_setfilter")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_setfilter: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_getfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_getfilter")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_getfilter: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_settilestyles, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_settilestyles")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_settilestyles: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_gettilestyles, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_gettilestyles")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_gettilestyles: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_getoffset, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_getoffset")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_getoffset: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_setoffset, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_setoffset")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_setoffset: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_getscale, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_getscale")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_getscale: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldfromimage3d_setscale, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldfromimage3d_setscale")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldfromimage3d_setscale: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldconstant_getvalue, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldconstant_getvalue")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldconstant_getvalue: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldconstant_setvalue, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldconstant_setvalue")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldconstant_setvalue: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_setmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_setmethod")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_setmethod: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_getmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_getmethod")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_getmethod: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_getfactor1, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_getfactor1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_getfactor1: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_setfactor1, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_setfactor1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_setfactor1: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_getfactor2, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_getfactor2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_getfactor2: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_setfactor2, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_setfactor2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_setfactor2: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_scalarfieldreference1, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_scalarfieldreference1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_scalarfieldreference1: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_scalarfieldreference2, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_scalarfieldreference2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_scalarfieldreference2: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldcomposed_scalarfieldreferencemask, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldcomposed_scalarfieldreferencemask")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldcomposed_scalarfieldreferencemask: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_getimage, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_getimage")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_getimage: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_setimage, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_setimage")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_setimage: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_setfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_setfilter")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_setfilter: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_getfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_getfilter")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_getfilter: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_settilestyles, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_settilestyles")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_settilestyles: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_gettilestyles, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_gettilestyles")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_gettilestyles: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_getoffset, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_getoffset")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_getoffset: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_setoffset, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_setoffset")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_setoffset: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_getscale, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_getscale")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_getscale: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldfromimage3d_setscale, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldfromimage3d_setscale")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldfromimage3d_setscale: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_getvaluex, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_getvaluex")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_getvaluex: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_setvaluex, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_setvaluex")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_setvaluex: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_getvaluey, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_getvaluey")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_getvaluey: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_setvaluey, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_setvaluey")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_setvaluey: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_getvaluez, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_getvaluez")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_getvaluez: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldconstant_setvaluez, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldconstant_setvaluez")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldconstant_setvaluez: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_setmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_setmethod")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_setmethod: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_getmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_getmethod")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_getmethod: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_setspace, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_setspace")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_setspace: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_getspace, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_getspace")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_getspace: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_getfactor1, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_getfactor1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_getfactor1: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_setfactor1, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_setfactor1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_setfactor1: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_getfactor2, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_getfactor2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_getfactor2: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_setfactor2, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_setfactor2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_setfactor2: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_vector3dfieldreference1, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_vector3dfieldreference1")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_vector3dfieldreference1: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_vector3dfieldreference2, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_vector3dfieldreference2")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_vector3dfieldreference2: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldcomposed_scalarfieldreferencemask, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldcomposed_scalarfieldreferencemask")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldcomposed_scalarfieldreferencemask: " + err.Error())
	}
	
	implementation.Lib3MF_fieldreference_getfieldresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_fieldreference_getfieldresourceid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_fieldreference_getfieldresourceid: " + err.Error())
	}
	
	implementation.Lib3MF_fieldreference_setfieldresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_fieldreference_setfieldresourceid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_fieldreference_setfieldresourceid: " + err.Error())
	}
	
	implementation.Lib3MF_fieldreference_gettransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_fieldreference_gettransform")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_fieldreference_gettransform: " + err.Error())
	}
	
	implementation.Lib3MF_fieldreference_settransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_fieldreference_settransform")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_fieldreference_settransform: " + err.Error())
	}
	
	implementation.Lib3MF_scalarfieldreference_setscalarfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_scalarfieldreference_setscalarfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_scalarfieldreference_setscalarfield: " + err.Error())
	}
	
	implementation.Lib3MF_vector3dfieldreference_setvector3dfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_vector3dfieldreference_setvector3dfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_vector3dfieldreference_setvector3dfield: " + err.Error())
	}
	
	implementation.Lib3MF_volumedataboundary_getsolidthreshold, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedataboundary_getsolidthreshold")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedataboundary_getsolidthreshold: " + err.Error())
	}
	
	implementation.Lib3MF_volumedataboundary_setsolidthreshold, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedataboundary_setsolidthreshold")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedataboundary_setsolidthreshold: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_getbasematerialgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_getbasematerialgroup")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_getbasematerialgroup: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_setbasematerialgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_setbasematerialgroup")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_setbasematerialgroup: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_getmaterialmappingcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_getmaterialmappingcount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_getmaterialmappingcount: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_getmaterialmapping, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_getmaterialmapping")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_getmaterialmapping: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_addmaterialmapping, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_addmaterialmapping")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_addmaterialmapping: " + err.Error())
	}
	
	implementation.Lib3MF_volumedatacomposite_removematerialmapping, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedatacomposite_removematerialmapping")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedatacomposite_removematerialmapping: " + err.Error())
	}
	
	implementation.Lib3MF_volumedataproperty_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedataproperty_getname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedataproperty_getname: " + err.Error())
	}
	
	implementation.Lib3MF_volumedataproperty_setisrequired, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedataproperty_setisrequired")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedataproperty_setisrequired: " + err.Error())
	}
	
	implementation.Lib3MF_volumedataproperty_isrequired, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedataproperty_isrequired")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedataproperty_isrequired: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_getboundary, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_getboundary")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_getboundary: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_createnewboundary, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_createnewboundary")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_createnewboundary: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_removeboundary, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_removeboundary")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_removeboundary: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_getcomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_getcomposite")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_getcomposite: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_createnewcomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_createnewcomposite")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_createnewcomposite: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_removecomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_removecomposite")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_removecomposite: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_getcolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_getcolor")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_getcolor: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_createnewcolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_createnewcolor")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_createnewcolor: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_removecolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_removecolor")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_removecolor: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_getpropertycount, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_getpropertycount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_getpropertycount: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_getproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_getproperty")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_getproperty: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_addpropertyfromscalarfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_addpropertyfromscalarfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_addpropertyfromscalarfield: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_addpropertyfromvector3dfield, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_addpropertyfromvector3dfield")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_addpropertyfromvector3dfield: " + err.Error())
	}
	
	implementation.Lib3MF_volumedata_removeproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_volumedata_removeproperty")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_volumedata_removeproperty: " + err.Error())
	}
	
	implementation.Lib3MF_component_getobjectresource, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_getobjectresource")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_getobjectresource: " + err.Error())
	}

	implementation.Lib3MF_component_getobjectresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_getobjectresourceid")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_getobjectresourceid: " + err.Error())
	}

	implementation.Lib3MF_component_getuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_getuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_getuuid: " + err.Error())
	}

	implementation.Lib3MF_component_setuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_setuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_setuuid: " + err.Error())
	}

	implementation.Lib3MF_component_hastransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_hastransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_hastransform: " + err.Error())
	}

	implementation.Lib3MF_component_gettransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_gettransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_gettransform: " + err.Error())
	}

	implementation.Lib3MF_component_settransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_component_settransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_component_settransform: " + err.Error())
	}

	implementation.Lib3MF_componentsobject_addcomponent, err = syscall.GetProcAddress(dllHandle, "lib3mf_componentsobject_addcomponent")
	if err != nil {
		return errors.New("Could not get function lib3mf_componentsobject_addcomponent: " + err.Error())
	}

	implementation.Lib3MF_componentsobject_getcomponent, err = syscall.GetProcAddress(dllHandle, "lib3mf_componentsobject_getcomponent")
	if err != nil {
		return errors.New("Could not get function lib3mf_componentsobject_getcomponent: " + err.Error())
	}

	implementation.Lib3MF_componentsobject_getcomponentcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_componentsobject_getcomponentcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_componentsobject_getcomponentcount: " + err.Error())
	}

	implementation.Lib3MF_beamset_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_setname")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_setname: " + err.Error())
	}

	implementation.Lib3MF_beamset_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getname")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getname: " + err.Error())
	}

	implementation.Lib3MF_beamset_setidentifier, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_setidentifier")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_setidentifier: " + err.Error())
	}

	implementation.Lib3MF_beamset_getidentifier, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getidentifier")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getidentifier: " + err.Error())
	}

	implementation.Lib3MF_beamset_getreferencecount, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getreferencecount")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getreferencecount: " + err.Error())
	}

	implementation.Lib3MF_beamset_setreferences, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_setreferences")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_setreferences: " + err.Error())
	}

	implementation.Lib3MF_beamset_getreferences, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getreferences")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getreferences: " + err.Error())
	}

	implementation.Lib3MF_beamset_getballreferencecount, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getballreferencecount")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getballreferencecount: " + err.Error())
	}

	implementation.Lib3MF_beamset_setballreferences, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_setballreferences")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_setballreferences: " + err.Error())
	}

	implementation.Lib3MF_beamset_getballreferences, err = syscall.GetProcAddress(dllHandle, "lib3mf_beamset_getballreferences")
	if err != nil {
		return errors.New("Could not get function lib3mf_beamset_getballreferences: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_getcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_getcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_getcount: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_getallpropertyids, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_getallpropertyids")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_getallpropertyids: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_addmaterial, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_addmaterial")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_addmaterial: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_removematerial, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_removematerial")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_removematerial: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_getname")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_getname: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_setname")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_setname: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_setdisplaycolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_setdisplaycolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_setdisplaycolor: " + err.Error())
	}

	implementation.Lib3MF_basematerialgroup_getdisplaycolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_basematerialgroup_getdisplaycolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_basematerialgroup_getdisplaycolor: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_getcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_getcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_getcount: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_getallpropertyids, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_getallpropertyids")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_getallpropertyids: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_addcolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_addcolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_addcolor: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_removecolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_removecolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_removecolor: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_setcolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_setcolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_setcolor: " + err.Error())
	}

	implementation.Lib3MF_colorgroup_getcolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_colorgroup_getcolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_colorgroup_getcolor: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_getcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_getcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_getcount: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_getallpropertyids, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_getallpropertyids")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_getallpropertyids: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_addtex2coord, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_addtex2coord")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_addtex2coord: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_gettex2coord, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_gettex2coord")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_gettex2coord: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_removetex2coord, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_removetex2coord")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_removetex2coord: " + err.Error())
	}

	implementation.Lib3MF_texture2dgroup_gettexture2d, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2dgroup_gettexture2d")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2dgroup_gettexture2d: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_getcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_getcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_getcount: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_getallpropertyids, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_getallpropertyids")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_getallpropertyids: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_getbasematerialgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_getbasematerialgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_getbasematerialgroup: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_addcomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_addcomposite")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_addcomposite: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_removecomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_removecomposite")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_removecomposite: " + err.Error())
	}

	implementation.Lib3MF_compositematerials_getcomposite, err = syscall.GetProcAddress(dllHandle, "lib3mf_compositematerials_getcomposite")
	if err != nil {
		return errors.New("Could not get function lib3mf_compositematerials_getcomposite: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_getcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_getcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_getcount: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_getallpropertyids, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_getallpropertyids")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_getallpropertyids: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_addmultiproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_addmultiproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_addmultiproperty: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_setmultiproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_setmultiproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_setmultiproperty: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_getmultiproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_getmultiproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_getmultiproperty: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_removemultiproperty, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_removemultiproperty")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_removemultiproperty: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_getlayercount, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_getlayercount")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_getlayercount: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_addlayer, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_addlayer")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_addlayer: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_getlayer, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_getlayer")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_getlayer: " + err.Error())
	}

	implementation.Lib3MF_multipropertygroup_removelayer, err = syscall.GetProcAddress(dllHandle, "lib3mf_multipropertygroup_removelayer")
	if err != nil {
		return errors.New("Could not get function lib3mf_multipropertygroup_removelayer: " + err.Error())
	}
	
	implementation.Lib3MF_image3d_getname, err = syscall.GetProcAddress(dllHandle, "lib3mf_image3d_getname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_image3d_getname: " + err.Error())
	}
	
	implementation.Lib3MF_image3d_setname, err = syscall.GetProcAddress(dllHandle, "lib3mf_image3d_setname")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_image3d_setname: " + err.Error())
	}
	
	implementation.Lib3MF_image3d_isimagestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_image3d_isimagestack")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_image3d_isimagestack: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_getrowcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_getrowcount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_getrowcount: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_setrowcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_setrowcount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_setrowcount: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_getcolumncount, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_getcolumncount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_getcolumncount: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_setcolumncount, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_setcolumncount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_setcolumncount: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_getsheetcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_getsheetcount")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_getsheetcount: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_getsheet, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_getsheet")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_getsheet: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_setsheet, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_setsheet")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_setsheet: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_createemptysheet, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_createemptysheet")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_createemptysheet: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_createsheetfrombuffer, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_createsheetfrombuffer")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_createsheetfrombuffer: " + err.Error())
	}
	
	implementation.Lib3MF_imagestack_createsheetfromfile, err = syscall.GetProcAddress(dllHandle, "lib3mf_imagestack_createsheetfromfile")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_imagestack_createsheetfromfile: " + err.Error())
	}
	
	implementation.Lib3MF_attachment_getpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_getpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_getpath: " + err.Error())
	}

	implementation.Lib3MF_attachment_setpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_setpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_setpath: " + err.Error())
	}

	implementation.Lib3MF_attachment_packagepart, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_packagepart")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_packagepart: " + err.Error())
	}

	implementation.Lib3MF_attachment_getrelationshiptype, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_getrelationshiptype")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_getrelationshiptype: " + err.Error())
	}

	implementation.Lib3MF_attachment_setrelationshiptype, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_setrelationshiptype")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_setrelationshiptype: " + err.Error())
	}

	implementation.Lib3MF_attachment_writetofile, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_writetofile")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_writetofile: " + err.Error())
	}

	implementation.Lib3MF_attachment_readfromfile, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_readfromfile")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_readfromfile: " + err.Error())
	}

	implementation.Lib3MF_attachment_readfromcallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_readfromcallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_readfromcallback: " + err.Error())
	}

	implementation.Lib3MF_attachment_getstreamsize, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_getstreamsize")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_getstreamsize: " + err.Error())
	}

	implementation.Lib3MF_attachment_writetobuffer, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_writetobuffer")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_writetobuffer: " + err.Error())
	}

	implementation.Lib3MF_attachment_readfrombuffer, err = syscall.GetProcAddress(dllHandle, "lib3mf_attachment_readfrombuffer")
	if err != nil {
		return errors.New("Could not get function lib3mf_attachment_readfrombuffer: " + err.Error())
	}

	implementation.Lib3MF_texture2d_getattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_getattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_getattachment: " + err.Error())
	}

	implementation.Lib3MF_texture2d_setattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_setattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_setattachment: " + err.Error())
	}

	implementation.Lib3MF_texture2d_getcontenttype, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_getcontenttype")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_getcontenttype: " + err.Error())
	}

	implementation.Lib3MF_texture2d_setcontenttype, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_setcontenttype")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_setcontenttype: " + err.Error())
	}

	implementation.Lib3MF_texture2d_gettilestyleuv, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_gettilestyleuv")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_gettilestyleuv: " + err.Error())
	}

	implementation.Lib3MF_texture2d_settilestyleuv, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_settilestyleuv")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_settilestyleuv: " + err.Error())
	}

	implementation.Lib3MF_texture2d_getfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_getfilter")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_getfilter: " + err.Error())
	}

	implementation.Lib3MF_texture2d_setfilter, err = syscall.GetProcAddress(dllHandle, "lib3mf_texture2d_setfilter")
	if err != nil {
		return errors.New("Could not get function lib3mf_texture2d_setfilter: " + err.Error())
	}

	implementation.Lib3MF_builditem_getobjectresource, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getobjectresource")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getobjectresource: " + err.Error())
	}

	implementation.Lib3MF_builditem_getuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getuuid: " + err.Error())
	}

	implementation.Lib3MF_builditem_setuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_setuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_setuuid: " + err.Error())
	}

	implementation.Lib3MF_builditem_getobjectresourceid, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getobjectresourceid")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getobjectresourceid: " + err.Error())
	}

	implementation.Lib3MF_builditem_hasobjecttransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_hasobjecttransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_hasobjecttransform: " + err.Error())
	}

	implementation.Lib3MF_builditem_getobjecttransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getobjecttransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getobjecttransform: " + err.Error())
	}

	implementation.Lib3MF_builditem_setobjecttransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_setobjecttransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_setobjecttransform: " + err.Error())
	}

	implementation.Lib3MF_builditem_getpartnumber, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getpartnumber")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getpartnumber: " + err.Error())
	}

	implementation.Lib3MF_builditem_setpartnumber, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_setpartnumber")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_setpartnumber: " + err.Error())
	}

	implementation.Lib3MF_builditem_getmetadatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getmetadatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getmetadatagroup: " + err.Error())
	}

	implementation.Lib3MF_builditem_getoutbox, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditem_getoutbox")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditem_getoutbox: " + err.Error())
	}

	implementation.Lib3MF_builditemiterator_movenext, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditemiterator_movenext")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditemiterator_movenext: " + err.Error())
	}

	implementation.Lib3MF_builditemiterator_moveprevious, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditemiterator_moveprevious")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditemiterator_moveprevious: " + err.Error())
	}

	implementation.Lib3MF_builditemiterator_getcurrent, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditemiterator_getcurrent")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditemiterator_getcurrent: " + err.Error())
	}

	implementation.Lib3MF_builditemiterator_clone, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditemiterator_clone")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditemiterator_clone: " + err.Error())
	}

	implementation.Lib3MF_builditemiterator_count, err = syscall.GetProcAddress(dllHandle, "lib3mf_builditemiterator_count")
	if err != nil {
		return errors.New("Could not get function lib3mf_builditemiterator_count: " + err.Error())
	}

	implementation.Lib3MF_slice_setvertices, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_setvertices")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_setvertices: " + err.Error())
	}

	implementation.Lib3MF_slice_getvertices, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getvertices")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getvertices: " + err.Error())
	}

	implementation.Lib3MF_slice_getvertexcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getvertexcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getvertexcount: " + err.Error())
	}

	implementation.Lib3MF_slice_addpolygon, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_addpolygon")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_addpolygon: " + err.Error())
	}

	implementation.Lib3MF_slice_getpolygoncount, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getpolygoncount")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getpolygoncount: " + err.Error())
	}

	implementation.Lib3MF_slice_setpolygonindices, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_setpolygonindices")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_setpolygonindices: " + err.Error())
	}

	implementation.Lib3MF_slice_getpolygonindices, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getpolygonindices")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getpolygonindices: " + err.Error())
	}

	implementation.Lib3MF_slice_getpolygonindexcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getpolygonindexcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getpolygonindexcount: " + err.Error())
	}

	implementation.Lib3MF_slice_getztop, err = syscall.GetProcAddress(dllHandle, "lib3mf_slice_getztop")
	if err != nil {
		return errors.New("Could not get function lib3mf_slice_getztop: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getbottomz, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getbottomz")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getbottomz: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getslicecount, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getslicecount")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getslicecount: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getslice, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getslice")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getslice: " + err.Error())
	}

	implementation.Lib3MF_slicestack_addslice, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_addslice")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_addslice: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getslicerefcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getslicerefcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getslicerefcount: " + err.Error())
	}

	implementation.Lib3MF_slicestack_addslicestackreference, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_addslicestackreference")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_addslicestackreference: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getslicestackreference, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getslicestackreference")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getslicestackreference: " + err.Error())
	}

	implementation.Lib3MF_slicestack_collapseslicereferences, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_collapseslicereferences")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_collapseslicereferences: " + err.Error())
	}

	implementation.Lib3MF_slicestack_setownpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_setownpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_setownpath: " + err.Error())
	}

	implementation.Lib3MF_slicestack_getownpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_slicestack_getownpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_slicestack_getownpath: " + err.Error())
	}

	implementation.Lib3MF_consumer_getconsumerid, err = syscall.GetProcAddress(dllHandle, "lib3mf_consumer_getconsumerid")
	if err != nil {
		return errors.New("Could not get function lib3mf_consumer_getconsumerid: " + err.Error())
	}

	implementation.Lib3MF_consumer_getkeyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_consumer_getkeyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_consumer_getkeyid: " + err.Error())
	}

	implementation.Lib3MF_consumer_getkeyvalue, err = syscall.GetProcAddress(dllHandle, "lib3mf_consumer_getkeyvalue")
	if err != nil {
		return errors.New("Could not get function lib3mf_consumer_getkeyvalue: " + err.Error())
	}

	implementation.Lib3MF_accessright_getconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_accessright_getconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_accessright_getconsumer: " + err.Error())
	}

	implementation.Lib3MF_accessright_getwrappingalgorithm, err = syscall.GetProcAddress(dllHandle, "lib3mf_accessright_getwrappingalgorithm")
	if err != nil {
		return errors.New("Could not get function lib3mf_accessright_getwrappingalgorithm: " + err.Error())
	}

	implementation.Lib3MF_accessright_getmgfalgorithm, err = syscall.GetProcAddress(dllHandle, "lib3mf_accessright_getmgfalgorithm")
	if err != nil {
		return errors.New("Could not get function lib3mf_accessright_getmgfalgorithm: " + err.Error())
	}

	implementation.Lib3MF_accessright_getdigestmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_accessright_getdigestmethod")
	if err != nil {
		return errors.New("Could not get function lib3mf_accessright_getdigestmethod: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getencryptionalgorithm, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getencryptionalgorithm")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getencryptionalgorithm: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getkey, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getkey")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getkey: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getinitializationvector, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getinitializationvector")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getinitializationvector: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getauthenticationtag, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getauthenticationtag")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getauthenticationtag: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_setauthenticationtag, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_setauthenticationtag")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_setauthenticationtag: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getadditionalauthenticationdata, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getadditionalauthenticationdata")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getadditionalauthenticationdata: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getdescriptor, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getdescriptor")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getdescriptor: " + err.Error())
	}

	implementation.Lib3MF_contentencryptionparams_getkeyuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_contentencryptionparams_getkeyuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_contentencryptionparams_getkeyuuid: " + err.Error())
	}

	implementation.Lib3MF_resourcedata_getpath, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedata_getpath")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedata_getpath: " + err.Error())
	}

	implementation.Lib3MF_resourcedata_getencryptionalgorithm, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedata_getencryptionalgorithm")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedata_getencryptionalgorithm: " + err.Error())
	}

	implementation.Lib3MF_resourcedata_getcompression, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedata_getcompression")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedata_getcompression: " + err.Error())
	}

	implementation.Lib3MF_resourcedata_getadditionalauthenticationdata, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedata_getadditionalauthenticationdata")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedata_getadditionalauthenticationdata: " + err.Error())
	}

	implementation.Lib3MF_resourcedatagroup_getkeyuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedatagroup_getkeyuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedatagroup_getkeyuuid: " + err.Error())
	}

	implementation.Lib3MF_resourcedatagroup_addaccessright, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedatagroup_addaccessright")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedatagroup_addaccessright: " + err.Error())
	}

	implementation.Lib3MF_resourcedatagroup_findaccessrightbyconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedatagroup_findaccessrightbyconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedatagroup_findaccessrightbyconsumer: " + err.Error())
	}

	implementation.Lib3MF_resourcedatagroup_removeaccessright, err = syscall.GetProcAddress(dllHandle, "lib3mf_resourcedatagroup_removeaccessright")
	if err != nil {
		return errors.New("Could not get function lib3mf_resourcedatagroup_removeaccessright: " + err.Error())
	}

	implementation.Lib3MF_keystore_addconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_addconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_addconsumer: " + err.Error())
	}

	implementation.Lib3MF_keystore_getconsumercount, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getconsumercount")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getconsumercount: " + err.Error())
	}

	implementation.Lib3MF_keystore_getconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getconsumer: " + err.Error())
	}

	implementation.Lib3MF_keystore_removeconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_removeconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_removeconsumer: " + err.Error())
	}

	implementation.Lib3MF_keystore_findconsumer, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_findconsumer")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_findconsumer: " + err.Error())
	}

	implementation.Lib3MF_keystore_getresourcedatagroupcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getresourcedatagroupcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getresourcedatagroupcount: " + err.Error())
	}

	implementation.Lib3MF_keystore_addresourcedatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_addresourcedatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_addresourcedatagroup: " + err.Error())
	}

	implementation.Lib3MF_keystore_getresourcedatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getresourcedatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getresourcedatagroup: " + err.Error())
	}

	implementation.Lib3MF_keystore_removeresourcedatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_removeresourcedatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_removeresourcedatagroup: " + err.Error())
	}

	implementation.Lib3MF_keystore_findresourcedatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_findresourcedatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_findresourcedatagroup: " + err.Error())
	}

	implementation.Lib3MF_keystore_addresourcedata, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_addresourcedata")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_addresourcedata: " + err.Error())
	}

	implementation.Lib3MF_keystore_removeresourcedata, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_removeresourcedata")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_removeresourcedata: " + err.Error())
	}

	implementation.Lib3MF_keystore_findresourcedata, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_findresourcedata")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_findresourcedata: " + err.Error())
	}

	implementation.Lib3MF_keystore_getresourcedatacount, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getresourcedatacount")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getresourcedatacount: " + err.Error())
	}

	implementation.Lib3MF_keystore_getresourcedata, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getresourcedata")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getresourcedata: " + err.Error())
	}

	implementation.Lib3MF_keystore_getuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_getuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_getuuid: " + err.Error())
	}

	implementation.Lib3MF_keystore_setuuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_keystore_setuuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_keystore_setuuid: " + err.Error())
	}

	implementation.Lib3MF_model_rootmodelpart, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_rootmodelpart")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_rootmodelpart: " + err.Error())
	}

	implementation.Lib3MF_model_findorcreatepackagepart, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_findorcreatepackagepart")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_findorcreatepackagepart: " + err.Error())
	}

	implementation.Lib3MF_model_setunit, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_setunit")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_setunit: " + err.Error())
	}

	implementation.Lib3MF_model_getunit, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getunit")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getunit: " + err.Error())
	}

	implementation.Lib3MF_model_getlanguage, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getlanguage")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getlanguage: " + err.Error())
	}

	implementation.Lib3MF_model_setlanguage, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_setlanguage")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_setlanguage: " + err.Error())
	}

	implementation.Lib3MF_model_querywriter, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_querywriter")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_querywriter: " + err.Error())
	}

	implementation.Lib3MF_model_queryreader, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_queryreader")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_queryreader: " + err.Error())
	}

	implementation.Lib3MF_model_gettexture2dbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_gettexture2dbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_gettexture2dbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getpropertytypebyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getpropertytypebyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getpropertytypebyid: " + err.Error())
	}

	implementation.Lib3MF_model_getbasematerialgroupbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getbasematerialgroupbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getbasematerialgroupbyid: " + err.Error())
	}

	implementation.Lib3MF_model_gettexture2dgroupbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_gettexture2dgroupbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_gettexture2dgroupbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getcompositematerialsbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcompositematerialsbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcompositematerialsbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getmultipropertygroupbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getmultipropertygroupbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getmultipropertygroupbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getmeshobjectbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getmeshobjectbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getmeshobjectbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getcomponentsobjectbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcomponentsobjectbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcomponentsobjectbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getcolorgroupbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcolorgroupbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcolorgroupbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getslicestackbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getslicestackbyid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getslicestackbyid: " + err.Error())
	}

	implementation.Lib3MF_model_getbuilduuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getbuilduuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getbuilduuid: " + err.Error())
	}

	implementation.Lib3MF_model_setbuilduuid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_setbuilduuid")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_setbuilduuid: " + err.Error())
	}

	implementation.Lib3MF_model_getbuilditems, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getbuilditems")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getbuilditems: " + err.Error())
	}

	implementation.Lib3MF_model_getoutbox, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getoutbox")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getoutbox: " + err.Error())
	}

	implementation.Lib3MF_model_getresources, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getresources")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getresources: " + err.Error())
	}

	implementation.Lib3MF_model_getobjects, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getobjects")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getobjects: " + err.Error())
	}

	implementation.Lib3MF_model_getmeshobjects, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getmeshobjects")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getmeshobjects: " + err.Error())
	}

	implementation.Lib3MF_model_getcomponentsobjects, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcomponentsobjects")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcomponentsobjects: " + err.Error())
	}

	implementation.Lib3MF_model_gettexture2ds, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_gettexture2ds")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_gettexture2ds: " + err.Error())
	}

	implementation.Lib3MF_model_getbasematerialgroups, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getbasematerialgroups")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getbasematerialgroups: " + err.Error())
	}

	implementation.Lib3MF_model_getcolorgroups, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcolorgroups")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcolorgroups: " + err.Error())
	}

	implementation.Lib3MF_model_gettexture2dgroups, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_gettexture2dgroups")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_gettexture2dgroups: " + err.Error())
	}

	implementation.Lib3MF_model_getcompositematerials, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getcompositematerials")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getcompositematerials: " + err.Error())
	}

	implementation.Lib3MF_model_getmultipropertygroups, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getmultipropertygroups")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getmultipropertygroups: " + err.Error())
	}

	implementation.Lib3MF_model_getslicestacks, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getslicestacks")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getslicestacks: " + err.Error())
	}
	
	implementation.Lib3MF_model_getimage3ds, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getimage3ds")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getimage3ds: " + err.Error())
	}
	
	implementation.Lib3MF_model_getscalarfields, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getscalarfields")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getscalarfields: " + err.Error())
	}
	
	implementation.Lib3MF_model_getvector3dfields, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getvector3dfields")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getvector3dfields: " + err.Error())
	}
	
	implementation.Lib3MF_model_mergetomodel, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_mergetomodel")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_mergetomodel: " + err.Error())
	}

	implementation.Lib3MF_model_addmeshobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addmeshobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addmeshobject: " + err.Error())
	}

	implementation.Lib3MF_model_addcomponentsobject, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addcomponentsobject")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addcomponentsobject: " + err.Error())
	}

	implementation.Lib3MF_model_addslicestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addslicestack")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addslicestack: " + err.Error())
	}

	implementation.Lib3MF_model_addtexture2dfromattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addtexture2dfromattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addtexture2dfromattachment: " + err.Error())
	}

	implementation.Lib3MF_model_addbasematerialgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addbasematerialgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addbasematerialgroup: " + err.Error())
	}

	implementation.Lib3MF_model_addcolorgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addcolorgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addcolorgroup: " + err.Error())
	}

	implementation.Lib3MF_model_addtexture2dgroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addtexture2dgroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addtexture2dgroup: " + err.Error())
	}

	implementation.Lib3MF_model_addcompositematerials, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addcompositematerials")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addcompositematerials: " + err.Error())
	}

	implementation.Lib3MF_model_addmultipropertygroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addmultipropertygroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addmultipropertygroup: " + err.Error())
	}
	
	implementation.Lib3MF_model_addimagestack, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addimagestack")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addimagestack: " + err.Error())
	}
	
	implementation.Lib3MF_model_getimagestackbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getimagestackbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getimagestackbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_addscalarfieldfromimage3d, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addscalarfieldfromimage3d")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addscalarfieldfromimage3d: " + err.Error())
	}
	
	implementation.Lib3MF_model_addscalarfieldcomposed, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addscalarfieldcomposed")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addscalarfieldcomposed: " + err.Error())
	}
	
	implementation.Lib3MF_model_addscalarfieldconstant, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addscalarfieldconstant")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addscalarfieldconstant: " + err.Error())
	}
	
	implementation.Lib3MF_model_getscalarfieldbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getscalarfieldbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getscalarfieldbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getscalarfieldfromimage3dbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getscalarfieldfromimage3dbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getscalarfieldfromimage3dbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getscalarfieldcomposedbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getscalarfieldcomposedbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getscalarfieldcomposedbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getscalarfieldconstantbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getscalarfieldconstantbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getscalarfieldconstantbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_addvector3dfieldfromimage3d, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addvector3dfieldfromimage3d")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addvector3dfieldfromimage3d: " + err.Error())
	}
	
	implementation.Lib3MF_model_addvector3dfieldcomposed, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addvector3dfieldcomposed")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addvector3dfieldcomposed: " + err.Error())
	}
	
	implementation.Lib3MF_model_addvector3dfieldconstant, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addvector3dfieldconstant")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_addvector3dfieldconstant: " + err.Error())
	}
	
	implementation.Lib3MF_model_getvector3dfieldbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getvector3dfieldbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getvector3dfieldbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getvector3dfieldfromimage3dbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getvector3dfieldfromimage3dbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getvector3dfieldfromimage3dbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getvector3dfieldcomposedbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getvector3dfieldcomposedbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getvector3dfieldcomposedbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_getvector3dfieldconstantbyid, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getvector3dfieldconstantbyid")
	if (err != nil) {
		return errors.New("Could not get function lib3mf_model_getvector3dfieldconstantbyid: " + err.Error())
	}
	
	implementation.Lib3MF_model_addbuilditem, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addbuilditem")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addbuilditem: " + err.Error())
	}

	implementation.Lib3MF_model_removebuilditem, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_removebuilditem")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_removebuilditem: " + err.Error())
	}

	implementation.Lib3MF_model_getmetadatagroup, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getmetadatagroup")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getmetadatagroup: " + err.Error())
	}

	implementation.Lib3MF_model_addattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addattachment: " + err.Error())
	}

	implementation.Lib3MF_model_removeattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_removeattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_removeattachment: " + err.Error())
	}

	implementation.Lib3MF_model_getattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getattachment: " + err.Error())
	}

	implementation.Lib3MF_model_findattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_findattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_findattachment: " + err.Error())
	}

	implementation.Lib3MF_model_getattachmentcount, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getattachmentcount")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getattachmentcount: " + err.Error())
	}

	implementation.Lib3MF_model_haspackagethumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_haspackagethumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_haspackagethumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_model_createpackagethumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_createpackagethumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_createpackagethumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_model_getpackagethumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getpackagethumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getpackagethumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_model_removepackagethumbnailattachment, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_removepackagethumbnailattachment")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_removepackagethumbnailattachment: " + err.Error())
	}

	implementation.Lib3MF_model_addcustomcontenttype, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_addcustomcontenttype")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_addcustomcontenttype: " + err.Error())
	}

	implementation.Lib3MF_model_removecustomcontenttype, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_removecustomcontenttype")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_removecustomcontenttype: " + err.Error())
	}

	implementation.Lib3MF_model_setrandomnumbercallback, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_setrandomnumbercallback")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_setrandomnumbercallback: " + err.Error())
	}

	implementation.Lib3MF_model_getkeystore, err = syscall.GetProcAddress(dllHandle, "lib3mf_model_getkeystore")
	if err != nil {
		return errors.New("Could not get function lib3mf_model_getkeystore: " + err.Error())
	}

	implementation.Lib3MF_getlibraryversion, err = syscall.GetProcAddress(dllHandle, "lib3mf_getlibraryversion")
	if err != nil {
		return errors.New("Could not get function lib3mf_getlibraryversion: " + err.Error())
	}

	implementation.Lib3MF_getprereleaseinformation, err = syscall.GetProcAddress(dllHandle, "lib3mf_getprereleaseinformation")
	if err != nil {
		return errors.New("Could not get function lib3mf_getprereleaseinformation: " + err.Error())
	}

	implementation.Lib3MF_getbuildinformation, err = syscall.GetProcAddress(dllHandle, "lib3mf_getbuildinformation")
	if err != nil {
		return errors.New("Could not get function lib3mf_getbuildinformation: " + err.Error())
	}

	implementation.Lib3MF_getspecificationversion, err = syscall.GetProcAddress(dllHandle, "lib3mf_getspecificationversion")
	if err != nil {
		return errors.New("Could not get function lib3mf_getspecificationversion: " + err.Error())
	}

	implementation.Lib3MF_createmodel, err = syscall.GetProcAddress(dllHandle, "lib3mf_createmodel")
	if err != nil {
		return errors.New("Could not get function lib3mf_createmodel: " + err.Error())
	}

	implementation.Lib3MF_release, err = syscall.GetProcAddress(dllHandle, "lib3mf_release")
	if err != nil {
		return errors.New("Could not get function lib3mf_release: " + err.Error())
	}

	implementation.Lib3MF_acquire, err = syscall.GetProcAddress(dllHandle, "lib3mf_acquire")
	if err != nil {
		return errors.New("Could not get function lib3mf_acquire: " + err.Error())
	}

	implementation.Lib3MF_setjournal, err = syscall.GetProcAddress(dllHandle, "lib3mf_setjournal")
	if err != nil {
		return errors.New("Could not get function lib3mf_setjournal: " + err.Error())
	}

	implementation.Lib3MF_getlasterror, err = syscall.GetProcAddress(dllHandle, "lib3mf_getlasterror")
	if err != nil {
		return errors.New("Could not get function lib3mf_getlasterror: " + err.Error())
	}

	implementation.Lib3MF_getsymbollookupmethod, err = syscall.GetProcAddress(dllHandle, "lib3mf_getsymbollookupmethod")
	if err != nil {
		return errors.New("Could not get function lib3mf_getsymbollookupmethod: " + err.Error())
	}

	implementation.Lib3MF_retrieveprogressmessage, err = syscall.GetProcAddress(dllHandle, "lib3mf_retrieveprogressmessage")
	if err != nil {
		return errors.New("Could not get function lib3mf_retrieveprogressmessage: " + err.Error())
	}

	implementation.Lib3MF_rgbatocolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_rgbatocolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_rgbatocolor: " + err.Error())
	}

	implementation.Lib3MF_floatrgbatocolor, err = syscall.GetProcAddress(dllHandle, "lib3mf_floatrgbatocolor")
	if err != nil {
		return errors.New("Could not get function lib3mf_floatrgbatocolor: " + err.Error())
	}

	implementation.Lib3MF_colortorgba, err = syscall.GetProcAddress(dllHandle, "lib3mf_colortorgba")
	if err != nil {
		return errors.New("Could not get function lib3mf_colortorgba: " + err.Error())
	}

	implementation.Lib3MF_colortofloatrgba, err = syscall.GetProcAddress(dllHandle, "lib3mf_colortofloatrgba")
	if err != nil {
		return errors.New("Could not get function lib3mf_colortofloatrgba: " + err.Error())
	}

	implementation.Lib3MF_getidentitytransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_getidentitytransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_getidentitytransform: " + err.Error())
	}

	implementation.Lib3MF_getuniformscaletransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_getuniformscaletransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_getuniformscaletransform: " + err.Error())
	}

	implementation.Lib3MF_getscaletransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_getscaletransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_getscaletransform: " + err.Error())
	}

	implementation.Lib3MF_gettranslationtransform, err = syscall.GetProcAddress(dllHandle, "lib3mf_gettranslationtransform")
	if err != nil {
		return errors.New("Could not get function lib3mf_gettranslationtransform: " + err.Error())
	}

	implementation.DLLHandle = dllHandle
	implementation.Initialized = true
	return nil
}

func (implementation *Lib3MFImplementation) NewHandle() Lib3MFImplementationHandle {
	handle := new(Lib3MFImplementationHandleStruct)
	handle.Implementation = implementation
	handle.DLLhandle = 0
	return handle
}

func (implementation *Lib3MFImplementation) CallFunction(funcptr uintptr, parameters ...uintptr) error {
	var ret uintptr
	if !implementation.Initialized {
		return errors.New("Lib3MF Implementation has not been initialized!")
	}

	switch len(parameters) {
	case 0:
		ret, _, _ = syscall.Syscall(funcptr, 0, 0, 0, 0)
	case 1:
		ret, _, _ = syscall.Syscall(funcptr, 1, uintptr(parameters[0]), 0, 0)
	case 2:
		ret, _, _ = syscall.Syscall(funcptr, 2, uintptr(parameters[0]), uintptr(parameters[1]), 0)
	case 3:
		ret, _, _ = syscall.Syscall(funcptr, 3, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]))
	case 4:
		ret, _, _ = syscall.Syscall6(funcptr, 4, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), 0, 0)
	case 5:
		ret, _, _ = syscall.Syscall6(funcptr, 5, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), 0)
	case 6:
		ret, _, _ = syscall.Syscall6(funcptr, 6, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]))
	case 7:
		ret, _, _ = syscall.Syscall9(funcptr, 7, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), 0, 0)
	case 8:
		ret, _, _ = syscall.Syscall9(funcptr, 8, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), uintptr(parameters[7]), 0)
	case 9:
		ret, _, _ = syscall.Syscall9(funcptr, 9, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), uintptr(parameters[7]), uintptr(parameters[8]))
	case 10:
		ret, _, _ = syscall.Syscall12(funcptr, 10, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), uintptr(parameters[7]), uintptr(parameters[8]), uintptr(parameters[9]), 0, 0)
	case 11:
		ret, _, _ = syscall.Syscall12(funcptr, 11, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), uintptr(parameters[7]), uintptr(parameters[8]), uintptr(parameters[9]), uintptr(parameters[10]), 0)
	case 12:
		ret, _, _ = syscall.Syscall12(funcptr, 12, uintptr(parameters[0]), uintptr(parameters[1]), uintptr(parameters[2]), uintptr(parameters[3]), uintptr(parameters[4]), uintptr(parameters[5]), uintptr(parameters[6]), uintptr(parameters[7]), uintptr(parameters[8]), uintptr(parameters[9]), uintptr(parameters[10]), uintptr(parameters[11]))
	default:
		return errors.New("Invalid DLL function parameter count!")
	}

	if int(ret) != 0 {
		return errors.New(fmt.Sprintf("Lib3MF Error: %.04x (%s)", int(ret), GetLib3MFErrorMessage(uint32(ret))))
	}

	return nil
}

func (implementation *Lib3MFImplementation) Writer_WriteToFile(Writer Lib3MFHandle, sFilename string) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_writetofile, implementation_writer.GetDLLInHandle(), StringInValue(sFilename))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_GetStreamSize(Writer Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nStreamSize uint64 = 0

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_getstreamsize, implementation_writer.GetDLLInHandle(), UInt64OutValue(&nStreamSize))
	if err != nil {
		return 0, err
	}

	return uint64(nStreamSize), err
}

func (implementation *Lib3MFImplementation) Writer_WriteToBuffer(Writer Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforBuffer int64 = 0
	var filledinBuffer int64 = 0
	bufferBuffer := make([]uint8, 0)

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_writetobuffer, implementation_writer.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforBuffer), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeBuffer := neededforBuffer
	bufferBuffer = make([]uint8, bufferSizeBuffer)
	err = implementation.CallFunction(implementation.Lib3MF_writer_writetobuffer, implementation_writer.GetDLLInHandle(), Int64InValue(bufferSizeBuffer), Int64OutValue(&filledinBuffer), uintptr(unsafe.Pointer(&bufferBuffer[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferBuffer, err
}

func (implementation *Lib3MFImplementation) Writer_WriteToCallback(Writer Lib3MFHandle, pTheWriteCallback int64, pTheSeekCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_writetocallback, implementation_writer.GetDLLInHandle(), 0, 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_SetProgressCallback(Writer Lib3MFHandle, pProgressCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_setprogresscallback, implementation_writer.GetDLLInHandle(), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_GetDecimalPrecision(Writer Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nDecimalPrecision uint32 = 0

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_getdecimalprecision, implementation_writer.GetDLLInHandle(), UInt32OutValue(&nDecimalPrecision))
	if err != nil {
		return 0, err
	}

	return uint32(nDecimalPrecision), err
}

func (implementation *Lib3MFImplementation) Writer_SetDecimalPrecision(Writer Lib3MFHandle, nDecimalPrecision uint32) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_setdecimalprecision, implementation_writer.GetDLLInHandle(), UInt32InValue(nDecimalPrecision))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_SetStrictModeActive(Writer Lib3MFHandle, bStrictModeActive bool) error {
	var err error = nil
	var nStrictModeActive uint8 = 0
	if bStrictModeActive {
		nStrictModeActive = 1
	}

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_setstrictmodeactive, implementation_writer.GetDLLInHandle(), UInt8InValue(nStrictModeActive))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_GetStrictModeActive(Writer Lib3MFHandle) (bool, error) {
	var err error = nil
	var bStrictModeActive int64 = 0

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_getstrictmodeactive, implementation_writer.GetDLLInHandle(), Int64OutValue(&bStrictModeActive))
	if err != nil {
		return false, err
	}

	return (bStrictModeActive != 0), err
}

func (implementation *Lib3MFImplementation) Writer_GetWarning(Writer Lib3MFHandle, nIndex uint32) (uint32, string, error) {
	var err error = nil
	var nErrorCode uint32 = 0
	var neededforWarning int64 = 0
	var filledinWarning int64 = 0

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return 0, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_getwarning, implementation_writer.GetDLLInHandle(), UInt32InValue(nIndex), UInt32OutValue(&nErrorCode), Int64InValue(0), Int64OutValue(&neededforWarning), Int64InValue(0))
	if err != nil {
		return 0, "", err
	}
	bufferSizeWarning := neededforWarning
	bufferWarning := make([]byte, bufferSizeWarning)
	err = implementation.CallFunction(implementation.Lib3MF_writer_getwarning, implementation_writer.GetDLLInHandle(), UInt32InValue(nIndex), UInt32OutValue(&nErrorCode), Int64InValue(bufferSizeWarning), Int64OutValue(&filledinWarning), uintptr(unsafe.Pointer(&bufferWarning[0])))
	if err != nil {
		return 0, "", err
	}

	return uint32(nErrorCode), string(bufferWarning[:(filledinWarning - 1)]), err
}

func (implementation *Lib3MFImplementation) Writer_GetWarningCount(Writer Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_getwarningcount, implementation_writer.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) Writer_AddKeyWrappingCallback(Writer Lib3MFHandle, sConsumerID string, pTheCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_addkeywrappingcallback, implementation_writer.GetDLLInHandle(), StringInValue(sConsumerID), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Writer_SetContentEncryptionCallback(Writer Lib3MFHandle, pTheCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_writer, err := implementation.GetWrapperHandle(Writer)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_writer_setcontentencryptioncallback, implementation_writer.GetDLLInHandle(), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_ReadFromFile(Reader Lib3MFHandle, sFilename string) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_readfromfile, implementation_reader.GetDLLInHandle(), StringInValue(sFilename))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_ReadFromBuffer(Reader Lib3MFHandle, Buffer []uint8) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_readfrombuffer, implementation_reader.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_ReadFromCallback(Reader Lib3MFHandle, pTheReadCallback int64, nStreamSize uint64, pTheSeekCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_readfromcallback, implementation_reader.GetDLLInHandle(), 0, UInt64InValue(nStreamSize), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_SetProgressCallback(Reader Lib3MFHandle, pProgressCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_setprogresscallback, implementation_reader.GetDLLInHandle(), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_AddRelationToRead(Reader Lib3MFHandle, sRelationShipType string) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_addrelationtoread, implementation_reader.GetDLLInHandle(), StringInValue(sRelationShipType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_RemoveRelationToRead(Reader Lib3MFHandle, sRelationShipType string) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_removerelationtoread, implementation_reader.GetDLLInHandle(), StringInValue(sRelationShipType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_SetStrictModeActive(Reader Lib3MFHandle, bStrictModeActive bool) error {
	var err error = nil
	var nStrictModeActive uint8 = 0
	if bStrictModeActive {
		nStrictModeActive = 1
	}

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_setstrictmodeactive, implementation_reader.GetDLLInHandle(), UInt8InValue(nStrictModeActive))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_GetStrictModeActive(Reader Lib3MFHandle) (bool, error) {
	var err error = nil
	var bStrictModeActive int64 = 0

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_getstrictmodeactive, implementation_reader.GetDLLInHandle(), Int64OutValue(&bStrictModeActive))
	if err != nil {
		return false, err
	}

	return (bStrictModeActive != 0), err
}

func (implementation *Lib3MFImplementation) Reader_GetWarning(Reader Lib3MFHandle, nIndex uint32) (uint32, string, error) {
	var err error = nil
	var nErrorCode uint32 = 0
	var neededforWarning int64 = 0
	var filledinWarning int64 = 0

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return 0, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_getwarning, implementation_reader.GetDLLInHandle(), UInt32InValue(nIndex), UInt32OutValue(&nErrorCode), Int64InValue(0), Int64OutValue(&neededforWarning), Int64InValue(0))
	if err != nil {
		return 0, "", err
	}
	bufferSizeWarning := neededforWarning
	bufferWarning := make([]byte, bufferSizeWarning)
	err = implementation.CallFunction(implementation.Lib3MF_reader_getwarning, implementation_reader.GetDLLInHandle(), UInt32InValue(nIndex), UInt32OutValue(&nErrorCode), Int64InValue(bufferSizeWarning), Int64OutValue(&filledinWarning), uintptr(unsafe.Pointer(&bufferWarning[0])))
	if err != nil {
		return 0, "", err
	}

	return uint32(nErrorCode), string(bufferWarning[:(filledinWarning - 1)]), err
}

func (implementation *Lib3MFImplementation) Reader_GetWarningCount(Reader Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_getwarningcount, implementation_reader.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) Reader_AddKeyWrappingCallback(Reader Lib3MFHandle, sConsumerID string, pTheCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_addkeywrappingcallback, implementation_reader.GetDLLInHandle(), StringInValue(sConsumerID), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Reader_SetContentEncryptionCallback(Reader Lib3MFHandle, pTheCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_reader, err := implementation.GetWrapperHandle(Reader)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_reader_setcontentencryptioncallback, implementation_reader.GetDLLInHandle(), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) PackagePart_GetPath(PackagePart Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPath int64 = 0
	var filledinPath int64 = 0

	implementation_packagepart, err := implementation.GetWrapperHandle(PackagePart)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_packagepart_getpath, implementation_packagepart.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPath), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePath := neededforPath
	bufferPath := make([]byte, bufferSizePath)
	err = implementation.CallFunction(implementation.Lib3MF_packagepart_getpath, implementation_packagepart.GetDLLInHandle(), Int64InValue(bufferSizePath), Int64OutValue(&filledinPath), uintptr(unsafe.Pointer(&bufferPath[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPath[:(filledinPath - 1)]), err
}

func (implementation *Lib3MFImplementation) PackagePart_SetPath(PackagePart Lib3MFHandle, sPath string) error {
	var err error = nil

	implementation_packagepart, err := implementation.GetWrapperHandle(PackagePart)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_packagepart_setpath, implementation_packagepart.GetDLLInHandle(), StringInValue(sPath))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Resource_GetResourceID(Resource Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0

	implementation_resource, err := implementation.GetWrapperHandle(Resource)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resource_getresourceid, implementation_resource.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return 0, err
	}

	return uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) Resource_GetUniqueResourceID(Resource Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0

	implementation_resource, err := implementation.GetWrapperHandle(Resource)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resource_getuniqueresourceid, implementation_resource.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return 0, err
	}

	return uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) Resource_PackagePart(Resource Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hPackagePart := implementation.NewHandle()

	implementation_resource, err := implementation.GetWrapperHandle(Resource)
	if err != nil {
		return hPackagePart, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resource_packagepart, implementation_resource.GetDLLInHandle(), hPackagePart.GetDLLOutHandle())
	if err != nil {
		return hPackagePart, err
	}

	return hPackagePart, err
}

func (implementation *Lib3MFImplementation) Resource_SetPackagePart(Resource Lib3MFHandle, PackagePart Lib3MFHandle) error {
	var err error = nil

	implementation_resource, err := implementation.GetWrapperHandle(Resource)
	if err != nil {
		return err
	}
	implementation_packagepart, err := implementation.GetWrapperHandle(PackagePart)
	if err != nil {
		return err
	}

	PackagePartDLLHandle := implementation_packagepart.GetDLLInHandle()
	if PackagePartDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resource_setpackagepart, implementation_resource.GetDLLInHandle(), PackagePartDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Resource_GetModelResourceID(Resource Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nModelResourceId uint32 = 0

	implementation_resource, err := implementation.GetWrapperHandle(Resource)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resource_getmodelresourceid, implementation_resource.GetDLLInHandle(), UInt32OutValue(&nModelResourceId))
	if err != nil {
		return 0, err
	}

	return uint32(nModelResourceId), err
}

func (implementation *Lib3MFImplementation) ResourceIterator_MoveNext(ResourceIterator Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasNext int64 = 0

	implementation_resourceiterator, err := implementation.GetWrapperHandle(ResourceIterator)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourceiterator_movenext, implementation_resourceiterator.GetDLLInHandle(), Int64OutValue(&bHasNext))
	if err != nil {
		return false, err
	}

	return (bHasNext != 0), err
}

func (implementation *Lib3MFImplementation) ResourceIterator_MovePrevious(ResourceIterator Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasPrevious int64 = 0

	implementation_resourceiterator, err := implementation.GetWrapperHandle(ResourceIterator)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourceiterator_moveprevious, implementation_resourceiterator.GetDLLInHandle(), Int64OutValue(&bHasPrevious))
	if err != nil {
		return false, err
	}

	return (bHasPrevious != 0), err
}

func (implementation *Lib3MFImplementation) ResourceIterator_GetCurrent(ResourceIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_resourceiterator, err := implementation.GetWrapperHandle(ResourceIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourceiterator_getcurrent, implementation_resourceiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) ResourceIterator_Clone(ResourceIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hOutResourceIterator := implementation.NewHandle()

	implementation_resourceiterator, err := implementation.GetWrapperHandle(ResourceIterator)
	if err != nil {
		return hOutResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourceiterator_clone, implementation_resourceiterator.GetDLLInHandle(), hOutResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hOutResourceIterator, err
	}

	return hOutResourceIterator, err
}

func (implementation *Lib3MFImplementation) ResourceIterator_Count(ResourceIterator Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_resourceiterator, err := implementation.GetWrapperHandle(ResourceIterator)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourceiterator_count, implementation_resourceiterator.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) SliceStackIterator_GetCurrentSliceStack(SliceStackIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_slicestackiterator, err := implementation.GetWrapperHandle(SliceStackIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestackiterator_getcurrentslicestack, implementation_slicestackiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) ObjectIterator_GetCurrentObject(ObjectIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_objectiterator, err := implementation.GetWrapperHandle(ObjectIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_objectiterator_getcurrentobject, implementation_objectiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) MeshObjectIterator_GetCurrentMeshObject(MeshObjectIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_meshobjectiterator, err := implementation.GetWrapperHandle(MeshObjectIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobjectiterator_getcurrentmeshobject, implementation_meshobjectiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) ComponentsObjectIterator_GetCurrentComponentsObject(ComponentsObjectIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_componentsobjectiterator, err := implementation.GetWrapperHandle(ComponentsObjectIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_componentsobjectiterator_getcurrentcomponentsobject, implementation_componentsobjectiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) Texture2DIterator_GetCurrentTexture2D(Texture2DIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_texture2diterator, err := implementation.GetWrapperHandle(Texture2DIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2diterator_getcurrenttexture2d, implementation_texture2diterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(BaseMaterialGroupIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_basematerialgroupiterator, err := implementation.GetWrapperHandle(BaseMaterialGroupIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroupiterator_getcurrentbasematerialgroup, implementation_basematerialgroupiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) ColorGroupIterator_GetCurrentColorGroup(ColorGroupIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_colorgroupiterator, err := implementation.GetWrapperHandle(ColorGroupIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroupiterator_getcurrentcolorgroup, implementation_colorgroupiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) Texture2DGroupIterator_GetCurrentTexture2DGroup(Texture2DGroupIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_texture2dgroupiterator, err := implementation.GetWrapperHandle(Texture2DGroupIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroupiterator_getcurrenttexture2dgroup, implementation_texture2dgroupiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) CompositeMaterialsIterator_GetCurrentCompositeMaterials(CompositeMaterialsIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_compositematerialsiterator, err := implementation.GetWrapperHandle(CompositeMaterialsIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerialsiterator_getcurrentcompositematerials, implementation_compositematerialsiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if err != nil {
		return hResource, err
	}

	return hResource, err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(MultiPropertyGroupIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()

	implementation_multipropertygroupiterator, err := implementation.GetWrapperHandle(MultiPropertyGroupIterator)
	if err != nil {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroupiterator_getcurrentmultipropertygroup, implementation_multipropertygroupiterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if (err != nil) {
		return hResource, err
	}
	
	return hResource, err
}

func (implementation *Lib3MFImplementation) Image3DIterator_GetCurrentImage3D(Image3DIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()
	
	implementation_image3diterator, err := implementation.GetWrapperHandle(Image3DIterator)
	if (err != nil) {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_image3diterator_getcurrentimage3d, implementation_image3diterator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if (err != nil) {
		return hResource, err
	}
	
	return hResource, err
}

func (implementation *Lib3MFImplementation) ScalarFieldIterator_GetCurrentScalarField(ScalarFieldIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()
	
	implementation_scalarfielditerator, err := implementation.GetWrapperHandle(ScalarFieldIterator)
	if (err != nil) {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfielditerator_getcurrentscalarfield, implementation_scalarfielditerator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if (err != nil) {
		return hResource, err
	}
	
	return hResource, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldIterator_GetCurrentVector3DField(Vector3DFieldIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResource := implementation.NewHandle()
	
	implementation_vector3dfielditerator, err := implementation.GetWrapperHandle(Vector3DFieldIterator)
	if (err != nil) {
		return hResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfielditerator_getcurrentvector3dfield, implementation_vector3dfielditerator.GetDLLInHandle(), hResource.GetDLLOutHandle())
	if (err != nil) {
		return hResource, err
	}
	
	return hResource, err
}

func (implementation *Lib3MFImplementation) MetaData_GetNameSpace(MetaData Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforNameSpace int64 = 0
	var filledinNameSpace int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_getnamespace, implementation_metadata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforNameSpace), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeNameSpace := neededforNameSpace
	bufferNameSpace := make([]byte, bufferSizeNameSpace)
	err = implementation.CallFunction(implementation.Lib3MF_metadata_getnamespace, implementation_metadata.GetDLLInHandle(), Int64InValue(bufferSizeNameSpace), Int64OutValue(&filledinNameSpace), uintptr(unsafe.Pointer(&bufferNameSpace[0])))
	if err != nil {
		return "", err
	}

	return string(bufferNameSpace[:(filledinNameSpace - 1)]), err
}

func (implementation *Lib3MFImplementation) MetaData_SetNameSpace(MetaData Lib3MFHandle, sNameSpace string) error {
	var err error = nil

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_setnamespace, implementation_metadata.GetDLLInHandle(), StringInValue(sNameSpace))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaData_GetName(MetaData Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_getname, implementation_metadata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_metadata_getname, implementation_metadata.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if err != nil {
		return "", err
	}

	return string(bufferName[:(filledinName - 1)]), err
}

func (implementation *Lib3MFImplementation) MetaData_SetName(MetaData Lib3MFHandle, sName string) error {
	var err error = nil

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_setname, implementation_metadata.GetDLLInHandle(), StringInValue(sName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaData_GetKey(MetaData Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforKey int64 = 0
	var filledinKey int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_getkey, implementation_metadata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforKey), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeKey := neededforKey
	bufferKey := make([]byte, bufferSizeKey)
	err = implementation.CallFunction(implementation.Lib3MF_metadata_getkey, implementation_metadata.GetDLLInHandle(), Int64InValue(bufferSizeKey), Int64OutValue(&filledinKey), uintptr(unsafe.Pointer(&bufferKey[0])))
	if err != nil {
		return "", err
	}

	return string(bufferKey[:(filledinKey - 1)]), err
}

func (implementation *Lib3MFImplementation) MetaData_GetMustPreserve(MetaData Lib3MFHandle) (bool, error) {
	var err error = nil
	var bMustPreserve int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_getmustpreserve, implementation_metadata.GetDLLInHandle(), Int64OutValue(&bMustPreserve))
	if err != nil {
		return false, err
	}

	return (bMustPreserve != 0), err
}

func (implementation *Lib3MFImplementation) MetaData_SetMustPreserve(MetaData Lib3MFHandle, bMustPreserve bool) error {
	var err error = nil
	var nMustPreserve uint8 = 0
	if bMustPreserve {
		nMustPreserve = 1
	}

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_setmustpreserve, implementation_metadata.GetDLLInHandle(), UInt8InValue(nMustPreserve))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaData_GetType(MetaData Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforType int64 = 0
	var filledinType int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_gettype, implementation_metadata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforType), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeType := neededforType
	bufferType := make([]byte, bufferSizeType)
	err = implementation.CallFunction(implementation.Lib3MF_metadata_gettype, implementation_metadata.GetDLLInHandle(), Int64InValue(bufferSizeType), Int64OutValue(&filledinType), uintptr(unsafe.Pointer(&bufferType[0])))
	if err != nil {
		return "", err
	}

	return string(bufferType[:(filledinType - 1)]), err
}

func (implementation *Lib3MFImplementation) MetaData_SetType(MetaData Lib3MFHandle, sType string) error {
	var err error = nil

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_settype, implementation_metadata.GetDLLInHandle(), StringInValue(sType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaData_GetValue(MetaData Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforValue int64 = 0
	var filledinValue int64 = 0

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_getvalue, implementation_metadata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforValue), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeValue := neededforValue
	bufferValue := make([]byte, bufferSizeValue)
	err = implementation.CallFunction(implementation.Lib3MF_metadata_getvalue, implementation_metadata.GetDLLInHandle(), Int64InValue(bufferSizeValue), Int64OutValue(&filledinValue), uintptr(unsafe.Pointer(&bufferValue[0])))
	if err != nil {
		return "", err
	}

	return string(bufferValue[:(filledinValue - 1)]), err
}

func (implementation *Lib3MFImplementation) MetaData_SetValue(MetaData Lib3MFHandle, sValue string) error {
	var err error = nil

	implementation_metadata, err := implementation.GetWrapperHandle(MetaData)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadata_setvalue, implementation_metadata.GetDLLInHandle(), StringInValue(sValue))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_GetMetaDataCount(MetaDataGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_getmetadatacount, implementation_metadatagroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_GetMetaData(MetaDataGroup Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hMetaData := implementation.NewHandle()

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return hMetaData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_getmetadata, implementation_metadatagroup.GetDLLInHandle(), UInt32InValue(nIndex), hMetaData.GetDLLOutHandle())
	if err != nil {
		return hMetaData, err
	}

	return hMetaData, err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_GetMetaDataByKey(MetaDataGroup Lib3MFHandle, sNameSpace string, sName string) (Lib3MFHandle, error) {
	var err error = nil
	hMetaData := implementation.NewHandle()

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return hMetaData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_getmetadatabykey, implementation_metadatagroup.GetDLLInHandle(), StringInValue(sNameSpace), StringInValue(sName), hMetaData.GetDLLOutHandle())
	if err != nil {
		return hMetaData, err
	}

	return hMetaData, err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_RemoveMetaDataByIndex(MetaDataGroup Lib3MFHandle, nIndex uint32) error {
	var err error = nil

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_removemetadatabyindex, implementation_metadatagroup.GetDLLInHandle(), UInt32InValue(nIndex))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_RemoveMetaData(MetaDataGroup Lib3MFHandle, TheMetaData Lib3MFHandle) error {
	var err error = nil

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return err
	}
	implementation_themetadata, err := implementation.GetWrapperHandle(TheMetaData)
	if err != nil {
		return err
	}

	TheMetaDataDLLHandle := implementation_themetadata.GetDLLInHandle()
	if TheMetaDataDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_removemetadata, implementation_metadatagroup.GetDLLInHandle(), TheMetaDataDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MetaDataGroup_AddMetaData(MetaDataGroup Lib3MFHandle, sNameSpace string, sName string, sValue string, sType string, bMustPreserve bool) (Lib3MFHandle, error) {
	var err error = nil
	var nMustPreserve uint8 = 0
	if bMustPreserve {
		nMustPreserve = 1
	}

	hMetaData := implementation.NewHandle()

	implementation_metadatagroup, err := implementation.GetWrapperHandle(MetaDataGroup)
	if err != nil {
		return hMetaData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_metadatagroup_addmetadata, implementation_metadatagroup.GetDLLInHandle(), StringInValue(sNameSpace), StringInValue(sName), StringInValue(sValue), StringInValue(sType), UInt8InValue(nMustPreserve), hMetaData.GetDLLOutHandle())
	if err != nil {
		return hMetaData, err
	}

	return hMetaData, err
}

func (implementation *Lib3MFImplementation) Object_GetType(Object Lib3MFHandle) (ELib3MFObjectType, error) {
	var err error = nil
	var eObjectType uint64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_gettype, implementation_object.GetDLLInHandle(), UInt64OutValue(&eObjectType))
	if err != nil {
		return 0, err
	}

	return ELib3MFObjectType(eObjectType), err
}

func (implementation *Lib3MFImplementation) Object_SetType(Object Lib3MFHandle, eObjectType ELib3MFObjectType) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_settype, implementation_object.GetDLLInHandle(), uintptr(eObjectType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetName(Object Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getname, implementation_object.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_object_getname, implementation_object.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if err != nil {
		return "", err
	}

	return string(bufferName[:(filledinName - 1)]), err
}

func (implementation *Lib3MFImplementation) Object_SetName(Object Lib3MFHandle, sName string) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_setname, implementation_object.GetDLLInHandle(), StringInValue(sName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetPartNumber(Object Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPartNumber int64 = 0
	var filledinPartNumber int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getpartnumber, implementation_object.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPartNumber), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePartNumber := neededforPartNumber
	bufferPartNumber := make([]byte, bufferSizePartNumber)
	err = implementation.CallFunction(implementation.Lib3MF_object_getpartnumber, implementation_object.GetDLLInHandle(), Int64InValue(bufferSizePartNumber), Int64OutValue(&filledinPartNumber), uintptr(unsafe.Pointer(&bufferPartNumber[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPartNumber[:(filledinPartNumber - 1)]), err
}

func (implementation *Lib3MFImplementation) Object_SetPartNumber(Object Lib3MFHandle, sPartNumber string) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_setpartnumber, implementation_object.GetDLLInHandle(), StringInValue(sPartNumber))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_IsMeshObject(Object Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsMeshObject int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_ismeshobject, implementation_object.GetDLLInHandle(), Int64OutValue(&bIsMeshObject))
	if err != nil {
		return false, err
	}

	return (bIsMeshObject != 0), err
}

func (implementation *Lib3MFImplementation) Object_IsComponentsObject(Object Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsComponentsObject int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_iscomponentsobject, implementation_object.GetDLLInHandle(), Int64OutValue(&bIsComponentsObject))
	if err != nil {
		return false, err
	}

	return (bIsComponentsObject != 0), err
}

func (implementation *Lib3MFImplementation) Object_IsValid(Object Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsValid int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_isvalid, implementation_object.GetDLLInHandle(), Int64OutValue(&bIsValid))
	if err != nil {
		return false, err
	}

	return (bIsValid != 0), err
}

func (implementation *Lib3MFImplementation) Object_SetAttachmentAsThumbnail(Object Lib3MFHandle, Attachment Lib3MFHandle) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}
	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	AttachmentDLLHandle := implementation_attachment.GetDLLInHandle()
	if AttachmentDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_setattachmentasthumbnail, implementation_object.GetDLLInHandle(), AttachmentDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetThumbnailAttachment(Object Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hAttachment := implementation.NewHandle()

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return hAttachment, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getthumbnailattachment, implementation_object.GetDLLInHandle(), hAttachment.GetDLLOutHandle())
	if err != nil {
		return hAttachment, err
	}

	return hAttachment, err
}

func (implementation *Lib3MFImplementation) Object_ClearThumbnailAttachment(Object Lib3MFHandle) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_clearthumbnailattachment, implementation_object.GetDLLInHandle())
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetOutbox(Object Lib3MFHandle) (sLib3MFBox, error) {
	var err error = nil
	var sOutbox sLib3MFBox

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return sOutbox, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getoutbox, implementation_object.GetDLLInHandle(), 0)
	if err != nil {
		return sOutbox, err
	}

	return sOutbox, err
}

func (implementation *Lib3MFImplementation) Object_GetUUID(Object Lib3MFHandle) (bool, string, error) {
	var err error = nil
	var bHasUUID int64 = 0
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return false, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getuuid, implementation_object.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_object_getuuid, implementation_object.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasUUID != 0), string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) Object_SetUUID(Object Lib3MFHandle, sUUID string) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_setuuid, implementation_object.GetDLLInHandle(), StringInValue(sUUID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetMetaDataGroup(Object Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hMetaDataGroup := implementation.NewHandle()

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return hMetaDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getmetadatagroup, implementation_object.GetDLLInHandle(), hMetaDataGroup.GetDLLOutHandle())
	if err != nil {
		return hMetaDataGroup, err
	}

	return hMetaDataGroup, err
}

func (implementation *Lib3MFImplementation) Object_SetSlicesMeshResolution(Object Lib3MFHandle, eMeshResolution ELib3MFSlicesMeshResolution) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_setslicesmeshresolution, implementation_object.GetDLLInHandle(), uintptr(eMeshResolution))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetSlicesMeshResolution(Object Lib3MFHandle) (ELib3MFSlicesMeshResolution, error) {
	var err error = nil
	var eMeshResolution uint64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getslicesmeshresolution, implementation_object.GetDLLInHandle(), UInt64OutValue(&eMeshResolution))
	if err != nil {
		return 0, err
	}

	return ELib3MFSlicesMeshResolution(eMeshResolution), err
}

func (implementation *Lib3MFImplementation) Object_HasSlices(Object Lib3MFHandle, bRecursive bool) (bool, error) {
	var err error = nil
	var nRecursive uint8 = 0
	if bRecursive {
		nRecursive = 1
	}

	var bHasSlices int64 = 0

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_hasslices, implementation_object.GetDLLInHandle(), UInt8InValue(nRecursive), Int64OutValue(&bHasSlices))
	if err != nil {
		return false, err
	}

	return (bHasSlices != 0), err
}

func (implementation *Lib3MFImplementation) Object_ClearSliceStack(Object Lib3MFHandle) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_clearslicestack, implementation_object.GetDLLInHandle())
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Object_GetSliceStack(Object Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hSliceStackInstance := implementation.NewHandle()

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return hSliceStackInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_getslicestack, implementation_object.GetDLLInHandle(), hSliceStackInstance.GetDLLOutHandle())
	if err != nil {
		return hSliceStackInstance, err
	}

	return hSliceStackInstance, err
}

func (implementation *Lib3MFImplementation) Object_AssignSliceStack(Object Lib3MFHandle, SliceStackInstance Lib3MFHandle) error {
	var err error = nil

	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return err
	}
	implementation_slicestackinstance, err := implementation.GetWrapperHandle(SliceStackInstance)
	if err != nil {
		return err
	}

	SliceStackInstanceDLLHandle := implementation_slicestackinstance.GetDLLInHandle()
	if SliceStackInstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_object_assignslicestack, implementation_object.GetDLLInHandle(), SliceStackInstanceDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_GetVertexCount(MeshObject Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nVertexCount uint32 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getvertexcount, implementation_meshobject.GetDLLInHandle(), UInt32OutValue(&nVertexCount))
	if err != nil {
		return 0, err
	}

	return uint32(nVertexCount), err
}

func (implementation *Lib3MFImplementation) MeshObject_GetTriangleCount(MeshObject Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nVertexCount uint32 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_gettrianglecount, implementation_meshobject.GetDLLInHandle(), UInt32OutValue(&nVertexCount))
	if err != nil {
		return 0, err
	}

	return uint32(nVertexCount), err
}

func (implementation *Lib3MFImplementation) MeshObject_GetVertex(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFPosition, error) {
	var err error = nil
	var sCoordinates sLib3MFPosition

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return sCoordinates, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getvertex, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), 0)
	if err != nil {
		return sCoordinates, err
	}

	return sCoordinates, err
}

func (implementation *Lib3MFImplementation) MeshObject_SetVertex(MeshObject Lib3MFHandle, nIndex uint32, sCoordinates sLib3MFPosition) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_setvertex, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), uintptr(unsafe.Pointer(&sCoordinates)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_AddVertex(MeshObject Lib3MFHandle, sCoordinates sLib3MFPosition) (uint32, error) {
	var err error = nil
	var nNewIndex uint32 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_addvertex, implementation_meshobject.GetDLLInHandle(), uintptr(unsafe.Pointer(&sCoordinates)), UInt32OutValue(&nNewIndex))
	if err != nil {
		return 0, err
	}

	return uint32(nNewIndex), err
}

func (implementation *Lib3MFImplementation) MeshObject_GetVertices(MeshObject Lib3MFHandle) ([]sLib3MFPosition, error) {
	var err error = nil
	arrayVertices := make([]sLib3MFPosition, 0)

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return make([]sLib3MFPosition, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getvertices, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFPosition, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getvertices, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFPosition, 0), err
	}

	return arrayVertices, err
}

func (implementation *Lib3MFImplementation) MeshObject_GetTriangle(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFTriangle, error) {
	var err error = nil
	var sIndices sLib3MFTriangle

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return sIndices, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_gettriangle, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), 0)
	if err != nil {
		return sIndices, err
	}

	return sIndices, err
}

func (implementation *Lib3MFImplementation) MeshObject_SetTriangle(MeshObject Lib3MFHandle, nIndex uint32, sIndices sLib3MFTriangle) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_settriangle, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), uintptr(unsafe.Pointer(&sIndices)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_AddTriangle(MeshObject Lib3MFHandle, sIndices sLib3MFTriangle) (uint32, error) {
	var err error = nil
	var nNewIndex uint32 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_addtriangle, implementation_meshobject.GetDLLInHandle(), uintptr(unsafe.Pointer(&sIndices)), UInt32OutValue(&nNewIndex))
	if err != nil {
		return 0, err
	}

	return uint32(nNewIndex), err
}

func (implementation *Lib3MFImplementation) MeshObject_GetTriangleIndices(MeshObject Lib3MFHandle) ([]sLib3MFTriangle, error) {
	var err error = nil
	arrayIndices := make([]sLib3MFTriangle, 0)

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return make([]sLib3MFTriangle, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_gettriangleindices, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFTriangle, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_meshobject_gettriangleindices, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFTriangle, 0), err
	}

	return arrayIndices, err
}

func (implementation *Lib3MFImplementation) MeshObject_SetObjectLevelProperty(MeshObject Lib3MFHandle, nUniqueResourceID uint32, nPropertyID uint32) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_setobjectlevelproperty, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_GetObjectLevelProperty(MeshObject Lib3MFHandle) (uint32, uint32, bool, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0
	var nPropertyID uint32 = 0
	var bHasObjectLevelProperty int64 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return 0, 0, false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getobjectlevelproperty, implementation_meshobject.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID), UInt32OutValue(&nPropertyID), Int64OutValue(&bHasObjectLevelProperty))
	if err != nil {
		return 0, 0, false, err
	}

	return uint32(nUniqueResourceID), uint32(nPropertyID), (bHasObjectLevelProperty != 0), err
}

func (implementation *Lib3MFImplementation) MeshObject_SetTriangleProperties(MeshObject Lib3MFHandle, nIndex uint32, sProperties sLib3MFTriangleProperties) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_settriangleproperties, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), uintptr(unsafe.Pointer(&sProperties)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_GetTriangleProperties(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFTriangleProperties, error) {
	var err error = nil
	var sProperty sLib3MFTriangleProperties

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return sProperty, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_gettriangleproperties, implementation_meshobject.GetDLLInHandle(), UInt32InValue(nIndex), 0)
	if err != nil {
		return sProperty, err
	}

	return sProperty, err
}

func (implementation *Lib3MFImplementation) MeshObject_SetAllTriangleProperties(MeshObject Lib3MFHandle, PropertiesArray []sLib3MFTriangleProperties) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_setalltriangleproperties, implementation_meshobject.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_GetAllTriangleProperties(MeshObject Lib3MFHandle) ([]sLib3MFTriangleProperties, error) {
	var err error = nil
	arrayPropertiesArray := make([]sLib3MFTriangleProperties, 0)

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return make([]sLib3MFTriangleProperties, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getalltriangleproperties, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFTriangleProperties, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_meshobject_getalltriangleproperties, implementation_meshobject.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFTriangleProperties, 0), err
	}

	return arrayPropertiesArray, err
}

func (implementation *Lib3MFImplementation) MeshObject_ClearAllProperties(MeshObject Lib3MFHandle) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_clearallproperties, implementation_meshobject.GetDLLInHandle())
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_SetGeometry(MeshObject Lib3MFHandle, Vertices []sLib3MFPosition, Indices []sLib3MFTriangle) error {
	var err error = nil

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_setgeometry, implementation_meshobject.GetDLLInHandle(), 0, 0, 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MeshObject_IsManifoldAndOriented(MeshObject Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsManifoldAndOriented int64 = 0

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_ismanifoldandoriented, implementation_meshobject.GetDLLInHandle(), Int64OutValue(&bIsManifoldAndOriented))
	if err != nil {
		return false, err
	}

	return (bIsManifoldAndOriented != 0), err
}

func (implementation *Lib3MFImplementation) MeshObject_BeamLattice(MeshObject Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheBeamLattice := implementation.NewHandle()

	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if err != nil {
		return hTheBeamLattice, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_beamlattice, implementation_meshobject.GetDLLInHandle(), hTheBeamLattice.GetDLLOutHandle())
	if err != nil {
		return hTheBeamLattice, err
	}

	return hTheBeamLattice, err
}

func (implementation *Lib3MFImplementation) MeshObject_VolumeData(MeshObject Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVolumeData := implementation.NewHandle()
	
	implementation_meshobject, err := implementation.GetWrapperHandle(MeshObject)
	if (err != nil) {
		return hTheVolumeData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_meshobject_volumedata, implementation_meshobject.GetDLLInHandle(), hTheVolumeData.GetDLLOutHandle())
	if (err != nil) {
		return hTheVolumeData, err
	}
	
	return hTheVolumeData, err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetMinLength(BeamLattice Lib3MFHandle) (float64, error) {
	var err error = nil
	var dMinLength float64 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getminlength, implementation_beamlattice.GetDLLInHandle(), Float64OutValue(&dMinLength))
	if err != nil {
		return 0, err
	}

	return dMinLength, err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetMinLength(BeamLattice Lib3MFHandle, dMinLength float64) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setminlength, implementation_beamlattice.GetDLLInHandle(), Float64InValue(dMinLength))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetClipping(BeamLattice Lib3MFHandle) (ELib3MFBeamLatticeClipMode, uint32, error) {
	var err error = nil
	var eClipMode uint64 = 0
	var nUniqueResourceID uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getclipping, implementation_beamlattice.GetDLLInHandle(), UInt64OutValue(&eClipMode), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return 0, 0, err
	}

	return ELib3MFBeamLatticeClipMode(eClipMode), uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetClipping(BeamLattice Lib3MFHandle, eClipMode ELib3MFBeamLatticeClipMode, nUniqueResourceID uint32) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setclipping, implementation_beamlattice.GetDLLInHandle(), uintptr(eClipMode), UInt32InValue(nUniqueResourceID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetRepresentation(BeamLattice Lib3MFHandle) (bool, uint32, error) {
	var err error = nil
	var bHasRepresentation int64 = 0
	var nUniqueResourceID uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return false, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getrepresentation, implementation_beamlattice.GetDLLInHandle(), Int64OutValue(&bHasRepresentation), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return false, 0, err
	}

	return (bHasRepresentation != 0), uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetRepresentation(BeamLattice Lib3MFHandle, nUniqueResourceID uint32) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setrepresentation, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nUniqueResourceID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBallOptions(BeamLattice Lib3MFHandle) (ELib3MFBeamLatticeBallMode, float64, error) {
	var err error = nil
	var eBallMode uint64 = 0
	var dBallRadius float64 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getballoptions, implementation_beamlattice.GetDLLInHandle(), UInt64OutValue(&eBallMode), Float64OutValue(&dBallRadius))
	if err != nil {
		return 0, 0, err
	}

	return ELib3MFBeamLatticeBallMode(eBallMode), dBallRadius, err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetBallOptions(BeamLattice Lib3MFHandle, eBallMode ELib3MFBeamLatticeBallMode, dBallRadius float64) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setballoptions, implementation_beamlattice.GetDLLInHandle(), uintptr(eBallMode), Float64InValue(dBallRadius))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBeamCount(BeamLattice Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeamcount, implementation_beamlattice.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBeam(BeamLattice Lib3MFHandle, nIndex uint32) (sLib3MFBeam, error) {
	var err error = nil
	var sBeamInfo sLib3MFBeam

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return sBeamInfo, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeam, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nIndex), 0)
	if err != nil {
		return sBeamInfo, err
	}

	return sBeamInfo, err
}

func (implementation *Lib3MFImplementation) BeamLattice_AddBeam(BeamLattice Lib3MFHandle, sBeamInfo sLib3MFBeam) (uint32, error) {
	var err error = nil
	var nIndex uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_addbeam, implementation_beamlattice.GetDLLInHandle(), uintptr(unsafe.Pointer(&sBeamInfo)), UInt32OutValue(&nIndex))
	if err != nil {
		return 0, err
	}

	return uint32(nIndex), err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetBeam(BeamLattice Lib3MFHandle, nIndex uint32, sBeamInfo sLib3MFBeam) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setbeam, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nIndex), uintptr(unsafe.Pointer(&sBeamInfo)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetBeams(BeamLattice Lib3MFHandle, BeamInfo []sLib3MFBeam) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setbeams, implementation_beamlattice.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBeams(BeamLattice Lib3MFHandle) ([]sLib3MFBeam, error) {
	var err error = nil
	arrayBeamInfo := make([]sLib3MFBeam, 0)

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return make([]sLib3MFBeam, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeams, implementation_beamlattice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFBeam, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeams, implementation_beamlattice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFBeam, 0), err
	}

	return arrayBeamInfo, err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBallCount(BeamLattice Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getballcount, implementation_beamlattice.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBall(BeamLattice Lib3MFHandle, nIndex uint32) (sLib3MFBall, error) {
	var err error = nil
	var sBallInfo sLib3MFBall

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return sBallInfo, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getball, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nIndex), 0)
	if err != nil {
		return sBallInfo, err
	}

	return sBallInfo, err
}

func (implementation *Lib3MFImplementation) BeamLattice_AddBall(BeamLattice Lib3MFHandle, sBallInfo sLib3MFBall) (uint32, error) {
	var err error = nil
	var nIndex uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_addball, implementation_beamlattice.GetDLLInHandle(), uintptr(unsafe.Pointer(&sBallInfo)), UInt32OutValue(&nIndex))
	if err != nil {
		return 0, err
	}

	return uint32(nIndex), err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetBall(BeamLattice Lib3MFHandle, nIndex uint32, sBallInfo sLib3MFBall) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setball, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nIndex), uintptr(unsafe.Pointer(&sBallInfo)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_SetBalls(BeamLattice Lib3MFHandle, BallInfo []sLib3MFBall) error {
	var err error = nil

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_setballs, implementation_beamlattice.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBalls(BeamLattice Lib3MFHandle) ([]sLib3MFBall, error) {
	var err error = nil
	arrayBallInfo := make([]sLib3MFBall, 0)

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return make([]sLib3MFBall, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getballs, implementation_beamlattice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFBall, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getballs, implementation_beamlattice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFBall, 0), err
	}

	return arrayBallInfo, err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBeamSetCount(BeamLattice Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeamsetcount, implementation_beamlattice.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamLattice_AddBeamSet(BeamLattice Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBeamSet := implementation.NewHandle()

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return hBeamSet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_addbeamset, implementation_beamlattice.GetDLLInHandle(), hBeamSet.GetDLLOutHandle())
	if err != nil {
		return hBeamSet, err
	}

	return hBeamSet, err
}

func (implementation *Lib3MFImplementation) BeamLattice_GetBeamSet(BeamLattice Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hBeamSet := implementation.NewHandle()

	implementation_beamlattice, err := implementation.GetWrapperHandle(BeamLattice)
	if err != nil {
		return hBeamSet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamlattice_getbeamset, implementation_beamlattice.GetDLLInHandle(), UInt32InValue(nIndex), hBeamSet.GetDLLOutHandle())
	if err != nil {
		return hBeamSet, err
	}

	return hBeamSet, err
}

func (implementation *Lib3MFImplementation) ScalarField_GetName(ScalarField Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0
	
	implementation_scalarfield, err := implementation.GetWrapperHandle(ScalarField)
	if (err != nil) {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_getname, implementation_scalarfield.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if (err != nil) {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_getname, implementation_scalarfield.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if (err != nil) {
		return "", err
	}
	
	return string(bufferName[:(filledinName-1)]), err
}

func (implementation *Lib3MFImplementation) ScalarField_SetName(ScalarField Lib3MFHandle, sName string) (error) {
	var err error = nil
	
	implementation_scalarfield, err := implementation.GetWrapperHandle(ScalarField)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_setname, implementation_scalarfield.GetDLLInHandle(), StringInValue(sName))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarField_IsFromImage3D(ScalarField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsFromImage3D int64 = 0
	
	implementation_scalarfield, err := implementation.GetWrapperHandle(ScalarField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_isfromimage3d, implementation_scalarfield.GetDLLInHandle(), Int64OutValue(&bIsFromImage3D))
	if (err != nil) {
		return false, err
	}
	
	return (bIsFromImage3D != 0), err
}

func (implementation *Lib3MFImplementation) ScalarField_IsConstant(ScalarField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsConstant int64 = 0
	
	implementation_scalarfield, err := implementation.GetWrapperHandle(ScalarField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_isconstant, implementation_scalarfield.GetDLLInHandle(), Int64OutValue(&bIsConstant))
	if (err != nil) {
		return false, err
	}
	
	return (bIsConstant != 0), err
}

func (implementation *Lib3MFImplementation) ScalarField_IsComposed(ScalarField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsComposed int64 = 0
	
	implementation_scalarfield, err := implementation.GetWrapperHandle(ScalarField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfield_iscomposed, implementation_scalarfield.GetDLLInHandle(), Int64OutValue(&bIsComposed))
	if (err != nil) {
		return false, err
	}
	
	return (bIsComposed != 0), err
}

func (implementation *Lib3MFImplementation) Vector3DField_GetName(Vector3DField Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0
	
	implementation_vector3dfield, err := implementation.GetWrapperHandle(Vector3DField)
	if (err != nil) {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_getname, implementation_vector3dfield.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if (err != nil) {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_getname, implementation_vector3dfield.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if (err != nil) {
		return "", err
	}
	
	return string(bufferName[:(filledinName-1)]), err
}

func (implementation *Lib3MFImplementation) Vector3DField_SetName(Vector3DField Lib3MFHandle, sName string) (error) {
	var err error = nil
	
	implementation_vector3dfield, err := implementation.GetWrapperHandle(Vector3DField)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_setname, implementation_vector3dfield.GetDLLInHandle(), StringInValue(sName))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DField_IsFromImage3D(Vector3DField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsFromImage3D int64 = 0
	
	implementation_vector3dfield, err := implementation.GetWrapperHandle(Vector3DField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_isfromimage3d, implementation_vector3dfield.GetDLLInHandle(), Int64OutValue(&bIsFromImage3D))
	if (err != nil) {
		return false, err
	}
	
	return (bIsFromImage3D != 0), err
}

func (implementation *Lib3MFImplementation) Vector3DField_IsConstant(Vector3DField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsConstant int64 = 0
	
	implementation_vector3dfield, err := implementation.GetWrapperHandle(Vector3DField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_isconstant, implementation_vector3dfield.GetDLLInHandle(), Int64OutValue(&bIsConstant))
	if (err != nil) {
		return false, err
	}
	
	return (bIsConstant != 0), err
}

func (implementation *Lib3MFImplementation) Vector3DField_IsComposed(Vector3DField Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsComposed int64 = 0
	
	implementation_vector3dfield, err := implementation.GetWrapperHandle(Vector3DField)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfield_iscomposed, implementation_vector3dfield.GetDLLInHandle(), Int64OutValue(&bIsComposed))
	if (err != nil) {
		return false, err
	}
	
	return (bIsComposed != 0), err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetImage(ScalarFieldFromImage3D Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hImage3D := implementation.NewHandle()
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return hImage3D, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_getimage, implementation_scalarfieldfromimage3d.GetDLLInHandle(), hImage3D.GetDLLOutHandle())
	if (err != nil) {
		return hImage3D, err
	}
	
	return hImage3D, err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetImage(ScalarFieldFromImage3D Lib3MFHandle, Image3D Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return err
	}
	
	Image3DDLLHandle := implementation_image3d.GetDLLInHandle()
	if (Image3DDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_setimage, implementation_scalarfieldfromimage3d.GetDLLInHandle(), Image3DDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetChannel(ScalarFieldFromImage3D Lib3MFHandle, eName ELib3MFChannelName) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_setchannel, implementation_scalarfieldfromimage3d.GetDLLInHandle(), uintptr(eName))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetChannel(ScalarFieldFromImage3D Lib3MFHandle) (ELib3MFChannelName, error) {
	var err error = nil
	var eName uint64 = 0
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_getchannel, implementation_scalarfieldfromimage3d.GetDLLInHandle(), UInt64OutValue(&eName))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFChannelName (eName), err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetFilter(ScalarFieldFromImage3D Lib3MFHandle, eFilter ELib3MFTextureFilter) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_setfilter, implementation_scalarfieldfromimage3d.GetDLLInHandle(), uintptr(eFilter))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetFilter(ScalarFieldFromImage3D Lib3MFHandle) (ELib3MFTextureFilter, error) {
	var err error = nil
	var eFilter uint64 = 0
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_getfilter, implementation_scalarfieldfromimage3d.GetDLLInHandle(), UInt64OutValue(&eFilter))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFTextureFilter (eFilter), err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetTileStyles(ScalarFieldFromImage3D Lib3MFHandle, eTileStyleU ELib3MFTextureTileStyle, eTileStyleV ELib3MFTextureTileStyle, eTileStyleW ELib3MFTextureTileStyle) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_settilestyles, implementation_scalarfieldfromimage3d.GetDLLInHandle(), uintptr(eTileStyleU), uintptr(eTileStyleV), uintptr(eTileStyleW))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetTileStyles(ScalarFieldFromImage3D Lib3MFHandle) (ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, error) {
	var err error = nil
	var eTileStyleU uint64 = 0
	var eTileStyleV uint64 = 0
	var eTileStyleW uint64 = 0
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return 0, 0, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_gettilestyles, implementation_scalarfieldfromimage3d.GetDLLInHandle(), UInt64OutValue(&eTileStyleU), UInt64OutValue(&eTileStyleV), UInt64OutValue(&eTileStyleW))
	if (err != nil) {
		return 0, 0, 0, err
	}
	
	return ELib3MFTextureTileStyle (eTileStyleU), ELib3MFTextureTileStyle (eTileStyleV), ELib3MFTextureTileStyle (eTileStyleW), err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetOffset(ScalarFieldFromImage3D Lib3MFHandle) (float64, error) {
	var err error = nil
	var dOffset float64 = 0
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_getoffset, implementation_scalarfieldfromimage3d.GetDLLInHandle(), Float64OutValue(&dOffset))
	if (err != nil) {
		return 0, err
	}
	
	return dOffset, err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetOffset(ScalarFieldFromImage3D Lib3MFHandle, dOffset float64) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_setoffset, implementation_scalarfieldfromimage3d.GetDLLInHandle(), Float64InValue(dOffset))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_GetScale(ScalarFieldFromImage3D Lib3MFHandle) (float64, error) {
	var err error = nil
	var dScale float64 = 0
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_getscale, implementation_scalarfieldfromimage3d.GetDLLInHandle(), Float64OutValue(&dScale))
	if (err != nil) {
		return 0, err
	}
	
	return dScale, err
}

func (implementation *Lib3MFImplementation) ScalarFieldFromImage3D_SetScale(ScalarFieldFromImage3D Lib3MFHandle, dScale float64) (error) {
	var err error = nil
	
	implementation_scalarfieldfromimage3d, err := implementation.GetWrapperHandle(ScalarFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldfromimage3d_setscale, implementation_scalarfieldfromimage3d.GetDLLInHandle(), Float64InValue(dScale))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldConstant_GetValue(ScalarFieldConstant Lib3MFHandle) (float64, error) {
	var err error = nil
	var dValue float64 = 0
	
	implementation_scalarfieldconstant, err := implementation.GetWrapperHandle(ScalarFieldConstant)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldconstant_getvalue, implementation_scalarfieldconstant.GetDLLInHandle(), Float64OutValue(&dValue))
	if (err != nil) {
		return 0, err
	}
	
	return dValue, err
}

func (implementation *Lib3MFImplementation) ScalarFieldConstant_SetValue(ScalarFieldConstant Lib3MFHandle, dValue float64) (error) {
	var err error = nil
	
	implementation_scalarfieldconstant, err := implementation.GetWrapperHandle(ScalarFieldConstant)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldconstant_setvalue, implementation_scalarfieldconstant.GetDLLInHandle(), Float64InValue(dValue))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_SetMethod(ScalarFieldComposed Lib3MFHandle, eTheMethod ELib3MFCompositionMethod) (error) {
	var err error = nil
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_setmethod, implementation_scalarfieldcomposed.GetDLLInHandle(), uintptr(eTheMethod))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_GetMethod(ScalarFieldComposed Lib3MFHandle) (ELib3MFCompositionMethod, error) {
	var err error = nil
	var eTheMethod uint64 = 0
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_getmethod, implementation_scalarfieldcomposed.GetDLLInHandle(), UInt64OutValue(&eTheMethod))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFCompositionMethod (eTheMethod), err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_GetFactor1(ScalarFieldComposed Lib3MFHandle) (float64, error) {
	var err error = nil
	var dFactor1 float64 = 0
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_getfactor1, implementation_scalarfieldcomposed.GetDLLInHandle(), Float64OutValue(&dFactor1))
	if (err != nil) {
		return 0, err
	}
	
	return dFactor1, err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_SetFactor1(ScalarFieldComposed Lib3MFHandle, dFactor1 float64) (error) {
	var err error = nil
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_setfactor1, implementation_scalarfieldcomposed.GetDLLInHandle(), Float64InValue(dFactor1))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_GetFactor2(ScalarFieldComposed Lib3MFHandle) (float64, error) {
	var err error = nil
	var dFactor2 float64 = 0
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_getfactor2, implementation_scalarfieldcomposed.GetDLLInHandle(), Float64OutValue(&dFactor2))
	if (err != nil) {
		return 0, err
	}
	
	return dFactor2, err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_SetFactor2(ScalarFieldComposed Lib3MFHandle, dFactor2 float64) (error) {
	var err error = nil
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_setfactor2, implementation_scalarfieldcomposed.GetDLLInHandle(), Float64InValue(dFactor2))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_ScalarFieldReference1(ScalarFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldReference1 := implementation.NewHandle()
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return hTheScalarFieldReference1, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_scalarfieldreference1, implementation_scalarfieldcomposed.GetDLLInHandle(), hTheScalarFieldReference1.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldReference1, err
	}
	
	return hTheScalarFieldReference1, err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_ScalarFieldReference2(ScalarFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldReference1 := implementation.NewHandle()
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return hTheScalarFieldReference1, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_scalarfieldreference2, implementation_scalarfieldcomposed.GetDLLInHandle(), hTheScalarFieldReference1.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldReference1, err
	}
	
	return hTheScalarFieldReference1, err
}

func (implementation *Lib3MFImplementation) ScalarFieldComposed_ScalarFieldReferenceMask(ScalarFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldReferenceMask := implementation.NewHandle()
	
	implementation_scalarfieldcomposed, err := implementation.GetWrapperHandle(ScalarFieldComposed)
	if (err != nil) {
		return hTheScalarFieldReferenceMask, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldcomposed_scalarfieldreferencemask, implementation_scalarfieldcomposed.GetDLLInHandle(), hTheScalarFieldReferenceMask.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldReferenceMask, err
	}
	
	return hTheScalarFieldReferenceMask, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_GetImage(Vector3DFieldFromImage3D Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hImage3D := implementation.NewHandle()
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return hImage3D, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_getimage, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), hImage3D.GetDLLOutHandle())
	if (err != nil) {
		return hImage3D, err
	}
	
	return hImage3D, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_SetImage(Vector3DFieldFromImage3D Lib3MFHandle, Image3D Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return err
	}
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return err
	}
	
	Image3DDLLHandle := implementation_image3d.GetDLLInHandle()
	if (Image3DDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_setimage, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), Image3DDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_SetFilter(Vector3DFieldFromImage3D Lib3MFHandle, eFilter ELib3MFTextureFilter) (error) {
	var err error = nil
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_setfilter, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), uintptr(eFilter))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_GetFilter(Vector3DFieldFromImage3D Lib3MFHandle) (ELib3MFTextureFilter, error) {
	var err error = nil
	var eFilter uint64 = 0
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_getfilter, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), UInt64OutValue(&eFilter))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFTextureFilter (eFilter), err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_SetTileStyles(Vector3DFieldFromImage3D Lib3MFHandle, eTileStyleU ELib3MFTextureTileStyle, eTileStyleV ELib3MFTextureTileStyle, eTileStyleW ELib3MFTextureTileStyle) (error) {
	var err error = nil
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_settilestyles, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), uintptr(eTileStyleU), uintptr(eTileStyleV), uintptr(eTileStyleW))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_GetTileStyles(Vector3DFieldFromImage3D Lib3MFHandle) (ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, error) {
	var err error = nil
	var eTileStyleU uint64 = 0
	var eTileStyleV uint64 = 0
	var eTileStyleW uint64 = 0
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return 0, 0, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_gettilestyles, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), UInt64OutValue(&eTileStyleU), UInt64OutValue(&eTileStyleV), UInt64OutValue(&eTileStyleW))
	if (err != nil) {
		return 0, 0, 0, err
	}
	
	return ELib3MFTextureTileStyle (eTileStyleU), ELib3MFTextureTileStyle (eTileStyleV), ELib3MFTextureTileStyle (eTileStyleW), err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_GetOffset(Vector3DFieldFromImage3D Lib3MFHandle) (float64, error) {
	var err error = nil
	var dOffset float64 = 0
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_getoffset, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), Float64OutValue(&dOffset))
	if (err != nil) {
		return 0, err
	}
	
	return dOffset, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_SetOffset(Vector3DFieldFromImage3D Lib3MFHandle, dOffset float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_setoffset, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), Float64InValue(dOffset))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_GetScale(Vector3DFieldFromImage3D Lib3MFHandle) (float64, error) {
	var err error = nil
	var dScale float64 = 0
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_getscale, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), Float64OutValue(&dScale))
	if (err != nil) {
		return 0, err
	}
	
	return dScale, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldFromImage3D_SetScale(Vector3DFieldFromImage3D Lib3MFHandle, dScale float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldfromimage3d, err := implementation.GetWrapperHandle(Vector3DFieldFromImage3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldfromimage3d_setscale, implementation_vector3dfieldfromimage3d.GetDLLInHandle(), Float64InValue(dScale))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_GetValueX(Vector3DFieldConstant Lib3MFHandle) (float64, error) {
	var err error = nil
	var dValueX float64 = 0
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_getvaluex, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64OutValue(&dValueX))
	if (err != nil) {
		return 0, err
	}
	
	return dValueX, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_SetValueX(Vector3DFieldConstant Lib3MFHandle, dValueX float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_setvaluex, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64InValue(dValueX))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_GetValueY(Vector3DFieldConstant Lib3MFHandle) (float64, error) {
	var err error = nil
	var dValueY float64 = 0
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_getvaluey, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64OutValue(&dValueY))
	if (err != nil) {
		return 0, err
	}
	
	return dValueY, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_SetValueY(Vector3DFieldConstant Lib3MFHandle, dValueY float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_setvaluey, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64InValue(dValueY))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_GetValueZ(Vector3DFieldConstant Lib3MFHandle) (float64, error) {
	var err error = nil
	var dValueZ float64 = 0
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_getvaluez, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64OutValue(&dValueZ))
	if (err != nil) {
		return 0, err
	}
	
	return dValueZ, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldConstant_SetValueZ(Vector3DFieldConstant Lib3MFHandle, dValueZ float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldconstant, err := implementation.GetWrapperHandle(Vector3DFieldConstant)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldconstant_setvaluez, implementation_vector3dfieldconstant.GetDLLInHandle(), Float64InValue(dValueZ))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_SetMethod(Vector3DFieldComposed Lib3MFHandle, eTheMethod ELib3MFCompositionMethod) (error) {
	var err error = nil
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_setmethod, implementation_vector3dfieldcomposed.GetDLLInHandle(), uintptr(eTheMethod))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_GetMethod(Vector3DFieldComposed Lib3MFHandle) (ELib3MFCompositionMethod, error) {
	var err error = nil
	var eTheMethod uint64 = 0
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_getmethod, implementation_vector3dfieldcomposed.GetDLLInHandle(), UInt64OutValue(&eTheMethod))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFCompositionMethod (eTheMethod), err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_SetSpace(Vector3DFieldComposed Lib3MFHandle, eTheSpace ELib3MFCompositionSpace) (error) {
	var err error = nil
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_setspace, implementation_vector3dfieldcomposed.GetDLLInHandle(), uintptr(eTheSpace))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_GetSpace(Vector3DFieldComposed Lib3MFHandle) (ELib3MFCompositionSpace, error) {
	var err error = nil
	var eTheSpace uint64 = 0
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_getspace, implementation_vector3dfieldcomposed.GetDLLInHandle(), UInt64OutValue(&eTheSpace))
	if (err != nil) {
		return 0, err
	}
	
	return ELib3MFCompositionSpace (eTheSpace), err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_GetFactor1(Vector3DFieldComposed Lib3MFHandle) (float64, error) {
	var err error = nil
	var dFactor1 float64 = 0
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_getfactor1, implementation_vector3dfieldcomposed.GetDLLInHandle(), Float64OutValue(&dFactor1))
	if (err != nil) {
		return 0, err
	}
	
	return dFactor1, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_SetFactor1(Vector3DFieldComposed Lib3MFHandle, dFactor1 float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_setfactor1, implementation_vector3dfieldcomposed.GetDLLInHandle(), Float64InValue(dFactor1))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_GetFactor2(Vector3DFieldComposed Lib3MFHandle) (float64, error) {
	var err error = nil
	var dFactor2 float64 = 0
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_getfactor2, implementation_vector3dfieldcomposed.GetDLLInHandle(), Float64OutValue(&dFactor2))
	if (err != nil) {
		return 0, err
	}
	
	return dFactor2, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_SetFactor2(Vector3DFieldComposed Lib3MFHandle, dFactor2 float64) (error) {
	var err error = nil
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_setfactor2, implementation_vector3dfieldcomposed.GetDLLInHandle(), Float64InValue(dFactor2))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_Vector3DFieldReference1(Vector3DFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVector3DFieldReference1 := implementation.NewHandle()
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return hTheVector3DFieldReference1, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_vector3dfieldreference1, implementation_vector3dfieldcomposed.GetDLLInHandle(), hTheVector3DFieldReference1.GetDLLOutHandle())
	if (err != nil) {
		return hTheVector3DFieldReference1, err
	}
	
	return hTheVector3DFieldReference1, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_Vector3DFieldReference2(Vector3DFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVector3DFieldReference1 := implementation.NewHandle()
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return hTheVector3DFieldReference1, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_vector3dfieldreference2, implementation_vector3dfieldcomposed.GetDLLInHandle(), hTheVector3DFieldReference1.GetDLLOutHandle())
	if (err != nil) {
		return hTheVector3DFieldReference1, err
	}
	
	return hTheVector3DFieldReference1, err
}

func (implementation *Lib3MFImplementation) Vector3DFieldComposed_ScalarFieldReferenceMask(Vector3DFieldComposed Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldReferenceMask := implementation.NewHandle()
	
	implementation_vector3dfieldcomposed, err := implementation.GetWrapperHandle(Vector3DFieldComposed)
	if (err != nil) {
		return hTheScalarFieldReferenceMask, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldcomposed_scalarfieldreferencemask, implementation_vector3dfieldcomposed.GetDLLInHandle(), hTheScalarFieldReferenceMask.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldReferenceMask, err
	}
	
	return hTheScalarFieldReferenceMask, err
}

func (implementation *Lib3MFImplementation) FieldReference_GetFieldResourceID(FieldReference Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0
	
	implementation_fieldreference, err := implementation.GetWrapperHandle(FieldReference)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_fieldreference_getfieldresourceid, implementation_fieldreference.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) FieldReference_SetFieldResourceID(FieldReference Lib3MFHandle, nUniqueResourceID uint32) (error) {
	var err error = nil
	
	implementation_fieldreference, err := implementation.GetWrapperHandle(FieldReference)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_fieldreference_setfieldresourceid, implementation_fieldreference.GetDLLInHandle(), UInt32InValue(nUniqueResourceID))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) FieldReference_GetTransform(FieldReference Lib3MFHandle) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform
	
	implementation_fieldreference, err := implementation.GetWrapperHandle(FieldReference)
	if (err != nil) {
		return sTransform, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_fieldreference_gettransform, implementation_fieldreference.GetDLLInHandle(), 0)
	if (err != nil) {
		return sTransform, err
	}
	
	return sTransform, err
}

func (implementation *Lib3MFImplementation) FieldReference_SetTransform(FieldReference Lib3MFHandle, sTransform sLib3MFTransform) (error) {
	var err error = nil
	
	implementation_fieldreference, err := implementation.GetWrapperHandle(FieldReference)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_fieldreference_settransform, implementation_fieldreference.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTransform)))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ScalarFieldReference_SetScalarField(ScalarFieldReference Lib3MFHandle, TheScalarField Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_scalarfieldreference, err := implementation.GetWrapperHandle(ScalarFieldReference)
	if (err != nil) {
		return err
	}
	implementation_thescalarfield, err := implementation.GetWrapperHandle(TheScalarField)
	if (err != nil) {
		return err
	}
	
	TheScalarFieldDLLHandle := implementation_thescalarfield.GetDLLInHandle()
	if (TheScalarFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_scalarfieldreference_setscalarfield, implementation_scalarfieldreference.GetDLLInHandle(), TheScalarFieldDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Vector3DFieldReference_SetVector3DField(Vector3DFieldReference Lib3MFHandle, TheVector3DField Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_vector3dfieldreference, err := implementation.GetWrapperHandle(Vector3DFieldReference)
	if (err != nil) {
		return err
	}
	implementation_thevector3dfield, err := implementation.GetWrapperHandle(TheVector3DField)
	if (err != nil) {
		return err
	}
	
	TheVector3DFieldDLLHandle := implementation_thevector3dfield.GetDLLInHandle()
	if (TheVector3DFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_vector3dfieldreference_setvector3dfield, implementation_vector3dfieldreference.GetDLLInHandle(), TheVector3DFieldDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeDataBoundary_GetSolidThreshold(VolumeDataBoundary Lib3MFHandle) (float64, error) {
	var err error = nil
	var dTheSolidThreshold float64 = 0
	
	implementation_volumedataboundary, err := implementation.GetWrapperHandle(VolumeDataBoundary)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedataboundary_getsolidthreshold, implementation_volumedataboundary.GetDLLInHandle(), Float64OutValue(&dTheSolidThreshold))
	if (err != nil) {
		return 0, err
	}
	
	return dTheSolidThreshold, err
}

func (implementation *Lib3MFImplementation) VolumeDataBoundary_SetSolidThreshold(VolumeDataBoundary Lib3MFHandle, dTheSolidThreshold float64) (error) {
	var err error = nil
	
	implementation_volumedataboundary, err := implementation.GetWrapperHandle(VolumeDataBoundary)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedataboundary_setsolidthreshold, implementation_volumedataboundary.GetDLLInHandle(), Float64InValue(dTheSolidThreshold))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_GetBaseMaterialGroup(VolumeDataComposite Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBaseMaterialGroupInstance := implementation.NewHandle()
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return hBaseMaterialGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_getbasematerialgroup, implementation_volumedatacomposite.GetDLLInHandle(), hBaseMaterialGroupInstance.GetDLLOutHandle())
	if (err != nil) {
		return hBaseMaterialGroupInstance, err
	}
	
	return hBaseMaterialGroupInstance, err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_SetBaseMaterialGroup(VolumeDataComposite Lib3MFHandle, BaseMaterialGroupInstance Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return err
	}
	implementation_basematerialgroupinstance, err := implementation.GetWrapperHandle(BaseMaterialGroupInstance)
	if (err != nil) {
		return err
	}
	
	BaseMaterialGroupInstanceDLLHandle := implementation_basematerialgroupinstance.GetDLLInHandle()
	if (BaseMaterialGroupInstanceDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_setbasematerialgroup, implementation_volumedatacomposite.GetDLLInHandle(), BaseMaterialGroupInstanceDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_GetMaterialMappingCount(VolumeDataComposite Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_getmaterialmappingcount, implementation_volumedatacomposite.GetDLLInHandle(), UInt32OutValue(&nCount))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_GetMaterialMapping(VolumeDataComposite Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hTheMaterialMapping := implementation.NewHandle()
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return hTheMaterialMapping, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_getmaterialmapping, implementation_volumedatacomposite.GetDLLInHandle(), UInt32InValue(nIndex), hTheMaterialMapping.GetDLLOutHandle())
	if (err != nil) {
		return hTheMaterialMapping, err
	}
	
	return hTheMaterialMapping, err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_AddMaterialMapping(VolumeDataComposite Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFHandle, error) {
	var err error = nil
	hTheMaterialMapping := implementation.NewHandle()
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return hTheMaterialMapping, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_addmaterialmapping, implementation_volumedatacomposite.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTransform)), hTheMaterialMapping.GetDLLOutHandle())
	if (err != nil) {
		return hTheMaterialMapping, err
	}
	
	return hTheMaterialMapping, err
}

func (implementation *Lib3MFImplementation) VolumeDataComposite_RemoveMaterialMapping(VolumeDataComposite Lib3MFHandle, nIndex uint32) (error) {
	var err error = nil
	
	implementation_volumedatacomposite, err := implementation.GetWrapperHandle(VolumeDataComposite)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedatacomposite_removematerialmapping, implementation_volumedatacomposite.GetDLLInHandle(), UInt32InValue(nIndex))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeDataProperty_GetName(VolumeDataProperty Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPropertyName int64 = 0
	var filledinPropertyName int64 = 0
	
	implementation_volumedataproperty, err := implementation.GetWrapperHandle(VolumeDataProperty)
	if (err != nil) {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedataproperty_getname, implementation_volumedataproperty.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyName), Int64InValue(0))
	if (err != nil) {
		return "", err
	}
	bufferSizePropertyName := neededforPropertyName
	bufferPropertyName := make([]byte, bufferSizePropertyName)
	err = implementation.CallFunction(implementation.Lib3MF_volumedataproperty_getname, implementation_volumedataproperty.GetDLLInHandle(), Int64InValue(bufferSizePropertyName), Int64OutValue(&filledinPropertyName), uintptr(unsafe.Pointer(&bufferPropertyName[0])))
	if (err != nil) {
		return "", err
	}
	
	return string(bufferPropertyName[:(filledinPropertyName-1)]), err
}

func (implementation *Lib3MFImplementation) VolumeDataProperty_SetIsRequired(VolumeDataProperty Lib3MFHandle, bIsRequired bool) (error) {
	var err error = nil
	var nIsRequired uint8 = 0
	if (bIsRequired) {
		nIsRequired = 1
	}
	
	
	implementation_volumedataproperty, err := implementation.GetWrapperHandle(VolumeDataProperty)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedataproperty_setisrequired, implementation_volumedataproperty.GetDLLInHandle(), UInt8InValue(nIsRequired))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeDataProperty_IsRequired(VolumeDataProperty Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsRequired int64 = 0
	
	implementation_volumedataproperty, err := implementation.GetWrapperHandle(VolumeDataProperty)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedataproperty_isrequired, implementation_volumedataproperty.GetDLLInHandle(), Int64OutValue(&bIsRequired))
	if (err != nil) {
		return false, err
	}
	
	return (bIsRequired != 0), err
}

func (implementation *Lib3MFImplementation) VolumeData_GetBoundary(VolumeData Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheLevelSetData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheLevelSetData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_getboundary, implementation_volumedata.GetDLLInHandle(), hTheLevelSetData.GetDLLOutHandle())
	if (err != nil) {
		return hTheLevelSetData, err
	}
	
	return hTheLevelSetData, err
}

func (implementation *Lib3MFImplementation) VolumeData_CreateNewBoundary(VolumeData Lib3MFHandle, TheScalarField Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheLevelSetData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheLevelSetData, err
	}
	implementation_thescalarfield, err := implementation.GetWrapperHandle(TheScalarField)
	if (err != nil) {
		return hTheLevelSetData, err
	}
	
	TheScalarFieldDLLHandle := implementation_thescalarfield.GetDLLInHandle()
	if (TheScalarFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheLevelSetData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_createnewboundary, implementation_volumedata.GetDLLInHandle(), TheScalarFieldDLLHandle, hTheLevelSetData.GetDLLOutHandle())
	if (err != nil) {
		return hTheLevelSetData, err
	}
	
	return hTheLevelSetData, err
}

func (implementation *Lib3MFImplementation) VolumeData_RemoveBoundary(VolumeData Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_removeboundary, implementation_volumedata.GetDLLInHandle())
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeData_GetComposite(VolumeData Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheCompositeData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheCompositeData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_getcomposite, implementation_volumedata.GetDLLInHandle(), hTheCompositeData.GetDLLOutHandle())
	if (err != nil) {
		return hTheCompositeData, err
	}
	
	return hTheCompositeData, err
}

func (implementation *Lib3MFImplementation) VolumeData_CreateNewComposite(VolumeData Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheCompositeData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheCompositeData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_createnewcomposite, implementation_volumedata.GetDLLInHandle(), hTheCompositeData.GetDLLOutHandle())
	if (err != nil) {
		return hTheCompositeData, err
	}
	
	return hTheCompositeData, err
}

func (implementation *Lib3MFImplementation) VolumeData_RemoveComposite(VolumeData Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_removecomposite, implementation_volumedata.GetDLLInHandle())
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeData_GetColor(VolumeData Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheColorData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheColorData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_getcolor, implementation_volumedata.GetDLLInHandle(), hTheColorData.GetDLLOutHandle())
	if (err != nil) {
		return hTheColorData, err
	}
	
	return hTheColorData, err
}

func (implementation *Lib3MFImplementation) VolumeData_CreateNewColor(VolumeData Lib3MFHandle, TheVector3DField Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheColorData := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheColorData, err
	}
	implementation_thevector3dfield, err := implementation.GetWrapperHandle(TheVector3DField)
	if (err != nil) {
		return hTheColorData, err
	}
	
	TheVector3DFieldDLLHandle := implementation_thevector3dfield.GetDLLInHandle()
	if (TheVector3DFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheColorData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_createnewcolor, implementation_volumedata.GetDLLInHandle(), TheVector3DFieldDLLHandle, hTheColorData.GetDLLOutHandle())
	if (err != nil) {
		return hTheColorData, err
	}
	
	return hTheColorData, err
}

func (implementation *Lib3MFImplementation) VolumeData_RemoveColor(VolumeData Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_removecolor, implementation_volumedata.GetDLLInHandle())
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) VolumeData_GetPropertyCount(VolumeData Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_getpropertycount, implementation_volumedata.GetDLLInHandle(), UInt32OutValue(&nCount))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) VolumeData_GetProperty(VolumeData Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hTheVolumeDataProperty := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_getproperty, implementation_volumedata.GetDLLInHandle(), UInt32InValue(nIndex), hTheVolumeDataProperty.GetDLLOutHandle())
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	
	return hTheVolumeDataProperty, err
}

func (implementation *Lib3MFImplementation) VolumeData_AddPropertyFromScalarField(VolumeData Lib3MFHandle, sName string, TheScalarField Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVolumeDataProperty := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	implementation_thescalarfield, err := implementation.GetWrapperHandle(TheScalarField)
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	
	TheScalarFieldDLLHandle := implementation_thescalarfield.GetDLLInHandle()
	if (TheScalarFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheVolumeDataProperty, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_addpropertyfromscalarfield, implementation_volumedata.GetDLLInHandle(), StringInValue(sName), TheScalarFieldDLLHandle, hTheVolumeDataProperty.GetDLLOutHandle())
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	
	return hTheVolumeDataProperty, err
}

func (implementation *Lib3MFImplementation) VolumeData_AddPropertyFromVector3DField(VolumeData Lib3MFHandle, sName string, TheVector3DField Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVolumeDataProperty := implementation.NewHandle()
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	implementation_thevector3dfield, err := implementation.GetWrapperHandle(TheVector3DField)
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	
	TheVector3DFieldDLLHandle := implementation_thevector3dfield.GetDLLInHandle()
	if (TheVector3DFieldDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheVolumeDataProperty, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_addpropertyfromvector3dfield, implementation_volumedata.GetDLLInHandle(), StringInValue(sName), TheVector3DFieldDLLHandle, hTheVolumeDataProperty.GetDLLOutHandle())
	if (err != nil) {
		return hTheVolumeDataProperty, err
	}
	
	return hTheVolumeDataProperty, err
}

func (implementation *Lib3MFImplementation) VolumeData_RemoveProperty(VolumeData Lib3MFHandle, nIndex uint32) (error) {
	var err error = nil
	
	implementation_volumedata, err := implementation.GetWrapperHandle(VolumeData)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_volumedata_removeproperty, implementation_volumedata.GetDLLInHandle(), UInt32InValue(nIndex))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Component_GetObjectResource(Component Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hObjectResource := implementation.NewHandle()

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return hObjectResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_getobjectresource, implementation_component.GetDLLInHandle(), hObjectResource.GetDLLOutHandle())
	if err != nil {
		return hObjectResource, err
	}

	return hObjectResource, err
}

func (implementation *Lib3MFImplementation) Component_GetObjectResourceID(Component Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_getobjectresourceid, implementation_component.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return 0, err
	}

	return uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) Component_GetUUID(Component Lib3MFHandle) (bool, string, error) {
	var err error = nil
	var bHasUUID int64 = 0
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return false, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_getuuid, implementation_component.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_component_getuuid, implementation_component.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasUUID != 0), string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) Component_SetUUID(Component Lib3MFHandle, sUUID string) error {
	var err error = nil

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_setuuid, implementation_component.GetDLLInHandle(), StringInValue(sUUID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Component_HasTransform(Component Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasTransform int64 = 0

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_hastransform, implementation_component.GetDLLInHandle(), Int64OutValue(&bHasTransform))
	if err != nil {
		return false, err
	}

	return (bHasTransform != 0), err
}

func (implementation *Lib3MFImplementation) Component_GetTransform(Component Lib3MFHandle) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return sTransform, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_gettransform, implementation_component.GetDLLInHandle(), 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) Component_SetTransform(Component Lib3MFHandle, sTransform sLib3MFTransform) error {
	var err error = nil

	implementation_component, err := implementation.GetWrapperHandle(Component)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_component_settransform, implementation_component.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTransform)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) ComponentsObject_AddComponent(ComponentsObject Lib3MFHandle, ObjectResource Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFHandle, error) {
	var err error = nil
	hComponentInstance := implementation.NewHandle()

	implementation_componentsobject, err := implementation.GetWrapperHandle(ComponentsObject)
	if err != nil {
		return hComponentInstance, err
	}
	implementation_objectresource, err := implementation.GetWrapperHandle(ObjectResource)
	if err != nil {
		return hComponentInstance, err
	}

	ObjectResourceDLLHandle := implementation_objectresource.GetDLLInHandle()
	if ObjectResourceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hComponentInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_componentsobject_addcomponent, implementation_componentsobject.GetDLLInHandle(), ObjectResourceDLLHandle, uintptr(unsafe.Pointer(&sTransform)), hComponentInstance.GetDLLOutHandle())
	if err != nil {
		return hComponentInstance, err
	}

	return hComponentInstance, err
}

func (implementation *Lib3MFImplementation) ComponentsObject_GetComponent(ComponentsObject Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hComponentInstance := implementation.NewHandle()

	implementation_componentsobject, err := implementation.GetWrapperHandle(ComponentsObject)
	if err != nil {
		return hComponentInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_componentsobject_getcomponent, implementation_componentsobject.GetDLLInHandle(), UInt32InValue(nIndex), hComponentInstance.GetDLLOutHandle())
	if err != nil {
		return hComponentInstance, err
	}

	return hComponentInstance, err
}

func (implementation *Lib3MFImplementation) ComponentsObject_GetComponentCount(ComponentsObject Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_componentsobject, err := implementation.GetWrapperHandle(ComponentsObject)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_componentsobject_getcomponentcount, implementation_componentsobject.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamSet_SetName(BeamSet Lib3MFHandle, sName string) error {
	var err error = nil

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_setname, implementation_beamset.GetDLLInHandle(), StringInValue(sName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamSet_GetName(BeamSet Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getname, implementation_beamset.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_beamset_getname, implementation_beamset.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if err != nil {
		return "", err
	}

	return string(bufferName[:(filledinName - 1)]), err
}

func (implementation *Lib3MFImplementation) BeamSet_SetIdentifier(BeamSet Lib3MFHandle, sIdentifier string) error {
	var err error = nil

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_setidentifier, implementation_beamset.GetDLLInHandle(), StringInValue(sIdentifier))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamSet_GetIdentifier(BeamSet Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforIdentifier int64 = 0
	var filledinIdentifier int64 = 0

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getidentifier, implementation_beamset.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforIdentifier), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeIdentifier := neededforIdentifier
	bufferIdentifier := make([]byte, bufferSizeIdentifier)
	err = implementation.CallFunction(implementation.Lib3MF_beamset_getidentifier, implementation_beamset.GetDLLInHandle(), Int64InValue(bufferSizeIdentifier), Int64OutValue(&filledinIdentifier), uintptr(unsafe.Pointer(&bufferIdentifier[0])))
	if err != nil {
		return "", err
	}

	return string(bufferIdentifier[:(filledinIdentifier - 1)]), err
}

func (implementation *Lib3MFImplementation) BeamSet_GetReferenceCount(BeamSet Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getreferencecount, implementation_beamset.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamSet_SetReferences(BeamSet Lib3MFHandle, References []uint32) error {
	var err error = nil

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_setreferences, implementation_beamset.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamSet_GetReferences(BeamSet Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforReferences int64 = 0
	var filledinReferences int64 = 0
	bufferReferences := make([]uint32, 0)

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getreferences, implementation_beamset.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforReferences), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizeReferences := neededforReferences
	bufferReferences = make([]uint32, bufferSizeReferences)
	err = implementation.CallFunction(implementation.Lib3MF_beamset_getreferences, implementation_beamset.GetDLLInHandle(), Int64InValue(bufferSizeReferences), Int64OutValue(&filledinReferences), uintptr(unsafe.Pointer(&bufferReferences[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferReferences, err
}

func (implementation *Lib3MFImplementation) BeamSet_GetBallReferenceCount(BeamSet Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getballreferencecount, implementation_beamset.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BeamSet_SetBallReferences(BeamSet Lib3MFHandle, BallReferences []uint32) error {
	var err error = nil

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_setballreferences, implementation_beamset.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BeamSet_GetBallReferences(BeamSet Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforBallReferences int64 = 0
	var filledinBallReferences int64 = 0
	bufferBallReferences := make([]uint32, 0)

	implementation_beamset, err := implementation.GetWrapperHandle(BeamSet)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_beamset_getballreferences, implementation_beamset.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforBallReferences), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizeBallReferences := neededforBallReferences
	bufferBallReferences = make([]uint32, bufferSizeBallReferences)
	err = implementation.CallFunction(implementation.Lib3MF_beamset_getballreferences, implementation_beamset.GetDLLInHandle(), Int64InValue(bufferSizeBallReferences), Int64OutValue(&filledinBallReferences), uintptr(unsafe.Pointer(&bufferBallReferences[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferBallReferences, err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_GetCount(BaseMaterialGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getcount, implementation_basematerialgroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_GetAllPropertyIDs(BaseMaterialGroup Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getallpropertyids, implementation_basematerialgroup.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getallpropertyids, implementation_basematerialgroup.GetDLLInHandle(), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_AddMaterial(BaseMaterialGroup Lib3MFHandle, sName string, sDisplayColor sLib3MFColor) (uint32, error) {
	var err error = nil
	var nPropertyID uint32 = 0

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_addmaterial, implementation_basematerialgroup.GetDLLInHandle(), StringInValue(sName), uintptr(unsafe.Pointer(&sDisplayColor)), UInt32OutValue(&nPropertyID))
	if err != nil {
		return 0, err
	}

	return uint32(nPropertyID), err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_RemoveMaterial(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) error {
	var err error = nil

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_removematerial, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_GetName(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getname, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getname, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if err != nil {
		return "", err
	}

	return string(bufferName[:(filledinName - 1)]), err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_SetName(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32, sName string) error {
	var err error = nil

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_setname, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), StringInValue(sName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_SetDisplayColor(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32, sTheColor sLib3MFColor) error {
	var err error = nil

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_setdisplaycolor, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), uintptr(unsafe.Pointer(&sTheColor)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BaseMaterialGroup_GetDisplayColor(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFColor, error) {
	var err error = nil
	var sTheColor sLib3MFColor

	implementation_basematerialgroup, err := implementation.GetWrapperHandle(BaseMaterialGroup)
	if err != nil {
		return sTheColor, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_basematerialgroup_getdisplaycolor, implementation_basematerialgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), 0)
	if err != nil {
		return sTheColor, err
	}

	return sTheColor, err
}

func (implementation *Lib3MFImplementation) ColorGroup_GetCount(ColorGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_getcount, implementation_colorgroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) ColorGroup_GetAllPropertyIDs(ColorGroup Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_getallpropertyids, implementation_colorgroup.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_getallpropertyids, implementation_colorgroup.GetDLLInHandle(), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) ColorGroup_AddColor(ColorGroup Lib3MFHandle, sTheColor sLib3MFColor) (uint32, error) {
	var err error = nil
	var nPropertyID uint32 = 0

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_addcolor, implementation_colorgroup.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTheColor)), UInt32OutValue(&nPropertyID))
	if err != nil {
		return 0, err
	}

	return uint32(nPropertyID), err
}

func (implementation *Lib3MFImplementation) ColorGroup_RemoveColor(ColorGroup Lib3MFHandle, nPropertyID uint32) error {
	var err error = nil

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_removecolor, implementation_colorgroup.GetDLLInHandle(), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) ColorGroup_SetColor(ColorGroup Lib3MFHandle, nPropertyID uint32, sTheColor sLib3MFColor) error {
	var err error = nil

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_setcolor, implementation_colorgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), uintptr(unsafe.Pointer(&sTheColor)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) ColorGroup_GetColor(ColorGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFColor, error) {
	var err error = nil
	var sTheColor sLib3MFColor

	implementation_colorgroup, err := implementation.GetWrapperHandle(ColorGroup)
	if err != nil {
		return sTheColor, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_colorgroup_getcolor, implementation_colorgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), 0)
	if err != nil {
		return sTheColor, err
	}

	return sTheColor, err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_GetCount(Texture2DGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_getcount, implementation_texture2dgroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_GetAllPropertyIDs(Texture2DGroup Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_getallpropertyids, implementation_texture2dgroup.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_getallpropertyids, implementation_texture2dgroup.GetDLLInHandle(), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_AddTex2Coord(Texture2DGroup Lib3MFHandle, sUVCoordinate sLib3MFTex2Coord) (uint32, error) {
	var err error = nil
	var nPropertyID uint32 = 0

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_addtex2coord, implementation_texture2dgroup.GetDLLInHandle(), uintptr(unsafe.Pointer(&sUVCoordinate)), UInt32OutValue(&nPropertyID))
	if err != nil {
		return 0, err
	}

	return uint32(nPropertyID), err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_GetTex2Coord(Texture2DGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFTex2Coord, error) {
	var err error = nil
	var sUVCoordinate sLib3MFTex2Coord

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return sUVCoordinate, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_gettex2coord, implementation_texture2dgroup.GetDLLInHandle(), UInt32InValue(nPropertyID), 0)
	if err != nil {
		return sUVCoordinate, err
	}

	return sUVCoordinate, err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_RemoveTex2Coord(Texture2DGroup Lib3MFHandle, nPropertyID uint32) error {
	var err error = nil

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_removetex2coord, implementation_texture2dgroup.GetDLLInHandle(), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Texture2DGroup_GetTexture2D(Texture2DGroup Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTexture2DInstance := implementation.NewHandle()

	implementation_texture2dgroup, err := implementation.GetWrapperHandle(Texture2DGroup)
	if err != nil {
		return hTexture2DInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2dgroup_gettexture2d, implementation_texture2dgroup.GetDLLInHandle(), hTexture2DInstance.GetDLLOutHandle())
	if err != nil {
		return hTexture2DInstance, err
	}

	return hTexture2DInstance, err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_GetCount(CompositeMaterials Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getcount, implementation_compositematerials.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_GetAllPropertyIDs(CompositeMaterials Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getallpropertyids, implementation_compositematerials.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getallpropertyids, implementation_compositematerials.GetDLLInHandle(), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_GetBaseMaterialGroup(CompositeMaterials Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBaseMaterialGroupInstance := implementation.NewHandle()

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getbasematerialgroup, implementation_compositematerials.GetDLLInHandle(), hBaseMaterialGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	return hBaseMaterialGroupInstance, err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_AddComposite(CompositeMaterials Lib3MFHandle, Composite []sLib3MFCompositeConstituent) (uint32, error) {
	var err error = nil
	var nPropertyID uint32 = 0

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_addcomposite, implementation_compositematerials.GetDLLInHandle(), 0, 0, UInt32OutValue(&nPropertyID))
	if err != nil {
		return 0, err
	}

	return uint32(nPropertyID), err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_RemoveComposite(CompositeMaterials Lib3MFHandle, nPropertyID uint32) error {
	var err error = nil

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_removecomposite, implementation_compositematerials.GetDLLInHandle(), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) CompositeMaterials_GetComposite(CompositeMaterials Lib3MFHandle, nPropertyID uint32) ([]sLib3MFCompositeConstituent, error) {
	var err error = nil
	arrayComposite := make([]sLib3MFCompositeConstituent, 0)

	implementation_compositematerials, err := implementation.GetWrapperHandle(CompositeMaterials)
	if err != nil {
		return make([]sLib3MFCompositeConstituent, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getcomposite, implementation_compositematerials.GetDLLInHandle(), UInt32InValue(nPropertyID), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFCompositeConstituent, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_compositematerials_getcomposite, implementation_compositematerials.GetDLLInHandle(), UInt32InValue(nPropertyID), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFCompositeConstituent, 0), err
	}

	return arrayComposite, err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_GetCount(MultiPropertyGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getcount, implementation_multipropertygroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_GetAllPropertyIDs(MultiPropertyGroup Lib3MFHandle) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getallpropertyids, implementation_multipropertygroup.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getallpropertyids, implementation_multipropertygroup.GetDLLInHandle(), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_AddMultiProperty(MultiPropertyGroup Lib3MFHandle, PropertyIDs []uint32) (uint32, error) {
	var err error = nil
	var nPropertyID uint32 = 0

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_addmultiproperty, implementation_multipropertygroup.GetDLLInHandle(), 0, 0, UInt32OutValue(&nPropertyID))
	if err != nil {
		return 0, err
	}

	return uint32(nPropertyID), err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_SetMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32, PropertyIDs []uint32) error {
	var err error = nil

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_setmultiproperty, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nPropertyID), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_GetMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32) ([]uint32, error) {
	var err error = nil
	var neededforPropertyIDs int64 = 0
	var filledinPropertyIDs int64 = 0
	bufferPropertyIDs := make([]uint32, 0)

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getmultiproperty, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nPropertyID), Int64InValue(0), Int64OutValue(&neededforPropertyIDs), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizePropertyIDs := neededforPropertyIDs
	bufferPropertyIDs = make([]uint32, bufferSizePropertyIDs)
	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getmultiproperty, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nPropertyID), Int64InValue(bufferSizePropertyIDs), Int64OutValue(&filledinPropertyIDs), uintptr(unsafe.Pointer(&bufferPropertyIDs[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferPropertyIDs, err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_RemoveMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32) error {
	var err error = nil

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_removemultiproperty, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nPropertyID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_GetLayerCount(MultiPropertyGroup Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nCount uint32 = 0

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getlayercount, implementation_multipropertygroup.GetDLLInHandle(), UInt32OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint32(nCount), err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_AddLayer(MultiPropertyGroup Lib3MFHandle, sTheLayer sLib3MFMultiPropertyLayer) (uint32, error) {
	var err error = nil
	var nLayerIndex uint32 = 0

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_addlayer, implementation_multipropertygroup.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTheLayer)), UInt32OutValue(&nLayerIndex))
	if err != nil {
		return 0, err
	}

	return uint32(nLayerIndex), err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_GetLayer(MultiPropertyGroup Lib3MFHandle, nLayerIndex uint32) (sLib3MFMultiPropertyLayer, error) {
	var err error = nil
	var sTheLayer sLib3MFMultiPropertyLayer

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return sTheLayer, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_getlayer, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nLayerIndex), 0)
	if err != nil {
		return sTheLayer, err
	}

	return sTheLayer, err
}

func (implementation *Lib3MFImplementation) MultiPropertyGroup_RemoveLayer(MultiPropertyGroup Lib3MFHandle, nLayerIndex uint32) error {
	var err error = nil

	implementation_multipropertygroup, err := implementation.GetWrapperHandle(MultiPropertyGroup)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_multipropertygroup_removelayer, implementation_multipropertygroup.GetDLLInHandle(), UInt32InValue(nLayerIndex))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Image3D_GetName(Image3D Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforName int64 = 0
	var filledinName int64 = 0
	
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_image3d_getname, implementation_image3d.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforName), Int64InValue(0))
	if (err != nil) {
		return "", err
	}
	bufferSizeName := neededforName
	bufferName := make([]byte, bufferSizeName)
	err = implementation.CallFunction(implementation.Lib3MF_image3d_getname, implementation_image3d.GetDLLInHandle(), Int64InValue(bufferSizeName), Int64OutValue(&filledinName), uintptr(unsafe.Pointer(&bufferName[0])))
	if (err != nil) {
		return "", err
	}
	
	return string(bufferName[:(filledinName-1)]), err
}

func (implementation *Lib3MFImplementation) Image3D_SetName(Image3D Lib3MFHandle, sName string) (error) {
	var err error = nil
	
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_image3d_setname, implementation_image3d.GetDLLInHandle(), StringInValue(sName))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) Image3D_IsImageStack(Image3D Lib3MFHandle) (bool, error) {
	var err error = nil
	var bIsImageStack int64 = 0
	
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_image3d_isimagestack, implementation_image3d.GetDLLInHandle(), Int64OutValue(&bIsImageStack))
	if (err != nil) {
		return false, err
	}
	
	return (bIsImageStack != 0), err
}

func (implementation *Lib3MFImplementation) ImageStack_GetRowCount(ImageStack Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nRowCount uint32 = 0
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_getrowcount, implementation_imagestack.GetDLLInHandle(), UInt32OutValue(&nRowCount))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nRowCount), err
}

func (implementation *Lib3MFImplementation) ImageStack_SetRowCount(ImageStack Lib3MFHandle, nRowCount uint32) (error) {
	var err error = nil
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_setrowcount, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nRowCount))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ImageStack_GetColumnCount(ImageStack Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nColumnCount uint32 = 0
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_getcolumncount, implementation_imagestack.GetDLLInHandle(), UInt32OutValue(&nColumnCount))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nColumnCount), err
}

func (implementation *Lib3MFImplementation) ImageStack_SetColumnCount(ImageStack Lib3MFHandle, nColumnCount uint32) (error) {
	var err error = nil
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_setcolumncount, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nColumnCount))
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ImageStack_GetSheetCount(ImageStack Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nSheetCount uint32 = 0
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_getsheetcount, implementation_imagestack.GetDLLInHandle(), UInt32OutValue(&nSheetCount))
	if (err != nil) {
		return 0, err
	}
	
	return uint32(nSheetCount), err
}

func (implementation *Lib3MFImplementation) ImageStack_GetSheet(ImageStack Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hSheet := implementation.NewHandle()
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return hSheet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_getsheet, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nIndex), hSheet.GetDLLOutHandle())
	if (err != nil) {
		return hSheet, err
	}
	
	return hSheet, err
}

func (implementation *Lib3MFImplementation) ImageStack_SetSheet(ImageStack Lib3MFHandle, nIndex uint32, Sheet Lib3MFHandle) (error) {
	var err error = nil
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return err
	}
	implementation_sheet, err := implementation.GetWrapperHandle(Sheet)
	if (err != nil) {
		return err
	}
	
	SheetDLLHandle := implementation_sheet.GetDLLInHandle()
	if (SheetDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_setsheet, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nIndex), SheetDLLHandle)
	if (err != nil) {
		return err
	}
	
	return err
}

func (implementation *Lib3MFImplementation) ImageStack_CreateEmptySheet(ImageStack Lib3MFHandle, nIndex uint32, sPath string) (Lib3MFHandle, error) {
	var err error = nil
	hSheet := implementation.NewHandle()
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return hSheet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_createemptysheet, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nIndex), StringInValue(sPath), hSheet.GetDLLOutHandle())
	if (err != nil) {
		return hSheet, err
	}
	
	return hSheet, err
}

func (implementation *Lib3MFImplementation) ImageStack_CreateSheetFromBuffer(ImageStack Lib3MFHandle, nIndex uint32, sPath string, Data []uint8) (Lib3MFHandle, error) {
	var err error = nil
	hSheet := implementation.NewHandle()
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return hSheet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_createsheetfrombuffer, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nIndex), StringInValue(sPath), 0, 0, hSheet.GetDLLOutHandle())
	if (err != nil) {
		return hSheet, err
	}
	
	return hSheet, err
}

func (implementation *Lib3MFImplementation) ImageStack_CreateSheetFromFile(ImageStack Lib3MFHandle, nIndex uint32, sPath string, sFileName string) (Lib3MFHandle, error) {
	var err error = nil
	hSheet := implementation.NewHandle()
	
	implementation_imagestack, err := implementation.GetWrapperHandle(ImageStack)
	if (err != nil) {
		return hSheet, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_imagestack_createsheetfromfile, implementation_imagestack.GetDLLInHandle(), UInt32InValue(nIndex), StringInValue(sPath), StringInValue(sFileName), hSheet.GetDLLOutHandle())
	if (err != nil) {
		return hSheet, err
	}
	
	return hSheet, err
}

func (implementation *Lib3MFImplementation) Attachment_GetPath(Attachment Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPath int64 = 0
	var filledinPath int64 = 0

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_getpath, implementation_attachment.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPath), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePath := neededforPath
	bufferPath := make([]byte, bufferSizePath)
	err = implementation.CallFunction(implementation.Lib3MF_attachment_getpath, implementation_attachment.GetDLLInHandle(), Int64InValue(bufferSizePath), Int64OutValue(&filledinPath), uintptr(unsafe.Pointer(&bufferPath[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPath[:(filledinPath - 1)]), err
}

func (implementation *Lib3MFImplementation) Attachment_SetPath(Attachment Lib3MFHandle, sPath string) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_setpath, implementation_attachment.GetDLLInHandle(), StringInValue(sPath))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Attachment_PackagePart(Attachment Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hPackagePart := implementation.NewHandle()

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return hPackagePart, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_packagepart, implementation_attachment.GetDLLInHandle(), hPackagePart.GetDLLOutHandle())
	if err != nil {
		return hPackagePart, err
	}

	return hPackagePart, err
}

func (implementation *Lib3MFImplementation) Attachment_GetRelationShipType(Attachment Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPath int64 = 0
	var filledinPath int64 = 0

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_getrelationshiptype, implementation_attachment.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPath), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePath := neededforPath
	bufferPath := make([]byte, bufferSizePath)
	err = implementation.CallFunction(implementation.Lib3MF_attachment_getrelationshiptype, implementation_attachment.GetDLLInHandle(), Int64InValue(bufferSizePath), Int64OutValue(&filledinPath), uintptr(unsafe.Pointer(&bufferPath[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPath[:(filledinPath - 1)]), err
}

func (implementation *Lib3MFImplementation) Attachment_SetRelationShipType(Attachment Lib3MFHandle, sPath string) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_setrelationshiptype, implementation_attachment.GetDLLInHandle(), StringInValue(sPath))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Attachment_WriteToFile(Attachment Lib3MFHandle, sFileName string) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_writetofile, implementation_attachment.GetDLLInHandle(), StringInValue(sFileName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Attachment_ReadFromFile(Attachment Lib3MFHandle, sFileName string) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_readfromfile, implementation_attachment.GetDLLInHandle(), StringInValue(sFileName))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Attachment_ReadFromCallback(Attachment Lib3MFHandle, pTheReadCallback int64, nStreamSize uint64, pTheSeekCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_readfromcallback, implementation_attachment.GetDLLInHandle(), 0, UInt64InValue(nStreamSize), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Attachment_GetStreamSize(Attachment Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nStreamSize uint64 = 0

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_getstreamsize, implementation_attachment.GetDLLInHandle(), UInt64OutValue(&nStreamSize))
	if err != nil {
		return 0, err
	}

	return uint64(nStreamSize), err
}

func (implementation *Lib3MFImplementation) Attachment_WriteToBuffer(Attachment Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforBuffer int64 = 0
	var filledinBuffer int64 = 0
	bufferBuffer := make([]uint8, 0)

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_writetobuffer, implementation_attachment.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforBuffer), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeBuffer := neededforBuffer
	bufferBuffer = make([]uint8, bufferSizeBuffer)
	err = implementation.CallFunction(implementation.Lib3MF_attachment_writetobuffer, implementation_attachment.GetDLLInHandle(), Int64InValue(bufferSizeBuffer), Int64OutValue(&filledinBuffer), uintptr(unsafe.Pointer(&bufferBuffer[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferBuffer, err
}

func (implementation *Lib3MFImplementation) Attachment_ReadFromBuffer(Attachment Lib3MFHandle, Buffer []uint8) error {
	var err error = nil

	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_attachment_readfrombuffer, implementation_attachment.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Texture2D_GetAttachment(Texture2D Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hAttachment := implementation.NewHandle()

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return hAttachment, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_getattachment, implementation_texture2d.GetDLLInHandle(), hAttachment.GetDLLOutHandle())
	if err != nil {
		return hAttachment, err
	}

	return hAttachment, err
}

func (implementation *Lib3MFImplementation) Texture2D_SetAttachment(Texture2D Lib3MFHandle, Attachment Lib3MFHandle) error {
	var err error = nil

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return err
	}
	implementation_attachment, err := implementation.GetWrapperHandle(Attachment)
	if err != nil {
		return err
	}

	AttachmentDLLHandle := implementation_attachment.GetDLLInHandle()
	if AttachmentDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_setattachment, implementation_texture2d.GetDLLInHandle(), AttachmentDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Texture2D_GetContentType(Texture2D Lib3MFHandle) (ELib3MFTextureType, error) {
	var err error = nil
	var eContentType uint64 = 0

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_getcontenttype, implementation_texture2d.GetDLLInHandle(), UInt64OutValue(&eContentType))
	if err != nil {
		return 0, err
	}

	return ELib3MFTextureType(eContentType), err
}

func (implementation *Lib3MFImplementation) Texture2D_SetContentType(Texture2D Lib3MFHandle, eContentType ELib3MFTextureType) error {
	var err error = nil

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_setcontenttype, implementation_texture2d.GetDLLInHandle(), uintptr(eContentType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Texture2D_GetTileStyleUV(Texture2D Lib3MFHandle) (ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, error) {
	var err error = nil
	var eTileStyleU uint64 = 0
	var eTileStyleV uint64 = 0

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return 0, 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_gettilestyleuv, implementation_texture2d.GetDLLInHandle(), UInt64OutValue(&eTileStyleU), UInt64OutValue(&eTileStyleV))
	if err != nil {
		return 0, 0, err
	}

	return ELib3MFTextureTileStyle(eTileStyleU), ELib3MFTextureTileStyle(eTileStyleV), err
}

func (implementation *Lib3MFImplementation) Texture2D_SetTileStyleUV(Texture2D Lib3MFHandle, eTileStyleU ELib3MFTextureTileStyle, eTileStyleV ELib3MFTextureTileStyle) error {
	var err error = nil

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_settilestyleuv, implementation_texture2d.GetDLLInHandle(), uintptr(eTileStyleU), uintptr(eTileStyleV))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Texture2D_GetFilter(Texture2D Lib3MFHandle) (ELib3MFTextureFilter, error) {
	var err error = nil
	var eFilter uint64 = 0

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_getfilter, implementation_texture2d.GetDLLInHandle(), UInt64OutValue(&eFilter))
	if err != nil {
		return 0, err
	}

	return ELib3MFTextureFilter(eFilter), err
}

func (implementation *Lib3MFImplementation) Texture2D_SetFilter(Texture2D Lib3MFHandle, eFilter ELib3MFTextureFilter) error {
	var err error = nil

	implementation_texture2d, err := implementation.GetWrapperHandle(Texture2D)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_texture2d_setfilter, implementation_texture2d.GetDLLInHandle(), uintptr(eFilter))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BuildItem_GetObjectResource(BuildItem Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hObjectResource := implementation.NewHandle()

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return hObjectResource, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getobjectresource, implementation_builditem.GetDLLInHandle(), hObjectResource.GetDLLOutHandle())
	if err != nil {
		return hObjectResource, err
	}

	return hObjectResource, err
}

func (implementation *Lib3MFImplementation) BuildItem_GetUUID(BuildItem Lib3MFHandle) (bool, string, error) {
	var err error = nil
	var bHasUUID int64 = 0
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return false, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getuuid, implementation_builditem.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_builditem_getuuid, implementation_builditem.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasUUID != 0), string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) BuildItem_SetUUID(BuildItem Lib3MFHandle, sUUID string) error {
	var err error = nil

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_setuuid, implementation_builditem.GetDLLInHandle(), StringInValue(sUUID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BuildItem_GetObjectResourceID(BuildItem Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nUniqueResourceID uint32 = 0

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getobjectresourceid, implementation_builditem.GetDLLInHandle(), UInt32OutValue(&nUniqueResourceID))
	if err != nil {
		return 0, err
	}

	return uint32(nUniqueResourceID), err
}

func (implementation *Lib3MFImplementation) BuildItem_HasObjectTransform(BuildItem Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasTransform int64 = 0

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_hasobjecttransform, implementation_builditem.GetDLLInHandle(), Int64OutValue(&bHasTransform))
	if err != nil {
		return false, err
	}

	return (bHasTransform != 0), err
}

func (implementation *Lib3MFImplementation) BuildItem_GetObjectTransform(BuildItem Lib3MFHandle) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return sTransform, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getobjecttransform, implementation_builditem.GetDLLInHandle(), 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) BuildItem_SetObjectTransform(BuildItem Lib3MFHandle, sTransform sLib3MFTransform) error {
	var err error = nil

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_setobjecttransform, implementation_builditem.GetDLLInHandle(), uintptr(unsafe.Pointer(&sTransform)))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BuildItem_GetPartNumber(BuildItem Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPartNumber int64 = 0
	var filledinPartNumber int64 = 0

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getpartnumber, implementation_builditem.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPartNumber), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePartNumber := neededforPartNumber
	bufferPartNumber := make([]byte, bufferSizePartNumber)
	err = implementation.CallFunction(implementation.Lib3MF_builditem_getpartnumber, implementation_builditem.GetDLLInHandle(), Int64InValue(bufferSizePartNumber), Int64OutValue(&filledinPartNumber), uintptr(unsafe.Pointer(&bufferPartNumber[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPartNumber[:(filledinPartNumber - 1)]), err
}

func (implementation *Lib3MFImplementation) BuildItem_SetPartNumber(BuildItem Lib3MFHandle, sSetPartnumber string) error {
	var err error = nil

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_setpartnumber, implementation_builditem.GetDLLInHandle(), StringInValue(sSetPartnumber))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) BuildItem_GetMetaDataGroup(BuildItem Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hMetaDataGroup := implementation.NewHandle()

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return hMetaDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getmetadatagroup, implementation_builditem.GetDLLInHandle(), hMetaDataGroup.GetDLLOutHandle())
	if err != nil {
		return hMetaDataGroup, err
	}

	return hMetaDataGroup, err
}

func (implementation *Lib3MFImplementation) BuildItem_GetOutbox(BuildItem Lib3MFHandle) (sLib3MFBox, error) {
	var err error = nil
	var sOutbox sLib3MFBox

	implementation_builditem, err := implementation.GetWrapperHandle(BuildItem)
	if err != nil {
		return sOutbox, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditem_getoutbox, implementation_builditem.GetDLLInHandle(), 0)
	if err != nil {
		return sOutbox, err
	}

	return sOutbox, err
}

func (implementation *Lib3MFImplementation) BuildItemIterator_MoveNext(BuildItemIterator Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasNext int64 = 0

	implementation_builditemiterator, err := implementation.GetWrapperHandle(BuildItemIterator)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditemiterator_movenext, implementation_builditemiterator.GetDLLInHandle(), Int64OutValue(&bHasNext))
	if err != nil {
		return false, err
	}

	return (bHasNext != 0), err
}

func (implementation *Lib3MFImplementation) BuildItemIterator_MovePrevious(BuildItemIterator Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasPrevious int64 = 0

	implementation_builditemiterator, err := implementation.GetWrapperHandle(BuildItemIterator)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditemiterator_moveprevious, implementation_builditemiterator.GetDLLInHandle(), Int64OutValue(&bHasPrevious))
	if err != nil {
		return false, err
	}

	return (bHasPrevious != 0), err
}

func (implementation *Lib3MFImplementation) BuildItemIterator_GetCurrent(BuildItemIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBuildItem := implementation.NewHandle()

	implementation_builditemiterator, err := implementation.GetWrapperHandle(BuildItemIterator)
	if err != nil {
		return hBuildItem, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditemiterator_getcurrent, implementation_builditemiterator.GetDLLInHandle(), hBuildItem.GetDLLOutHandle())
	if err != nil {
		return hBuildItem, err
	}

	return hBuildItem, err
}

func (implementation *Lib3MFImplementation) BuildItemIterator_Clone(BuildItemIterator Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hOutBuildItemIterator := implementation.NewHandle()

	implementation_builditemiterator, err := implementation.GetWrapperHandle(BuildItemIterator)
	if err != nil {
		return hOutBuildItemIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditemiterator_clone, implementation_builditemiterator.GetDLLInHandle(), hOutBuildItemIterator.GetDLLOutHandle())
	if err != nil {
		return hOutBuildItemIterator, err
	}

	return hOutBuildItemIterator, err
}

func (implementation *Lib3MFImplementation) BuildItemIterator_Count(BuildItemIterator Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_builditemiterator, err := implementation.GetWrapperHandle(BuildItemIterator)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_builditemiterator_count, implementation_builditemiterator.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) Slice_SetVertices(Slice Lib3MFHandle, Vertices []sLib3MFPosition2D) error {
	var err error = nil

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_setvertices, implementation_slice.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Slice_GetVertices(Slice Lib3MFHandle) ([]sLib3MFPosition2D, error) {
	var err error = nil
	arrayVertices := make([]sLib3MFPosition2D, 0)

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return make([]sLib3MFPosition2D, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getvertices, implementation_slice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFPosition2D, 0), err
	}
	err = implementation.CallFunction(implementation.Lib3MF_slice_getvertices, implementation_slice.GetDLLInHandle(), 0, 0, 0)
	if err != nil {
		return make([]sLib3MFPosition2D, 0), err
	}

	return arrayVertices, err
}

func (implementation *Lib3MFImplementation) Slice_GetVertexCount(Slice Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getvertexcount, implementation_slice.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) Slice_AddPolygon(Slice Lib3MFHandle, Indices []uint32) (uint64, error) {
	var err error = nil
	var nIndex uint64 = 0

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_addpolygon, implementation_slice.GetDLLInHandle(), 0, 0, UInt64OutValue(&nIndex))
	if err != nil {
		return 0, err
	}

	return uint64(nIndex), err
}

func (implementation *Lib3MFImplementation) Slice_GetPolygonCount(Slice Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getpolygoncount, implementation_slice.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) Slice_SetPolygonIndices(Slice Lib3MFHandle, nIndex uint64, Indices []uint32) error {
	var err error = nil

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_setpolygonindices, implementation_slice.GetDLLInHandle(), UInt64InValue(nIndex), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Slice_GetPolygonIndices(Slice Lib3MFHandle, nIndex uint64) ([]uint32, error) {
	var err error = nil
	var neededforIndices int64 = 0
	var filledinIndices int64 = 0
	bufferIndices := make([]uint32, 0)

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return make([]uint32, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getpolygonindices, implementation_slice.GetDLLInHandle(), UInt64InValue(nIndex), Int64InValue(0), Int64OutValue(&neededforIndices), Int64InValue(0))
	if err != nil {
		return make([]uint32, 0), err
	}
	bufferSizeIndices := neededforIndices
	bufferIndices = make([]uint32, bufferSizeIndices)
	err = implementation.CallFunction(implementation.Lib3MF_slice_getpolygonindices, implementation_slice.GetDLLInHandle(), UInt64InValue(nIndex), Int64InValue(bufferSizeIndices), Int64OutValue(&filledinIndices), uintptr(unsafe.Pointer(&bufferIndices[0])))
	if err != nil {
		return make([]uint32, 0), err
	}

	return bufferIndices, err
}

func (implementation *Lib3MFImplementation) Slice_GetPolygonIndexCount(Slice Lib3MFHandle, nIndex uint64) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getpolygonindexcount, implementation_slice.GetDLLInHandle(), UInt64InValue(nIndex), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) Slice_GetZTop(Slice Lib3MFHandle) (float64, error) {
	var err error = nil
	var dZTop float64 = 0

	implementation_slice, err := implementation.GetWrapperHandle(Slice)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slice_getztop, implementation_slice.GetDLLInHandle(), Float64OutValue(&dZTop))
	if err != nil {
		return 0, err
	}

	return dZTop, err
}

func (implementation *Lib3MFImplementation) SliceStack_GetBottomZ(SliceStack Lib3MFHandle) (float64, error) {
	var err error = nil
	var dZBottom float64 = 0

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getbottomz, implementation_slicestack.GetDLLInHandle(), Float64OutValue(&dZBottom))
	if err != nil {
		return 0, err
	}

	return dZBottom, err
}

func (implementation *Lib3MFImplementation) SliceStack_GetSliceCount(SliceStack Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getslicecount, implementation_slicestack.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) SliceStack_GetSlice(SliceStack Lib3MFHandle, nSliceIndex uint64) (Lib3MFHandle, error) {
	var err error = nil
	hTheSlice := implementation.NewHandle()

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return hTheSlice, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getslice, implementation_slicestack.GetDLLInHandle(), UInt64InValue(nSliceIndex), hTheSlice.GetDLLOutHandle())
	if err != nil {
		return hTheSlice, err
	}

	return hTheSlice, err
}

func (implementation *Lib3MFImplementation) SliceStack_AddSlice(SliceStack Lib3MFHandle, dZTop float64) (Lib3MFHandle, error) {
	var err error = nil
	hTheSlice := implementation.NewHandle()

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return hTheSlice, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_addslice, implementation_slicestack.GetDLLInHandle(), Float64InValue(dZTop), hTheSlice.GetDLLOutHandle())
	if err != nil {
		return hTheSlice, err
	}

	return hTheSlice, err
}

func (implementation *Lib3MFImplementation) SliceStack_GetSliceRefCount(SliceStack Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getslicerefcount, implementation_slicestack.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) SliceStack_AddSliceStackReference(SliceStack Lib3MFHandle, TheSliceStack Lib3MFHandle) error {
	var err error = nil

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return err
	}
	implementation_theslicestack, err := implementation.GetWrapperHandle(TheSliceStack)
	if err != nil {
		return err
	}

	TheSliceStackDLLHandle := implementation_theslicestack.GetDLLInHandle()
	if TheSliceStackDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_addslicestackreference, implementation_slicestack.GetDLLInHandle(), TheSliceStackDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) SliceStack_GetSliceStackReference(SliceStack Lib3MFHandle, nSliceRefIndex uint64) (Lib3MFHandle, error) {
	var err error = nil
	hTheSliceStack := implementation.NewHandle()

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return hTheSliceStack, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getslicestackreference, implementation_slicestack.GetDLLInHandle(), UInt64InValue(nSliceRefIndex), hTheSliceStack.GetDLLOutHandle())
	if err != nil {
		return hTheSliceStack, err
	}

	return hTheSliceStack, err
}

func (implementation *Lib3MFImplementation) SliceStack_CollapseSliceReferences(SliceStack Lib3MFHandle) error {
	var err error = nil

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_collapseslicereferences, implementation_slicestack.GetDLLInHandle())
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) SliceStack_SetOwnPath(SliceStack Lib3MFHandle, sPath string) error {
	var err error = nil

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_setownpath, implementation_slicestack.GetDLLInHandle(), StringInValue(sPath))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) SliceStack_GetOwnPath(SliceStack Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforPath int64 = 0
	var filledinPath int64 = 0

	implementation_slicestack, err := implementation.GetWrapperHandle(SliceStack)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getownpath, implementation_slicestack.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforPath), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizePath := neededforPath
	bufferPath := make([]byte, bufferSizePath)
	err = implementation.CallFunction(implementation.Lib3MF_slicestack_getownpath, implementation_slicestack.GetDLLInHandle(), Int64InValue(bufferSizePath), Int64OutValue(&filledinPath), uintptr(unsafe.Pointer(&bufferPath[0])))
	if err != nil {
		return "", err
	}

	return string(bufferPath[:(filledinPath - 1)]), err
}

func (implementation *Lib3MFImplementation) Consumer_GetConsumerID(Consumer Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforConsumerID int64 = 0
	var filledinConsumerID int64 = 0

	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_consumer_getconsumerid, implementation_consumer.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforConsumerID), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeConsumerID := neededforConsumerID
	bufferConsumerID := make([]byte, bufferSizeConsumerID)
	err = implementation.CallFunction(implementation.Lib3MF_consumer_getconsumerid, implementation_consumer.GetDLLInHandle(), Int64InValue(bufferSizeConsumerID), Int64OutValue(&filledinConsumerID), uintptr(unsafe.Pointer(&bufferConsumerID[0])))
	if err != nil {
		return "", err
	}

	return string(bufferConsumerID[:(filledinConsumerID - 1)]), err
}

func (implementation *Lib3MFImplementation) Consumer_GetKeyID(Consumer Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforKeyID int64 = 0
	var filledinKeyID int64 = 0

	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_consumer_getkeyid, implementation_consumer.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforKeyID), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeKeyID := neededforKeyID
	bufferKeyID := make([]byte, bufferSizeKeyID)
	err = implementation.CallFunction(implementation.Lib3MF_consumer_getkeyid, implementation_consumer.GetDLLInHandle(), Int64InValue(bufferSizeKeyID), Int64OutValue(&filledinKeyID), uintptr(unsafe.Pointer(&bufferKeyID[0])))
	if err != nil {
		return "", err
	}

	return string(bufferKeyID[:(filledinKeyID - 1)]), err
}

func (implementation *Lib3MFImplementation) Consumer_GetKeyValue(Consumer Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforKeyValue int64 = 0
	var filledinKeyValue int64 = 0

	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_consumer_getkeyvalue, implementation_consumer.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforKeyValue), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeKeyValue := neededforKeyValue
	bufferKeyValue := make([]byte, bufferSizeKeyValue)
	err = implementation.CallFunction(implementation.Lib3MF_consumer_getkeyvalue, implementation_consumer.GetDLLInHandle(), Int64InValue(bufferSizeKeyValue), Int64OutValue(&filledinKeyValue), uintptr(unsafe.Pointer(&bufferKeyValue[0])))
	if err != nil {
		return "", err
	}

	return string(bufferKeyValue[:(filledinKeyValue - 1)]), err
}

func (implementation *Lib3MFImplementation) AccessRight_GetConsumer(AccessRight Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hConsumer := implementation.NewHandle()

	implementation_accessright, err := implementation.GetWrapperHandle(AccessRight)
	if err != nil {
		return hConsumer, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_accessright_getconsumer, implementation_accessright.GetDLLInHandle(), hConsumer.GetDLLOutHandle())
	if err != nil {
		return hConsumer, err
	}

	return hConsumer, err
}

func (implementation *Lib3MFImplementation) AccessRight_GetWrappingAlgorithm(AccessRight Lib3MFHandle) (ELib3MFWrappingAlgorithm, error) {
	var err error = nil
	var eAlgorithm uint64 = 0

	implementation_accessright, err := implementation.GetWrapperHandle(AccessRight)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_accessright_getwrappingalgorithm, implementation_accessright.GetDLLInHandle(), UInt64OutValue(&eAlgorithm))
	if err != nil {
		return 0, err
	}

	return ELib3MFWrappingAlgorithm(eAlgorithm), err
}

func (implementation *Lib3MFImplementation) AccessRight_GetMgfAlgorithm(AccessRight Lib3MFHandle) (ELib3MFMgfAlgorithm, error) {
	var err error = nil
	var eAlgorithm uint64 = 0

	implementation_accessright, err := implementation.GetWrapperHandle(AccessRight)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_accessright_getmgfalgorithm, implementation_accessright.GetDLLInHandle(), UInt64OutValue(&eAlgorithm))
	if err != nil {
		return 0, err
	}

	return ELib3MFMgfAlgorithm(eAlgorithm), err
}

func (implementation *Lib3MFImplementation) AccessRight_GetDigestMethod(AccessRight Lib3MFHandle) (ELib3MFDigestMethod, error) {
	var err error = nil
	var eAlgorithm uint64 = 0

	implementation_accessright, err := implementation.GetWrapperHandle(AccessRight)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_accessright_getdigestmethod, implementation_accessright.GetDLLInHandle(), UInt64OutValue(&eAlgorithm))
	if err != nil {
		return 0, err
	}

	return ELib3MFDigestMethod(eAlgorithm), err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetEncryptionAlgorithm(ContentEncryptionParams Lib3MFHandle) (ELib3MFEncryptionAlgorithm, error) {
	var err error = nil
	var eAlgorithm uint64 = 0

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getencryptionalgorithm, implementation_contentencryptionparams.GetDLLInHandle(), UInt64OutValue(&eAlgorithm))
	if err != nil {
		return 0, err
	}

	return ELib3MFEncryptionAlgorithm(eAlgorithm), err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetKey(ContentEncryptionParams Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforByteData int64 = 0
	var filledinByteData int64 = 0
	bufferByteData := make([]uint8, 0)

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getkey, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforByteData), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeByteData := neededforByteData
	bufferByteData = make([]uint8, bufferSizeByteData)
	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getkey, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(bufferSizeByteData), Int64OutValue(&filledinByteData), uintptr(unsafe.Pointer(&bufferByteData[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferByteData, err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetInitializationVector(ContentEncryptionParams Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforByteData int64 = 0
	var filledinByteData int64 = 0
	bufferByteData := make([]uint8, 0)

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getinitializationvector, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforByteData), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeByteData := neededforByteData
	bufferByteData = make([]uint8, bufferSizeByteData)
	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getinitializationvector, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(bufferSizeByteData), Int64OutValue(&filledinByteData), uintptr(unsafe.Pointer(&bufferByteData[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferByteData, err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetAuthenticationTag(ContentEncryptionParams Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforByteData int64 = 0
	var filledinByteData int64 = 0
	bufferByteData := make([]uint8, 0)

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getauthenticationtag, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforByteData), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeByteData := neededforByteData
	bufferByteData = make([]uint8, bufferSizeByteData)
	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getauthenticationtag, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(bufferSizeByteData), Int64OutValue(&filledinByteData), uintptr(unsafe.Pointer(&bufferByteData[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferByteData, err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_SetAuthenticationTag(ContentEncryptionParams Lib3MFHandle, ByteData []uint8) error {
	var err error = nil

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_setauthenticationtag, implementation_contentencryptionparams.GetDLLInHandle(), 0, 0)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetAdditionalAuthenticationData(ContentEncryptionParams Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforByteData int64 = 0
	var filledinByteData int64 = 0
	bufferByteData := make([]uint8, 0)

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getadditionalauthenticationdata, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforByteData), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeByteData := neededforByteData
	bufferByteData = make([]uint8, bufferSizeByteData)
	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getadditionalauthenticationdata, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(bufferSizeByteData), Int64OutValue(&filledinByteData), uintptr(unsafe.Pointer(&bufferByteData[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferByteData, err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetDescriptor(ContentEncryptionParams Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nDescriptor uint64 = 0

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getdescriptor, implementation_contentencryptionparams.GetDLLInHandle(), UInt64OutValue(&nDescriptor))
	if err != nil {
		return 0, err
	}

	return uint64(nDescriptor), err
}

func (implementation *Lib3MFImplementation) ContentEncryptionParams_GetKeyUUID(ContentEncryptionParams Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_contentencryptionparams, err := implementation.GetWrapperHandle(ContentEncryptionParams)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getkeyuuid, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_contentencryptionparams_getkeyuuid, implementation_contentencryptionparams.GetDLLInHandle(), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return "", err
	}

	return string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) ResourceData_GetPath(ResourceData Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hPath := implementation.NewHandle()

	implementation_resourcedata, err := implementation.GetWrapperHandle(ResourceData)
	if err != nil {
		return hPath, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedata_getpath, implementation_resourcedata.GetDLLInHandle(), hPath.GetDLLOutHandle())
	if err != nil {
		return hPath, err
	}

	return hPath, err
}

func (implementation *Lib3MFImplementation) ResourceData_GetEncryptionAlgorithm(ResourceData Lib3MFHandle) (ELib3MFEncryptionAlgorithm, error) {
	var err error = nil
	var eEncryptionAlgorithm uint64 = 0

	implementation_resourcedata, err := implementation.GetWrapperHandle(ResourceData)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedata_getencryptionalgorithm, implementation_resourcedata.GetDLLInHandle(), UInt64OutValue(&eEncryptionAlgorithm))
	if err != nil {
		return 0, err
	}

	return ELib3MFEncryptionAlgorithm(eEncryptionAlgorithm), err
}

func (implementation *Lib3MFImplementation) ResourceData_GetCompression(ResourceData Lib3MFHandle) (ELib3MFCompression, error) {
	var err error = nil
	var eCompression uint64 = 0

	implementation_resourcedata, err := implementation.GetWrapperHandle(ResourceData)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedata_getcompression, implementation_resourcedata.GetDLLInHandle(), UInt64OutValue(&eCompression))
	if err != nil {
		return 0, err
	}

	return ELib3MFCompression(eCompression), err
}

func (implementation *Lib3MFImplementation) ResourceData_GetAdditionalAuthenticationData(ResourceData Lib3MFHandle) ([]uint8, error) {
	var err error = nil
	var neededforByteData int64 = 0
	var filledinByteData int64 = 0
	bufferByteData := make([]uint8, 0)

	implementation_resourcedata, err := implementation.GetWrapperHandle(ResourceData)
	if err != nil {
		return make([]uint8, 0), err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedata_getadditionalauthenticationdata, implementation_resourcedata.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforByteData), Int64InValue(0))
	if err != nil {
		return make([]uint8, 0), err
	}
	bufferSizeByteData := neededforByteData
	bufferByteData = make([]uint8, bufferSizeByteData)
	err = implementation.CallFunction(implementation.Lib3MF_resourcedata_getadditionalauthenticationdata, implementation_resourcedata.GetDLLInHandle(), Int64InValue(bufferSizeByteData), Int64OutValue(&filledinByteData), uintptr(unsafe.Pointer(&bufferByteData[0])))
	if err != nil {
		return make([]uint8, 0), err
	}

	return bufferByteData, err
}

func (implementation *Lib3MFImplementation) ResourceDataGroup_GetKeyUUID(ResourceDataGroup Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedatagroup_getkeyuuid, implementation_resourcedatagroup.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_resourcedatagroup_getkeyuuid, implementation_resourcedatagroup.GetDLLInHandle(), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return "", err
	}

	return string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) ResourceDataGroup_AddAccessRight(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle, eWrappingAlgorithm ELib3MFWrappingAlgorithm, eMgfAlgorithm ELib3MFMgfAlgorithm, eDigestMethod ELib3MFDigestMethod) (Lib3MFHandle, error) {
	var err error = nil
	hTheAccessRight := implementation.NewHandle()

	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return hTheAccessRight, err
	}
	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return hTheAccessRight, err
	}

	ConsumerDLLHandle := implementation_consumer.GetDLLInHandle()
	if ConsumerDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheAccessRight, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedatagroup_addaccessright, implementation_resourcedatagroup.GetDLLInHandle(), ConsumerDLLHandle, uintptr(eWrappingAlgorithm), uintptr(eMgfAlgorithm), uintptr(eDigestMethod), hTheAccessRight.GetDLLOutHandle())
	if err != nil {
		return hTheAccessRight, err
	}

	return hTheAccessRight, err
}

func (implementation *Lib3MFImplementation) ResourceDataGroup_FindAccessRightByConsumer(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheAccessRight := implementation.NewHandle()

	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return hTheAccessRight, err
	}
	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return hTheAccessRight, err
	}

	ConsumerDLLHandle := implementation_consumer.GetDLLInHandle()
	if ConsumerDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheAccessRight, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedatagroup_findaccessrightbyconsumer, implementation_resourcedatagroup.GetDLLInHandle(), ConsumerDLLHandle, hTheAccessRight.GetDLLOutHandle())
	if err != nil {
		return hTheAccessRight, err
	}

	return hTheAccessRight, err
}

func (implementation *Lib3MFImplementation) ResourceDataGroup_RemoveAccessRight(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle) error {
	var err error = nil

	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return err
	}
	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return err
	}

	ConsumerDLLHandle := implementation_consumer.GetDLLInHandle()
	if ConsumerDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_resourcedatagroup_removeaccessright, implementation_resourcedatagroup.GetDLLInHandle(), ConsumerDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) KeyStore_AddConsumer(KeyStore Lib3MFHandle, sConsumerID string, sKeyID string, sKeyValue string) (Lib3MFHandle, error) {
	var err error = nil
	hConsumer := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hConsumer, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_addconsumer, implementation_keystore.GetDLLInHandle(), StringInValue(sConsumerID), StringInValue(sKeyID), StringInValue(sKeyValue), hConsumer.GetDLLOutHandle())
	if err != nil {
		return hConsumer, err
	}

	return hConsumer, err
}

func (implementation *Lib3MFImplementation) KeyStore_GetConsumerCount(KeyStore Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getconsumercount, implementation_keystore.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) KeyStore_GetConsumer(KeyStore Lib3MFHandle, nConsumerIndex uint64) (Lib3MFHandle, error) {
	var err error = nil
	hConsumer := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hConsumer, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getconsumer, implementation_keystore.GetDLLInHandle(), UInt64InValue(nConsumerIndex), hConsumer.GetDLLOutHandle())
	if err != nil {
		return hConsumer, err
	}

	return hConsumer, err
}

func (implementation *Lib3MFImplementation) KeyStore_RemoveConsumer(KeyStore Lib3MFHandle, Consumer Lib3MFHandle) error {
	var err error = nil

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return err
	}
	implementation_consumer, err := implementation.GetWrapperHandle(Consumer)
	if err != nil {
		return err
	}

	ConsumerDLLHandle := implementation_consumer.GetDLLInHandle()
	if ConsumerDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_removeconsumer, implementation_keystore.GetDLLInHandle(), ConsumerDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) KeyStore_FindConsumer(KeyStore Lib3MFHandle, sConsumerID string) (Lib3MFHandle, error) {
	var err error = nil
	hConsumer := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hConsumer, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_findconsumer, implementation_keystore.GetDLLInHandle(), StringInValue(sConsumerID), hConsumer.GetDLLOutHandle())
	if err != nil {
		return hConsumer, err
	}

	return hConsumer, err
}

func (implementation *Lib3MFImplementation) KeyStore_GetResourceDataGroupCount(KeyStore Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getresourcedatagroupcount, implementation_keystore.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) KeyStore_AddResourceDataGroup(KeyStore Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceDataGroup := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_addresourcedatagroup, implementation_keystore.GetDLLInHandle(), hResourceDataGroup.GetDLLOutHandle())
	if err != nil {
		return hResourceDataGroup, err
	}

	return hResourceDataGroup, err
}

func (implementation *Lib3MFImplementation) KeyStore_GetResourceDataGroup(KeyStore Lib3MFHandle, nResourceDataIndex uint64) (Lib3MFHandle, error) {
	var err error = nil
	hResourceDataGroup := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getresourcedatagroup, implementation_keystore.GetDLLInHandle(), UInt64InValue(nResourceDataIndex), hResourceDataGroup.GetDLLOutHandle())
	if err != nil {
		return hResourceDataGroup, err
	}

	return hResourceDataGroup, err
}

func (implementation *Lib3MFImplementation) KeyStore_RemoveResourceDataGroup(KeyStore Lib3MFHandle, ResourceDataGroup Lib3MFHandle) error {
	var err error = nil

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return err
	}
	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return err
	}

	ResourceDataGroupDLLHandle := implementation_resourcedatagroup.GetDLLInHandle()
	if ResourceDataGroupDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_removeresourcedatagroup, implementation_keystore.GetDLLInHandle(), ResourceDataGroupDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) KeyStore_FindResourceDataGroup(KeyStore Lib3MFHandle, PartPath Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceDataGroup := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceDataGroup, err
	}
	implementation_partpath, err := implementation.GetWrapperHandle(PartPath)
	if err != nil {
		return hResourceDataGroup, err
	}

	PartPathDLLHandle := implementation_partpath.GetDLLInHandle()
	if PartPathDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hResourceDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_findresourcedatagroup, implementation_keystore.GetDLLInHandle(), PartPathDLLHandle, hResourceDataGroup.GetDLLOutHandle())
	if err != nil {
		return hResourceDataGroup, err
	}

	return hResourceDataGroup, err
}

func (implementation *Lib3MFImplementation) KeyStore_AddResourceData(KeyStore Lib3MFHandle, ResourceDataGroup Lib3MFHandle, PartPath Lib3MFHandle, eAlgorithm ELib3MFEncryptionAlgorithm, eCompression ELib3MFCompression, AdditionalAuthenticationData []uint8) (Lib3MFHandle, error) {
	var err error = nil
	hResourceData := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceData, err
	}
	implementation_resourcedatagroup, err := implementation.GetWrapperHandle(ResourceDataGroup)
	if err != nil {
		return hResourceData, err
	}

	ResourceDataGroupDLLHandle := implementation_resourcedatagroup.GetDLLInHandle()
	if ResourceDataGroupDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hResourceData, err
	}
	implementation_partpath, err := implementation.GetWrapperHandle(PartPath)
	if err != nil {
		return hResourceData, err
	}

	PartPathDLLHandle := implementation_partpath.GetDLLInHandle()
	if PartPathDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hResourceData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_addresourcedata, implementation_keystore.GetDLLInHandle(), ResourceDataGroupDLLHandle, PartPathDLLHandle, uintptr(eAlgorithm), uintptr(eCompression), 0, 0, hResourceData.GetDLLOutHandle())
	if err != nil {
		return hResourceData, err
	}

	return hResourceData, err
}

func (implementation *Lib3MFImplementation) KeyStore_RemoveResourceData(KeyStore Lib3MFHandle, ResourceData Lib3MFHandle) error {
	var err error = nil

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return err
	}
	implementation_resourcedata, err := implementation.GetWrapperHandle(ResourceData)
	if err != nil {
		return err
	}

	ResourceDataDLLHandle := implementation_resourcedata.GetDLLInHandle()
	if ResourceDataDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_removeresourcedata, implementation_keystore.GetDLLInHandle(), ResourceDataDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) KeyStore_FindResourceData(KeyStore Lib3MFHandle, ResourcePath Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceData := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceData, err
	}
	implementation_resourcepath, err := implementation.GetWrapperHandle(ResourcePath)
	if err != nil {
		return hResourceData, err
	}

	ResourcePathDLLHandle := implementation_resourcepath.GetDLLInHandle()
	if ResourcePathDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hResourceData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_findresourcedata, implementation_keystore.GetDLLInHandle(), ResourcePathDLLHandle, hResourceData.GetDLLOutHandle())
	if err != nil {
		return hResourceData, err
	}

	return hResourceData, err
}

func (implementation *Lib3MFImplementation) KeyStore_GetResourceDataCount(KeyStore Lib3MFHandle) (uint64, error) {
	var err error = nil
	var nCount uint64 = 0

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getresourcedatacount, implementation_keystore.GetDLLInHandle(), UInt64OutValue(&nCount))
	if err != nil {
		return 0, err
	}

	return uint64(nCount), err
}

func (implementation *Lib3MFImplementation) KeyStore_GetResourceData(KeyStore Lib3MFHandle, nResourceDataIndex uint64) (Lib3MFHandle, error) {
	var err error = nil
	hResourceData := implementation.NewHandle()

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return hResourceData, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getresourcedata, implementation_keystore.GetDLLInHandle(), UInt64InValue(nResourceDataIndex), hResourceData.GetDLLOutHandle())
	if err != nil {
		return hResourceData, err
	}

	return hResourceData, err
}

func (implementation *Lib3MFImplementation) KeyStore_GetUUID(KeyStore Lib3MFHandle) (bool, string, error) {
	var err error = nil
	var bHasUUID int64 = 0
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return false, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_getuuid, implementation_keystore.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_keystore_getuuid, implementation_keystore.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasUUID != 0), string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) KeyStore_SetUUID(KeyStore Lib3MFHandle, sUUID string) error {
	var err error = nil

	implementation_keystore, err := implementation.GetWrapperHandle(KeyStore)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_keystore_setuuid, implementation_keystore.GetDLLInHandle(), StringInValue(sUUID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_RootModelPart(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hRootModelPart := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hRootModelPart, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_rootmodelpart, implementation_model.GetDLLInHandle(), hRootModelPart.GetDLLOutHandle())
	if err != nil {
		return hRootModelPart, err
	}

	return hRootModelPart, err
}

func (implementation *Lib3MFImplementation) Model_FindOrCreatePackagePart(Model Lib3MFHandle, sAbsolutePath string) (Lib3MFHandle, error) {
	var err error = nil
	hModelPart := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hModelPart, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_findorcreatepackagepart, implementation_model.GetDLLInHandle(), StringInValue(sAbsolutePath), hModelPart.GetDLLOutHandle())
	if err != nil {
		return hModelPart, err
	}

	return hModelPart, err
}

func (implementation *Lib3MFImplementation) Model_SetUnit(Model Lib3MFHandle, eUnit ELib3MFModelUnit) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_setunit, implementation_model.GetDLLInHandle(), uintptr(eUnit))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_GetUnit(Model Lib3MFHandle) (ELib3MFModelUnit, error) {
	var err error = nil
	var eUnit uint64 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getunit, implementation_model.GetDLLInHandle(), UInt64OutValue(&eUnit))
	if err != nil {
		return 0, err
	}

	return ELib3MFModelUnit(eUnit), err
}

func (implementation *Lib3MFImplementation) Model_GetLanguage(Model Lib3MFHandle) (string, error) {
	var err error = nil
	var neededforLanguage int64 = 0
	var filledinLanguage int64 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getlanguage, implementation_model.GetDLLInHandle(), Int64InValue(0), Int64OutValue(&neededforLanguage), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeLanguage := neededforLanguage
	bufferLanguage := make([]byte, bufferSizeLanguage)
	err = implementation.CallFunction(implementation.Lib3MF_model_getlanguage, implementation_model.GetDLLInHandle(), Int64InValue(bufferSizeLanguage), Int64OutValue(&filledinLanguage), uintptr(unsafe.Pointer(&bufferLanguage[0])))
	if err != nil {
		return "", err
	}

	return string(bufferLanguage[:(filledinLanguage - 1)]), err
}

func (implementation *Lib3MFImplementation) Model_SetLanguage(Model Lib3MFHandle, sLanguage string) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_setlanguage, implementation_model.GetDLLInHandle(), StringInValue(sLanguage))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_QueryWriter(Model Lib3MFHandle, sWriterClass string) (Lib3MFHandle, error) {
	var err error = nil
	hWriterInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hWriterInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_querywriter, implementation_model.GetDLLInHandle(), StringInValue(sWriterClass), hWriterInstance.GetDLLOutHandle())
	if err != nil {
		return hWriterInstance, err
	}

	return hWriterInstance, err
}

func (implementation *Lib3MFImplementation) Model_QueryReader(Model Lib3MFHandle, sReaderClass string) (Lib3MFHandle, error) {
	var err error = nil
	hReaderInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hReaderInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_queryreader, implementation_model.GetDLLInHandle(), StringInValue(sReaderClass), hReaderInstance.GetDLLOutHandle())
	if err != nil {
		return hReaderInstance, err
	}

	return hReaderInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetTexture2DByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hTextureInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hTextureInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_gettexture2dbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hTextureInstance.GetDLLOutHandle())
	if err != nil {
		return hTextureInstance, err
	}

	return hTextureInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetPropertyTypeByID(Model Lib3MFHandle, nUniqueResourceID uint32) (ELib3MFPropertyType, error) {
	var err error = nil
	var eThePropertyType uint64 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getpropertytypebyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), UInt64OutValue(&eThePropertyType))
	if err != nil {
		return 0, err
	}

	return ELib3MFPropertyType(eThePropertyType), err
}

func (implementation *Lib3MFImplementation) Model_GetBaseMaterialGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hBaseMaterialGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getbasematerialgroupbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hBaseMaterialGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	return hBaseMaterialGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetTexture2DGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hTexture2DGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hTexture2DGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_gettexture2dgroupbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hTexture2DGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hTexture2DGroupInstance, err
	}

	return hTexture2DGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetCompositeMaterialsByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hCompositeMaterialsInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hCompositeMaterialsInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcompositematerialsbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hCompositeMaterialsInstance.GetDLLOutHandle())
	if err != nil {
		return hCompositeMaterialsInstance, err
	}

	return hCompositeMaterialsInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetMultiPropertyGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hMultiPropertyGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hMultiPropertyGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getmultipropertygroupbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hMultiPropertyGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hMultiPropertyGroupInstance, err
	}

	return hMultiPropertyGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetMeshObjectByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hMeshObjectInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hMeshObjectInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getmeshobjectbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hMeshObjectInstance.GetDLLOutHandle())
	if err != nil {
		return hMeshObjectInstance, err
	}

	return hMeshObjectInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetComponentsObjectByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hComponentsObjectInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hComponentsObjectInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcomponentsobjectbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hComponentsObjectInstance.GetDLLOutHandle())
	if err != nil {
		return hComponentsObjectInstance, err
	}

	return hComponentsObjectInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetColorGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hColorGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hColorGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcolorgroupbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hColorGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hColorGroupInstance, err
	}

	return hColorGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetSliceStackByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hSliceStacInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hSliceStacInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getslicestackbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hSliceStacInstance.GetDLLOutHandle())
	if err != nil {
		return hSliceStacInstance, err
	}

	return hSliceStacInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetBuildUUID(Model Lib3MFHandle) (bool, string, error) {
	var err error = nil
	var bHasUUID int64 = 0
	var neededforUUID int64 = 0
	var filledinUUID int64 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return false, "", err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getbuilduuid, implementation_model.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(0), Int64OutValue(&neededforUUID), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeUUID := neededforUUID
	bufferUUID := make([]byte, bufferSizeUUID)
	err = implementation.CallFunction(implementation.Lib3MF_model_getbuilduuid, implementation_model.GetDLLInHandle(), Int64OutValue(&bHasUUID), Int64InValue(bufferSizeUUID), Int64OutValue(&filledinUUID), uintptr(unsafe.Pointer(&bufferUUID[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasUUID != 0), string(bufferUUID[:(filledinUUID - 1)]), err
}

func (implementation *Lib3MFImplementation) Model_SetBuildUUID(Model Lib3MFHandle, sUUID string) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_setbuilduuid, implementation_model.GetDLLInHandle(), StringInValue(sUUID))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_GetBuildItems(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBuildItemIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hBuildItemIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getbuilditems, implementation_model.GetDLLInHandle(), hBuildItemIterator.GetDLLOutHandle())
	if err != nil {
		return hBuildItemIterator, err
	}

	return hBuildItemIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetOutbox(Model Lib3MFHandle) (sLib3MFBox, error) {
	var err error = nil
	var sOutbox sLib3MFBox

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return sOutbox, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getoutbox, implementation_model.GetDLLInHandle(), 0)
	if err != nil {
		return sOutbox, err
	}

	return sOutbox, err
}

func (implementation *Lib3MFImplementation) Model_GetResources(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getresources, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetObjects(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getobjects, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetMeshObjects(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getmeshobjects, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetComponentsObjects(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcomponentsobjects, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetTexture2Ds(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_gettexture2ds, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetBaseMaterialGroups(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getbasematerialgroups, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetColorGroups(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcolorgroups, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetTexture2DGroups(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_gettexture2dgroups, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetCompositeMaterials(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getcompositematerials, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetMultiPropertyGroups(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getmultipropertygroups, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if err != nil {
		return hResourceIterator, err
	}

	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetSliceStacks(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getslicestacks, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if (err != nil) {
		return hResourceIterator, err
	}
	
	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetImage3Ds(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getimage3ds, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if (err != nil) {
		return hResourceIterator, err
	}
	
	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetScalarFields(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getscalarfields, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if (err != nil) {
		return hResourceIterator, err
	}
	
	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_GetVector3DFields(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hResourceIterator := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hResourceIterator, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getvector3dfields, implementation_model.GetDLLInHandle(), hResourceIterator.GetDLLOutHandle())
	if (err != nil) {
		return hResourceIterator, err
	}
	
	return hResourceIterator, err
}

func (implementation *Lib3MFImplementation) Model_MergeToModel(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hMergedModelInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hMergedModelInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_mergetomodel, implementation_model.GetDLLInHandle(), hMergedModelInstance.GetDLLOutHandle())
	if err != nil {
		return hMergedModelInstance, err
	}

	return hMergedModelInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddMeshObject(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hMeshObjectInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hMeshObjectInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addmeshobject, implementation_model.GetDLLInHandle(), hMeshObjectInstance.GetDLLOutHandle())
	if err != nil {
		return hMeshObjectInstance, err
	}

	return hMeshObjectInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddComponentsObject(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hComponentsObjectInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hComponentsObjectInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addcomponentsobject, implementation_model.GetDLLInHandle(), hComponentsObjectInstance.GetDLLOutHandle())
	if err != nil {
		return hComponentsObjectInstance, err
	}

	return hComponentsObjectInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddSliceStack(Model Lib3MFHandle, dZBottom float64) (Lib3MFHandle, error) {
	var err error = nil
	hSliceStackInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hSliceStackInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addslicestack, implementation_model.GetDLLInHandle(), Float64InValue(dZBottom), hSliceStackInstance.GetDLLOutHandle())
	if err != nil {
		return hSliceStackInstance, err
	}

	return hSliceStackInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddTexture2DFromAttachment(Model Lib3MFHandle, TextureAttachment Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTexture2DInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hTexture2DInstance, err
	}
	implementation_textureattachment, err := implementation.GetWrapperHandle(TextureAttachment)
	if err != nil {
		return hTexture2DInstance, err
	}

	TextureAttachmentDLLHandle := implementation_textureattachment.GetDLLInHandle()
	if TextureAttachmentDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hTexture2DInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addtexture2dfromattachment, implementation_model.GetDLLInHandle(), TextureAttachmentDLLHandle, hTexture2DInstance.GetDLLOutHandle())
	if err != nil {
		return hTexture2DInstance, err
	}

	return hTexture2DInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddBaseMaterialGroup(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hBaseMaterialGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addbasematerialgroup, implementation_model.GetDLLInHandle(), hBaseMaterialGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hBaseMaterialGroupInstance, err
	}

	return hBaseMaterialGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddColorGroup(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hColorGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hColorGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addcolorgroup, implementation_model.GetDLLInHandle(), hColorGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hColorGroupInstance, err
	}

	return hColorGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddTexture2DGroup(Model Lib3MFHandle, Texture2DInstance Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTexture2DGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hTexture2DGroupInstance, err
	}
	implementation_texture2dinstance, err := implementation.GetWrapperHandle(Texture2DInstance)
	if err != nil {
		return hTexture2DGroupInstance, err
	}

	Texture2DInstanceDLLHandle := implementation_texture2dinstance.GetDLLInHandle()
	if Texture2DInstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hTexture2DGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addtexture2dgroup, implementation_model.GetDLLInHandle(), Texture2DInstanceDLLHandle, hTexture2DGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hTexture2DGroupInstance, err
	}

	return hTexture2DGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddCompositeMaterials(Model Lib3MFHandle, BaseMaterialGroupInstance Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hCompositeMaterialsInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hCompositeMaterialsInstance, err
	}
	implementation_basematerialgroupinstance, err := implementation.GetWrapperHandle(BaseMaterialGroupInstance)
	if err != nil {
		return hCompositeMaterialsInstance, err
	}

	BaseMaterialGroupInstanceDLLHandle := implementation_basematerialgroupinstance.GetDLLInHandle()
	if BaseMaterialGroupInstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hCompositeMaterialsInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addcompositematerials, implementation_model.GetDLLInHandle(), BaseMaterialGroupInstanceDLLHandle, hCompositeMaterialsInstance.GetDLLOutHandle())
	if err != nil {
		return hCompositeMaterialsInstance, err
	}

	return hCompositeMaterialsInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddMultiPropertyGroup(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hMultiPropertyGroupInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hMultiPropertyGroupInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addmultipropertygroup, implementation_model.GetDLLInHandle(), hMultiPropertyGroupInstance.GetDLLOutHandle())
	if err != nil {
		return hMultiPropertyGroupInstance, err
	}

	return hMultiPropertyGroupInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddImageStack(Model Lib3MFHandle, nColumnCount uint32, nRowCount uint32, nSheetCount uint32) (Lib3MFHandle, error) {
	var err error = nil
	hInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addimagestack, implementation_model.GetDLLInHandle(), UInt32InValue(nColumnCount), UInt32InValue(nRowCount), UInt32InValue(nSheetCount), hInstance.GetDLLOutHandle())
	if (err != nil) {
		return hInstance, err
	}
	
	return hInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetImageStackByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hImageStackInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hImageStackInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getimagestackbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hImageStackInstance.GetDLLOutHandle())
	if (err != nil) {
		return hImageStackInstance, err
	}
	
	return hImageStackInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddScalarFieldFromImage3D(Model Lib3MFHandle, Image3D Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldFromImage3D := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheScalarFieldFromImage3D, err
	}
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return hTheScalarFieldFromImage3D, err
	}
	
	Image3DDLLHandle := implementation_image3d.GetDLLInHandle()
	if (Image3DDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheScalarFieldFromImage3D, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addscalarfieldfromimage3d, implementation_model.GetDLLInHandle(), Image3DDLLHandle, hTheScalarFieldFromImage3D.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldFromImage3D, err
	}
	
	return hTheScalarFieldFromImage3D, err
}

func (implementation *Lib3MFImplementation) Model_AddScalarFieldComposed(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldComposed := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheScalarFieldComposed, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addscalarfieldcomposed, implementation_model.GetDLLInHandle(), hTheScalarFieldComposed.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldComposed, err
	}
	
	return hTheScalarFieldComposed, err
}

func (implementation *Lib3MFImplementation) Model_AddScalarFieldConstant(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheScalarFieldConstant := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheScalarFieldConstant, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addscalarfieldconstant, implementation_model.GetDLLInHandle(), hTheScalarFieldConstant.GetDLLOutHandle())
	if (err != nil) {
		return hTheScalarFieldConstant, err
	}
	
	return hTheScalarFieldConstant, err
}

func (implementation *Lib3MFImplementation) Model_GetScalarFieldByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hScalarFieldInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hScalarFieldInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getscalarfieldbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hScalarFieldInstance.GetDLLOutHandle())
	if (err != nil) {
		return hScalarFieldInstance, err
	}
	
	return hScalarFieldInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetScalarFieldFromImage3DByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hScalarFieldFromImage3DInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hScalarFieldFromImage3DInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getscalarfieldfromimage3dbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hScalarFieldFromImage3DInstance.GetDLLOutHandle())
	if (err != nil) {
		return hScalarFieldFromImage3DInstance, err
	}
	
	return hScalarFieldFromImage3DInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetScalarFieldComposedByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hScalarFieldComposedInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hScalarFieldComposedInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getscalarfieldcomposedbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hScalarFieldComposedInstance.GetDLLOutHandle())
	if (err != nil) {
		return hScalarFieldComposedInstance, err
	}
	
	return hScalarFieldComposedInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetScalarFieldConstantByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hScalarFieldConstantInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hScalarFieldConstantInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getscalarfieldconstantbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hScalarFieldConstantInstance.GetDLLOutHandle())
	if (err != nil) {
		return hScalarFieldConstantInstance, err
	}
	
	return hScalarFieldConstantInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddVector3DFieldFromImage3D(Model Lib3MFHandle, Image3D Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVector3DFieldFromImage3D := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheVector3DFieldFromImage3D, err
	}
	implementation_image3d, err := implementation.GetWrapperHandle(Image3D)
	if (err != nil) {
		return hTheVector3DFieldFromImage3D, err
	}
	
	Image3DDLLHandle := implementation_image3d.GetDLLInHandle()
	if (Image3DDLLHandle == 0) {
		err := fmt.Errorf("Handle must not be 0.")
		return hTheVector3DFieldFromImage3D, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addvector3dfieldfromimage3d, implementation_model.GetDLLInHandle(), Image3DDLLHandle, hTheVector3DFieldFromImage3D.GetDLLOutHandle())
	if (err != nil) {
		return hTheVector3DFieldFromImage3D, err
	}
	
	return hTheVector3DFieldFromImage3D, err
}

func (implementation *Lib3MFImplementation) Model_AddVector3DFieldComposed(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVector3DFieldComposed := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheVector3DFieldComposed, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addvector3dfieldcomposed, implementation_model.GetDLLInHandle(), hTheVector3DFieldComposed.GetDLLOutHandle())
	if (err != nil) {
		return hTheVector3DFieldComposed, err
	}
	
	return hTheVector3DFieldComposed, err
}

func (implementation *Lib3MFImplementation) Model_AddVector3DFieldConstant(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheVector3DFieldConstant := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hTheVector3DFieldConstant, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addvector3dfieldconstant, implementation_model.GetDLLInHandle(), hTheVector3DFieldConstant.GetDLLOutHandle())
	if (err != nil) {
		return hTheVector3DFieldConstant, err
	}
	
	return hTheVector3DFieldConstant, err
}

func (implementation *Lib3MFImplementation) Model_GetVector3DFieldByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hVector3DFieldInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hVector3DFieldInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getvector3dfieldbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hVector3DFieldInstance.GetDLLOutHandle())
	if (err != nil) {
		return hVector3DFieldInstance, err
	}
	
	return hVector3DFieldInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetVector3DFieldFromImage3DByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hVector3DFieldFromImage3DInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hVector3DFieldFromImage3DInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getvector3dfieldfromimage3dbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hVector3DFieldFromImage3DInstance.GetDLLOutHandle())
	if (err != nil) {
		return hVector3DFieldFromImage3DInstance, err
	}
	
	return hVector3DFieldFromImage3DInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetVector3DFieldComposedByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hVector3DFieldComposedInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hVector3DFieldComposedInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getvector3dfieldcomposedbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hVector3DFieldComposedInstance.GetDLLOutHandle())
	if (err != nil) {
		return hVector3DFieldComposedInstance, err
	}
	
	return hVector3DFieldComposedInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetVector3DFieldConstantByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error) {
	var err error = nil
	hVector3DFieldConstantInstance := implementation.NewHandle()
	
	implementation_model, err := implementation.GetWrapperHandle(Model)
	if (err != nil) {
		return hVector3DFieldConstantInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getvector3dfieldconstantbyid, implementation_model.GetDLLInHandle(), UInt32InValue(nUniqueResourceID), hVector3DFieldConstantInstance.GetDLLOutHandle())
	if (err != nil) {
		return hVector3DFieldConstantInstance, err
	}
	
	return hVector3DFieldConstantInstance, err
}

func (implementation *Lib3MFImplementation) Model_AddBuildItem(Model Lib3MFHandle, Object Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFHandle, error) {
	var err error = nil
	hBuildItemInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hBuildItemInstance, err
	}
	implementation_object, err := implementation.GetWrapperHandle(Object)
	if err != nil {
		return hBuildItemInstance, err
	}

	ObjectDLLHandle := implementation_object.GetDLLInHandle()
	if ObjectDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return hBuildItemInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addbuilditem, implementation_model.GetDLLInHandle(), ObjectDLLHandle, uintptr(unsafe.Pointer(&sTransform)), hBuildItemInstance.GetDLLOutHandle())
	if err != nil {
		return hBuildItemInstance, err
	}

	return hBuildItemInstance, err
}

func (implementation *Lib3MFImplementation) Model_RemoveBuildItem(Model Lib3MFHandle, BuildItemInstance Lib3MFHandle) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}
	implementation_builditeminstance, err := implementation.GetWrapperHandle(BuildItemInstance)
	if err != nil {
		return err
	}

	BuildItemInstanceDLLHandle := implementation_builditeminstance.GetDLLInHandle()
	if BuildItemInstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_removebuilditem, implementation_model.GetDLLInHandle(), BuildItemInstanceDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_GetMetaDataGroup(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hTheMetaDataGroup := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hTheMetaDataGroup, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getmetadatagroup, implementation_model.GetDLLInHandle(), hTheMetaDataGroup.GetDLLOutHandle())
	if err != nil {
		return hTheMetaDataGroup, err
	}

	return hTheMetaDataGroup, err
}

func (implementation *Lib3MFImplementation) Model_AddAttachment(Model Lib3MFHandle, sURI string, sRelationShipType string) (Lib3MFHandle, error) {
	var err error = nil
	hAttachmentInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hAttachmentInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addattachment, implementation_model.GetDLLInHandle(), StringInValue(sURI), StringInValue(sRelationShipType), hAttachmentInstance.GetDLLOutHandle())
	if err != nil {
		return hAttachmentInstance, err
	}

	return hAttachmentInstance, err
}

func (implementation *Lib3MFImplementation) Model_RemoveAttachment(Model Lib3MFHandle, AttachmentInstance Lib3MFHandle) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}
	implementation_attachmentinstance, err := implementation.GetWrapperHandle(AttachmentInstance)
	if err != nil {
		return err
	}

	AttachmentInstanceDLLHandle := implementation_attachmentinstance.GetDLLInHandle()
	if AttachmentInstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_removeattachment, implementation_model.GetDLLInHandle(), AttachmentInstanceDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_GetAttachment(Model Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error) {
	var err error = nil
	hAttachmentInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hAttachmentInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getattachment, implementation_model.GetDLLInHandle(), UInt32InValue(nIndex), hAttachmentInstance.GetDLLOutHandle())
	if err != nil {
		return hAttachmentInstance, err
	}

	return hAttachmentInstance, err
}

func (implementation *Lib3MFImplementation) Model_FindAttachment(Model Lib3MFHandle, sURI string) (Lib3MFHandle, error) {
	var err error = nil
	hAttachmentInstance := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hAttachmentInstance, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_findattachment, implementation_model.GetDLLInHandle(), StringInValue(sURI), hAttachmentInstance.GetDLLOutHandle())
	if err != nil {
		return hAttachmentInstance, err
	}

	return hAttachmentInstance, err
}

func (implementation *Lib3MFImplementation) Model_GetAttachmentCount(Model Lib3MFHandle) (uint32, error) {
	var err error = nil
	var nAttachmentCount uint32 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return 0, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getattachmentcount, implementation_model.GetDLLInHandle(), UInt32OutValue(&nAttachmentCount))
	if err != nil {
		return 0, err
	}

	return uint32(nAttachmentCount), err
}

func (implementation *Lib3MFImplementation) Model_HasPackageThumbnailAttachment(Model Lib3MFHandle) (bool, error) {
	var err error = nil
	var bHasThumbnail int64 = 0

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_haspackagethumbnailattachment, implementation_model.GetDLLInHandle(), Int64OutValue(&bHasThumbnail))
	if err != nil {
		return false, err
	}

	return (bHasThumbnail != 0), err
}

func (implementation *Lib3MFImplementation) Model_CreatePackageThumbnailAttachment(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hAttachment := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hAttachment, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_createpackagethumbnailattachment, implementation_model.GetDLLInHandle(), hAttachment.GetDLLOutHandle())
	if err != nil {
		return hAttachment, err
	}

	return hAttachment, err
}

func (implementation *Lib3MFImplementation) Model_GetPackageThumbnailAttachment(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hAttachment := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hAttachment, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getpackagethumbnailattachment, implementation_model.GetDLLInHandle(), hAttachment.GetDLLOutHandle())
	if err != nil {
		return hAttachment, err
	}

	return hAttachment, err
}

func (implementation *Lib3MFImplementation) Model_RemovePackageThumbnailAttachment(Model Lib3MFHandle) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_removepackagethumbnailattachment, implementation_model.GetDLLInHandle())
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_AddCustomContentType(Model Lib3MFHandle, sExtension string, sContentType string) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_addcustomcontenttype, implementation_model.GetDLLInHandle(), StringInValue(sExtension), StringInValue(sContentType))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_RemoveCustomContentType(Model Lib3MFHandle, sExtension string) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_removecustomcontenttype, implementation_model.GetDLLInHandle(), StringInValue(sExtension))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_SetRandomNumberCallback(Model Lib3MFHandle, pTheCallback int64, nUserData uint64) error {
	var err error = nil

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_setrandomnumbercallback, implementation_model.GetDLLInHandle(), 0, UInt64InValue(nUserData))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Model_GetKeyStore(Model Lib3MFHandle) (Lib3MFHandle, error) {
	var err error = nil
	hKeyStore := implementation.NewHandle()

	implementation_model, err := implementation.GetWrapperHandle(Model)
	if err != nil {
		return hKeyStore, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_model_getkeystore, implementation_model.GetDLLInHandle(), hKeyStore.GetDLLOutHandle())
	if err != nil {
		return hKeyStore, err
	}

	return hKeyStore, err
}

/*
************************************************************************************************************************

	Class definition Lib3MFWrapper

*************************************************************************************************************************
*/
type Lib3MFWrapper struct {
	Interface Lib3MFGoInterface
}

func (implementation *Lib3MFImplementation) GetLibraryVersion() (uint32, uint32, uint32, error) {
	var err error = nil
	var nMajor uint32 = 0
	var nMinor uint32 = 0
	var nMicro uint32 = 0

	err = implementation.CallFunction(implementation.Lib3MF_getlibraryversion, UInt32OutValue(&nMajor), UInt32OutValue(&nMinor), UInt32OutValue(&nMicro))
	if err != nil {
		return 0, 0, 0, err
	}

	return uint32(nMajor), uint32(nMinor), uint32(nMicro), err
}

func (implementation *Lib3MFImplementation) GetPrereleaseInformation() (bool, string, error) {
	var err error = nil
	var bHasPrereleaseInfo int64 = 0
	var neededforPrereleaseInfo int64 = 0
	var filledinPrereleaseInfo int64 = 0

	err = implementation.CallFunction(implementation.Lib3MF_getprereleaseinformation, Int64OutValue(&bHasPrereleaseInfo), Int64InValue(0), Int64OutValue(&neededforPrereleaseInfo), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizePrereleaseInfo := neededforPrereleaseInfo
	bufferPrereleaseInfo := make([]byte, bufferSizePrereleaseInfo)
	err = implementation.CallFunction(implementation.Lib3MF_getprereleaseinformation, Int64OutValue(&bHasPrereleaseInfo), Int64InValue(bufferSizePrereleaseInfo), Int64OutValue(&filledinPrereleaseInfo), uintptr(unsafe.Pointer(&bufferPrereleaseInfo[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasPrereleaseInfo != 0), string(bufferPrereleaseInfo[:(filledinPrereleaseInfo - 1)]), err
}

func (implementation *Lib3MFImplementation) GetBuildInformation() (bool, string, error) {
	var err error = nil
	var bHasBuildInfo int64 = 0
	var neededforBuildInformation int64 = 0
	var filledinBuildInformation int64 = 0

	err = implementation.CallFunction(implementation.Lib3MF_getbuildinformation, Int64OutValue(&bHasBuildInfo), Int64InValue(0), Int64OutValue(&neededforBuildInformation), Int64InValue(0))
	if err != nil {
		return false, "", err
	}
	bufferSizeBuildInformation := neededforBuildInformation
	bufferBuildInformation := make([]byte, bufferSizeBuildInformation)
	err = implementation.CallFunction(implementation.Lib3MF_getbuildinformation, Int64OutValue(&bHasBuildInfo), Int64InValue(bufferSizeBuildInformation), Int64OutValue(&filledinBuildInformation), uintptr(unsafe.Pointer(&bufferBuildInformation[0])))
	if err != nil {
		return false, "", err
	}

	return (bHasBuildInfo != 0), string(bufferBuildInformation[:(filledinBuildInformation - 1)]), err
}

func (implementation *Lib3MFImplementation) GetSpecificationVersion(sSpecificationURL string) (bool, uint32, uint32, uint32, error) {
	var err error = nil
	var bIsSupported int64 = 0
	var nMajor uint32 = 0
	var nMinor uint32 = 0
	var nMicro uint32 = 0

	err = implementation.CallFunction(implementation.Lib3MF_getspecificationversion, StringInValue(sSpecificationURL), Int64OutValue(&bIsSupported), UInt32OutValue(&nMajor), UInt32OutValue(&nMinor), UInt32OutValue(&nMicro))
	if err != nil {
		return false, 0, 0, 0, err
	}

	return (bIsSupported != 0), uint32(nMajor), uint32(nMinor), uint32(nMicro), err
}

func (implementation *Lib3MFImplementation) CreateModel() (Lib3MFHandle, error) {
	var err error = nil
	hModel := implementation.NewHandle()

	err = implementation.CallFunction(implementation.Lib3MF_createmodel, hModel.GetDLLOutHandle())
	if err != nil {
		return hModel, err
	}

	return hModel, err
}

func (implementation *Lib3MFImplementation) Release(Instance Lib3MFHandle) error {
	var err error = nil
	implementation_instance, err := implementation.GetWrapperHandle(Instance)
	if err != nil {
		return err
	}

	InstanceDLLHandle := implementation_instance.GetDLLInHandle()
	if InstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_release, InstanceDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) Acquire(Instance Lib3MFHandle) error {
	var err error = nil
	implementation_instance, err := implementation.GetWrapperHandle(Instance)
	if err != nil {
		return err
	}

	InstanceDLLHandle := implementation_instance.GetDLLInHandle()
	if InstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return err
	}

	err = implementation.CallFunction(implementation.Lib3MF_acquire, InstanceDLLHandle)
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) SetJournal(sJournalPath string) error {
	var err error = nil

	err = implementation.CallFunction(implementation.Lib3MF_setjournal, StringInValue(sJournalPath))
	if err != nil {
		return err
	}

	return err
}

func (implementation *Lib3MFImplementation) GetLastError(Instance Lib3MFHandle) (string, bool, error) {
	var err error = nil
	var neededforLastErrorString int64 = 0
	var filledinLastErrorString int64 = 0
	var bHasLastError int64 = 0
	implementation_instance, err := implementation.GetWrapperHandle(Instance)
	if err != nil {
		return "", false, err
	}

	InstanceDLLHandle := implementation_instance.GetDLLInHandle()
	if InstanceDLLHandle == 0 {
		err := fmt.Errorf("Handle must not be 0.")
		return "", false, err
	}

	err = implementation.CallFunction(implementation.Lib3MF_getlasterror, InstanceDLLHandle, Int64InValue(0), Int64OutValue(&neededforLastErrorString), Int64InValue(0), Int64OutValue(&bHasLastError))
	if err != nil {
		return "", false, err
	}
	bufferSizeLastErrorString := neededforLastErrorString
	bufferLastErrorString := make([]byte, bufferSizeLastErrorString)
	err = implementation.CallFunction(implementation.Lib3MF_getlasterror, InstanceDLLHandle, Int64InValue(bufferSizeLastErrorString), Int64OutValue(&filledinLastErrorString), uintptr(unsafe.Pointer(&bufferLastErrorString[0])), Int64OutValue(&bHasLastError))
	if err != nil {
		return "", false, err
	}

	return string(bufferLastErrorString[:(filledinLastErrorString - 1)]), (bHasLastError != 0), err
}

func (implementation *Lib3MFImplementation) GetSymbolLookupMethod() (uint64, error) {
	var err error = nil
	var nSymbolLookupMethod uint64 = 0

	err = implementation.CallFunction(implementation.Lib3MF_getsymbollookupmethod, UInt64OutValue(&nSymbolLookupMethod))
	if err != nil {
		return 0, err
	}

	return nSymbolLookupMethod, err
}

func (implementation *Lib3MFImplementation) RetrieveProgressMessage(eTheProgressIdentifier ELib3MFProgressIdentifier) (string, error) {
	var err error = nil
	var neededforProgressMessage int64 = 0
	var filledinProgressMessage int64 = 0

	err = implementation.CallFunction(implementation.Lib3MF_retrieveprogressmessage, uintptr(eTheProgressIdentifier), Int64InValue(0), Int64OutValue(&neededforProgressMessage), Int64InValue(0))
	if err != nil {
		return "", err
	}
	bufferSizeProgressMessage := neededforProgressMessage
	bufferProgressMessage := make([]byte, bufferSizeProgressMessage)
	err = implementation.CallFunction(implementation.Lib3MF_retrieveprogressmessage, uintptr(eTheProgressIdentifier), Int64InValue(bufferSizeProgressMessage), Int64OutValue(&filledinProgressMessage), uintptr(unsafe.Pointer(&bufferProgressMessage[0])))
	if err != nil {
		return "", err
	}

	return string(bufferProgressMessage[:(filledinProgressMessage - 1)]), err
}

func (implementation *Lib3MFImplementation) RGBAToColor(nRed uint8, nGreen uint8, nBlue uint8, nAlpha uint8) (sLib3MFColor, error) {
	var err error = nil
	var sTheColor sLib3MFColor

	err = implementation.CallFunction(implementation.Lib3MF_rgbatocolor, UInt8InValue(nRed), UInt8InValue(nGreen), UInt8InValue(nBlue), UInt8InValue(nAlpha), 0)
	if err != nil {
		return sTheColor, err
	}

	return sTheColor, err
}

func (implementation *Lib3MFImplementation) FloatRGBAToColor(fRed float32, fGreen float32, fBlue float32, fAlpha float32) (sLib3MFColor, error) {
	var err error = nil
	var sTheColor sLib3MFColor

	err = implementation.CallFunction(implementation.Lib3MF_floatrgbatocolor, Float32InValue(fRed), Float32InValue(fGreen), Float32InValue(fBlue), Float32InValue(fAlpha), 0)
	if err != nil {
		return sTheColor, err
	}

	return sTheColor, err
}

func (implementation *Lib3MFImplementation) ColorToRGBA(sTheColor sLib3MFColor) (uint8, uint8, uint8, uint8, error) {
	var err error = nil
	var nRed uint8 = 0
	var nGreen uint8 = 0
	var nBlue uint8 = 0
	var nAlpha uint8 = 0

	err = implementation.CallFunction(implementation.Lib3MF_colortorgba, uintptr(unsafe.Pointer(&sTheColor)), UInt8OutValue(&nRed), UInt8OutValue(&nGreen), UInt8OutValue(&nBlue), UInt8OutValue(&nAlpha))
	if err != nil {
		return 0, 0, 0, 0, err
	}

	return uint8(nRed), uint8(nGreen), uint8(nBlue), uint8(nAlpha), err
}

func (implementation *Lib3MFImplementation) ColorToFloatRGBA(sTheColor sLib3MFColor) (float32, float32, float32, float32, error) {
	var err error = nil
	var fRed float32 = 0
	var fGreen float32 = 0
	var fBlue float32 = 0
	var fAlpha float32 = 0

	err = implementation.CallFunction(implementation.Lib3MF_colortofloatrgba, uintptr(unsafe.Pointer(&sTheColor)), Float32OutValue(&fRed), Float32OutValue(&fGreen), Float32OutValue(&fBlue), Float32OutValue(&fAlpha))
	if err != nil {
		return 0, 0, 0, 0, err
	}

	return fRed, fGreen, fBlue, fAlpha, err
}

func (implementation *Lib3MFImplementation) GetIdentityTransform() (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	err = implementation.CallFunction(implementation.Lib3MF_getidentitytransform, 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) GetUniformScaleTransform(fFactor float32) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	err = implementation.CallFunction(implementation.Lib3MF_getuniformscaletransform, Float32InValue(fFactor), 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) GetScaleTransform(fFactorX float32, fFactorY float32, fFactorZ float32) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	err = implementation.CallFunction(implementation.Lib3MF_getscaletransform, Float32InValue(fFactorX), Float32InValue(fFactorY), Float32InValue(fFactorZ), 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) GetTranslationTransform(fVectorX float32, fVectorY float32, fVectorZ float32) (sLib3MFTransform, error) {
	var err error = nil
	var sTransform sLib3MFTransform

	err = implementation.CallFunction(implementation.Lib3MF_gettranslationtransform, Float32InValue(fVectorX), Float32InValue(fVectorY), Float32InValue(fVectorZ), 0)
	if err != nil {
		return sTransform, err
	}

	return sTransform, err
}

func (implementation *Lib3MFImplementation) checkBinaryVersion() error {
	var nBindingMajor uint32 = 2
	var nBindingMinor uint32 = 3
	nMajor, nMinor, _, err := implementation.GetLibraryVersion()
	if err != nil {
		return err
	}
	if (nMajor != nBindingMajor) || (nMinor < nBindingMinor) {
		return fmt.Errorf("Lib3MF Error: 25 (%s)", int(0), GetLib3MFErrorMessage(uint32(0)))
	}
	return nil
}

func Lib3MFLoadWrapper(DllFileName string) (Lib3MFWrapper, error) {
	var Wrapper Lib3MFWrapper
	var Instance Lib3MFImplementation

	err := Instance.Initialize(DllFileName)
	if err != nil {
		return Wrapper, err
	}
	err = Instance.checkBinaryVersion()
	if err != nil {
		return Wrapper, err
	}
	Wrapper.Interface = &Instance

	return Wrapper, nil
}
