/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.services;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.BulkResponse;
import org.opensearch.protobufs.services.DocumentServiceGrpc;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.grpc.listeners.BulkRequestActionListener;
import org.opensearch.transport.grpc.proto.request.document.bulk.BulkRequestProtoUtils;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class DocumentServiceImpl
extends DocumentServiceGrpc.DocumentServiceImplBase {
    private static final Logger logger = LogManager.getLogger(DocumentServiceImpl.class);
    private final Client client;

    public DocumentServiceImpl(Client client) {
        this.client = client;
    }

    public void bulk(BulkRequest request, StreamObserver<BulkResponse> responseObserver) {
        try {
            org.opensearch.action.bulk.BulkRequest bulkRequest = BulkRequestProtoUtils.prepareRequest(request);
            BulkRequestActionListener listener = new BulkRequestActionListener(responseObserver);
            this.client.bulk(bulkRequest, (ActionListener)listener);
        }
        catch (RuntimeException e) {
            logger.debug("DocumentServiceImpl failed: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            responseObserver.onError((Throwable)grpcError);
        }
    }
}

