/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.replay;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.translog.Translog;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/replication/action/replay/ReplayChangesRequest;", "Lorg/opensearch/action/support/replication/ReplicatedWriteRequest;", "shardId", "Lorg/opensearch/core/index/shard/ShardId;", "changes", "", "Lorg/opensearch/index/translog/Translog$Operation;", "maxSeqNoOfUpdatesOrDeletes", "", "leaderAlias", "", "leaderIndex", "<init>", "(Lorg/opensearch/core/index/shard/ShardId;Ljava/util/List;JLjava/lang/String;Ljava/lang/String;)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getLeaderAlias", "()Ljava/lang/String;", "getLeaderIndex", "getChanges", "()Ljava/util/List;", "getMaxSeqNoOfUpdatesOrDeletes", "()J", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toString", "opensearch-cross-cluster-replication"})
public final class ReplayChangesRequest
extends ReplicatedWriteRequest<ReplayChangesRequest> {
    @NotNull
    private final String leaderAlias;
    @NotNull
    private final String leaderIndex;
    @NotNull
    private final List<Translog.Operation> changes;
    private final long maxSeqNoOfUpdatesOrDeletes;

    @NotNull
    public final String getLeaderAlias() {
        return this.leaderAlias;
    }

    @NotNull
    public final String getLeaderIndex() {
        return this.leaderIndex;
    }

    @NotNull
    public final List<Translog.Operation> getChanges() {
        return this.changes;
    }

    public final long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes;
    }

    public ReplayChangesRequest(@NotNull ShardId shardId, @NotNull List<? extends Translog.Operation> changes, long maxSeqNoOfUpdatesOrDeletes, @NotNull String leaderAlias, @NotNull String leaderIndex) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderIndex, (String)"leaderIndex");
        super(shardId);
        this.changes = changes;
        this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
        this.leaderAlias = leaderAlias;
        this.leaderIndex = leaderIndex;
    }

    public ReplayChangesRequest(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        String string = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.leaderAlias = string;
        String string2 = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        this.leaderIndex = string2;
        List list = inp.readList(Translog.Operation::readOperation);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this.changes = list;
        this.maxSeqNoOfUpdatesOrDeletes = inp.readLong();
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeString(this.leaderAlias);
        out.writeString(this.leaderIndex);
        out.writeCollection((Collection)this.changes, Translog.Operation::writeOperation);
        out.writeLong(this.maxSeqNoOfUpdatesOrDeletes);
    }

    @NotNull
    public String toString() {
        return "ReplayChangesRequest[changes=<" + CollectionsKt.take((Iterable)this.changes, (int)3) + "]";
    }
}

