/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.settings;

import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.geospatial.settings.GeospatialSettings;

public class GeospatialSettingsAccessor {
    private volatile int maxCoordinatesPerGeometry;
    private volatile int maxHolesPerPolygon;
    private volatile int maxMultiGeometries;
    private volatile int maxGeometryCollectionNestedDepth;

    public GeospatialSettingsAccessor(ClusterService clusterService, Settings settings) {
        this.maxCoordinatesPerGeometry = (Integer)GeospatialSettings.MAX_COORDINATES_PER_GEOMETRY.get(settings);
        this.maxHolesPerPolygon = (Integer)GeospatialSettings.MAX_HOLES_PER_POLYGON.get(settings);
        this.maxMultiGeometries = (Integer)GeospatialSettings.MAX_MULTI_GEOMETRIES.get(settings);
        this.maxGeometryCollectionNestedDepth = (Integer)GeospatialSettings.MAX_GEOMETRY_COLLECTION_NESTED_DEPTH.get(settings);
        this.registerSettingsCallbacks(clusterService);
    }

    private void registerSettingsCallbacks(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(GeospatialSettings.MAX_COORDINATES_PER_GEOMETRY, value -> {
            this.maxCoordinatesPerGeometry = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(GeospatialSettings.MAX_HOLES_PER_POLYGON, value -> {
            this.maxHolesPerPolygon = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(GeospatialSettings.MAX_MULTI_GEOMETRIES, value -> {
            this.maxMultiGeometries = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(GeospatialSettings.MAX_GEOMETRY_COLLECTION_NESTED_DEPTH, value -> {
            this.maxGeometryCollectionNestedDepth = value;
        });
    }

    @Generated
    public int getMaxCoordinatesPerGeometry() {
        return this.maxCoordinatesPerGeometry;
    }

    @Generated
    public int getMaxHolesPerPolygon() {
        return this.maxHolesPerPolygon;
    }

    @Generated
    public int getMaxMultiGeometries() {
        return this.maxMultiGeometries;
    }

    @Generated
    public int getMaxGeometryCollectionNestedDepth() {
        return this.maxGeometryCollectionNestedDepth;
    }
}

