/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.opensearch.common.StopWatch;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.query.DefaultKNNWeight;
import org.opensearch.knn.index.query.memoryoptsearch.MemoryOptimizedKNNWeight;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.profile.KNNProfileUtil;
import org.opensearch.knn.profile.ProfileDefaultKNNWeight;
import org.opensearch.knn.profile.ProfileMemoryOptKNNWeight;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.query.QueryProfiler;

public class KNNQuery
extends Query {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNQuery.class);
    private final String field;
    private final float[] queryVector;
    private final float[] originalQueryVector;
    private final byte[] byteQueryVector;
    private int k;
    private Map<String, ?> methodParameters;
    private final String indexName;
    private final VectorDataType vectorDataType;
    private final RescoreContext rescoreContext;
    private Query filterQuery;
    private BitSetProducer parentsFilter;
    private Float radius;
    private Context context;
    private boolean explain;
    private boolean isMemoryOptimizedSearch;
    private int shardId;

    @Deprecated
    public KNNQuery(String field, float[] queryVector, int k, String indexName, BitSetProducer parentsFilter) {
        this(field, queryVector, null, k, indexName, null, parentsFilter, VectorDataType.FLOAT, null);
    }

    @Deprecated
    public KNNQuery(String field, float[] queryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, RescoreContext rescoreContext) {
        this(field, queryVector, null, k, indexName, filterQuery, parentsFilter, VectorDataType.FLOAT, rescoreContext);
    }

    @Deprecated
    public KNNQuery(String field, byte[] byteQueryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, VectorDataType vectorDataType, RescoreContext rescoreContext) {
        this(field, null, byteQueryVector, k, indexName, filterQuery, parentsFilter, vectorDataType, rescoreContext);
    }

    @Deprecated
    private KNNQuery(String field, float[] queryVector, byte[] byteQueryVector, int k, String indexName, Query filterQuery, BitSetProducer parentsFilter, VectorDataType vectorDataType, RescoreContext rescoreContext) {
        this.field = field;
        this.queryVector = queryVector;
        this.byteQueryVector = byteQueryVector;
        this.k = k;
        this.indexName = indexName;
        this.filterQuery = filterQuery;
        this.parentsFilter = parentsFilter;
        this.vectorDataType = vectorDataType;
        this.rescoreContext = rescoreContext;
        this.originalQueryVector = queryVector;
    }

    @Deprecated
    public KNNQuery(String field, float[] queryVector, String indexName, BitSetProducer parentsFilter) {
        this(field, queryVector, null, 0, indexName, null, parentsFilter, VectorDataType.FLOAT, null);
    }

    public KNNQuery radius(Float radius) {
        this.radius = radius;
        return this;
    }

    public KNNQuery kNNQueryContext(Context context) {
        this.context = context;
        return this;
    }

    public KNNQuery filterQuery(Query filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    public int getQueryDimension() {
        return switch (this.vectorDataType) {
            case VectorDataType.BINARY -> {
                if (!$assertionsDisabled && this.byteQueryVector == null) {
                    throw new AssertionError();
                }
                yield this.byteQueryVector.length * 8;
            }
            default -> {
                if (!$assertionsDisabled && this.queryVector == null) {
                    throw new AssertionError();
                }
                yield this.queryVector.length;
            }
        };
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.createWeight(searcher, scoreMode, boost, this.k);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost, int kOverride) throws IOException {
        QueryProfiler profiler;
        StopWatch stopWatch = null;
        if (log.isDebugEnabled()) {
            stopWatch = new StopWatch().start();
        }
        Weight filterWeight = this.getFilterWeight(searcher);
        if (log.isDebugEnabled() && stopWatch != null) {
            stopWatch.stop();
            log.debug("Creating filter weight, Shard: [{}], field: [{}] took in nanos: [{}]", (Object)this.shardId, (Object)this.field, (Object)stopWatch.totalTime().nanos());
        }
        if ((profiler = KNNProfileUtil.getProfiler(searcher)) != null) {
            ContextualProfileBreakdown profile = (ContextualProfileBreakdown)profiler.getProfileBreakdown((Query)this);
            if (this.isMemoryOptimizedSearch) {
                return new ProfileMemoryOptKNNWeight(this, boost, filterWeight, searcher, kOverride, profile);
            }
            return new ProfileDefaultKNNWeight(this, boost, filterWeight, profile);
        }
        if (this.isMemoryOptimizedSearch) {
            return new MemoryOptimizedKNNWeight(this, boost, filterWeight, searcher, kOverride);
        }
        return new DefaultKNNWeight(this, boost, filterWeight);
    }

    private Weight getFilterWeight(IndexSearcher searcher) throws IOException {
        if (this.getFilterQuery() != null) {
            BooleanQuery booleanQuery = new BooleanQuery.Builder().add(this.getFilterQuery(), BooleanClause.Occur.FILTER).add((Query)new FieldExistsQuery(this.getField()), BooleanClause.Occur.FILTER).build();
            Query rewritten = searcher.rewrite((Query)booleanQuery);
            return searcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return null;
    }

    public Object getVector() {
        return switch (this.vectorDataType) {
            default -> throw new MatchException(null, null);
            case VectorDataType.BYTE -> {
                if (this.isMemoryOptimizedSearch) {
                    yield this.byteQueryVector;
                }
                yield (Object[])this.queryVector;
            }
            case VectorDataType.BINARY -> this.byteQueryVector;
            case VectorDataType.FLOAT -> (Object[])this.queryVector;
        };
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public String toString(String field) {
        return field;
    }

    public int hashCode() {
        return Objects.hash(this.field, Arrays.hashCode(this.queryVector), this.k, this.indexName, this.filterQuery, this.context, this.parentsFilter, this.radius, this.methodParameters, this.rescoreContext);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((KNNQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(KNNQuery other) {
        if (other == this) {
            return true;
        }
        return Objects.equals(this.field, other.field) && Arrays.equals(this.queryVector, other.queryVector) && Arrays.equals(this.byteQueryVector, other.byteQueryVector) && Objects.equals(this.k, other.k) && Objects.equals(this.methodParameters, other.methodParameters) && Objects.equals(this.radius, other.radius) && Objects.equals(this.context, other.context) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.parentsFilter, other.parentsFilter) && Objects.equals(this.filterQuery, other.filterQuery) && Objects.equals(this.rescoreContext, other.rescoreContext);
    }

    @Generated
    public static KNNQueryBuilder builder() {
        return new KNNQueryBuilder();
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public float[] getQueryVector() {
        return this.queryVector;
    }

    @Generated
    public float[] getOriginalQueryVector() {
        return this.originalQueryVector;
    }

    @Generated
    public byte[] getByteQueryVector() {
        return this.byteQueryVector;
    }

    @Generated
    public int getK() {
        return this.k;
    }

    @Generated
    public Map<String, ?> getMethodParameters() {
        return this.methodParameters;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    @Generated
    public RescoreContext getRescoreContext() {
        return this.rescoreContext;
    }

    @Generated
    public Query getFilterQuery() {
        return this.filterQuery;
    }

    @Generated
    public Float getRadius() {
        return this.radius;
    }

    @Generated
    public Context getContext() {
        return this.context;
    }

    @Generated
    public boolean isMemoryOptimizedSearch() {
        return this.isMemoryOptimizedSearch;
    }

    @Generated
    public int getShardId() {
        return this.shardId;
    }

    @Generated
    public KNNQuery(String field, float[] queryVector, float[] originalQueryVector, byte[] byteQueryVector, int k, Map<String, ?> methodParameters, String indexName, VectorDataType vectorDataType, RescoreContext rescoreContext, Query filterQuery, BitSetProducer parentsFilter, Float radius, Context context, boolean explain, boolean isMemoryOptimizedSearch, int shardId) {
        this.field = field;
        this.queryVector = queryVector;
        this.originalQueryVector = originalQueryVector;
        this.byteQueryVector = byteQueryVector;
        this.k = k;
        this.methodParameters = methodParameters;
        this.indexName = indexName;
        this.vectorDataType = vectorDataType;
        this.rescoreContext = rescoreContext;
        this.filterQuery = filterQuery;
        this.parentsFilter = parentsFilter;
        this.radius = radius;
        this.context = context;
        this.explain = explain;
        this.isMemoryOptimizedSearch = isMemoryOptimizedSearch;
        this.shardId = shardId;
    }

    @Generated
    public void setFilterQuery(Query filterQuery) {
        this.filterQuery = filterQuery;
    }

    @Generated
    public BitSetProducer getParentsFilter() {
        return this.parentsFilter;
    }

    @Generated
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Generated
    public boolean isExplain() {
        return this.explain;
    }

    public static class Context {
        int maxResultWindow;

        @Generated
        public void setMaxResultWindow(int maxResultWindow) {
            this.maxResultWindow = maxResultWindow;
        }

        @Generated
        public int getMaxResultWindow() {
            return this.maxResultWindow;
        }

        @Generated
        public Context(int maxResultWindow) {
            this.maxResultWindow = maxResultWindow;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxResultWindow() == other.getMaxResultWindow();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxResultWindow();
            return result;
        }
    }

    @Generated
    public static class KNNQueryBuilder {
        @Generated
        private String field;
        @Generated
        private float[] queryVector;
        @Generated
        private float[] originalQueryVector;
        @Generated
        private byte[] byteQueryVector;
        @Generated
        private int k;
        @Generated
        private Map<String, ?> methodParameters;
        @Generated
        private String indexName;
        @Generated
        private VectorDataType vectorDataType;
        @Generated
        private RescoreContext rescoreContext;
        @Generated
        private Query filterQuery;
        @Generated
        private BitSetProducer parentsFilter;
        @Generated
        private Float radius;
        @Generated
        private Context context;
        @Generated
        private boolean explain;
        @Generated
        private boolean isMemoryOptimizedSearch;
        @Generated
        private int shardId;

        @Generated
        KNNQueryBuilder() {
        }

        @Generated
        public KNNQueryBuilder field(String field) {
            this.field = field;
            return this;
        }

        @Generated
        public KNNQueryBuilder queryVector(float[] queryVector) {
            this.queryVector = queryVector;
            return this;
        }

        @Generated
        public KNNQueryBuilder originalQueryVector(float[] originalQueryVector) {
            this.originalQueryVector = originalQueryVector;
            return this;
        }

        @Generated
        public KNNQueryBuilder byteQueryVector(byte[] byteQueryVector) {
            this.byteQueryVector = byteQueryVector;
            return this;
        }

        @Generated
        public KNNQueryBuilder k(int k) {
            this.k = k;
            return this;
        }

        @Generated
        public KNNQueryBuilder methodParameters(Map<String, ?> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        @Generated
        public KNNQueryBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Generated
        public KNNQueryBuilder vectorDataType(VectorDataType vectorDataType) {
            this.vectorDataType = vectorDataType;
            return this;
        }

        @Generated
        public KNNQueryBuilder rescoreContext(RescoreContext rescoreContext) {
            this.rescoreContext = rescoreContext;
            return this;
        }

        @Generated
        public KNNQueryBuilder filterQuery(Query filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        @Generated
        public KNNQueryBuilder parentsFilter(BitSetProducer parentsFilter) {
            this.parentsFilter = parentsFilter;
            return this;
        }

        @Generated
        public KNNQueryBuilder radius(Float radius) {
            this.radius = radius;
            return this;
        }

        @Generated
        public KNNQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        @Generated
        public KNNQueryBuilder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        @Generated
        public KNNQueryBuilder isMemoryOptimizedSearch(boolean isMemoryOptimizedSearch) {
            this.isMemoryOptimizedSearch = isMemoryOptimizedSearch;
            return this;
        }

        @Generated
        public KNNQueryBuilder shardId(int shardId) {
            this.shardId = shardId;
            return this;
        }

        @Generated
        public KNNQuery build() {
            return new KNNQuery(this.field, this.queryVector, this.originalQueryVector, this.byteQueryVector, this.k, this.methodParameters, this.indexName, this.vectorDataType, this.rescoreContext, this.filterQuery, this.parentsFilter, this.radius, this.context, this.explain, this.isMemoryOptimizedSearch, this.shardId);
        }

        @Generated
        public String toString() {
            return "KNNQuery.KNNQueryBuilder(field=" + this.field + ", queryVector=" + Arrays.toString(this.queryVector) + ", originalQueryVector=" + Arrays.toString(this.originalQueryVector) + ", byteQueryVector=" + Arrays.toString(this.byteQueryVector) + ", k=" + this.k + ", methodParameters=" + String.valueOf(this.methodParameters) + ", indexName=" + this.indexName + ", vectorDataType=" + String.valueOf((Object)this.vectorDataType) + ", rescoreContext=" + String.valueOf(this.rescoreContext) + ", filterQuery=" + String.valueOf(this.filterQuery) + ", parentsFilter=" + String.valueOf(this.parentsFilter) + ", radius=" + this.radius + ", context=" + String.valueOf(this.context) + ", explain=" + this.explain + ", isMemoryOptimizedSearch=" + this.isMemoryOptimizedSearch + ", shardId=" + this.shardId + ")";
        }
    }
}

