/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.services.kms.internaldafny.types.CustomKeyStoreIdType;
import software.amazon.cryptography.services.kms.internaldafny.types.NumberOfBytesType;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;

public class GenerateRandomRequest {
    public Option<Integer> _NumberOfBytes;
    public Option<DafnySequence<? extends Character>> _CustomKeyStoreId;
    public Option<RecipientInfo> _Recipient;
    private static final TypeDescriptor<GenerateRandomRequest> _TYPE = TypeDescriptor.referenceWithInitializer(GenerateRandomRequest.class, () -> GenerateRandomRequest.Default());
    private static final GenerateRandomRequest theDefault = GenerateRandomRequest.create(Option.Default(NumberOfBytesType._typeDescriptor()), Option.Default(CustomKeyStoreIdType._typeDescriptor()), Option.Default(RecipientInfo._typeDescriptor()));

    public GenerateRandomRequest(Option<Integer> NumberOfBytes, Option<DafnySequence<? extends Character>> CustomKeyStoreId, Option<RecipientInfo> Recipient) {
        this._NumberOfBytes = NumberOfBytes;
        this._CustomKeyStoreId = CustomKeyStoreId;
        this._Recipient = Recipient;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GenerateRandomRequest o = (GenerateRandomRequest)other;
        return Objects.equals(this._NumberOfBytes, o._NumberOfBytes) && Objects.equals(this._CustomKeyStoreId, o._CustomKeyStoreId) && Objects.equals(this._Recipient, o._Recipient);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._NumberOfBytes);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._CustomKeyStoreId);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._Recipient);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ComAmazonawsKmsTypes.GenerateRandomRequest.GenerateRandomRequest");
        s.append("(");
        s.append(Helpers.toString(this._NumberOfBytes));
        s.append(", ");
        s.append(Helpers.toString(this._CustomKeyStoreId));
        s.append(", ");
        s.append(Helpers.toString(this._Recipient));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<GenerateRandomRequest> _typeDescriptor() {
        return _TYPE;
    }

    public static GenerateRandomRequest Default() {
        return theDefault;
    }

    public static GenerateRandomRequest create(Option<Integer> NumberOfBytes, Option<DafnySequence<? extends Character>> CustomKeyStoreId, Option<RecipientInfo> Recipient) {
        return new GenerateRandomRequest(NumberOfBytes, CustomKeyStoreId, Recipient);
    }

    public static GenerateRandomRequest create_GenerateRandomRequest(Option<Integer> NumberOfBytes, Option<DafnySequence<? extends Character>> CustomKeyStoreId, Option<RecipientInfo> Recipient) {
        return GenerateRandomRequest.create(NumberOfBytes, CustomKeyStoreId, Recipient);
    }

    public boolean is_GenerateRandomRequest() {
        return true;
    }

    public Option<Integer> dtor_NumberOfBytes() {
        return this._NumberOfBytes;
    }

    public Option<DafnySequence<? extends Character>> dtor_CustomKeyStoreId() {
        return this._CustomKeyStoreId;
    }

    public Option<RecipientInfo> dtor_Recipient() {
        return this._Recipient;
    }
}

