/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.handler.codec.http3.Http3ServerConnectionHandler;
import io.netty.handler.codec.quic.QuicChannel;
import io.netty.handler.codec.quic.QuicServerCodecBuilder;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicSslContextBuilder;
import io.netty.handler.codec.quic.QuicSslEngine;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.handler.codec.quic.QuicTokenHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Randomness;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpReadTimeoutException;
import org.opensearch.http.HttpServerChannel;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.http.netty4.HttpResponseHeadersFactories;
import org.opensearch.http.netty4.Netty4Http3RequestCreator;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.http.netty4.Netty4HttpPipeliningHandler;
import org.opensearch.http.netty4.Netty4HttpRequestHandler;
import org.opensearch.http.netty4.Netty4HttpResponseCreator;
import org.opensearch.http.netty4.Netty4HttpServerChannel;
import org.opensearch.http.netty4.Netty4HttpServerTransport;
import org.opensearch.http.netty4.http3.SecureQuicTokenHandler;
import org.opensearch.plugins.SecureHttpTransportSettingsProvider;
import org.opensearch.plugins.TransportExceptionHandler;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.NettyAllocator;
import org.opensearch.transport.NettyByteBufSizer;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.netty4.Netty4Utils;

public class Netty4Http3ServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4Http3ServerTransport.class);
    public static final Setting<ByteSizeValue> SETTING_H3_MAX_STREAM_LOCAL_LENGTH = Setting.byteSizeSetting((String)"h3.max_stream_local_length", (ByteSizeValue)new ByteSizeValue(1000000L, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SETTING_H3_MAX_STREAM_REMOTE_LENGTH = Setting.byteSizeSetting((String)"h3.max_stream_remote_length", (ByteSizeValue)new ByteSizeValue(1000000L, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Long> SETTING_H3_MAX_STREAMS = Setting.longSetting((String)"h3.max_streams", (long)100L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ByteSizeValue maxInitialLineLength;
    private final ByteSizeValue maxHeaderSize;
    private final ByteSizeValue maxChunkSize;
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    private final int connectTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private final int pipeliningMaxEvents;
    private volatile Bootstrap bootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    private final SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider;
    private final TransportExceptionHandler exceptionHandler;
    public static final AttributeKey<Netty4HttpChannel> HTTP_CHANNEL_KEY = AttributeKey.newInstance((String)"opensearch-quic-channel");
    protected static final AttributeKey<SSLEngine> HTTP_SERVER_ENGINE_KEY = AttributeKey.newInstance((String)"opensearch-quic-server-ssl-engine");
    protected static final AttributeKey<Netty4HttpServerChannel> HTTP_SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"opensearch-quic-server-channel");

    public Netty4Http3ServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, tracer);
        Netty4Utils.setAvailableProcessors((int)((Integer)OpenSearchExecutors.NODE_PROCESSORS_SETTING.get(settings)));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.secureHttpTransportSettingsProvider = secureHttpTransportSettingsProvider;
        this.exceptionHandler = secureHttpTransportSettingsProvider.buildHttpServerExceptionHandler(settings, (HttpServerTransport)this).orElse(TransportExceptionHandler.NOOP);
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.maxCompositeBufferComponents = (Integer)Netty4HttpServerTransport.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.readTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings)).getMillis());
        this.connectTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_CONNECT_TIMEOUT.get(settings)).getMillis());
        ByteSizeValue receivePredictor = (ByteSizeValue)Netty4HttpServerTransport.SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents);
    }

    public Settings settings() {
        return this.settings;
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.sharedGroup = this.sharedGroupFactory.getHttpGroup();
            this.bootstrap = new Bootstrap();
            this.bootstrap.group(this.sharedGroup.getLowLevelGroup());
            this.bootstrap.channel(NioDatagramChannel.class);
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator(true));
            this.bootstrap.handler(this.configureServerChannelHandler());
            this.bootstrap.option(ChannelOption.RECVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.bindServer();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        ChannelFuture future = this.bootstrap.bind((SocketAddress)socketAddress).sync();
        Channel channel = future.channel();
        Netty4HttpServerChannel httpServerChannel = new Netty4HttpServerChannel(channel);
        channel.attr(HTTP_SERVER_CHANNEL_KEY).set((Object)httpServerChannel);
        return httpServerChannel;
    }

    protected void stopInternal() {
        if (this.sharedGroup != null) {
            this.sharedGroup.shutdown();
            this.sharedGroup = null;
        }
    }

    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException) {
            cause = cause0.getCause();
        }
        this.exceptionHandler.onError(cause);
        logger.error("Exception during establishing a HTTP/3 connection: " + String.valueOf(cause), cause);
        if (cause instanceof ReadTimeoutException) {
            super.onException(channel, (Exception)new HttpReadTimeoutException((long)this.readTimeoutMillis, cause0));
        } else {
            super.onException(channel, cause0);
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Optional parameters = Netty4Http3ServerTransport.this.secureHttpTransportSettingsProvider.parameters(Netty4Http3ServerTransport.this.settings);
                KeyManagerFactory keyManagerFactory = (KeyManagerFactory)parameters.flatMap(SecureHttpTransportSettingsProvider.SecureHttpTransportParameters::keyManagerFactory).orElseThrow(() -> new OpenSearchException("The KeyManagerFactory instance is not provided", new Object[0]));
                QuicSslContextBuilder sslContextBuilder = QuicSslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory, null);
                parameters.flatMap(SecureHttpTransportSettingsProvider.SecureHttpTransportParameters::trustManagerFactory).ifPresent(arg_0 -> ((QuicSslContextBuilder)sslContextBuilder).trustManager(arg_0));
                parameters.flatMap(SecureHttpTransportSettingsProvider.SecureHttpTransportParameters::clientAuth).ifPresent(clientAuth -> sslContextBuilder.clientAuth(ClientAuth.valueOf((String)clientAuth)));
                QuicSslContext sslContext = sslContextBuilder.applicationProtocols(Http3.supportedApplicationProtocols()).build();
                ch.pipeline().addLast(new ChannelHandler[]{((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)Http3.newQuicServerCodecBuilder().sslEngineProvider(q -> {
                    QuicSslEngine engine = sslContext.newEngine(q.alloc());
                    q.attr(HTTP_SERVER_ENGINE_KEY).set((Object)engine);
                    return engine;
                })).maxIdleTimeout((long)Netty4Http3ServerTransport.this.connectTimeoutMillis, TimeUnit.MILLISECONDS)).initialMaxData(((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(Netty4Http3ServerTransport.this.settings)).getBytes())).initialMaxStreamDataBidirectionalLocal(((ByteSizeValue)SETTING_H3_MAX_STREAM_LOCAL_LENGTH.get(Netty4Http3ServerTransport.this.settings)).getBytes())).initialMaxStreamDataBidirectionalRemote(((ByteSizeValue)SETTING_H3_MAX_STREAM_REMOTE_LENGTH.get(Netty4Http3ServerTransport.this.settings)).getBytes())).initialMaxStreamsBidirectional(((Long)SETTING_H3_MAX_STREAMS.get(Netty4Http3ServerTransport.this.settings)).longValue())).tokenHandler((QuicTokenHandler)new SecureQuicTokenHandler(Randomness.createSecure())).handler((ChannelHandler)new ChannelInitializer<QuicChannel>(){

                    protected void initChannel(QuicChannel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{new Http3ServerConnectionHandler((ChannelHandler)new HttpChannelHandler(Netty4Http3ServerTransport.this, Netty4Http3ServerTransport.this.handlingSettings))});
                    }
                }).build()});
            }
        };
    }

    protected ChannelInboundHandlerAdapter createHeaderVerifier() {
        return new ChannelInboundHandlerAdapter();
    }

    protected ChannelInboundHandlerAdapter createDecompressor() {
        return new HttpContentDecompressor();
    }

    private static CompressionOptions[] defaultCompressionOptions(int compressionLevel) {
        return Netty4Http3ServerTransport.defaultCompressionOptions(compressionLevel, 15, 8);
    }

    private static CompressionOptions[] defaultCompressionOptions(int compressionLevel, int windowBits, int memLevel) {
        ArrayList<Object> options = new ArrayList<Object>(4);
        GzipOptions gzipOptions = StandardCompressionOptions.gzip((int)compressionLevel, (int)windowBits, (int)memLevel);
        DeflateOptions deflateOptions = StandardCompressionOptions.deflate((int)compressionLevel, (int)windowBits, (int)memLevel);
        options.add(gzipOptions);
        options.add(deflateOptions);
        options.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            options.add(StandardCompressionOptions.brotli());
        }
        return options.toArray(new CompressionOptions[0]);
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<QuicStreamChannel> {
        private final Netty4Http3ServerTransport transport;
        private final NettyByteBufSizer byteBufSizer;
        private final Netty4Http3RequestCreator requestCreator;
        private final Netty4HttpRequestHandler requestHandler;
        private final Netty4HttpResponseCreator responseCreator;
        private final HttpHandlingSettings handlingSettings;

        protected HttpChannelHandler(Netty4Http3ServerTransport transport, HttpHandlingSettings handlingSettings) {
            this.transport = transport;
            this.handlingSettings = handlingSettings;
            this.byteBufSizer = new NettyByteBufSizer();
            this.requestCreator = new Netty4Http3RequestCreator(transport.maxInitialLineLength, HttpResponseHeadersFactories.newHttp2Aware(transport.settings, (HttpServerTransport)transport));
            this.requestHandler = new Netty4HttpRequestHandler(transport, HTTP_CHANNEL_KEY);
            this.responseCreator = new Netty4HttpResponseCreator();
        }

        public ChannelHandler getRequestHandler() {
            return this.requestHandler;
        }

        protected void initChannel(QuicStreamChannel ch) throws Exception {
            Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel((Channel)ch, HTTP_SERVER_ENGINE_KEY);
            ch.attr(HTTP_CHANNEL_KEY).set((Object)nettyHttpChannel);
            ch.pipeline().addLast("byte_buf_sizer", (ChannelHandler)this.byteBufSizer);
            ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            this.configurePipeline((Channel)ch);
            this.transport.serverAcceptedChannel(nettyHttpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
            NioDatagramChannel parent = this.parent(ctx.channel());
            NioDatagramChannel channel = parent != null ? parent : ctx.channel();
            Netty4HttpServerChannel httpServerChannel = (Netty4HttpServerChannel)channel.attr(HTTP_SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                this.transport.onServerException(httpServerChannel, new Exception(cause));
            } else {
                this.transport.onServerException(httpServerChannel, (Exception)cause);
            }
        }

        protected void configurePipeline(Channel ch) {
            ch.pipeline().addLast(new ChannelHandler[]{new Http3FrameToHttpObjectCodec(true)});
            ch.pipeline().addLast("header_verifier", (ChannelHandler)this.transport.createHeaderVerifier());
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)this.transport.createDecompressor());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(this.handlingSettings.getMaxContentLength());
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            ch.pipeline().addLast("aggregator", (ChannelHandler)aggregator);
            if (this.handlingSettings.isCompression()) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(Netty4Http3ServerTransport.defaultCompressionOptions(this.handlingSettings.getCompressionLevel())));
            }
            ch.pipeline().addLast("request_creator", (ChannelHandler)this.requestCreator);
            ch.pipeline().addLast("response_creator", (ChannelHandler)this.responseCreator);
            ch.pipeline().addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, this.transport.pipeliningMaxEvents));
            ch.pipeline().addLast("handler", (ChannelHandler)this.requestHandler);
        }

        private NioDatagramChannel parent(Channel channel) {
            if (channel == null) {
                return null;
            }
            if (channel instanceof NioDatagramChannel) {
                NioDatagramChannel ndc = (NioDatagramChannel)channel;
                return ndc;
            }
            return this.parent(channel.parent());
        }
    }
}

