/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;

public class NodeProcessingMetadataFilter
extends AbstractMetadataFilter {
    @Nonnull
    private List<MetadataNodeProcessor> processors = new ArrayList<MetadataNodeProcessor>();

    @Nonnull
    @Live
    public List<MetadataNodeProcessor> getNodeProcessors() {
        return this.processors;
    }

    public void setNodeProcessors(@Nonnull List<MetadataNodeProcessor> newProcessors) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(newProcessors, "MetadataNodeProcessor list cannot be null");
        this.processors = new ArrayList<MetadataNodeProcessor>(newProcessors);
    }

    @Override
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        this.processNode(metadata);
        return metadata;
    }

    protected void processNode(@Nonnull XMLObject node) throws FilterException {
        for (MetadataNodeProcessor processor : this.getNodeProcessors()) {
            processor.process(node);
        }
        List<XMLObject> children = node.getOrderedChildren();
        if (children != null) {
            for (XMLObject child : children) {
                assert (child != null);
                this.processNode(child);
            }
        }
    }
}

