/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.AbstractBundleKt;
import com.intellij.BundleBase;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.l10n.LocalizationOrder;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    private static final ConcurrentMap<String, ResourceBundle> bundles = CollectionFactory.createConcurrentWeakValueMap();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
    }

    @ApiStatus.Obsolete
    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(baseLoader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, pathToBundle, DynamicBundle.getResolveLocale(), (loader, locale) -> super.findBundle(pathToBundle, (ClassLoader)loader, control, (Locale)locale)));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        return resourceBundle;
    }

    @Nullable
    private static ResourceBundle getBundleFromCache(@NotNull ClassLoader loader, @NotNull String pathToBundle) {
        Map<String, ResourceBundle> loaderCache;
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(8);
        }
        if ((loaderCache = ourCache.get(loader)) == null) {
            return null;
        }
        return loaderCache.get(pathToBundle);
    }

    private static void removeBundleFromCache(@NotNull ClassLoader loader, @NotNull String pathToBundle) {
        Map<String, ResourceBundle> loaderCache;
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(9);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(10);
        }
        if ((loaderCache = ourCache.get(loader)) == null) {
            return;
        }
        loaderCache.remove(pathToBundle);
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull String defaultPath, @NotNull Locale locale, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(11);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(12);
        }
        if (defaultPath == null) {
            DynamicBundle.$$$reportNull$$$0(13);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(14);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(15);
        }
        String bundlePath = FileUtilRt.toCanonicalPath((String)defaultPath, (char)'.', (boolean)true);
        ClassLoader pluginClassLoader = DefaultBundleService.isDefaultBundle() ? null : LocalizationUtil.INSTANCE.getPluginClassLoader(bundleClassLoader, locale);
        List<String> paths = LocalizationUtil.INSTANCE.getLocalizedPathsWithDefault(bundlePath, locale);
        HashMap<LocalizationOrder, ResourceBundle> bundleOrderMap = new HashMap<LocalizationOrder, ResourceBundle>();
        if (pluginClassLoader != null) {
            try {
                ResourceBundle pluginBundle = bundleResolver.apply(pluginClassLoader, Locale.ROOT);
                bundleOrderMap.put(LocalizationOrder.DEFAULT_PLUGIN, pluginBundle);
            }
            catch (MissingResourceException e) {
                LOG.debug("Bundle " + defaultPath + " was not found in localization plugin for locale: " + locale.toLanguageTag());
            }
        }
        DynamicBundle.resolveBundleOrder(baseLoader, bundlePath, paths, bundleOrderMap, bundleResolver, locale);
        DynamicBundle.reorderParents(bundleOrderMap);
        Optional resourceBundleEntry = bundleOrderMap.entrySet().stream().min(Map.Entry.comparingByKey());
        if (!resourceBundleEntry.isPresent()) {
            throw new RuntimeException("No such resource bundle: " + bundlePath);
        }
        ResourceBundle bundle = (ResourceBundle)resourceBundleEntry.get().getValue();
        bundles.put(defaultPath, bundle);
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(16);
        }
        return resourceBundle;
    }

    @NotNull
    private static List<ResourceBundle> getBundlesFromLocalizationFolder(@NotNull String pathToBundle, ClassLoader loader, @NotNull Locale locale) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(17);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(18);
        }
        List<String> paths = LocalizationUtil.INSTANCE.getFolderLocalizedPaths(pathToBundle, locale);
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (String path : paths) {
            try {
                resourceBundles.add(AbstractBundleKt._doResolveBundle(loader, locale, path));
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (resourceBundles.isEmpty()) {
            LOG.debug("No bundles found in: " + StringUtil.join(paths, ", "));
        }
        ArrayList<ResourceBundle> arrayList = resourceBundles;
        if (arrayList == null) {
            DynamicBundle.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static ResourceBundle getParent(@NotNull ResourceBundle bundle) throws Throwable {
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(20);
        }
        return (ResourceBundle)DynamicBundleInternal.GET_PARENT.invokeWithArguments(bundle);
    }

    private static void resolveBundleOrder(@NotNull ClassLoader loader, @NotNull String pathToBundle, @NotNull List<String> orderedPaths, @NotNull Map<? super LocalizationOrder, ? super ResourceBundle> bundleOrderMap, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(21);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(22);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(23);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(24);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(25);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(26);
        }
        ResourceBundle bundle = bundleResolver.apply(loader, locale);
        try {
            while (bundle != null) {
                DynamicBundle.putBundleOrder(bundle, bundleOrderMap, orderedPaths);
                bundle = DynamicBundle.getParent(bundle);
            }
        }
        catch (Throwable throwable) {
            LOG.info(throwable);
        }
        for (ResourceBundle localizedBundle : DynamicBundle.getBundlesFromLocalizationFolder(pathToBundle, loader, locale)) {
            DynamicBundle.putBundleOrder(localizedBundle, bundleOrderMap, orderedPaths);
        }
    }

    private static void putBundleOrder(@NotNull ResourceBundle bundle, @NotNull Map<? super LocalizationOrder, ? super ResourceBundle> bundleOrderMap, @NotNull List<String> orderedPaths) {
        LocalizationOrder localizationOrder;
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(27);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(28);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(29);
        }
        String bundlePath = FileUtil.toCanonicalPath(bundle.getBaseBundleName(), '.');
        if (!bundle.getLocale().toString().isEmpty()) {
            bundlePath = bundlePath + "_" + bundle.getLocale().toString();
        }
        if ((localizationOrder = LocalizationOrder.Companion.getLocalizationOrder(orderedPaths, bundlePath)) == null) {
            LOG.debug("Order cannot be defined for the bundle: " + bundlePath + "; Current locale: " + DynamicBundle.getLocale() + "; Paths for locale: " + orderedPaths);
            return;
        }
        bundleOrderMap.put(localizationOrder, bundle);
    }

    private static void reorderParents(@NotNull Map<LocalizationOrder, ResourceBundle> bundleOrderMap) {
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(30);
        }
        ResourceBundle resourceBundle = null;
        for (LocalizationOrder localizationOrder : LocalizationOrder.getEntries()) {
            ResourceBundle parentBundle = bundleOrderMap.get((Object)localizationOrder);
            if (parentBundle == null || parentBundle == resourceBundle) continue;
            if (resourceBundle != null) {
                try {
                    DynamicBundleInternal.SET_PARENT.bindTo(resourceBundle).invoke(parentBundle);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
            resourceBundle = parentBundle;
        }
    }

    @Override
    @ApiStatus.Internal
    protected ResourceBundle getBundle(boolean isDefault, @NotNull ClassLoader classLoader) {
        ResourceBundle bundle;
        if (classLoader == null) {
            DynamicBundle.$$$reportNull$$$0(31);
        }
        if ((bundle = super.getBundle(isDefault, classLoader)) == null || isDefault) {
            return bundle;
        }
        String bundleName = bundle.getBaseBundleName();
        if (bundleName == null) {
            LOG.warn("Bundle without name cannot be properly cached: " + bundle);
            return bundle;
        }
        ResourceBundle bundleFromCache = DynamicBundle.getBundleFromCache(classLoader, bundleName);
        if (bundleFromCache == null) {
            return null;
        }
        if (bundleFromCache != bundle) {
            LOG.info("Cleanup bundle cache for " + bundleName);
            DynamicBundle.removeBundleFromCache(classLoader, bundleName);
            return null;
        }
        return bundle;
    }

    @ApiStatus.Internal
    public static void clearCache() {
        ourCache.clear();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(32);
        }
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(33);
        }
        return DynamicBundle.getResourceBundle(loader, pathToBundle);
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(34);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(35);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, DynamicBundle.getResolveLocale()));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(36);
        }
        return resourceBundle;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(37);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(38);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(39);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, locale));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(40);
        }
        return resourceBundle;
    }

    @ApiStatus.Internal
    @NotNull
    public static ResourceBundle getResourceBundleLocalized(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle, @NotNull Locale locale) {
        ResourceBundle bundle;
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(41);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(42);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(43);
        }
        if ((bundle = (ResourceBundle)(DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).get(pathToBundle)) != null && bundle.getLocale().equals(locale)) {
            ResourceBundle resourceBundle = bundle;
            if (resourceBundle == null) {
                DynamicBundle.$$$reportNull$$$0(44);
            }
            return resourceBundle;
        }
        return DynamicBundle.resolveResourceBundle(loader, pathToBundle, locale);
    }

    @Nullable
    public static ResourceBundle getPluginBundle(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DynamicBundle.$$$reportNull$$$0(45);
        }
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        String baseName = pluginDescriptor.getResourceBundleBaseName();
        return classLoader != null && baseName != null ? DynamicBundle.getResourceBundle(classLoader, baseName) : null;
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(46);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(47);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(48);
        }
        ResourceBundle resourceBundle = Companion.resolveResourceBundleWithFallback(loader, pathToBundle, () -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader, pathToBundle, locale, DynamicBundle.bundleResolver(pathToBundle)), e -> {
            PluginId pluginId = loader instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)loader).getPluginId() : null;
            LOG.error(new PluginException((Throwable)e, pluginId));
            return Unit.INSTANCE;
        });
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(49);
        }
        return resourceBundle;
    }

    @NotNull
    private static @NotNull BiFunction<@NotNull ClassLoader, @NotNull Locale, @NotNull ResourceBundle> bundleResolver(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(50);
        }
        BiFunction<ClassLoader, Locale, ResourceBundle> biFunction = (loader, locale) -> AbstractBundleKt._doResolveBundle(loader, locale, pathToBundle);
        if (biFunction == null) {
            DynamicBundle.$$$reportNull$$$0(51);
        }
        return biFunction;
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class<?> callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(52);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass(2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(53);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(54);
        }
        final ResourceBundle rb = DynamicBundle.getResourceBundle(formClass.getClassLoader(), baseName);
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object get = rb.getObject(key);
                assert (get instanceof String) : "Language bundles should contain only strings";
                return BundleBase.INSTANCE.appendLocalizationSuffix((String)get, "\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = rb.getKeys();
                if (enumeration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return enumeration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleGetObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static Locale getLocale() {
        Locale locale = LocalizationUtil.INSTANCE.getLocale();
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(55);
        }
        return locale;
    }

    @NotNull
    private static Locale getResolveLocale() {
        Locale resolveLocale = DynamicBundle.getLocale();
        Locale locale = resolveLocale.equals(Locale.ENGLISH) ? Locale.ROOT : resolveLocale;
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(56);
        }
        return locale;
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable Map<String, ResourceBundle> getResourceBundles() {
        Map<String, ResourceBundle> map2 = Collections.unmodifiableMap(bundles);
        if (map2 == null) {
            DynamicBundle.$$$reportNull$$$0(57);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 17: 
            case 22: 
            case 32: 
            case 35: 
            case 38: 
            case 42: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/DynamicBundle";
                break;
            }
            case 7: 
            case 9: 
            case 21: 
            case 33: 
            case 34: 
            case 37: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClassLoader";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
            case 14: 
            case 18: 
            case 26: 
            case 39: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleResolver";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedPaths";
                break;
            }
            case 24: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleOrderMap";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/DynamicBundle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBundle";
                break;
            }
            case 16: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 36: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundleLocalized";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "bundleResolver";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveLocale";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBundleFromCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeBundleFromCache";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundleOrder";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putBundleOrder";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "reorderParents";
                break;
            }
            case 31: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundleLocalized";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPluginBundle";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "bundleResolver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 16: 
            case 19: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DynamicBundleInternal {
        @NotNull
        private static final MethodHandle SET_PARENT;
        @NotNull
        private static final MethodHandle GET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
                Field parentField = ResourceBundle.class.getDeclaredField("parent");
                parentField.setAccessible(true);
                GET_PARENT = MethodHandles.lookup().unreflectGetter(parentField);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        @Attribute(value="displayName")
        public String displayName;
        public PluginDescriptor pluginDescriptor;

        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }
}

