\name{DiscreteGaussianImageFilter}
\alias{DiscreteGaussianImageFilter}
\title{DiscreteGaussianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).
DiscreteGaussianImageFilter}
\details{
The Gaussian operator used here was described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.) The Gaussian kernel used here was designed so that smoothing
and derivative operations commute after discretization.
The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.
When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .
See:
GaussianOperator
Image
Neighborhood
NeighborhoodOperator
RecursiveGaussianImageFilter
DiscreteGaussian for the procedural interface
itk::DiscreteGaussianImageFilter for the Doxygen on the original ITK class.
DiscreteGaussianImageFilter}
%C++ includes: sitkDiscreteGaussianImageFilter.h
\section{Methods}{
\describe{
\item{ DiscreteGaussianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< double > GetMaximumError() const:}{
The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.
}
\item{unsigned int GetMaximumKernelWidth() const:}{
Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to specify the Gaussian variance in real
world units; use Off to ignore the image spacing and to specify the
Gaussian variance in voxel units. Default is On.
}
\item{std::vector< double > GetVariance() const:}{
The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.
}
\item{Self SetMaximumError(double value):}{
Set the values of the MaximumError vector all to value
}
\item{Self SetMaximumError(std::vector< double > MaximumError):}{}
\item{Self SetMaximumKernelWidth(unsigned int MaximumKernelWidth):}{
Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to specify the Gaussian variance in real
world units; use Off to ignore the image spacing and to specify the
Gaussian variance in voxel units. Default is On.
}
\item{Self SetVariance(double value):}{
Set the values of the Variance vector all to value
}
\item{Self SetVariance(std::vector< double > Variance):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~DiscreteGaussianImageFilter():}{
Destructor
}
}
}
