/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.lang.ref.Cleaner;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.TransmitAction;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.jaybird.util.Cleaners;

public abstract class AbstractFbWireStatement
extends AbstractFbStatement
implements FbWireStatement {
    private final Map<RowDescriptor, byte[]> blrCache = new WeakHashMap<RowDescriptor, byte[]>();
    private volatile int handle = 65535;
    private final FbWireDatabase database;
    private Cleaner.Cleanable cleanable = Cleaners.getNoOp();

    protected AbstractFbWireStatement(FbWireDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
    }

    @Override
    public final LockCloseable withLock() {
        return this.database.withLock();
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    protected final void withTransmitLock(TransmitAction transmitAction) throws IOException, SQLException {
        this.getXdrStreamAccess().withTransmitLock(transmitAction);
    }

    private XdrStreamAccess getXdrStreamAccess() {
        return this.database.getXdrStreamAccess();
    }

    @Override
    public final FbWireDatabase getDatabase() {
        return this.database;
    }

    @Override
    public final int getHandle() {
        return this.handle;
    }

    protected final void setHandle(int handle) {
        this.handle = handle;
        this.cleanable = Cleaners.getJbCleaner().register(this, new CleanupAction(this));
    }

    @Override
    public FbWireTransaction getTransaction() {
        return (FbWireTransaction)super.getTransaction();
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor) throws SQLException {
        if (rowDescriptor == null) {
            return null;
        }
        byte[] blr = this.blrCache.get(rowDescriptor);
        if (blr == null) {
            blr = this.getBlrCalculator().calculateBlr(rowDescriptor);
            this.blrCache.put(rowDescriptor, blr);
        }
        return blr;
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor, RowValue rowValue) throws SQLException {
        if (rowDescriptor == null || rowValue == null) {
            return null;
        }
        return this.getBlrCalculator().calculateBlr(rowDescriptor, rowValue);
    }

    protected final BlrCalculator getBlrCalculator() {
        return this.getDatabase().getBlrCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.cleanable.clean();
            try (LockCloseable ignored = this.withLock();){
                this.blrCache.clear();
            }
        }
    }

    @Override
    protected boolean isValidTransactionClass(Class<? extends FbTransaction> transactionClass) {
        return FbWireTransaction.class.isAssignableFrom(transactionClass);
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.database.emptyRowDescriptor();
    }

    @Override
    public byte[] getSqlInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            this.checkStatementValid();
            return this.getInfo(70, requestItems, bufferLength);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected byte[] getInfo(int operation, byte[] requestItems, int bufferLength) throws SQLException {
        return this.getDatabase().getInfo(operation, this.getHandle(), requestItems, bufferLength, this.getStatementWarningCallback());
    }

    protected void handleInlineBlobResponse(InlineBlobResponse inlineBlobResponse) {
    }

    protected final <T> DeferredAction wrapDeferredResponse(DeferredResponse<T> deferredResponse, Function<Response, T> responseMapper, boolean requiresSync) {
        return DeferredAction.wrapDeferredResponse(deferredResponse, responseMapper, this.getStatementWarningCallback(), this::deferredExceptionHandler, requiresSync);
    }

    private void deferredExceptionHandler(Exception exception) {
        if (exception instanceof SQLException) {
            SQLException sqle = (SQLException)exception;
            this.exceptionListenerDispatcher.errorOccurred(sqle);
        }
        if (exception instanceof IOException || exception.getCause() instanceof IOException) {
            this.forceState(StatementState.ERROR);
        }
    }

    private static final class CleanupAction
    implements Runnable,
    StatementListener,
    DatabaseListener {
        private static final AtomicReferenceFieldUpdater<CleanupAction, FbWireDatabase> databaseUpdater = AtomicReferenceFieldUpdater.newUpdater(CleanupAction.class, FbWireDatabase.class, "database");
        private static final DeferredAction CLEANUP_FREE_DEFERRED_ACTION = new DeferredAction(){

            @Override
            public boolean requiresSync() {
                return true;
            }
        };
        private final int handle;
        private volatile FbWireDatabase database;

        private CleanupAction(AbstractFbWireStatement statement) {
            this.handle = statement.getHandle();
            FbWireDatabase database = statement.getDatabase();
            databaseUpdater.set(this, database);
            database.addWeakDatabaseListener(this);
            statement.addWeakStatementListener(this);
        }

        @Override
        public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
            if (newState == StatementState.CLOSING) {
                this.releaseDatabaseReference();
                sender.removeStatementListener(this);
            }
        }

        @Override
        public void detaching(FbDatabase database) {
            this.releaseDatabaseReference();
        }

        private void releaseDatabaseReference() {
            FbWireDatabase database = databaseUpdater.getAndSet(this, null);
            if (database != null) {
                database.removeDatabaseListener(this);
            }
        }

        private FbWireDatabase releaseAndGetDatabaseReference() {
            FbWireDatabase database = databaseUpdater.getAndSet(this, null);
            if (database != null) {
                database.removeDatabaseListener(this);
            }
            return database;
        }

        @Override
        public void run() {
            FbWireDatabase database = this.releaseAndGetDatabaseReference();
            if (database == null) {
                return;
            }
            try (LockCloseable ignored = database.withLock();){
                if (!database.isAttached()) {
                    return;
                }
                database.getXdrStreamAccess().withTransmitLock(xdrOut -> {
                    xdrOut.writeInt(67);
                    xdrOut.writeInt(this.handle);
                    xdrOut.writeInt(2);
                    xdrOut.flush();
                });
                database.enqueueDeferredAction(CLEANUP_FREE_DEFERRED_ACTION);
            }
            catch (IOException | SQLException e) {
                System.getLogger(this.getClass().getName()).log(System.Logger.Level.TRACE, "Ignored exception during statement clean up", (Throwable)e);
            }
        }
    }
}

