# Greek (Leiden Aratea + Almagest)

## Introduction

This is a manuscript from the Carolingian period, two copies of which are known so far. One was found in Metz (France), the other in Leiden (Netherlands). It dates to the reign of the Carolingian king Louis the Pious (778-840), who may have been the patron himself (or his wife).

The manuscript was probably created around 816 to 825 in Aachen or Metz (Lorraine) and was made with such expensive material that a royal patron is suspected. It comprises 99 parchment leaves, each of which measures 22.5 by 20.0 cm (i.e. approximately square with the width of DIN A4). In addition to graphic representations of planetary orbits and other didactic visualisations, this manuscript also contains 35 full-page miniatures depicting the ancient figures behind the constellations.

## Description

The figures are drawn from a non-preserved Roman model, but not from a globe, so that there is no fit to the stars. The stars themselves are only symbolically distributed on the figures, i.e. the number of stars per figure is marked in the manuscript in the form of applied gold leaves. The gold leaves, however, are not located at the true places of the stars in view of the figure in the sky, but are only indicated summarily. Elly Decker's essay discusses her proposed identifications in detail.

<p><img width="800" src="illustrations/descr_pics/Aratea fol. 3v und 4r.jpg"/></p>
<p><i>A sample page from the medieval manuscript shows the three cushion images Draco, Ursa Maior and Ursa Minor with the text opposite.</i></p>

### How this Sky Culture was made

The illustrations of the individual figures were taken directly from the manuscript (provided by Prof. D. Blume, Jena, for planetarium applications). Stellarium works with point coordinates for stars in the catalogue of the astrometry satellite HIPPARCOS, so that the historical drawings have to be locked at three points each. Some of the flat book illustrations had to be distorted slightly on the planetarium dome to fit the stars. Except for the illustration of Scorpius and Ophiuchus, an approximate adjustment was possible.

 In a planetarium dome, i.e. against a dark background, the dark blue and black parts of the manuscript are not recognisable. That is why these parts (e.g. the crab as a figure, the horns of the ibex, the goats of the carter...) were colour-inverted. The female bears, which are supposed to be dark, have only been shifted slightly into the red. How the image looks in the original (with its lapis lazuli blue background and the original dark colours) is shown in the table below.

There are some constellations in the Leiden Aratea, in particular Cen + Lup, Vir, Lib are leaving a huge gap in the sky.
Both, Virgo and Centaur are probably not painted because the painter thought it were variants of the images of Sgr (Cen) and And (Vir).
The artist of the Leiden Aratea never mapped the images onto the stars.
In order to make these depictions understandable for us, I mapped them in Stellarium and added the names and stickfigures of the constellations and the names of individual stars from the Almagest.
The Almagest is a book of mathematical astronomy of the 2nd century (i.e. the reign of the Roman Emperor Hadrian) while Aratos's poem describes a much earlier (~300 BCE) Greek sky culture.
Both, the Almagest and the poem, are written in Greek originally but the Leiden Aratea presumably refers to a Latin translation of Aratus' poem and Roman artwork.

The following table lists the original names of the constellations in columns 2 and 3. constellations, in column 4 the illustration in the manuscript.

<p>
<table>
	<tr valign="top">
		<td><b>Latin Name, Abbreviation</b></td>
		<td><b>Original Greek Name</b></td>
		<td><b>Translation</b> (literally)</td>
		<td><b>Picture</b></td>
	</tr>
	<tr valign="top">
		<td><notr>Ursa Minor, Ursa Maior, Draco<br />UMi, UMa, Dra</notr></td>
		<td><notr>&Mu;&iota;&kappa;&rho;&#942; &#702;&#714;&Alpha;&rho;&kappa;&tau;&omicron;&sigmaf;, &Mu;&epsilon;&gamma;&alpha;&lambda;&#942; &#702;&#714;&Alpha;&rho;&kappa;&tau;&omicron;&sigmaf;, &Delta;&rho;&#940;&kappa;&omega;&nu;</notr></td>
		<td>Little She-Bear, Great She-Bear, Dragon (Latin) / Snake (Greek)</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_dra.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>King Cepheus, Cep</notr></td>
		<td><notr>&Kappa;&eta;&phi;&epsilon;&#973;&sigmaf;</notr></td>
		<td>Kepheus</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cep.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Bootes, Boo</notr></td>
		<td><notr>&Beta;&omicron;&#974;&tau;&eta;&sigmaf;</notr></td>
		<td>Ox driver (Latin), Ploughing Man (Greek)</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_boo.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Northern Crown, CrB</notr></td>
		<td><notr>&Sigma;&tau;&#941;&phi;&alpha;&nu;&omicron;&sigmaf;</notr></td>
		<td>Crown (Latin), Wreath (Greek)</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_crB.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Hercules, Her</notr></td>
		<td><notr>&#702;&Epsilon;&nu;&gamma;&#972;&nu;&alpha;&sigma;&iota;&nu;</notr></td>
		<td>Hercules (Latin), Kneeler (Greek)<br />The star between the legs is a well-known mistake in the picture: for this figure the draughtsman obviously took Bootes as a model; leg position, shepherd's crook (instead of club for Hercules) and star between the knees are the same.</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_her.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Lyra, Lyr</notr></td>
		<td><notr>&Lambda;&#973;&rho;&alpha;</notr></td>
		<td>Lyre</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_lyr.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cygnus, Cyg</notr></td>
		<td><notr>&#702;&#714;&Omicron;&rho;&nu;&iota;&sigmaf;</notr></td>
		<td>Bird [not specified]</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cyg.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cassiopeia, Cas</notr></td>
		<td><notr>&Kappa;&alpha;&sigma;&sigma;&iota;&#941;&pi;&epsilon;&iota;&alpha;</notr></td>
		<td>Queen Kassiepeia </td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cas.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Perseus, Per</notr></td>
		<td><notr>&Pi;&epsilon;&rho;&sigma;&epsilon;&#973;&sigmaf;</notr></td>
		<td>Perseus<br />mirrored depiction</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_per.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Auriga, Aur</notr></td>
		<td><notr>&#703;&Eta;&nu;&#943;&omicron;&chi;&omicron;&sigmaf;</notr></td>
		<td>Charioteer</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_aur.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Aquila et Sagitta,<br />Aql </notr>and<notr> Sge</notr></td>
		<td><notr>&#702;&Alpha;&epsilon;&tau;&#972;&sigmaf; </notr>and<notr> &#702;&Omicron;&iota;&sigma;&tau;&#972;&sigmaf;</notr></td>
		<td>Eagle with Arrow</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_aql.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Delphinus, Del</notr></td>
		<td><notr>&Delta;&epsilon;&lambda;&phi;&#943;&sigmaf;</notr></td>
		<td>Dolphin <br /> In the Greek original (Aratos, ~300 BCE), there was no constellation Equuleus. The Farnese Globe (as well as the Mainz Globe and the Kugel Globe) depicts the Dolphin rather largely, covering the space of Equ. That is why I chose to follow this Aratean tradition also for the Leiden Aratea.</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_del.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Pegasus, Peg</notr></td>
		<td><notr>&#703;&#714;&Iota;&pi;&pi;&omicron;&sigmaf;</notr></td>
		<td>Pegasus (name of a winged horse; Latin), a Horse (Greek)</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_peg.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Andromeda, And</notr></td>
		<td><notr>&#702;&Alpha;&nu;&delta;&rho;&omicron;&mu;&#941;&delta;&alpha;</notr></td>
		<td>Princess Andromeda</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_and.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Triangulum, Tri</notr></td>
		<td><notr>&Tau;&rho;&#943;&gamma;&omega;&nu;&omicron;&sigmaf;</notr></td>
		<td>Triangle</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_tri.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Aries, Ari</notr></td>
		<td><notr>&Kappa;&rho;&iota;&#972;&sigmaf;</notr></td>
		<td>Ram<br />(jumping through a ring which is a symbol for the year; Roman new year was in spring).</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_ari.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Taurus, Tau</notr></td>
		<td><notr>&Tau;&alpha;&upsilon;&#771;&rho;&omicron;&sigmaf;</notr></td>
		<td>Bull</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_tau.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>M45, </notr>Pleiades</td>
		<td></td>
		<td>The Pleiades<br />or Seven Sisters</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_plei.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Gemini, Gem</notr></td>
		<td><notr>&Delta;&#943;&delta;&upsilon;&mu;&omicron;&iota;</notr></td>
		<td>Twins</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_gem.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cancer, Cnc</notr></td>
		<td><notr>&Kappa;&alpha;&rho;&kappa;&#943;&nu;&omicron;&sigmaf;</notr></td>
		<td>Cancer<br /><i>The cancer was lightened.</i></td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cnc.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Leo, Leo</notr></td>
		<td><notr>&Lambda;&#941;&omega;&nu;</notr></td>
		<td>Lion<br />mirrored depiction</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_leo.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Virgo, Vir</notr></td>
		<td><notr>&Pi;&alpha;&rho;&theta;&#941;&nu;&omicron;&sigmaf;</notr></td>
		<td>Young Lady<br />Apparently, the manuscript only contains one drawing for figures that are depicted twice: like Sagittarius is depicted as centaur and the constellation Centaur is missing, Andromeda is painted as young lady but the second young lady for the constellation of Virgo is missing.</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Libra, Lib</notr></td>
		<td><notr>&Chi;&eta;&lambda;&alpha;&#943;</notr></td>
		<td>Balance (Latin, since 1st century CE in Geminos and Manilius; transferred in a style epoch of Babylonian revival),
		<br />Claws [of the Scorpion] (Greek)<br />The claws of the Scorpion indeed to cover this area.</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Ophiuchus et Serpens, Scorpius,<br />Oph + Ser </notr>and<notr> Sco</notr></td>
		<td><notr>&#702;&Omicron;&phi;&iota;&omicron;&#973;&chi;&omicron;&sigmaf;, &#702;&#714;&Omicron;&phi;&iota;&sigmaf; </notr>and<notr> &Sigma;&kappa;&omicron;&rho;&pi;&#943;&omicron;&sigmaf;</notr></td>
		<td>Snake Carrier and Scorpion (both in the zodiac ever since)<br />mirrored depiction</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_oph.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Sagittarius, Sgr</notr></td>
		<td><notr>&Tau;&omicron;&xi;&#972;&tau;&eta;&sigmaf;</notr></td>
		<td>Archer</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_sgr.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Capricornus, Cap</notr></td>
		<td><notr>&Alpha;&#943;&gamma;&#972;&kappa;&epsilon;&rho;&omicron;&sigmaf;</notr></td>
		<td>The Goat-Horned One</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cap.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Aquarius, Aqr</notr></td>
		<td><notr>&#703;&Upsilon;&delta;&rho;&omicron;&chi;&#972;&omicron;&sigmaf;</notr></td>
		<td>Water Pourer<br />mirrored depiction (although front view)</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_aqr.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Pisces, Psc</notr></td>
		<td><notr>&#702;&Iota;&chi;&theta;&#973;&epsilon;&sigmaf;</notr></td>
		<td>Fishes</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_psc.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cetus, Cet</notr></td>
		<td><notr>&Kappa;&eta;&#771;&tau;&omicron;&sigmaf;</notr></td>
		<td>a Sea Monster named Cetus</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cet.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Orion, Ori</notr></td>
		<td><notr>&#702;&Omega;&rho;&#943;&omega;&nu;</notr></td>
		<td>Orion<br /><i>mirrored depiction</i><br />The Hare in this depiction had been deleted and replaced by the Hare from his own single-page painting.</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_ori.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Eridanus, Eri</notr></td>
		<td><notr>&Pi;&omicron;&tau;&alpha;&mu;&#972;&sigmaf;</notr></td>
		<td>the river Eridanus (Latin), an unnamed River (Greek);<br />here a river god is depicted</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_eri.jpg"/></td>
	</tr>
	<tr>
		<td><notr>Lepus, Lep</notr></td>
		<td><notr>&Lambda;&alpha;&gamma;&omega;&#771;&sigmaf;</notr></td>
		<td>Hare<br /><i>shown twice: once between Orion's legs, once separately; for the visualisation we have removed the hare between Orion's legs. The separately illustrated hare runs in the direction of writing, but the hare between Orion's legs runs in the direction of the true course of the sun. The constellation figure should therefore be thought of as mirrored in relation to the illustration in the book: this can be seen in the sketch of the hare between Orion's legs.</i></td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_lep.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Canis Maior, CMa</notr></td>
		<td><notr>&Kappa;&#973;&omega;&nu;</notr></td>
		<td>Dog<br />mirrored depiction of a little dog</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cma.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Canis Minor (Procyon), CMi</notr></td>
		<td><notr>&Pi;&rho;&omicron;&kappa;&#973;&omega;&nu;</notr></td>
		<td>The star in front of the dog <br /> mirrored depiction<br />(an asterism of three stars forming a small dog is already mentioned by Eratosthenes, but the name of the figure was always "Prokyon"). Procyon is a Greek term (with "k") latinized.</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_cmi.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Argo, Arg</notr></td>
		<td><notr>&#702;&Alpha;&rho;&gamma;&omega;</notr></td>
		<td>Ship &quot;Argo&quot;<br />mirrored depiction</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_arg.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Hydra, Crater, Corvus<br />Hya, Crt, Crv</notr></td>
		<td><notr>&#703;&#714;&Upsilon;&delta;&rho;&omicron;&sigmaf;, &Kappa;&rho;&alpha;&tau;&#942;&rho;, &Kappa;&oacute;&rho;&alpha;&xi;</notr></td>
		<td>Water Snake, a particular vessel (crater), Raven</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_hya.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Centaurus, Cen</notr></td>
		<td><notr>&Kappa;&#941;&nu;&tau;&alpha;&upsilon;&rho;&omicron;&sigmaf;</notr></td>
		<td>Kentauros<br />apparently the constellations that are double have been painted only once: Sagittarius is depicted as centaur in the manuscript, the constellation Centaurus (a centaur with a sacrificial animal) is not depicted<br />(likewise, Andromeda is depicted but not Virgo)</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Lupus, Lup</notr></td>
		<td><notr>&Theta;&eta;&rho;&#943;&omicron;&nu;</notr></td>
		<td>monster<br />(in the Greek original (Aratos, ~300 BCE), Lupus is not a standalone constellation but a composite of the constellation of Centaurus that is missing here).</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Ara, Ara</notr></td>
		<td><notr>&Theta;&upsilon;&mu;&iota;&alpha;&tau;&#942;&rho;&iota;&omicron;&nu;</notr></td>
		<td>Altar</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_ara.jpg"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Corona Australis, CrA</notr></td>
		<td><notr>&Sigma;&tau;&#941;&phi;&alpha;&nu;&omicron;&sigmaf; &Nu;&#972;&tau;&iota;&omicron;&sigmaf;</notr></td>
		<td>Southern Crown (Latin), Southern Wreath (Greek)</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Piscis Austrinus, PsA</notr></td>
		<td><notr>&Nu;&#972;&tau;&iota;&omicron;&sigmaf; &#702;&Iota;&chi;&theta;&#973;&sigmaf;</notr></td>
		<td>Southern Fish<br />(had been "Great Fish" for Eratosthenes and Aratus in Greek)<br />It is so darkly drawn here that you would not recognise it in the stars. That is why the colours have been dipped into a blue-green scheme instead of the original red-purple one.</td>
		<td><img width="255" src="illustrations/descr_pics/aratea_small_psA.jpg"/></td>
	</tr>
</table>
</p>

## References

 - [#1]: Blume, Dieter; Haffner, Mechthild; Metzger, Wolfgang: Sternbilder des Mittelalters und der Renaissance: Porträts aus der Geschichte der Leibnizschen Wissenschaftsakademie, Band I-II, de Gruyter, 2012-2016
 - [#2]: Dekker, Elly: The Provenance of the Stars in the Leiden Aratea Picture Book, Journal of the Warburg and Courtauld Institutes Vol. 73 (2010), pp. 1-37
 - [#3]: Katzenstein, Ranee and Savage-Smith, Emily: The Leiden Aratea &mdash; Ancient Constellations in a medieval manuscript, The Paul Getty Museum, Malibu California, 1988
 - [#4]: Heiberg, J. L. (Ed.): Claudii Ptolemaei: Syntaxis Mathematica, Teubner, Leipzig, 1898
 - [#5]: Hoffmann, S. M.: Hipparchs Himmelsglobus, Springer, Wiesbaden/ New York, 2017
 - [#6]: Toomer, G. J.: Ptolemy's Almagest, Duckworth, London, 1984

## Authors

This sky culture was added to Stellarium by Susanne M. Hoffmann (service@uhura-uraniae.com) and originally created in collaboration with Prof. Dr. Dieter Blume (Art History, FSU Jena, Germany) for Planetarium Jena.

Written in English: the authors

### Fair Use

We provide this sky culture free of charge, but the authors deserve to be cited according to the usual rules. Thank you!

## License

CC BY-ND 4.0
