# Modern

## Introduction

The modern sky culture is used internationally by modern astronomers, and is the official scheme of The International Astronomical Union. It has historical roots in Ancient Greek astronomy, with influences from Islamic astronomy.

## Description

The modern sky culture divides the celestial sphere into 88 areas of various sizes called constellations, each with precise boundary, issued by the International Astronomical Union in 1922. These constellations have become the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

The constellations in use today are based mainly on ancient Greek constellations depicted by Ptolemy in his book the Almagest during the 2nd century CE. In the subsequent centuries, this book has been translated from Greek into Arabic (6th to 9th century) and later to medieval Latin. In the Arabic more than in the Latin tradition, the Ptolemaic figures were enriched and transformed by native Arabic constellations and star names.

In the 16-18th centuries, European astronomers suggested new constellations to fill the gaps between northern constellations (e.g. the constellation of "the lynx" for an area close to the Great Bear but with stars so faint that you would need the eyes of a lynx to see them) and also created new constellations in the southern part of the sky which had not been visible to Ptolemy. These new constellations were usually named after new technical inventions of the early modern period (e.g. a chemical furnace, a balloon, an air pump) or exotic animals (e.g. a chamaeleon, a tucan, a paradise bird). Among them several constellations were also named with political consideration to honor certain kings or patrons.

In the beginning of the 20th century, the IAU (International Astronomical Union) aimed for a large clean-up: in 1922, it officially accepted the list of 88 constellation names. In 1928 it also defined precise constellation boundaries [#40] still in use today.

### Extras

In the 2nd century CE, Ptolemy in Alexandria published a multi-volume book which summarised the astronomical knowledge of the time, rooted in a tradition of mathematical astronomy since Hipparchus (at least 265 years earlier). In the subsequent centuries, this book has been translated from Greek into Arabic (6th to 9th century), from Arabic into Latin, and later, from the original ancient Greek into medieval Latin. Due to this transformation, it is now known under the artificial name Almagest, derived from the Arabic title [#46].

The Almagest star catalogue (books VII and VIII) has been depicted many times in the Islamic as well as in the Christian astronomical traditions. Often, the figures were re-drawn in order to adapt them to the taste of art of the epoch. In the Arabic more than in the Latin tradition, the Ptolemaic figures were enriched and transformed by native Arabic constellations and star names. Therefore, this sky culture displays a modern descendant of the Ptolemaic one with traces of translations, misunderstandings, transformations, and deliberate additions.

In 1603 the lawyer and hobby astronomer Johann Bayer from Augsburg, Germany, made a new celestial atlas, called Uranometria [#41]. In this atlas, he introduced a systematic naming of stars starting with alpha, the brightest, beta, the second brightest, gamma, the third ... within a constellation. Subsequently, it was established to name a star with a Greek letter and the Latin constellation name in casus genitive.

In the 18th century, the century of great atlases (Flamsteed, Fortin, Bode: [#42][#43]), new constellations were added to fill the gaps between northern constellations. Additionally, there were suggestions to create new constellations in the southern part of the sky which had not been visible to Ptolemy. European astronomers visited the European colonies and instead of asking the native people for their constellations, the Europeans were creative. This way, many new technical inventions of the early modern period were depicted in constellations (e.g. a chemical furnace, a balloon, an air pump) as well as exotic animals (e.g. a chamaeleon, a tucan, a paradise bird).

The problem was that sometimes astronomers did not agree with each other and, thus, atlases showed deviations from each other.

After many centuries of astronomers taking liberties in interpretation of the Ptolemaic original, there were many variants of constellations. As constellations are a positioning system, i.e. astronomers describe positions in the sky relative to stars and stars relative to constellations (like "Betelgeuse", Orion's right shoulder), it is necessary to use constellation names and star names uniformly all over the world.

In the "Fin de siècle", there were upcoming suggestions in the astronomical community to unify the system of constellations and star names [#44].

The IAU, only founded in 1919, in 1928 defined the boundaries of these areas [#43] and not the way of drawing artwork or connecting lines within them. Consequently several sub-cultures of painting figures and drawing simplified stickfigures were developed during the 20th and 21st century. We provide some of them as further sky cultures.

### Constellations

These constellations are based mainly on the Ptolemaic tradition which had been used in all three Abrahamitic religions and, thus, was common in the Near East, in Europe and its colonies on all continents. However, between the ancient Greek constellations there were gaps of areas with only faint stars belonging to no constellation.[#47] In the Modern Epoch, several astronomers suggested constellation figures for these gaps, among them several political constellations to the honor of certain kings or patrons. In the late 19th century, the astronomical research community aimed for a huge clean-up to avoid ambiguities in assigning stars to constellations.

In 1922, the IAU officially approved the list of 88 constellation names and their official abbreviations with three letters. The only remaining political constellation is Scutum, the shield of a Polish king but without mentioning the political reference anymore. The Belgian priest E. Delporte got the task to define constellation boundaries according to coordinates. In 1928, he finished the work, based on an atlas from Argentina [#51], and the IAU accepted his delimitations [#40].

These "constellations" are naked areas in the sky without any stick figures or depictions [#44]. The borders simply follow the lines of right ascension and declination from the epoch 1875.0. Precession causes a slowly increasing deviation from the originally rectilinear grid. These constellations became the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

Stellarium by default displays the precise RA-DEC-boundaries and a set of artwork constellations on the basis of Ptolemaic figures but following our contemporary taste of art.

### Asterisms

The term "asterism" (assembly of stars) can sometimes be used synonymously to "constellation". In the modern use it describes a figure which is not part of the official canon. Sometimes an asterism is a part of a constellation, e.g. the Big Dipper as part of Ursa Major, or Great Square as part of Pegasus. Other asterisms span over several constellations, e.g. the Summer Triangle or Winter Hexagon. Yet others are only visible in binoculars or telescopes and are aptly named "telescopic asterism", e.g. the Coathanger. They are often discussed in the observing columns of popular astronomy magazines.

### Ray Helpers

Seasoned observers can find their way around the sky easily. One mnemonic tool are associative chains of stars that span large distances. We show them as "ray helpers". These are not standardized.

### Proper names of stars

Ptolemy's star catalogue had the layout of a table listing the description of the star's position in the constellation's figure, the ecliptical coordinates, and the magnitude e.g.: "The star at the tip of the tail of Ursa Minor", "Gem 0 1/6, +66", "Mag 3".

In most cases, the star names evolved by astronomer's systematical abbreviations of these descriptions, e.g., a first astronomer abbreviated in a text "tip of the tail", a next astronomer drew a map with less space and wrote only "tail" next to the star and this name remained. Over centuries, these descriptions were translated into Arabic and Latin, and in some cases the translators or scribes made mistakes because of misreading or misspelling of the Arabic words (e.g. the Arabic "yad al gauza", the hand of the giant woman, was mangled to the common term "Betelgeuse").

However, there are also a few original Greek words like the red star "Antares", the counterpart of Ares (Mars), and even a few original Babylonian terms like "Shargaz", the Sting, in Scorpius. Our modern, most recent IAU star names [#45] are a renewed mixture, also with influences or even politically wanted additions of star names from the non-Ptolemaic sky cultures, e.g. the traditional Pingsing, a Chinese star name for a star in Hydra (its meaning is only "star", a reminescence to his lonely position), or newly adopted star names from Polynesian, Hawaiian, or Aboriginal cultures for names of stars with exoplanets.

The IAU is the only scientifically accepted authority to assign new names to stars. Commercial exploits like "star name registries", who sell stars for commemorative purposes or as gifts, only sell printed pieces of paper. These names are not approved and never used by scientists.

## Constellations

##### Andromeda

Princess Andromeda, daughter of Queen Cassiopeia and King Kepheus, was chained to a rock on the coast of Ethiopia to prepare her as sacrifice to Cetus, the Sea Monster. She was rescued by Perseus.  

In this constellation you find the nearest large galaxy, the Great Andromeda Galaxy. It is barely visible with the unaided eye in a dark rural sky. 

##### Cassiopeia

Shown as the Seated Queen, Cassiopeia had boasted about her beauty, so much as to enrage Poseidon. The latter sent the sea monster Cetus which ravaged the coast of Ethiopia. An oracle promised Cetus would only go away when Princess Andromeda would be sacrificed to Cetus. 

##### Cepheus

King Kepheus of Ethiopia was husband of Cassiopeia and father of Andromeda. After his wife had enraged Poseidon, he had to order that his daughter, Princess Andromeda, should be sacrificed to Cetus, the sea monster. 

##### Whale

The Sea Monster, also called Whale, was sent by Poseidon to punish Ethiopia for the heresy of Cassiopeia. It was finally killed by Perseus.

##### Pegasus

The Winged Horse carried Perseus on his way to rescue Princess Andromeda from being sacrificed to Cetus. 

##### Little Horse

_Equuleus_, the Little Horse, is actually only a horse head and represents the foal Celeris, offspring or brother of the larger horse, Pegasus. It is seen next to the head of Pegasus. 

##### Perseus

The hero Perseus came in flying on Pegasus to rescue Andromeda from being sacrificed. In his hand he carries Medusa's head with the variable star Algol, which he presented to the sea monster Cetus just as it was about to devour Andromeda. Its magic caused Cetus to immediately turn to a rock. Before freeing Andromeda from her chains, he dropped the sack with Medusa's head to the beach. When the surf opened the sack, nearby algae were petrified into corals.

##### Orion

The famous hunter Orion was killed by a Scorpion, but was transferred into one of the most prominent constellations, notably just opposite of Scorpius. He is accompanied by the Greater and Lesser Dogs.  

Orion is host of one of the most spectacular star-forming regions, the Great Orion Nebula, Messier 42.

##### Greater Dog

The Greater Dog is one of Orion's hunting companions. Its main star, *Sirius*, is the brightest of the fixed stars.

##### Lesser Dog

The Lesser Dog is one of Orion's hunting companions. 

##### Hare

_Lepus_, the hare, is hiding just below the hunter Orion.

##### Charioteer

_Auriga_, the charioteer, was born with crippled legs. He invented the wheel and built his wagon to overcome his handicap. Its main star, *Capella*, represents a goat which accompanies him. 

In this constellation you can find a nice selection of open star clusters.

##### Great Bear

_Ursa Major_, the Great Bear, represents Callisto. Once a beautiful nymph, she was seduced by Zeus. His wife Hera was enraged and converted her into a bear. Zeus could not change that, but he could raise her to the stars. But again, Hera interfered so that the Bear could not take a bath in the Okeanos. This means, from ancient Greece the constellation was circumpolar, always above the horizon. Meanwhile, precession allows the Bear to at least submerge her feet in the sea. The seven brightest stars are called the Plough or Big Dipper in English but have other names in other cultures. 

Ursa Major contains a few nice galaxies for small telescopes. 

##### Lesser Bear

_Ursa Minor_, the Lesser Bear may be Arkas, son of Callisto, who is commemorated as Greater Bear and who was likewise placed into the sky by Zeus. Another myth commemorates two bears who saved the infant Zeus from his father Kronos. When he later placed them in the sky, he flung them up by their tails, explaining these unnaturally long bear tails.

Its most prominent object is Polaris, the Pole Star. In our era, it is less than a degree from the pole which makes it a very important navigational aid, but, due to precession, in antiquity there was no bright star right on the celestial pole. 

##### Dragon

Greek mythology names several dragons. Eratosthenes identifies _Draco_ as Ladon, the snake-like dragon which protected the golden apples in the garden of the Hesperides. It was killed by Hercules who can be seen stepping on the dragon's head.

The constellation winds around the Northern Ecliptical Pole, close to which we can observe a planetary nebula, the Cat's Eye. The star alpha Draconis, or *Thuban*, was closest to the Northern Celestial Pole when the Egyptians built their pyramids, and could have acted as their polar star. 

##### Hercules

Hercules, or the Kneeler, was a Greek hero, a son of Zeus with Alkmene. When his half-sister Athena tried to put him on Hera's breast, his biting caused Hera to push him away, and Hera's milk spilled all over the sky, creating the Milky Way. Hercules had to fulfill 12 major labours and countless other fights and adventures.  In the northern sky, he is actually upside-down, with his head, *Ras Algethi* next to the head of Ophiuchus, *Rasalhague*, and he is seen to trample on the head of Draco, the dragon. 

Hercules hosts the magnificent globular cluster Messier 13, and a smaller one, Messier 92.

##### Serpent Bearer

The Serpent Bearer, _Ophiuchus_, also called _Serpentarius_, resembles a man holding Serpens, the snake, in his hands. He is standing on Scorpius, and with his legs he is in fact crossing the ecliptic. Some people therefore call it the 13th zodiacal constellation, but the Zodiac still only has 12 signs, for practical purposes of it being just a coordinate system. His head, *Rasalhague*, is adjacent to the head of Hercules, *Ras Algethi*. 

##### Serpent

The Serpent is the only constellation which nowadays comes in two parts, the serpent's head and tail. Its central part is held by Ophiuchus, the Serpent Bearer, and therefore those stars are counted belonging to that constellation. 

##### Boötes

This figure is described either as cow shepherd moving behind the seven oxen (*septemtriones*) according to the Romans, or in Greek tradition of *Arktophylax*, as figure related to the Greater Bear. Ptolemy described its brightest star, *Arcturus*, as not belonging to the actual shape but as bright star lying between his knees. Starting with the atlas of Polish astronomer Jan Hevelius in the 17th century, Boötes leads the Hunting Dogs on leashes. 

##### Hunting Dogs

The Hunting Dogs were introduced by Polish astronomer Jan Hevelius. In his atlas from 1687 he shows the dogs on a leash in the hands of Boötes, the Herdsman, maybe to chase the Greater Bear. 

The dim constellation hosts the magnificent Whirlpool Galaxy, Messier 51, and several other galaxies for small telescopes, and the bright globular cluster M3.

##### Triangle

The Triangle has been associated with a lot of things, like the Greek uppercase letter Delta, the Nile delta, or the Island of Sicily.

_Triangulum_ hosts one of the closest and brightest galaxies, Messier 33, called the Pinwheel.

##### Ram

_Aries_, the Ram, is the first of the twelve constellations of the Zodiac which mark the area of the apparent paths of the Sun, Moon and the planets. When the Zodiac system was invented, the stars stood roughly within the respective signs. Over two thousand years of precessional movement along the ecliptic has caused a shift which moved the actual star figures about one full sign further towards the east. 

##### Bull

_Taurus_, the front part of a bull, is one of the most conspicuous figures of the zodiac. The wide open star cluster of the Hyades form the V-shaped head with the red eye (which is itself not a member of the Hyades cluster), and the ends of two long horns are marked by moderately bright stars. On its back, the most famous of all open star clusters, the Pleiades, can be seen. Although named the Seven Sisters, most observers can see six or eight stars. The Hyades and Pleiades form the Golden Gate of the Ecliptic, through which all planets, the Sun and Moon usually pass. Occasionally, the Moon can occult the Pleiades. 

Taurus may have already been known to Paleolithic Europeans. A Cave painting in Lasceaux shows an Aurochs with a cluster of stars in its back. 

##### Twins

The zodiacal constellation of _Gemini_, the Twins, commemorates Kastor and Polydeukes, or Castor and Pollux. Queen Leda of Sparta gave birth to uneven twins, Castor fathered by her husband, King Tyndareos, and Polydeukes allegedly fathered by Zeus who had approached her in the shape of a beautiful swan, which made only Polydeukes immortal. The otherwise inseparable twins joined Hercules on Jason's voyage on the ship Argo. Castor was fatally wounded in a battle. Polydeukes pled to his divine father to let him die with his brother. Instead, Zeus placed both into the sky, where they jointly can be seen immortalized in the sky or go below the horizon into the underworld. 

Gemini is host to a fine open cluster (M35) and the Eskimo planetary nebula.

##### Crab

The zodiacal constellation of _Cancer_, the crab, used to stand along the northernmost part of the ecliptic which defines the Tropic of Cancer. Precession has meanwhile moved it a full sign to the east. 

When Hercules was wrestling the Lernaean Hydra, the Crab appeared and bit him in the foot. Hercules killed it, but Hera, always opposing Hercules, placed it among the stars. 

As an aquatic animal, Cancer consists of only dim stars, but is host to a nice naked-eye open star cluster called Praesepe, the manger. Two dim stars resemble the northern and southern donkeys eating from it.

##### Lion

The lion, or _Leo_, is a large and conspicuous zodiacal constellation that was already known to the Babylonians. The Greeks identified it with the Nemean Lion which was killed by Hercules. 

Two trapezoids form body and head. Its main star, *Regulus* lies almost on the ecliptic. Leo is host to five fine Messier and several more galaxies. 

##### Bernice's Hair

Over the tuft of the Lion's tail we can see a loose cluster of dim stars. Ptolemy has described this as one of two asterisms added to his traditional 48 constellations. _Coma Berenices_ represents the Hair of Berenike II, consort of Ptolemy III Euergetes, which she had sacrificed for a safe return of her husband from war. It is the only constellation commemorating a historical person. 

The stars of Coma are indeed a loose open star cluster, and far behind, in the border region to Virgo, lies a region very rich in galaxies.  

##### Lesser Lion

17th-century Polish astronomer Jan Hevelius filled several almost empty regions between classical constellations with new figures in his atlas. _Leo Minor_, the Lesser Lion, was one of them, residing between Leo and Ursa Major.

##### Maiden

The large zodiacal constellation of _Virgo_, the Maiden, spans more than one and a half zodiacal signs. Since the times of her Babylonian origins, she is associated with fertility and holds an ear of grain in her hand, marked by its brightest star *Spica*. 

There are plenty of Messier Galaxies and many dimmer ones in the Virgo galaxy cluster and more generally the Virgo-Coma area. 

##### Scales

The scales were known to Babylonian astronomy. The same stars were also seen as the claws of the Scorpion, which was the dominant interpretation in Greek antiquity. Later, the Romans re-established the scales as own constellation, commemorating the scales of Astraea, goddess of justice. 

The autumnal equinox point is called First Point of Libra, but this refers to the Zodiacal Sign. This point nowadays is near the head of Virgo.

##### Scorpion

When Orion boasted to Artemis that he could kill every animal on earth, she sent the scorpion to kill Orion. Both were raised to the stars by Zeus and placed on opposite sides of the sky. 

The constellation's brightest star is *Antares*, the "counter-Mars", named after its reddish color. A fan of stars radiating towards the west further extend towards the scales which used to be its claws, and a long curved tail extends towards the south-east, ending in a conspicuous sting.

Scorpius is host to a few fine globular clusters, M4 and M80, and several open star clusters. It covers some of the brightest parts of the Milky Way.

##### Archer

_Sagittarius_, the Archer, is commonly depicted as centaur, half-man and half-horse. 

The Archer lies around the center of the Milky Way, therefore this area is rich with open and globular star clusters, bright and dark clouds. The bright Messier objects M8 (the Lagoon Nebula), M17 (the Omega Nebula) or M20 (the Trifid Nebula) are always worth a look, but there are more. 

##### Capricornus

The Sea-Goat constellation is of Babylonian origin and is depicted, as the name says, as "having horns like a goat", with the back of the body in shape of a fish tail. In antiquity it used to stand along the southernmost part of the ecliptic which defines the Tropic of Capricorn. Precession has meanwhile moved the stars a full sign to the east, so that the Zodiacal First point of Capricorn lies near the western edge of the constellation of Sagittarius.

Capricornus includes one bright globular cluster, Messier 30. 

##### Water Bearer

_Aquarius_, the Water Bearer goes back to the Babylonian god Ea, bringer of fresh water. It is commonly depicted as man pouring water from a water jar which arches down into the mouth of the Southern Fish.

In 1846, Johann Galle discovered the planet Neptune close to where now we see the border to Capricornus.

The Water Bearer hosts three Messier objects: the two globular clusters M2 and M72, and the open cluster M73. 
In addition, it shows two prominent planetary nebulae: The large Helix Nebula, and much smaller Saturn nebula.

##### Fishes

The zodiacal constellation of _Pisces_, the Fishes, is located around where the Sun is on March equinox, the beginning of spring in the Northern hemisphere, a point commonly named the First Point of Aries. Since the time the Zodiac was defined as coordinate system of twelve zodiacal signs, the name-giving constellations have moved one full sign to the west by the precession of earth's axis. 

The two fishes are connected by a band of Babylonian origin. According to Hyginus, Aphrodite and Eros fled from the monster Typhon, jumped into the Euphrates river and were transformed into fishes. Ovid tells a similar story around their Roman counterparts, Venus and Cupid, who were not transformed, but saved by riding on the backs of two helpful fishes. In both stories the fishes are then placed into the sky, the band expressing their connectedness. 

The Fishes can be seen as two ovals of dim stars with a large V-shaped band knotted near the neck of Cetus. Its deep-sky highlight certainly is Messier 74, the Phantom Galaxy. 

##### Water Snake

_Hydra_, the Water Snake, is the largest of all constellations. Its origins go back to Babylonian times. The Greek mythology knows a story where Corvus, the Crow, was sent out with the Crater (the Cup) to fetch water for Apollo. The crow was distracted by a fig tree, the fruits of which it wanted to eat. When it finally returned, it brought a snake from the well, claiming it was the cause of the delay. Apollo, discovering the lie, threw Corvus, the Crater and Hydra into the sky.

Hydra hosts three Messier objects: the Southern Pinwheel galaxy (M83), a globular cluster nearby (M68) and the open cluster M48. Furthermore, there is the Ghost of Jupiter planetary nebula, and many fainter galaxies.

##### Cup

This is the cup, or _crater_, which was handed to Corvus, the crow, by Apollo to fetch water. When the crow finally returned with an excuse that a water snake caused its delay, Apollo did not believe the story and flung all three, Corvus, Crater and Hydra into the sky. 

##### Crow

_Corvus_, the crow, was sent out by Apollo to fetch water with Crater, the cup. When the crow finally returned with an excuse that a water snake caused its delay, Apollo did not believe the story and flung all three, Corvus, Crater and Hydra into the sky, arranging them so that the crow could not drink from the cup. 

##### Northern Crown

The Northern Crown, or _Corona Borealis_, commemorates the crest or similar bridal adornment of Ariadne, it was originally not a solid golden king's crown as shown here.  In one version of the legend, Dionysos gave a wreath to Ariadne, daughter of King Minos of Crete, who handed it over to Theseus as he went into the labyrinth to kill the Minotaur, and the wreath's light helped Theseus finding the way out again. Theseus took Ariadne to Naxos but abandoned her. Dionysos found and married her, throwing her bridal crown into the heavens.

The Northern Crown features interesting variable stars: the cataclysmic variable T Coronae Borealis and the prototype R Coronae Borealis which occasionally drops by many magnitude in brightness, obscured by its own dust clouds.

##### Southern Crown

The Southern Crown, or _Corona Australis_, should be seen more as wreath than as crown. It may belong to either Sagittarius or Centaurus. It can be seen as distinct ring of faint stars south of the "Teapot" asterism of Sagittarius.

##### Eagle

Aquila is the Eagle which carried the thunderbolts of Zeus and was sent out to bring the pretty boy Ganymede to the Olymp to serve as cupbearer. In another context Ptolemy placed Antinoos, the deceased favourite of emperor Hadrian, among the stars beside the eagle. For the Romans it was _Vultur volans_, the flying vulture, as opposed to _vultur cadens_, their interpretation of Lyra.

The main star, *Altair*, is one star of the famous Summer Triangle asterism, together with *Vega* in Lyra and *Deneb* in Cygnus. 

The Pioneer 11 space probe is heading towards &lambda; Aquilae, but don't hold your breath - it is expected to pass the star in about 4 million years. 

##### Lyre

According to Greek mythology, the young god Hermes stole a herd of Apollo's sacred cows. From a hollowed-out turtle shell and cow gut, he created the first _lyra_ which he gave to Apollo in compensation for the theft. The Greeks saw the constellation as commemorating the lyre of Orpheus, the famous singer. Later, the Roman author Hyginus saw the lyre of Theseus and connected it to nearby Hercules. Romans also saw _vultur cadens_ or the falling vulture, in contrast to _vultur volans_, our Aquila or Eagle.

The brightest star *Vega* is of magnitude 0.0. It is one star of the famous Summer Triangle asterism, together with *Altair* in Aquila and *Deneb* in Cygnus.   The nearby star epsilon is the famous double-double star, two close double stars observable in one eyepiece field. On the other end of the lyre, the famous Ring Nebula (M57) can be seen. And don't forget to visit globular cluster M56.

##### Swan

_Cygnus_, The Swan, is a large and conspicuous constellation right in the northern Milky Way. Its central part is also called Northern Cross, but its outstretched wing ends show the elegant curve of a large flying bird with long neck. In Greek mythology, it can be interpreted as one of several swans, among them Zeus who disguised himself as swan to seduce Leda, who then gave birth to the Twins, or Orpheus, who was transformed into a swan after his murder and placed into the sky next to his instrument, the lyre. In another interpretation, the three birds, Cygnus, the flying eagle or vulture (Aquila) and falling eagle or vulture (Lyra) could represent the Stymphalian birds which nearby Hercules had to fight as one of his twelve labours.

The brightest star *Deneb* in its tail is one star of the famous Summer Triangle asterism, together with *Altair* in Aquila and *Vega* in Lyra. Deneb is one of the most luminous stars of its spectral class known. It is 2600 light years away. The Swan's head star, *Albireo* is a pretty color-contrast binary star, a bright orange star with a blue companion. &chi; Cygni is a Mira-type variable sometimes visible in the swan's neck.

With its position right in the Milky Way, Cygnus hosts a multitude of star clusters and bright and dark nebulae. Famous examples are the North America Nebula and the Veil supernova remnant. The Milky Way itself is seen to be split by the Cygnus Rift, a dark molecule cloud. 

##### Altar

The Altar with offerings in fire and smoke is usually depicted with the smoke going to the south.

The constellation lies along the Milky Way south of Scorpius and has rich star fields, including a large globular cluster. 

##### Dolphin

In a story told by Roman poet Ovid, the musician Arion was on a return voyage from a successful concert tour to Sicily and Italy. The crew of his ship envied his amassed fortunes and wanted to kill him. Arion was granted a last wish, and he started singing, then jumped into the sea where a dolphin had been attracted by his music. The dolphin brought him back to the shore, and was placed into the heavens with nine stars.

The dolphin, or _Delphinus_, is a small but conspicuous shape between Aquila and Cygnus. 

##### Eridanus

The large constellation of the river Eridanus flows from its origin near *Rigel* in a winding curve towards the south. When Phaethon, son of Helios, failed to control his father's Sun wagon, Zeus had to throw a thunderbolt and Phaethon plunged burning into the Eridanus river.

The brightest star *Archernar* is too far south to have been observed from the Mediterranean, so usually *Acamar* used to be the final observable star of the river. 

##### Arrow

The distinct Arrow, or _Sagitta_, is the third smallest constellation. It may be an arrow shot by Hercules against the Eagle devouring the liver of Prometheus, or against the Stymphalian birds (Cygnus, Aquila, Lyra).

Its deep-sky highlight is the globular cluster Messier 71.

##### Southern Fish

_Piscis Austrinus_, the Southern Fish, goes back to a Babylonian fish constellation. It may be parent to the two fishes of the zodiacal constellation of the Fishes. It is a mostly dim constellation. The only moderately bright star is *Fomalhaut*, the mouth of the fish, which is often drawn to swallow the water poured by Aquarius from his water jar. 

##### Keel

_Carina_, or the Keel of the Ship, is part of the antique constellation Argo, which commemorates the ship of Jason and the Argonauts who sailed to Kolchis in search of the Golden Fleece. 

In the 1750s, French astronomer Abbé Nicolas-Louis de la Caille proposed to break apart the huge Argo constellation and created three separate parts. The other parts are Vela, the sails, and Puppis, the stern. This decision was only finalized in 1930 when the International Astronomical Union decided about the official constellation borders.

Its brightest star, *Canopus*, is the second brightest fixed star and lies close to the south pole of the ecliptic, and therefore is an important navigational star for interplanetary spacecraft.

Three cross-like asterisms can be seen in Carina: The False Cross which in cloudy nights may have decepted navigators in search of the Southern Cross, the Diamond Cross, and the Shadow Cross. 

Carina lies along the Milky Way and therefore includes a multitude of deep-sky objects like star clusters and gas clouds. Most prominent is the region about eta Carinae, a star system with huge luminosity which from 1837 to the 1850s experienced a "Great Eruption", temporarily becoming the second-brightest star in the sky.  

To the south of it we find the Southern Pleiades open star cluster. 

##### Stern

_Puppis_, the stern of the ship, is the largest part of the former constellation Argo. The other parts are Carina, the keel, and Vela, the sails. The Argo took Jason and the Argonauts to Kolchis in search of the Golden Fleece.

Puppis lies along the Milky Way and contains several prominent open clusters. In the northern part we find three Messier clusters, M46, M47 and M93. The planetary nebula NGC2438 appears to lie inside M46, but is a foreground object.

##### Sails

_Vela_ are the sails of the former constellation Argo. The other parts are Carina, the keel, and Puppis, the stern. The Argo took Jason and the Argonauts to Kolchis in search of the Golden Fleece.

_Vela_ lies along the Milky Way and shows several intersting deep-sky objects. Most notably the Eight-Burst or Southern Ring Planetary Nebula, and the globular cluster NGC 3201.

##### Centaur

According to Roman poet Ovid, the figure commemorates the centaur Chiron who had instructed Hercules and several other heroes. Chiron was accidentally poisoned by an arrow shot by Hercules. 

Centaurus is a large and conspicuous figure. The bright stars alpha and beta Centauri are commonly named "Pointers" as they indicate the Southern Cross which in antiquity were seen as the Centaur's hind legs.  Alpha is the nearest bright star and actually a multiple star system. One component is even closer to the Sun but only visible in telescopes: Proxima Centauri. Its light takes only 4.3 years to reach us. 

The large constellation lies along the Milky Way and therefore contains many open and several globular star clusters, most notably the largest in the sky, Omega Centauri. 

##### Wolf

_Lupus_, the Wolf, used to be an unspecified wild animal against which Centaurus was fighting, or, alternatively, a wineskin. 

In 1006, Lupus was host to the brightest supernova in written history.

##### Southern Cross

Early European seafarers separated four conspicuous stars from the hind legs of Centaurus to form _Crux_, the Southern Cross. It was first published on a celestial globe from 1589 by Jacob van Langren and Petrus Plancius and was accepted as an important guide for navigation and also spiritual guidance.

##### Southern Triangle

The simple constellation of _Triangulum Australe_ was introduced by Dutch-Flemish cartographer Petrus Plancius on a celestial globe published by Jacob van Langren in 1589. 

##### Dove

The Dove has been introduced by Dutch-Flemish cartographer Petrus Plancius in the early 1590s next to the great ship Argo. It represents the Dove returning to Noah with an olive branch, showing the end of the deluge.

The constellation contains the Solar antapex, meaning the Solar system moves away from this direction.

##### Fly

Originally this was introduced as _Apis_, the Bee, by Petrus Plancius on a celestial globe from 1598. Abbé de la Caille renamed it to its current name _Musca_, the Fly.

##### Bird of Paradise

_Apus_, the Bird of Paradise, was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman.

##### Chameleon

A _chamaeleon_ was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman.

##### Swordfish

_Dorado_ was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. Usually translated as Goldfish, and later also named Swordfish, it was named after the Mahi-Mahi or dolphinfish, a predatory fish often hunting the Flying Fish that you can see nearby.  

##### Flying Fish

Early European seafarers reported swarms of fish flying out of the water to escape their predators. _Volans_, the Flying Fish, was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. It is a common prey of the Doradus, or Goldfish. Both can be seen near Carina, the ship's keel of the old constellation Argo. 

##### Crane

The Crane, or _Grus_, is one of the four "Southern Birds" introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. The others are the Peacock, Phoenix, and the Toucan.

##### Peacock

_Pavo_, the Peacock, is one of the four "Southern Birds" introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. The others are the Crane, Phoenix, and the Toucan.

##### Phoenix

The Phoenix is the largest of the four "Southern Birds" introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. The others are the Peacock, the Crane, and the Toucan.

##### Toucan

_Tucana_, the Toucan, is the smallest of the four "Southern Birds" introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. The others are the Peacock, Phoenix, and the Crane. Originating from a Dutch expedition to the East Indies, it actually shows a Hornbill, while the name was taken from the bird in the American Tropics.

##### Lesser Water Snake

_Hydrus_, the Male, or Lesser Water Snake, was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman. It seems to continue the wiggle line formed by the Eridanus river. A line connecting its brightest star, beta, and the Southern Cross can guide you to the Southern Celestial Pole.

##### Indian

The Indian, _Indus_, was introduced by Petrus Plancius on a celestial globe from 1598, based on observations by Pieter Dirkszoon Keyser and Frederick de Houtman made on a Dutch expedition to the Eastern Indies. It is therefore likely to show a native from the region called East India by the European discoverers, or South-Eastern Asia today. 

##### Giraffe

On a celestial globe from 1612, Flemish-Dutch cartographer Petrus Plancius introduced a few new constellations to fill the voids. One of them was this large but inconspicuous constellation of _Camelopardalis_, the Giraffe, between Ursa Major and Cassiopeia. 

##### Unicorn

The large but inconspicuous constellation of _Monoceros_, the Unicorn, between Orion and Canis Minor, made its first appearance on a celestial globe from 1612 by the Flemish-Dutch cartographer Petrus Plancius.

While it does not have bright stars, telescope owners will like to visit a few fine open star clusters, and especially the Rosette Nebula.

##### Lynx

The constellation of Lynx was introduced by Polish astronomer Jan Hevelius in the late 17th century. You need the eyes of a Lynx to see it.

##### Shield

_Scutum_, the constellation of the shield, was introduced by Polish astronomer Jan Hevelius in the late 17th century to pay homage to his king, Jan Sobieski. 

##### Fox

Originally introduced as the constellation of _Vulpecula cum Ansere_, the Fox with the Goose, by Polish astronomer Jan Hevelius in the 17th century, nowadays we only see the little fox here. 

It is host to the famous Dumbbell planetary nebula, M27, and the Coathanger asterism, both visible in binoculars. 

##### Lizard

The constellation of _Lacerta_, the Lizard, was introduced by Polish astronomer Jan Hevelius in the late 17th century. 

##### Sextant

Polish astronomer Jan Hevelius placed the _sextans_, one of his observational instruments, into the sky in his atlas of 1687. This was not the mirror sextant later used for marine navigation!

##### Air Pump

The Air Pump, a scientific development of the 17th century, was formed as constellation _Antlia Pneumatica_ by French astronomer-geodesist Abbé Nicolas-Louis de la Caille in the mid-18th century.

##### Engraving Tool

This dim and small constellation was introduced as _Caelum Sculptorium_ by French astronomer Abbé Nicolas-Louis de la Caille in the 1750s. It commemorates an engraver's chisel, an essential tool for mapmaking. 

##### Drawing Compass

French astronomer Abbé Nicolas-Louis de la Caille introduced _Circinus_, the Drawing Compass, to join Triangulum Australe and Norma as scientific instruments for geometrical construction.

##### Carpenter's Square

A carpenter's square, helpful to draw right angles was important enough for Abbé Nicolas-Louis de la Caille to depict it as _Norma_ among his new constellations on the southern hemisphere, adjacent to other draughtsman's tools, Triangulum Australe and Circinus. 

##### Furnace

_Fornax_, a chemical oven was one of the scientific instruments placed into the southern sky by French astronomer Abbé Nicolas-Louis de la Caille. 

With only five stars brighter than 5th magnitude, it is better known for its richness in galaxies. 

##### Clock

In 1756, French astronomer Abbé Nicolas-Louis de la Caille placed _Horologium_, a pendulum clock with seconds hand, among the stars. An accurate clock of this kind was an important scientific instrument of his era, the Age of Enlightenment. 

##### Microscope

French astronomer Abbé Nicolas-Louis de la Caille created 14 new constellations in the southern sky in which he mostly commemorated scientific instruments of his time, the mid-18th century. _Microscopium_, the Microscope, just south of Capricornus, consists of dim stars only. 

##### Telescope

Next to the Microscope, French astronomer Abbé Nicolas-Louis de la Caille placed _Telescopium_ in his mid-18th century maps which introduced 14 new constellations, mostly commemorating scientific instruments. In his own imagination it was a long-focal-length aerial telescope, but later the constellation was cut back to its present size. It has only seven stars brighter than magnitude 5.

##### Table Mountain

French astronomer Abbé Nicolas-Louis de la Caille observed the southern sky in the mid-18th century from the Cape of Good Hope. He commemorated the Table Mountain in his constellation of _Mensa_, which includes the Large Magellanic Clound resembling the cloud "table cloth" frequently forming around the top of the mountain.

##### Octant

The Octant was a tool for marine navigation, similar to the sextant, developed by John Hadley in 1730. In his series of constellations commemorating scientific instruments, French astronomer Abbé Nicolas-Louis de la Caille placed _Octans_ right next to the Southern Celestial Pole. It only shows dim stars. 

##### Painter's Easel

The full name of this constellation was _Equuleus Pictoris_, or the Painter's Easel, when French astronomer Abbé Nicolas-Louis de la Caille introduced it in the mid-18th century. The name was shortened to _Pictor_.

In 1983, the IRAS Infrared Astronomical Satellite discovered a debris disk around the star Beta Pictoris. Later observations even showed two disks and several exoplanets. 

##### Reticle

A constellation _Rhombus_ had already been introduced in the early 17th century. More than a century later, French astronomer Abbé Nicolas-Louis de la Caille changed it to the present constellation of _Reticulum_, again commemorating a scientific instrument. The rhomboidal reticle, or net, was a device placed in the eyepiece's focal plane to allow more precise measurements. 

##### Sculptor

French astronomer Abbé Nicolas-Louis de la Caille created the _Apparatus Sculptoris_, the sculptor's studio in the 1750s, later shortened to Sculptor. 

While the constellation only hosts dim stars, deep-sky observers will enjoy galaxies: The Sculptor Galaxy (NGC 253), NGC 55 or even the Sculptor Dwarf galaxy.

##### Mariner Compass

French astronomer Abbé Nicolas-Louis de la Caille created 14 new constellations in the southern sky in which he mostly commemorated scientific instruments of his time, the 18th century. _Pyxis_, the Mariner Compass, can be seen as a valuable addition to the old Ship Argo, which de la Caille has however broken up into three pieces: Carina (the keel), Vela (the sails), and Puppis (the stern). 

## References

 - [#1]: Kunitzsch, P.; Smart T. (2006). "A Dictionary of Modern star Names: A Short Guide to 254 Star Names and Their Derivations" (2nd rev. ed.). Cambridge, MA: Sky Pub. ISBN 978-1-931559-44-7.
 - [#2]: Allen, R. H. (1963). "Star Names: Their Lore and Meaning" (rep. ed.). New York, NY: Dover Publications Inc. ISBN 0-486-21079-0.
 - [#3]: [2000, A&AS, 143, 9, "The SIMBAD astronomical database", Wenger et al.](http://adsabs.harvard.edu/abs/2000A%26AS..143....9W)
 - [#4]: [Final Results of NameExoWorlds Public Vote Released](http://www.iau.org/news/pressreleases/detail/iau1514/)
 - [#5]: [STARS by Jim Kaler, Prof. Emeritus of Astronomy, University of Illinois](http://stars.astro.illinois.edu/sow/sowlist.html)
 - [#6]: [IAU Catalog of Star Names (IAU-CSN)](http://www.pas.rochester.edu/~emamajek/WGSN/IAU-CSN.txt)
 - [#7]: [Covington, Michael (2002). "Celestial Objects for Modern Telescopes: Practical Amateur Astronomy". Cambridge University Press.](https://books.google.com/books?id=ql7wLq1fP5QC&pg=PA209)
 - [#8]: ["61 Cyg (Piazzi's Flying Star)". Science&Space News. Retrieved June 1, 2015.](http://news.sky-map.org/starview?object_type=1&object_id=2282&object_name=HD+201091&locale=EN)
 - [#9]: [Kruger 60](https://en.wikipedia.org/wiki/Kruger_60)
 - [#10]: [List of Named Stars in Alphabetical Order](https://web.archive.org/web/20220701073320/http://www.astro.wisc.edu/~dolan/constellations/starname_list.html)
 - [#11]: [Jack W. Rhoads (1971). "Reduced Star Catalog Containing 537 Named Stars", Jet Propulsion Laboratory, California Institute of Technology; November 15, 1971](https://ntrs.nasa.gov/citations/19720005197)
 - [#12]: [IAU Naming Stars](https://www.iau.org/public/themes/naming_stars/)
 - [#13]: [Bright Star Catalogue, 5th Revised Ed. (Hoffleit+, 1991)](http://vizier.u-strasbg.fr/viz-bin/VizieR?-source=V/50)
 - [#14]: Piazzi, G, ed. (1814). "Praecipuarum Stellarum Inerrantium Positiones Mediae Ineunte Saeculo XIX: ex Observationibus Habitis in Specula Panormitana ab anno 1792 ad annum 1813". Palermo. p. 21.
 - [#15]: Kunitzsch, P. (1959). "Arabische Sternnamen in Europa". Wiesbaden: Otto Harrassowitz. p. 155.
 - [#16]: Laffitte, R. (2005). "Héritages arabes: Des noms arabes pour les étoiles" (2éme revue et corrigée ed.). Paris: Librairie Orientaliste Paul Geunthner / Les Cahiers de l'Orient. p. 229.
 - [#17]: Burritt, E. H. (1835). "Atlas, Designed to Illustrate the Geography of the Heavens" (new ed.). New York: F. J. Huntington. plate III.
 - [#18]: Burnham, Robert Jr. (1978, 1979). "Burnham's Celestial Handbook: An Observer's Guide to the Universe Beyond the Solar System", Vol. 1, 2, 3. NY: Dover Publications. ISBN 978-0486235677, 978-0486235684, 978-0486236735
 - [#19]: [Iota Ursae Majoris](https://en.wikipedia.org/wiki/Iota_Ursae_Majoris)
 - [#20]: [Falkner, David E. (2011). "The Mythology of the Night Sky: An Amateur Astronomer's Guide to the Ancient Greek and Roman Legends", Patrick Moore's Practical Astronomy, Springer. ISBN 1-4614-0136-4](https://books.google.com/books?id=tyj8UUE968wC)
 - [#21]: Peters, C. A. F. (1853). "On the Parallax of Argelander's Star". Monthly Notices of the Royal Astronomical Society, Vol. 14, p.49. DOI: 10.1093/mnras/14.2.49
 - [#22]: Maddocks, Hugh C. (1991). "Deep-Sky Name Index 2000.0". Foxon-Maddocks Associates. ISBN 0-9628305-0-X.
 - [#23]: Josef Klepesta, Antonin Rükl (1977). "Constellations: A concise guide in colour". ISBN 0600008932.
 - [#24]: Oswald Thomas (1945). "Atlas der Sternbilder". Das Bergland-Buch, Salzburg.
 - [#25]: Fred Schaaf (2019). "An Assortment of Asterisms". Sky & Telescope, p.45 (Nov 2019)
 - [#26]: Gary Seronik (2017). "Binocular Highlights Revised & Expanded: 109 Celestial Sights for Binocular Users". F W Publications Inc. ISBN 9781940038445
 - [#27]: Tony Flanders (2019). "Constellation Close-up: Centaurus and Crux". Sky & Telescope, pp.22-27 (Apr 2019).
 - [#28]: Sue French (2019). "Deep-Sky Wonders: Heavenly Hero". Sky & Telescope, pp.54-56 (Jul 2019).
 - [#29]: [Software Bisque: A Complete List of Asterisms](https://www.bisque.com/tom/asterisms/list.asp)
 - [#30]: [University of Northern Iowa, EARTHSCI 1100 - Astronomy, Asterisms.](https://sites.uni.edu/morgans/astro/asterisms.html)
 - [#31]: [Horvatin - Obsolete Constellations, Department of Physics and Astronomy, Michigan State University.](https://web.pa.msu.edu/people/horvatin/Astronomy_Facts/obsolete_pages/triangulum_minor.htm)
 - [#32]: [Donald H. Menzel (1964). A Field Guide to the Stars and Planets by Donald H. Menzel, Collins books - St. James's Place, London. ISBN: 0395934311, ISBN13: 9780395934319](http://www.arvindguptatoys.com/arvindgupta/menzel-fieldguide.pdf)
 - [#33]: [James B. (Jim) Kaler. Professor Emeritus of Astronomy, University of Illinois.](http://stars.astro.illinois.edu/sow/6tri.html)
 - [#34]: [Astronomy Club of Tulsa - Observer, December 2008.](http://www.astrotulsa.com/cms_files/200812.pdf)
 - [#35]: [Baylor University, School of Engineering and Computer Science, Astronomy observing log.](http://cs.baylor.edu/~hamerly/personal/astro/log.html)
 - [#36]: [IAU100 NameExoWorlds](http://nameexoworlds.iau.org/)
 - [#37]: [The Washington Double Star Catalog (Mason+ 2001-2020)](https://vizier.u-strasbg.fr/viz-bin/VizieR?-source=B/wds)
 - [#38]: [Patrick Moore, Paul Doherty, H. J. P. Arnold, The Photographic Atlas of the Stars, CRC Press LLC, 1999. ISBN 0750306548 (EXCLUDED (too many typos))](https://books.google.com/books?id=YjcvJUfnWBAC&pg=PA97#v=onepage&q&f=false)
 - [#39]: [Guy Consolmagno, Dan M. Davis, Turn Left at Orion, Cambridge University Press, 2019. ISBN 9781108558464](https://doi.org/10.1017/9781108558464)
 - [#40]: Delporte, Eugene (1930). "Delimitation scientifique des constellations (tables et cartes)". Cambridge.
 - [#41]: facsimile: Uranometria von Johannes Bayer, Kunstschätzeverlag, Gerchsheim, 2010
 - [#42]: facsimile: Die große Flamsteed Edition - Himmelskartographie nach John Flamsteed von 1776 bis 1805, Albireo Verlag, Köln, 2017
 - [#43]: Latußeck, Arndt and Hoffmann, Susanne M: "Ein nützliches Unternehmen", Albireo Verlag, Köln, 2017
 - [#44]: [Constellation english names. IAU Constellations Page](https://www.iau.org/public/themes/constellations/)
 - [#45]: [IAU Working Group Star Names. WGSN](https://www.iau.org/science/scientific_bodies/working_groups/280/)
 - [#46]: Grasshoff, Gerd: The History of Ptolemy's Star Catalogue, Springer, New York, 1990
 - [#47]: Hoffmann, Susanne M.: Hipparchs Himmelsglobus, Springer, Wiesbaden / New York, 2017
 - [#48]: [Constellation. Article on Wikipedia](http://en.wikipedia.org/wiki/Constellation)
 - [#49]: [Star Catalogue. Article on Wikipedia](http://en.wikipedia.org/wiki/Star_catalogue)
 - [#50]: [Constellation image library of the U.S. Naval Observatory and the Space Telescope Science Institute. Johannes Hevelius Engravings.](http://hubblesource.stsci.edu/sources/illustrations/constellations/)
 - [#51]: Santiago Paolantonio, Beatriz García (2019). "Uranometría Argentina and the constellation boundaries". Under One Sky: The IAU Centenary Symposium. Cambridge. p. 505.
 - [#52]: Meade Instruction Manual 7" LX200 Maksutov-Cassegrain Telescope; 8", 10", and 12" LX200 Schmidt-Cassegrain Telescopes
 - [#53]: [Mike Wall (2013). "Strange 'Methuselah' Star Looks Older Than the Universe". Space.com](https://www.space.com/20112-oldest-known-star-universe.html)
 - [#54]: [Space Telescope Science Institute (STScI). "Hubble finds 'birth certificate' of oldest known star." ScienceDaily. ScienceDaily, 7 March 2013](www.sciencedaily.com/releases/2013/03/130307145103.htm)
 - [#55]: [Atlas Coeli Skalnaté Pleso 1950.0](https://en.wikipedia.org/wiki/Skalnate_Pleso_Atlas_of_the_Heavens)
 - [#56]: [Karlseiche](https://de.wikipedia.org/wiki/Karlseiche)
 - [#57]: [Mural Quadrant](https://de.wikipedia.org/wiki/Mauerquadrant_(Sternbild))
 - [#58]: WAA/Alexander Pikhard. Own creation, 2001. https://www.waa.at/bericht/2001/06_sofiexp/20010612/bb20010612.html. 

## Authors

Stellarium's team

## License

Text and data: CC BY-SA 4.0

Illustrations: Free Art License
