/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.file.FileTypeHandlerDescriptor;

public class FileTypeHandlerRegistry {
    private static FileTypeHandlerRegistry instance = null;
    private final List<FileTypeHandlerDescriptor.Extension> extensions = new ArrayList<FileTypeHandlerDescriptor.Extension>();
    private final List<FileTypeHandlerDescriptor> handlers = new ArrayList<FileTypeHandlerDescriptor>();

    public static synchronized FileTypeHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new FileTypeHandlerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FileTypeHandlerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.fileTypeHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            FileTypeHandlerDescriptor formatterDescriptor = new FileTypeHandlerDescriptor(ext);
            this.handlers.add(formatterDescriptor);
            ++n2;
        }
        this.handlers.sort(Comparator.comparingInt(FileTypeHandlerDescriptor::getOrder));
        this.handlers.stream().map(FileTypeHandlerDescriptor::getExtensions).flatMap(Arrays::stream).forEach(this.extensions::add);
    }

    @NotNull
    public List<FileTypeHandlerDescriptor> getHandlers() {
        return this.handlers;
    }

    @Nullable
    public FileTypeHandlerDescriptor findHandler(String fileExtension) {
        FileTypeHandlerDescriptor.Extension extension = this.findExtension(fileExtension);
        if (extension != null) {
            return extension.getDescriptor();
        }
        return null;
    }

    @Nullable
    public FileTypeHandlerDescriptor.Extension findExtension(String fileExtension) {
        for (FileTypeHandlerDescriptor.Extension ext : this.extensions) {
            String[] stringArray = ext.getExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extName = stringArray[n2];
                if (fileExtension.equals(extName) || extName.equals("*")) {
                    return ext;
                }
                ++n2;
            }
        }
        return null;
    }
}

