/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetPresentation
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageResultSetPresentation.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.presentation";
    private Button autoSwitchMode;
    private Button showFiltersInSingleTabMode;
    private Button showDescription;
    private Button columnWidthByValue;
    private Button showConnectionName;
    private Button transformComplexTypes;
    private Button rightJustifyNumbers;
    private Button rightJustifyDateTime;
    private Button autoCompleteProposal;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.behavior.autoSwitchMode") || store.contains("resultset.behavior.showFiltersPanelInSingleTabMode") || store.contains("resultset.show.columnDescription") || store.contains("resultset.calc.columnWidthByValues") || store.contains("resultset.show.connectionName") || store.contains("resultset.transform.complex.type") || store.contains("resultset.show.rightJustifyNumbers") || store.contains("resultset.show.rightJustifyDateTime") || store.contains("resultset.behavior.autoCompleteProposial");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite uiGroup = UIUtils.createTitledComposite((Composite)composite, (String)DataEditorsMessages.pref_page_database_resultsets_group_common, (int)1);
        this.autoSwitchMode = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_switch_mode_on_rows, (boolean)false);
        this.showFiltersInSingleTabMode = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_filters_panel_in_singletab_mode, (boolean)true);
        this.showDescription = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_column_description, (boolean)false);
        this.columnWidthByValue = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_calc_column_width_by_values, (String)DataEditorsMessages.pref_page_database_resultsets_label_calc_column_width_by_values_tip, (boolean)false, (int)1);
        this.showConnectionName = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_connection_name, (boolean)false);
        this.transformComplexTypes = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_structurize_complex_types, (String)DataEditorsMessages.pref_page_database_resultsets_label_structurize_complex_types_tip, (boolean)false, (int)1);
        this.rightJustifyNumbers = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_right_justify_numbers_and_date, null, (boolean)false, (int)1);
        this.rightJustifyDateTime = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_right_justify_datetime, null, (boolean)false, (int)1);
        this.autoCompleteProposal = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_auto_completion, (String)DataEditorsMessages.pref_page_database_resultsets_label_auto_completion_tip, (boolean)true, (int)1);
        return composite;
    }

    protected void loadPreferences(@NotNull DBPPreferenceStore store) {
        try {
            this.autoSwitchMode.setSelection(store.getBoolean("resultset.behavior.autoSwitchMode"));
            this.showFiltersInSingleTabMode.setSelection(store.getBoolean("resultset.behavior.showFiltersPanelInSingleTabMode"));
            this.showDescription.setSelection(store.getBoolean("resultset.show.columnDescription"));
            this.columnWidthByValue.setSelection(store.getBoolean("resultset.calc.columnWidthByValues"));
            this.showConnectionName.setSelection(store.getBoolean("resultset.show.connectionName"));
            this.rightJustifyNumbers.setSelection(store.getBoolean("resultset.show.rightJustifyNumbers"));
            this.rightJustifyDateTime.setSelection(store.getBoolean("resultset.show.rightJustifyDateTime"));
            this.transformComplexTypes.setSelection(store.getBoolean("resultset.transform.complex.type"));
            this.autoCompleteProposal.setSelection(store.getBoolean("resultset.behavior.autoCompleteProposial"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(@NotNull DBPPreferenceStore store) {
        try {
            store.setValue("resultset.behavior.autoSwitchMode", this.autoSwitchMode.getSelection());
            store.setValue("resultset.behavior.showFiltersPanelInSingleTabMode", this.showFiltersInSingleTabMode.getSelection());
            store.setValue("resultset.show.columnDescription", this.showDescription.getSelection());
            store.setValue("resultset.calc.columnWidthByValues", this.columnWidthByValue.getSelection());
            store.setValue("resultset.show.connectionName", this.showConnectionName.getSelection());
            store.setValue("resultset.show.rightJustifyNumbers", this.rightJustifyNumbers.getSelection());
            store.setValue("resultset.show.rightJustifyDateTime", this.rightJustifyDateTime.getSelection());
            store.setValue("resultset.transform.complex.type", this.transformComplexTypes.getSelection());
            store.setValue("resultset.behavior.autoCompleteProposial", this.autoCompleteProposal.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.behavior.autoSwitchMode");
        store.setToDefault("resultset.behavior.showFiltersPanelInSingleTabMode");
        store.setToDefault("resultset.show.columnDescription");
        store.setToDefault("resultset.calc.columnWidthByValues");
        store.setToDefault("resultset.show.connectionName");
        store.setToDefault("resultset.show.rightJustifyNumbers");
        store.setToDefault("resultset.show.rightJustifyDateTime");
        store.setToDefault("resultset.transform.complex.type");
        store.setToDefault("resultset.behavior.autoCompleteProposial");
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.autoSwitchMode.setSelection(store.getDefaultBoolean("resultset.behavior.autoSwitchMode"));
        this.showFiltersInSingleTabMode.setSelection(store.getDefaultBoolean("resultset.behavior.showFiltersPanelInSingleTabMode"));
        this.showDescription.setSelection(store.getDefaultBoolean("resultset.show.columnDescription"));
        this.columnWidthByValue.setSelection(store.getDefaultBoolean("resultset.calc.columnWidthByValues"));
        this.showConnectionName.setSelection(store.getDefaultBoolean("resultset.show.connectionName"));
        this.transformComplexTypes.setSelection(store.getDefaultBoolean("resultset.transform.complex.type"));
        this.rightJustifyNumbers.setSelection(store.getDefaultBoolean("resultset.show.rightJustifyNumbers"));
        this.rightJustifyDateTime.setSelection(store.getDefaultBoolean("resultset.show.rightJustifyDateTime"));
        this.autoCompleteProposal.setSelection(store.getDefaultBoolean("resultset.behavior.autoCompleteProposial"));
        super.performDefaults();
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

