package migrate

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AssessmentSizingCriterion enumerates the values for assessment sizing criterion.
type AssessmentSizingCriterion string

const (
	// AsOnPremises ...
	AsOnPremises AssessmentSizingCriterion = "AsOnPremises"
	// PerformanceBased ...
	PerformanceBased AssessmentSizingCriterion = "PerformanceBased"
)

// PossibleAssessmentSizingCriterionValues returns an array of possible values for the AssessmentSizingCriterion const type.
func PossibleAssessmentSizingCriterionValues() []AssessmentSizingCriterion {
	return []AssessmentSizingCriterion{AsOnPremises, PerformanceBased}
}

// AssessmentStage enumerates the values for assessment stage.
type AssessmentStage string

const (
	// Approved ...
	Approved AssessmentStage = "Approved"
	// InProgress ...
	InProgress AssessmentStage = "InProgress"
	// UnderReview ...
	UnderReview AssessmentStage = "UnderReview"
)

// PossibleAssessmentStageValues returns an array of possible values for the AssessmentStage const type.
func PossibleAssessmentStageValues() []AssessmentStage {
	return []AssessmentStage{Approved, InProgress, UnderReview}
}

// AssessmentStatus enumerates the values for assessment status.
type AssessmentStatus string

const (
	// Completed ...
	Completed AssessmentStatus = "Completed"
	// Created ...
	Created AssessmentStatus = "Created"
	// Invalid ...
	Invalid AssessmentStatus = "Invalid"
	// Running ...
	Running AssessmentStatus = "Running"
	// Updated ...
	Updated AssessmentStatus = "Updated"
)

// PossibleAssessmentStatusValues returns an array of possible values for the AssessmentStatus const type.
func PossibleAssessmentStatusValues() []AssessmentStatus {
	return []AssessmentStatus{Completed, Created, Invalid, Running, Updated}
}

// AzureDiskSize enumerates the values for azure disk size.
type AzureDiskSize string

const (
	// PremiumP10 ...
	PremiumP10 AzureDiskSize = "Premium_P10"
	// PremiumP20 ...
	PremiumP20 AzureDiskSize = "Premium_P20"
	// PremiumP30 ...
	PremiumP30 AzureDiskSize = "Premium_P30"
	// PremiumP4 ...
	PremiumP4 AzureDiskSize = "Premium_P4"
	// PremiumP40 ...
	PremiumP40 AzureDiskSize = "Premium_P40"
	// PremiumP50 ...
	PremiumP50 AzureDiskSize = "Premium_P50"
	// PremiumP6 ...
	PremiumP6 AzureDiskSize = "Premium_P6"
	// StandardS10 ...
	StandardS10 AzureDiskSize = "Standard_S10"
	// StandardS20 ...
	StandardS20 AzureDiskSize = "Standard_S20"
	// StandardS30 ...
	StandardS30 AzureDiskSize = "Standard_S30"
	// StandardS4 ...
	StandardS4 AzureDiskSize = "Standard_S4"
	// StandardS40 ...
	StandardS40 AzureDiskSize = "Standard_S40"
	// StandardS50 ...
	StandardS50 AzureDiskSize = "Standard_S50"
	// StandardS6 ...
	StandardS6 AzureDiskSize = "Standard_S6"
	// Unknown ...
	Unknown AzureDiskSize = "Unknown"
)

// PossibleAzureDiskSizeValues returns an array of possible values for the AzureDiskSize const type.
func PossibleAzureDiskSizeValues() []AzureDiskSize {
	return []AzureDiskSize{PremiumP10, PremiumP20, PremiumP30, PremiumP4, PremiumP40, PremiumP50, PremiumP6, StandardS10, StandardS20, StandardS30, StandardS4, StandardS40, StandardS50, StandardS6, Unknown}
}

// AzureDiskSuitabilityExplanation enumerates the values for azure disk suitability explanation.
type AzureDiskSuitabilityExplanation string

const (
	// AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported ...
	AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported AzureDiskSuitabilityExplanation = "DiskSizeGreaterThanSupported"
	// AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation ...
	AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation AzureDiskSuitabilityExplanation = "InternalErrorOccurredForDiskEvaluation"
	// AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy ...
	AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy AzureDiskSuitabilityExplanation = "NoDiskSizeFoundForSelectedRedundancy"
	// AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation ...
	AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation AzureDiskSuitabilityExplanation = "NoDiskSizeFoundInSelectedLocation"
	// AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops ...
	AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops AzureDiskSuitabilityExplanation = "NoSuitableDiskSizeForIops"
	// AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput ...
	AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput AzureDiskSuitabilityExplanation = "NoSuitableDiskSizeForThroughput"
	// AzureDiskSuitabilityExplanationNotApplicable ...
	AzureDiskSuitabilityExplanationNotApplicable AzureDiskSuitabilityExplanation = "NotApplicable"
	// AzureDiskSuitabilityExplanationUnknown ...
	AzureDiskSuitabilityExplanationUnknown AzureDiskSuitabilityExplanation = "Unknown"
)

// PossibleAzureDiskSuitabilityExplanationValues returns an array of possible values for the AzureDiskSuitabilityExplanation const type.
func PossibleAzureDiskSuitabilityExplanationValues() []AzureDiskSuitabilityExplanation {
	return []AzureDiskSuitabilityExplanation{AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported, AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation, AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy, AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation, AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops, AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput, AzureDiskSuitabilityExplanationNotApplicable, AzureDiskSuitabilityExplanationUnknown}
}

// AzureDiskType enumerates the values for azure disk type.
type AzureDiskType string

const (
	// AzureDiskTypePremium ...
	AzureDiskTypePremium AzureDiskType = "Premium"
	// AzureDiskTypeStandard ...
	AzureDiskTypeStandard AzureDiskType = "Standard"
	// AzureDiskTypeUnknown ...
	AzureDiskTypeUnknown AzureDiskType = "Unknown"
)

// PossibleAzureDiskTypeValues returns an array of possible values for the AzureDiskType const type.
func PossibleAzureDiskTypeValues() []AzureDiskType {
	return []AzureDiskType{AzureDiskTypePremium, AzureDiskTypeStandard, AzureDiskTypeUnknown}
}

// AzureHybridUseBenefit enumerates the values for azure hybrid use benefit.
type AzureHybridUseBenefit string

const (
	// AzureHybridUseBenefitNo ...
	AzureHybridUseBenefitNo AzureHybridUseBenefit = "No"
	// AzureHybridUseBenefitUnknown ...
	AzureHybridUseBenefitUnknown AzureHybridUseBenefit = "Unknown"
	// AzureHybridUseBenefitYes ...
	AzureHybridUseBenefitYes AzureHybridUseBenefit = "Yes"
)

// PossibleAzureHybridUseBenefitValues returns an array of possible values for the AzureHybridUseBenefit const type.
func PossibleAzureHybridUseBenefitValues() []AzureHybridUseBenefit {
	return []AzureHybridUseBenefit{AzureHybridUseBenefitNo, AzureHybridUseBenefitUnknown, AzureHybridUseBenefitYes}
}

// AzureLocation enumerates the values for azure location.
type AzureLocation string

const (
	// AzureLocationAustraliaEast ...
	AzureLocationAustraliaEast AzureLocation = "AustraliaEast"
	// AzureLocationAustraliaSoutheast ...
	AzureLocationAustraliaSoutheast AzureLocation = "AustraliaSoutheast"
	// AzureLocationBrazilSouth ...
	AzureLocationBrazilSouth AzureLocation = "BrazilSouth"
	// AzureLocationCanadaCentral ...
	AzureLocationCanadaCentral AzureLocation = "CanadaCentral"
	// AzureLocationCanadaEast ...
	AzureLocationCanadaEast AzureLocation = "CanadaEast"
	// AzureLocationCentralIndia ...
	AzureLocationCentralIndia AzureLocation = "CentralIndia"
	// AzureLocationCentralUs ...
	AzureLocationCentralUs AzureLocation = "CentralUs"
	// AzureLocationChinaEast ...
	AzureLocationChinaEast AzureLocation = "ChinaEast"
	// AzureLocationChinaNorth ...
	AzureLocationChinaNorth AzureLocation = "ChinaNorth"
	// AzureLocationEastAsia ...
	AzureLocationEastAsia AzureLocation = "EastAsia"
	// AzureLocationEastUs ...
	AzureLocationEastUs AzureLocation = "EastUs"
	// AzureLocationEastUs2 ...
	AzureLocationEastUs2 AzureLocation = "EastUs2"
	// AzureLocationGermanyCentral ...
	AzureLocationGermanyCentral AzureLocation = "GermanyCentral"
	// AzureLocationGermanyNortheast ...
	AzureLocationGermanyNortheast AzureLocation = "GermanyNortheast"
	// AzureLocationJapanEast ...
	AzureLocationJapanEast AzureLocation = "JapanEast"
	// AzureLocationJapanWest ...
	AzureLocationJapanWest AzureLocation = "JapanWest"
	// AzureLocationKoreaCentral ...
	AzureLocationKoreaCentral AzureLocation = "KoreaCentral"
	// AzureLocationKoreaSouth ...
	AzureLocationKoreaSouth AzureLocation = "KoreaSouth"
	// AzureLocationNorthCentralUs ...
	AzureLocationNorthCentralUs AzureLocation = "NorthCentralUs"
	// AzureLocationNorthEurope ...
	AzureLocationNorthEurope AzureLocation = "NorthEurope"
	// AzureLocationSouthCentralUs ...
	AzureLocationSouthCentralUs AzureLocation = "SouthCentralUs"
	// AzureLocationSoutheastAsia ...
	AzureLocationSoutheastAsia AzureLocation = "SoutheastAsia"
	// AzureLocationSouthIndia ...
	AzureLocationSouthIndia AzureLocation = "SouthIndia"
	// AzureLocationUkSouth ...
	AzureLocationUkSouth AzureLocation = "UkSouth"
	// AzureLocationUkWest ...
	AzureLocationUkWest AzureLocation = "UkWest"
	// AzureLocationUnknown ...
	AzureLocationUnknown AzureLocation = "Unknown"
	// AzureLocationWestCentralUs ...
	AzureLocationWestCentralUs AzureLocation = "WestCentralUs"
	// AzureLocationWestEurope ...
	AzureLocationWestEurope AzureLocation = "WestEurope"
	// AzureLocationWestIndia ...
	AzureLocationWestIndia AzureLocation = "WestIndia"
	// AzureLocationWestUs ...
	AzureLocationWestUs AzureLocation = "WestUs"
	// AzureLocationWestUs2 ...
	AzureLocationWestUs2 AzureLocation = "WestUs2"
)

// PossibleAzureLocationValues returns an array of possible values for the AzureLocation const type.
func PossibleAzureLocationValues() []AzureLocation {
	return []AzureLocation{AzureLocationAustraliaEast, AzureLocationAustraliaSoutheast, AzureLocationBrazilSouth, AzureLocationCanadaCentral, AzureLocationCanadaEast, AzureLocationCentralIndia, AzureLocationCentralUs, AzureLocationChinaEast, AzureLocationChinaNorth, AzureLocationEastAsia, AzureLocationEastUs, AzureLocationEastUs2, AzureLocationGermanyCentral, AzureLocationGermanyNortheast, AzureLocationJapanEast, AzureLocationJapanWest, AzureLocationKoreaCentral, AzureLocationKoreaSouth, AzureLocationNorthCentralUs, AzureLocationNorthEurope, AzureLocationSouthCentralUs, AzureLocationSoutheastAsia, AzureLocationSouthIndia, AzureLocationUkSouth, AzureLocationUkWest, AzureLocationUnknown, AzureLocationWestCentralUs, AzureLocationWestEurope, AzureLocationWestIndia, AzureLocationWestUs, AzureLocationWestUs2}
}

// AzureNetworkAdapterSuitabilityExplanation enumerates the values for azure network adapter suitability
// explanation.
type AzureNetworkAdapterSuitabilityExplanation string

const (
	// AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured ...
	AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured AzureNetworkAdapterSuitabilityExplanation = "InternalErrorOccured"
	// AzureNetworkAdapterSuitabilityExplanationNotApplicable ...
	AzureNetworkAdapterSuitabilityExplanationNotApplicable AzureNetworkAdapterSuitabilityExplanation = "NotApplicable"
	// AzureNetworkAdapterSuitabilityExplanationUnknown ...
	AzureNetworkAdapterSuitabilityExplanationUnknown AzureNetworkAdapterSuitabilityExplanation = "Unknown"
)

// PossibleAzureNetworkAdapterSuitabilityExplanationValues returns an array of possible values for the AzureNetworkAdapterSuitabilityExplanation const type.
func PossibleAzureNetworkAdapterSuitabilityExplanationValues() []AzureNetworkAdapterSuitabilityExplanation {
	return []AzureNetworkAdapterSuitabilityExplanation{AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured, AzureNetworkAdapterSuitabilityExplanationNotApplicable, AzureNetworkAdapterSuitabilityExplanationUnknown}
}

// AzureOfferCode enumerates the values for azure offer code.
type AzureOfferCode string

const (
	// AzureOfferCodeMSAZR0003P ...
	AzureOfferCodeMSAZR0003P AzureOfferCode = "MSAZR0003P"
	// AzureOfferCodeMSAZR0022P ...
	AzureOfferCodeMSAZR0022P AzureOfferCode = "MSAZR0022P"
	// AzureOfferCodeMSAZR0023P ...
	AzureOfferCodeMSAZR0023P AzureOfferCode = "MSAZR0023P"
	// AzureOfferCodeMSAZR0025P ...
	AzureOfferCodeMSAZR0025P AzureOfferCode = "MSAZR0025P"
	// AzureOfferCodeMSAZR0029P ...
	AzureOfferCodeMSAZR0029P AzureOfferCode = "MSAZR0029P"
	// AzureOfferCodeMSAZR0036P ...
	AzureOfferCodeMSAZR0036P AzureOfferCode = "MSAZR0036P"
	// AzureOfferCodeMSAZR0044P ...
	AzureOfferCodeMSAZR0044P AzureOfferCode = "MSAZR0044P"
	// AzureOfferCodeMSAZR0059P ...
	AzureOfferCodeMSAZR0059P AzureOfferCode = "MSAZR0059P"
	// AzureOfferCodeMSAZR0060P ...
	AzureOfferCodeMSAZR0060P AzureOfferCode = "MSAZR0060P"
	// AzureOfferCodeMSAZR0062P ...
	AzureOfferCodeMSAZR0062P AzureOfferCode = "MSAZR0062P"
	// AzureOfferCodeMSAZR0063P ...
	AzureOfferCodeMSAZR0063P AzureOfferCode = "MSAZR0063P"
	// AzureOfferCodeMSAZR0064P ...
	AzureOfferCodeMSAZR0064P AzureOfferCode = "MSAZR0064P"
	// AzureOfferCodeMSAZR0111P ...
	AzureOfferCodeMSAZR0111P AzureOfferCode = "MSAZR0111P"
	// AzureOfferCodeMSAZR0120P ...
	AzureOfferCodeMSAZR0120P AzureOfferCode = "MSAZR0120P"
	// AzureOfferCodeMSAZR0121P ...
	AzureOfferCodeMSAZR0121P AzureOfferCode = "MSAZR0121P"
	// AzureOfferCodeMSAZR0122P ...
	AzureOfferCodeMSAZR0122P AzureOfferCode = "MSAZR0122P"
	// AzureOfferCodeMSAZR0123P ...
	AzureOfferCodeMSAZR0123P AzureOfferCode = "MSAZR0123P"
	// AzureOfferCodeMSAZR0124P ...
	AzureOfferCodeMSAZR0124P AzureOfferCode = "MSAZR0124P"
	// AzureOfferCodeMSAZR0125P ...
	AzureOfferCodeMSAZR0125P AzureOfferCode = "MSAZR0125P"
	// AzureOfferCodeMSAZR0126P ...
	AzureOfferCodeMSAZR0126P AzureOfferCode = "MSAZR0126P"
	// AzureOfferCodeMSAZR0127P ...
	AzureOfferCodeMSAZR0127P AzureOfferCode = "MSAZR0127P"
	// AzureOfferCodeMSAZR0128P ...
	AzureOfferCodeMSAZR0128P AzureOfferCode = "MSAZR0128P"
	// AzureOfferCodeMSAZR0129P ...
	AzureOfferCodeMSAZR0129P AzureOfferCode = "MSAZR0129P"
	// AzureOfferCodeMSAZR0130P ...
	AzureOfferCodeMSAZR0130P AzureOfferCode = "MSAZR0130P"
	// AzureOfferCodeMSAZR0144P ...
	AzureOfferCodeMSAZR0144P AzureOfferCode = "MSAZR0144P"
	// AzureOfferCodeMSAZR0148P ...
	AzureOfferCodeMSAZR0148P AzureOfferCode = "MSAZR0148P"
	// AzureOfferCodeMSAZR0149P ...
	AzureOfferCodeMSAZR0149P AzureOfferCode = "MSAZR0149P"
	// AzureOfferCodeMSAZRDE0003P ...
	AzureOfferCodeMSAZRDE0003P AzureOfferCode = "MSAZRDE0003P"
	// AzureOfferCodeMSAZRDE0044P ...
	AzureOfferCodeMSAZRDE0044P AzureOfferCode = "MSAZRDE0044P"
	// AzureOfferCodeMSMCAZR0044P ...
	AzureOfferCodeMSMCAZR0044P AzureOfferCode = "MSMCAZR0044P"
	// AzureOfferCodeMSMCAZR0059P ...
	AzureOfferCodeMSMCAZR0059P AzureOfferCode = "MSMCAZR0059P"
	// AzureOfferCodeMSMCAZR0060P ...
	AzureOfferCodeMSMCAZR0060P AzureOfferCode = "MSMCAZR0060P"
	// AzureOfferCodeMSMCAZR0063P ...
	AzureOfferCodeMSMCAZR0063P AzureOfferCode = "MSMCAZR0063P"
	// AzureOfferCodeMSMCAZR0120P ...
	AzureOfferCodeMSMCAZR0120P AzureOfferCode = "MSMCAZR0120P"
	// AzureOfferCodeMSMCAZR0121P ...
	AzureOfferCodeMSMCAZR0121P AzureOfferCode = "MSMCAZR0121P"
	// AzureOfferCodeMSMCAZR0125P ...
	AzureOfferCodeMSMCAZR0125P AzureOfferCode = "MSMCAZR0125P"
	// AzureOfferCodeMSMCAZR0128P ...
	AzureOfferCodeMSMCAZR0128P AzureOfferCode = "MSMCAZR0128P"
	// AzureOfferCodeUnknown ...
	AzureOfferCodeUnknown AzureOfferCode = "Unknown"
)

// PossibleAzureOfferCodeValues returns an array of possible values for the AzureOfferCode const type.
func PossibleAzureOfferCodeValues() []AzureOfferCode {
	return []AzureOfferCode{AzureOfferCodeMSAZR0003P, AzureOfferCodeMSAZR0022P, AzureOfferCodeMSAZR0023P, AzureOfferCodeMSAZR0025P, AzureOfferCodeMSAZR0029P, AzureOfferCodeMSAZR0036P, AzureOfferCodeMSAZR0044P, AzureOfferCodeMSAZR0059P, AzureOfferCodeMSAZR0060P, AzureOfferCodeMSAZR0062P, AzureOfferCodeMSAZR0063P, AzureOfferCodeMSAZR0064P, AzureOfferCodeMSAZR0111P, AzureOfferCodeMSAZR0120P, AzureOfferCodeMSAZR0121P, AzureOfferCodeMSAZR0122P, AzureOfferCodeMSAZR0123P, AzureOfferCodeMSAZR0124P, AzureOfferCodeMSAZR0125P, AzureOfferCodeMSAZR0126P, AzureOfferCodeMSAZR0127P, AzureOfferCodeMSAZR0128P, AzureOfferCodeMSAZR0129P, AzureOfferCodeMSAZR0130P, AzureOfferCodeMSAZR0144P, AzureOfferCodeMSAZR0148P, AzureOfferCodeMSAZR0149P, AzureOfferCodeMSAZRDE0003P, AzureOfferCodeMSAZRDE0044P, AzureOfferCodeMSMCAZR0044P, AzureOfferCodeMSMCAZR0059P, AzureOfferCodeMSMCAZR0060P, AzureOfferCodeMSMCAZR0063P, AzureOfferCodeMSMCAZR0120P, AzureOfferCodeMSMCAZR0121P, AzureOfferCodeMSMCAZR0125P, AzureOfferCodeMSMCAZR0128P, AzureOfferCodeUnknown}
}

// AzurePricingTier enumerates the values for azure pricing tier.
type AzurePricingTier string

const (
	// Basic ...
	Basic AzurePricingTier = "Basic"
	// Standard ...
	Standard AzurePricingTier = "Standard"
)

// PossibleAzurePricingTierValues returns an array of possible values for the AzurePricingTier const type.
func PossibleAzurePricingTierValues() []AzurePricingTier {
	return []AzurePricingTier{Basic, Standard}
}

// AzureStorageRedundancy enumerates the values for azure storage redundancy.
type AzureStorageRedundancy string

const (
	// AzureStorageRedundancyGeoRedundant ...
	AzureStorageRedundancyGeoRedundant AzureStorageRedundancy = "GeoRedundant"
	// AzureStorageRedundancyLocallyRedundant ...
	AzureStorageRedundancyLocallyRedundant AzureStorageRedundancy = "LocallyRedundant"
	// AzureStorageRedundancyReadAccessGeoRedundant ...
	AzureStorageRedundancyReadAccessGeoRedundant AzureStorageRedundancy = "ReadAccessGeoRedundant"
	// AzureStorageRedundancyUnknown ...
	AzureStorageRedundancyUnknown AzureStorageRedundancy = "Unknown"
	// AzureStorageRedundancyZoneRedundant ...
	AzureStorageRedundancyZoneRedundant AzureStorageRedundancy = "ZoneRedundant"
)

// PossibleAzureStorageRedundancyValues returns an array of possible values for the AzureStorageRedundancy const type.
func PossibleAzureStorageRedundancyValues() []AzureStorageRedundancy {
	return []AzureStorageRedundancy{AzureStorageRedundancyGeoRedundant, AzureStorageRedundancyLocallyRedundant, AzureStorageRedundancyReadAccessGeoRedundant, AzureStorageRedundancyUnknown, AzureStorageRedundancyZoneRedundant}
}

// AzureVMSize enumerates the values for azure vm size.
type AzureVMSize string

const (
	// AzureVMSizeBasicA0 ...
	AzureVMSizeBasicA0 AzureVMSize = "Basic_A0"
	// AzureVMSizeBasicA1 ...
	AzureVMSizeBasicA1 AzureVMSize = "Basic_A1"
	// AzureVMSizeBasicA2 ...
	AzureVMSizeBasicA2 AzureVMSize = "Basic_A2"
	// AzureVMSizeBasicA3 ...
	AzureVMSizeBasicA3 AzureVMSize = "Basic_A3"
	// AzureVMSizeBasicA4 ...
	AzureVMSizeBasicA4 AzureVMSize = "Basic_A4"
	// AzureVMSizeStandardA0 ...
	AzureVMSizeStandardA0 AzureVMSize = "Standard_A0"
	// AzureVMSizeStandardA1 ...
	AzureVMSizeStandardA1 AzureVMSize = "Standard_A1"
	// AzureVMSizeStandardA10 ...
	AzureVMSizeStandardA10 AzureVMSize = "Standard_A10"
	// AzureVMSizeStandardA11 ...
	AzureVMSizeStandardA11 AzureVMSize = "Standard_A11"
	// AzureVMSizeStandardA1V2 ...
	AzureVMSizeStandardA1V2 AzureVMSize = "Standard_A1_v2"
	// AzureVMSizeStandardA2 ...
	AzureVMSizeStandardA2 AzureVMSize = "Standard_A2"
	// AzureVMSizeStandardA2mV2 ...
	AzureVMSizeStandardA2mV2 AzureVMSize = "Standard_A2m_v2"
	// AzureVMSizeStandardA2V2 ...
	AzureVMSizeStandardA2V2 AzureVMSize = "Standard_A2_v2"
	// AzureVMSizeStandardA3 ...
	AzureVMSizeStandardA3 AzureVMSize = "Standard_A3"
	// AzureVMSizeStandardA4 ...
	AzureVMSizeStandardA4 AzureVMSize = "Standard_A4"
	// AzureVMSizeStandardA4mV2 ...
	AzureVMSizeStandardA4mV2 AzureVMSize = "Standard_A4m_v2"
	// AzureVMSizeStandardA4V2 ...
	AzureVMSizeStandardA4V2 AzureVMSize = "Standard_A4_v2"
	// AzureVMSizeStandardA5 ...
	AzureVMSizeStandardA5 AzureVMSize = "Standard_A5"
	// AzureVMSizeStandardA6 ...
	AzureVMSizeStandardA6 AzureVMSize = "Standard_A6"
	// AzureVMSizeStandardA7 ...
	AzureVMSizeStandardA7 AzureVMSize = "Standard_A7"
	// AzureVMSizeStandardA8 ...
	AzureVMSizeStandardA8 AzureVMSize = "Standard_A8"
	// AzureVMSizeStandardA8mV2 ...
	AzureVMSizeStandardA8mV2 AzureVMSize = "Standard_A8m_v2"
	// AzureVMSizeStandardA8V2 ...
	AzureVMSizeStandardA8V2 AzureVMSize = "Standard_A8_v2"
	// AzureVMSizeStandardA9 ...
	AzureVMSizeStandardA9 AzureVMSize = "Standard_A9"
	// AzureVMSizeStandardD1 ...
	AzureVMSizeStandardD1 AzureVMSize = "Standard_D1"
	// AzureVMSizeStandardD11 ...
	AzureVMSizeStandardD11 AzureVMSize = "Standard_D11"
	// AzureVMSizeStandardD11V2 ...
	AzureVMSizeStandardD11V2 AzureVMSize = "Standard_D11_v2"
	// AzureVMSizeStandardD12 ...
	AzureVMSizeStandardD12 AzureVMSize = "Standard_D12"
	// AzureVMSizeStandardD12V2 ...
	AzureVMSizeStandardD12V2 AzureVMSize = "Standard_D12_v2"
	// AzureVMSizeStandardD13 ...
	AzureVMSizeStandardD13 AzureVMSize = "Standard_D13"
	// AzureVMSizeStandardD13V2 ...
	AzureVMSizeStandardD13V2 AzureVMSize = "Standard_D13_v2"
	// AzureVMSizeStandardD14 ...
	AzureVMSizeStandardD14 AzureVMSize = "Standard_D14"
	// AzureVMSizeStandardD14V2 ...
	AzureVMSizeStandardD14V2 AzureVMSize = "Standard_D14_v2"
	// AzureVMSizeStandardD15V2 ...
	AzureVMSizeStandardD15V2 AzureVMSize = "Standard_D15_v2"
	// AzureVMSizeStandardD1V2 ...
	AzureVMSizeStandardD1V2 AzureVMSize = "Standard_D1_v2"
	// AzureVMSizeStandardD2 ...
	AzureVMSizeStandardD2 AzureVMSize = "Standard_D2"
	// AzureVMSizeStandardD2V2 ...
	AzureVMSizeStandardD2V2 AzureVMSize = "Standard_D2_v2"
	// AzureVMSizeStandardD3 ...
	AzureVMSizeStandardD3 AzureVMSize = "Standard_D3"
	// AzureVMSizeStandardD3V2 ...
	AzureVMSizeStandardD3V2 AzureVMSize = "Standard_D3_v2"
	// AzureVMSizeStandardD4 ...
	AzureVMSizeStandardD4 AzureVMSize = "Standard_D4"
	// AzureVMSizeStandardD4V2 ...
	AzureVMSizeStandardD4V2 AzureVMSize = "Standard_D4_v2"
	// AzureVMSizeStandardD5V2 ...
	AzureVMSizeStandardD5V2 AzureVMSize = "Standard_D5_v2"
	// AzureVMSizeStandardDS1 ...
	AzureVMSizeStandardDS1 AzureVMSize = "Standard_DS1"
	// AzureVMSizeStandardDS11 ...
	AzureVMSizeStandardDS11 AzureVMSize = "Standard_DS11"
	// AzureVMSizeStandardDS11V2 ...
	AzureVMSizeStandardDS11V2 AzureVMSize = "Standard_DS11_v2"
	// AzureVMSizeStandardDS12 ...
	AzureVMSizeStandardDS12 AzureVMSize = "Standard_DS12"
	// AzureVMSizeStandardDS12V2 ...
	AzureVMSizeStandardDS12V2 AzureVMSize = "Standard_DS12_v2"
	// AzureVMSizeStandardDS13 ...
	AzureVMSizeStandardDS13 AzureVMSize = "Standard_DS13"
	// AzureVMSizeStandardDS13V2 ...
	AzureVMSizeStandardDS13V2 AzureVMSize = "Standard_DS13_v2"
	// AzureVMSizeStandardDS14 ...
	AzureVMSizeStandardDS14 AzureVMSize = "Standard_DS14"
	// AzureVMSizeStandardDS14V2 ...
	AzureVMSizeStandardDS14V2 AzureVMSize = "Standard_DS14_v2"
	// AzureVMSizeStandardDS15V2 ...
	AzureVMSizeStandardDS15V2 AzureVMSize = "Standard_DS15_v2"
	// AzureVMSizeStandardDS1V2 ...
	AzureVMSizeStandardDS1V2 AzureVMSize = "Standard_DS1_v2"
	// AzureVMSizeStandardDS2 ...
	AzureVMSizeStandardDS2 AzureVMSize = "Standard_DS2"
	// AzureVMSizeStandardDS2V2 ...
	AzureVMSizeStandardDS2V2 AzureVMSize = "Standard_DS2_v2"
	// AzureVMSizeStandardDS3 ...
	AzureVMSizeStandardDS3 AzureVMSize = "Standard_DS3"
	// AzureVMSizeStandardDS3V2 ...
	AzureVMSizeStandardDS3V2 AzureVMSize = "Standard_DS3_v2"
	// AzureVMSizeStandardDS4 ...
	AzureVMSizeStandardDS4 AzureVMSize = "Standard_DS4"
	// AzureVMSizeStandardDS4V2 ...
	AzureVMSizeStandardDS4V2 AzureVMSize = "Standard_DS4_v2"
	// AzureVMSizeStandardDS5V2 ...
	AzureVMSizeStandardDS5V2 AzureVMSize = "Standard_DS5_v2"
	// AzureVMSizeStandardF1 ...
	AzureVMSizeStandardF1 AzureVMSize = "Standard_F1"
	// AzureVMSizeStandardF16 ...
	AzureVMSizeStandardF16 AzureVMSize = "Standard_F16"
	// AzureVMSizeStandardF16s ...
	AzureVMSizeStandardF16s AzureVMSize = "Standard_F16s"
	// AzureVMSizeStandardF1s ...
	AzureVMSizeStandardF1s AzureVMSize = "Standard_F1s"
	// AzureVMSizeStandardF2 ...
	AzureVMSizeStandardF2 AzureVMSize = "Standard_F2"
	// AzureVMSizeStandardF2s ...
	AzureVMSizeStandardF2s AzureVMSize = "Standard_F2s"
	// AzureVMSizeStandardF4 ...
	AzureVMSizeStandardF4 AzureVMSize = "Standard_F4"
	// AzureVMSizeStandardF4s ...
	AzureVMSizeStandardF4s AzureVMSize = "Standard_F4s"
	// AzureVMSizeStandardF8 ...
	AzureVMSizeStandardF8 AzureVMSize = "Standard_F8"
	// AzureVMSizeStandardF8s ...
	AzureVMSizeStandardF8s AzureVMSize = "Standard_F8s"
	// AzureVMSizeStandardG1 ...
	AzureVMSizeStandardG1 AzureVMSize = "Standard_G1"
	// AzureVMSizeStandardG2 ...
	AzureVMSizeStandardG2 AzureVMSize = "Standard_G2"
	// AzureVMSizeStandardG3 ...
	AzureVMSizeStandardG3 AzureVMSize = "Standard_G3"
	// AzureVMSizeStandardG4 ...
	AzureVMSizeStandardG4 AzureVMSize = "Standard_G4"
	// AzureVMSizeStandardG5 ...
	AzureVMSizeStandardG5 AzureVMSize = "Standard_G5"
	// AzureVMSizeStandardGS1 ...
	AzureVMSizeStandardGS1 AzureVMSize = "Standard_GS1"
	// AzureVMSizeStandardGS2 ...
	AzureVMSizeStandardGS2 AzureVMSize = "Standard_GS2"
	// AzureVMSizeStandardGS3 ...
	AzureVMSizeStandardGS3 AzureVMSize = "Standard_GS3"
	// AzureVMSizeStandardGS4 ...
	AzureVMSizeStandardGS4 AzureVMSize = "Standard_GS4"
	// AzureVMSizeStandardGS5 ...
	AzureVMSizeStandardGS5 AzureVMSize = "Standard_GS5"
	// AzureVMSizeStandardH16 ...
	AzureVMSizeStandardH16 AzureVMSize = "Standard_H16"
	// AzureVMSizeStandardH16m ...
	AzureVMSizeStandardH16m AzureVMSize = "Standard_H16m"
	// AzureVMSizeStandardH16mr ...
	AzureVMSizeStandardH16mr AzureVMSize = "Standard_H16mr"
	// AzureVMSizeStandardH16r ...
	AzureVMSizeStandardH16r AzureVMSize = "Standard_H16r"
	// AzureVMSizeStandardH8 ...
	AzureVMSizeStandardH8 AzureVMSize = "Standard_H8"
	// AzureVMSizeStandardH8m ...
	AzureVMSizeStandardH8m AzureVMSize = "Standard_H8m"
	// AzureVMSizeStandardL16s ...
	AzureVMSizeStandardL16s AzureVMSize = "Standard_L16s"
	// AzureVMSizeStandardL32s ...
	AzureVMSizeStandardL32s AzureVMSize = "Standard_L32s"
	// AzureVMSizeStandardL4s ...
	AzureVMSizeStandardL4s AzureVMSize = "Standard_L4s"
	// AzureVMSizeStandardL8s ...
	AzureVMSizeStandardL8s AzureVMSize = "Standard_L8s"
	// AzureVMSizeUnknown ...
	AzureVMSizeUnknown AzureVMSize = "Unknown"
)

// PossibleAzureVMSizeValues returns an array of possible values for the AzureVMSize const type.
func PossibleAzureVMSizeValues() []AzureVMSize {
	return []AzureVMSize{AzureVMSizeBasicA0, AzureVMSizeBasicA1, AzureVMSizeBasicA2, AzureVMSizeBasicA3, AzureVMSizeBasicA4, AzureVMSizeStandardA0, AzureVMSizeStandardA1, AzureVMSizeStandardA10, AzureVMSizeStandardA11, AzureVMSizeStandardA1V2, AzureVMSizeStandardA2, AzureVMSizeStandardA2mV2, AzureVMSizeStandardA2V2, AzureVMSizeStandardA3, AzureVMSizeStandardA4, AzureVMSizeStandardA4mV2, AzureVMSizeStandardA4V2, AzureVMSizeStandardA5, AzureVMSizeStandardA6, AzureVMSizeStandardA7, AzureVMSizeStandardA8, AzureVMSizeStandardA8mV2, AzureVMSizeStandardA8V2, AzureVMSizeStandardA9, AzureVMSizeStandardD1, AzureVMSizeStandardD11, AzureVMSizeStandardD11V2, AzureVMSizeStandardD12, AzureVMSizeStandardD12V2, AzureVMSizeStandardD13, AzureVMSizeStandardD13V2, AzureVMSizeStandardD14, AzureVMSizeStandardD14V2, AzureVMSizeStandardD15V2, AzureVMSizeStandardD1V2, AzureVMSizeStandardD2, AzureVMSizeStandardD2V2, AzureVMSizeStandardD3, AzureVMSizeStandardD3V2, AzureVMSizeStandardD4, AzureVMSizeStandardD4V2, AzureVMSizeStandardD5V2, AzureVMSizeStandardDS1, AzureVMSizeStandardDS11, AzureVMSizeStandardDS11V2, AzureVMSizeStandardDS12, AzureVMSizeStandardDS12V2, AzureVMSizeStandardDS13, AzureVMSizeStandardDS13V2, AzureVMSizeStandardDS14, AzureVMSizeStandardDS14V2, AzureVMSizeStandardDS15V2, AzureVMSizeStandardDS1V2, AzureVMSizeStandardDS2, AzureVMSizeStandardDS2V2, AzureVMSizeStandardDS3, AzureVMSizeStandardDS3V2, AzureVMSizeStandardDS4, AzureVMSizeStandardDS4V2, AzureVMSizeStandardDS5V2, AzureVMSizeStandardF1, AzureVMSizeStandardF16, AzureVMSizeStandardF16s, AzureVMSizeStandardF1s, AzureVMSizeStandardF2, AzureVMSizeStandardF2s, AzureVMSizeStandardF4, AzureVMSizeStandardF4s, AzureVMSizeStandardF8, AzureVMSizeStandardF8s, AzureVMSizeStandardG1, AzureVMSizeStandardG2, AzureVMSizeStandardG3, AzureVMSizeStandardG4, AzureVMSizeStandardG5, AzureVMSizeStandardGS1, AzureVMSizeStandardGS2, AzureVMSizeStandardGS3, AzureVMSizeStandardGS4, AzureVMSizeStandardGS5, AzureVMSizeStandardH16, AzureVMSizeStandardH16m, AzureVMSizeStandardH16mr, AzureVMSizeStandardH16r, AzureVMSizeStandardH8, AzureVMSizeStandardH8m, AzureVMSizeStandardL16s, AzureVMSizeStandardL32s, AzureVMSizeStandardL4s, AzureVMSizeStandardL8s, AzureVMSizeUnknown}
}

// AzureVMSuitabilityExplanation enumerates the values for azure vm suitability explanation.
type AzureVMSuitabilityExplanation string

const (
	// AzureVMSuitabilityExplanationBootTypeNotSupported ...
	AzureVMSuitabilityExplanationBootTypeNotSupported AzureVMSuitabilityExplanation = "BootTypeNotSupported"
	// AzureVMSuitabilityExplanationBootTypeUnknown ...
	AzureVMSuitabilityExplanationBootTypeUnknown AzureVMSuitabilityExplanation = "BootTypeUnknown"
	// AzureVMSuitabilityExplanationCheckCentOsVersion ...
	AzureVMSuitabilityExplanationCheckCentOsVersion AzureVMSuitabilityExplanation = "CheckCentOsVersion"
	// AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion ...
	AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion AzureVMSuitabilityExplanation = "CheckCoreOsLinuxVersion"
	// AzureVMSuitabilityExplanationCheckDebianLinuxVersion ...
	AzureVMSuitabilityExplanationCheckDebianLinuxVersion AzureVMSuitabilityExplanation = "CheckDebianLinuxVersion"
	// AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion ...
	AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion AzureVMSuitabilityExplanation = "CheckOpenSuseLinuxVersion"
	// AzureVMSuitabilityExplanationCheckOracleLinuxVersion ...
	AzureVMSuitabilityExplanationCheckOracleLinuxVersion AzureVMSuitabilityExplanation = "CheckOracleLinuxVersion"
	// AzureVMSuitabilityExplanationCheckRedHatLinuxVersion ...
	AzureVMSuitabilityExplanationCheckRedHatLinuxVersion AzureVMSuitabilityExplanation = "CheckRedHatLinuxVersion"
	// AzureVMSuitabilityExplanationCheckSuseLinuxVersion ...
	AzureVMSuitabilityExplanationCheckSuseLinuxVersion AzureVMSuitabilityExplanation = "CheckSuseLinuxVersion"
	// AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion ...
	AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion AzureVMSuitabilityExplanation = "CheckUbuntuLinuxVersion"
	// AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version ...
	AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version AzureVMSuitabilityExplanation = "CheckWindowsServer2008R2Version"
	// AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions ...
	AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions AzureVMSuitabilityExplanation = "EndorsedWithConditionsLinuxDistributions"
	// AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported ...
	AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported AzureVMSuitabilityExplanation = "GuestOperatingSystemArchitectureNotSupported"
	// AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported ...
	AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported AzureVMSuitabilityExplanation = "GuestOperatingSystemNotSupported"
	// AzureVMSuitabilityExplanationGuestOperatingSystemUnknown ...
	AzureVMSuitabilityExplanationGuestOperatingSystemUnknown AzureVMSuitabilityExplanation = "GuestOperatingSystemUnknown"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringComputeEvaluation"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringNetworkEvaluation"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringStorageEvaluation"
	// AzureVMSuitabilityExplanationMoreDisksThanSupported ...
	AzureVMSuitabilityExplanationMoreDisksThanSupported AzureVMSuitabilityExplanation = "MoreDisksThanSupported"
	// AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported ...
	AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported AzureVMSuitabilityExplanation = "NoGuestOperatingSystemConditionallySupported"
	// AzureVMSuitabilityExplanationNoSuitableVMSizeFound ...
	AzureVMSuitabilityExplanationNoSuitableVMSizeFound AzureVMSuitabilityExplanation = "NoSuitableVmSizeFound"
	// AzureVMSuitabilityExplanationNotApplicable ...
	AzureVMSuitabilityExplanationNotApplicable AzureVMSuitabilityExplanation = "NotApplicable"
	// AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForBasicPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation ...
	AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation AzureVMSuitabilityExplanation = "NoVmSizeForSelectedAzureLocation"
	// AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForSelectedPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForStandardPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance ...
	AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance AzureVMSuitabilityExplanation = "NoVmSizeSupportsNetworkPerformance"
	// AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance ...
	AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance AzureVMSuitabilityExplanation = "NoVmSizeSupportsStoragePerformance"
	// AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable ...
	AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable AzureVMSuitabilityExplanation = "OneOrMoreAdaptersNotSuitable"
	// AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable ...
	AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable AzureVMSuitabilityExplanation = "OneOrMoreDisksNotSuitable"
	// AzureVMSuitabilityExplanationUnendorsedLinuxDistributions ...
	AzureVMSuitabilityExplanationUnendorsedLinuxDistributions AzureVMSuitabilityExplanation = "UnendorsedLinuxDistributions"
	// AzureVMSuitabilityExplanationUnknown ...
	AzureVMSuitabilityExplanationUnknown AzureVMSuitabilityExplanation = "Unknown"
	// AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported ...
	AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported AzureVMSuitabilityExplanation = "WindowsClientVersionsConditionallySupported"
	// AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport ...
	AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport AzureVMSuitabilityExplanation = "WindowsOSNoLongerUnderMSSupport"
	// AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported ...
	AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported AzureVMSuitabilityExplanation = "WindowsServerVersionConditionallySupported"
	// AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat ...
	AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat AzureVMSuitabilityExplanation = "WindowsServerVersionsSupportedWithCaveat"
)

// PossibleAzureVMSuitabilityExplanationValues returns an array of possible values for the AzureVMSuitabilityExplanation const type.
func PossibleAzureVMSuitabilityExplanationValues() []AzureVMSuitabilityExplanation {
	return []AzureVMSuitabilityExplanation{AzureVMSuitabilityExplanationBootTypeNotSupported, AzureVMSuitabilityExplanationBootTypeUnknown, AzureVMSuitabilityExplanationCheckCentOsVersion, AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion, AzureVMSuitabilityExplanationCheckDebianLinuxVersion, AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion, AzureVMSuitabilityExplanationCheckOracleLinuxVersion, AzureVMSuitabilityExplanationCheckRedHatLinuxVersion, AzureVMSuitabilityExplanationCheckSuseLinuxVersion, AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion, AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version, AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions, AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported, AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported, AzureVMSuitabilityExplanationGuestOperatingSystemUnknown, AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation, AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation, AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation, AzureVMSuitabilityExplanationMoreDisksThanSupported, AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported, AzureVMSuitabilityExplanationNoSuitableVMSizeFound, AzureVMSuitabilityExplanationNotApplicable, AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier, AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation, AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier, AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier, AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance, AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance, AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable, AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable, AzureVMSuitabilityExplanationUnendorsedLinuxDistributions, AzureVMSuitabilityExplanationUnknown, AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported, AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport, AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported, AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat}
}

// CloudSuitability enumerates the values for cloud suitability.
type CloudSuitability string

const (
	// CloudSuitabilityConditionallySuitable ...
	CloudSuitabilityConditionallySuitable CloudSuitability = "ConditionallySuitable"
	// CloudSuitabilityNotSuitable ...
	CloudSuitabilityNotSuitable CloudSuitability = "NotSuitable"
	// CloudSuitabilityReadinessUnknown ...
	CloudSuitabilityReadinessUnknown CloudSuitability = "ReadinessUnknown"
	// CloudSuitabilitySuitable ...
	CloudSuitabilitySuitable CloudSuitability = "Suitable"
	// CloudSuitabilityUnknown ...
	CloudSuitabilityUnknown CloudSuitability = "Unknown"
)

// PossibleCloudSuitabilityValues returns an array of possible values for the CloudSuitability const type.
func PossibleCloudSuitabilityValues() []CloudSuitability {
	return []CloudSuitability{CloudSuitabilityConditionallySuitable, CloudSuitabilityNotSuitable, CloudSuitabilityReadinessUnknown, CloudSuitabilitySuitable, CloudSuitabilityUnknown}
}

// Currency enumerates the values for currency.
type Currency string

const (
	// CurrencyARS ...
	CurrencyARS Currency = "ARS"
	// CurrencyAUD ...
	CurrencyAUD Currency = "AUD"
	// CurrencyBRL ...
	CurrencyBRL Currency = "BRL"
	// CurrencyCAD ...
	CurrencyCAD Currency = "CAD"
	// CurrencyCHF ...
	CurrencyCHF Currency = "CHF"
	// CurrencyCNY ...
	CurrencyCNY Currency = "CNY"
	// CurrencyDKK ...
	CurrencyDKK Currency = "DKK"
	// CurrencyEUR ...
	CurrencyEUR Currency = "EUR"
	// CurrencyGBP ...
	CurrencyGBP Currency = "GBP"
	// CurrencyHKD ...
	CurrencyHKD Currency = "HKD"
	// CurrencyIDR ...
	CurrencyIDR Currency = "IDR"
	// CurrencyINR ...
	CurrencyINR Currency = "INR"
	// CurrencyJPY ...
	CurrencyJPY Currency = "JPY"
	// CurrencyKRW ...
	CurrencyKRW Currency = "KRW"
	// CurrencyMXN ...
	CurrencyMXN Currency = "MXN"
	// CurrencyMYR ...
	CurrencyMYR Currency = "MYR"
	// CurrencyNOK ...
	CurrencyNOK Currency = "NOK"
	// CurrencyNZD ...
	CurrencyNZD Currency = "NZD"
	// CurrencyRUB ...
	CurrencyRUB Currency = "RUB"
	// CurrencySAR ...
	CurrencySAR Currency = "SAR"
	// CurrencySEK ...
	CurrencySEK Currency = "SEK"
	// CurrencyTRY ...
	CurrencyTRY Currency = "TRY"
	// CurrencyTWD ...
	CurrencyTWD Currency = "TWD"
	// CurrencyUnknown ...
	CurrencyUnknown Currency = "Unknown"
	// CurrencyUSD ...
	CurrencyUSD Currency = "USD"
	// CurrencyZAR ...
	CurrencyZAR Currency = "ZAR"
)

// PossibleCurrencyValues returns an array of possible values for the Currency const type.
func PossibleCurrencyValues() []Currency {
	return []Currency{CurrencyARS, CurrencyAUD, CurrencyBRL, CurrencyCAD, CurrencyCHF, CurrencyCNY, CurrencyDKK, CurrencyEUR, CurrencyGBP, CurrencyHKD, CurrencyIDR, CurrencyINR, CurrencyJPY, CurrencyKRW, CurrencyMXN, CurrencyMYR, CurrencyNOK, CurrencyNZD, CurrencyRUB, CurrencySAR, CurrencySEK, CurrencyTRY, CurrencyTWD, CurrencyUnknown, CurrencyUSD, CurrencyZAR}
}

// DiscoveryStatus enumerates the values for discovery status.
type DiscoveryStatus string

const (
	// DiscoveryStatusCompleted ...
	DiscoveryStatusCompleted DiscoveryStatus = "Completed"
	// DiscoveryStatusInProgress ...
	DiscoveryStatusInProgress DiscoveryStatus = "InProgress"
	// DiscoveryStatusNotStarted ...
	DiscoveryStatusNotStarted DiscoveryStatus = "NotStarted"
	// DiscoveryStatusUnknown ...
	DiscoveryStatusUnknown DiscoveryStatus = "Unknown"
)

// PossibleDiscoveryStatusValues returns an array of possible values for the DiscoveryStatus const type.
func PossibleDiscoveryStatusValues() []DiscoveryStatus {
	return []DiscoveryStatus{DiscoveryStatusCompleted, DiscoveryStatusInProgress, DiscoveryStatusNotStarted, DiscoveryStatusUnknown}
}

// MachineBootType enumerates the values for machine boot type.
type MachineBootType string

const (
	// MachineBootTypeBIOS ...
	MachineBootTypeBIOS MachineBootType = "BIOS"
	// MachineBootTypeEFI ...
	MachineBootTypeEFI MachineBootType = "EFI"
	// MachineBootTypeUnknown ...
	MachineBootTypeUnknown MachineBootType = "Unknown"
)

// PossibleMachineBootTypeValues returns an array of possible values for the MachineBootType const type.
func PossibleMachineBootTypeValues() []MachineBootType {
	return []MachineBootType{MachineBootTypeBIOS, MachineBootTypeEFI, MachineBootTypeUnknown}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// NameAvailabilityReasonAlreadyExists ...
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = "AlreadyExists"
	// NameAvailabilityReasonAvailable ...
	NameAvailabilityReasonAvailable NameAvailabilityReason = "Available"
	// NameAvailabilityReasonInvalid ...
	NameAvailabilityReasonInvalid NameAvailabilityReason = "Invalid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{NameAvailabilityReasonAlreadyExists, NameAvailabilityReasonAvailable, NameAvailabilityReasonInvalid}
}

// Percentile enumerates the values for percentile.
type Percentile string

const (
	// Percentile50 ...
	Percentile50 Percentile = "Percentile50"
	// Percentile90 ...
	Percentile90 Percentile = "Percentile90"
	// Percentile95 ...
	Percentile95 Percentile = "Percentile95"
	// Percentile99 ...
	Percentile99 Percentile = "Percentile99"
)

// PossiblePercentileValues returns an array of possible values for the Percentile const type.
func PossiblePercentileValues() []Percentile {
	return []Percentile{Percentile50, Percentile90, Percentile95, Percentile99}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Moving ...
	Moving ProvisioningState = "Moving"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Creating, Deleting, Failed, Moving, Succeeded}
}

// TimeRange enumerates the values for time range.
type TimeRange string

const (
	// Day ...
	Day TimeRange = "Day"
	// Month ...
	Month TimeRange = "Month"
	// Week ...
	Week TimeRange = "Week"
)

// PossibleTimeRangeValues returns an array of possible values for the TimeRange const type.
func PossibleTimeRangeValues() []TimeRange {
	return []TimeRange{Day, Month, Week}
}
