package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAddressBlockMapping invokes the address_purification.GetAddressBlockMapping API synchronously
func (client *Client) GetAddressBlockMapping(request *GetAddressBlockMappingRequest) (response *GetAddressBlockMappingResponse, err error) {
	response = CreateGetAddressBlockMappingResponse()
	err = client.DoAction(request, response)
	return
}

// GetAddressBlockMappingWithChan invokes the address_purification.GetAddressBlockMapping API asynchronously
func (client *Client) GetAddressBlockMappingWithChan(request *GetAddressBlockMappingRequest) (<-chan *GetAddressBlockMappingResponse, <-chan error) {
	responseChan := make(chan *GetAddressBlockMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAddressBlockMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAddressBlockMappingWithCallback invokes the address_purification.GetAddressBlockMapping API asynchronously
func (client *Client) GetAddressBlockMappingWithCallback(request *GetAddressBlockMappingRequest, callback func(response *GetAddressBlockMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAddressBlockMappingResponse
		var err error
		defer close(result)
		response, err = client.GetAddressBlockMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAddressBlockMappingRequest is the request struct for api GetAddressBlockMapping
type GetAddressBlockMappingRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// GetAddressBlockMappingResponse is the response struct for api GetAddressBlockMapping
type GetAddressBlockMappingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetAddressBlockMappingRequest creates a request to invoke GetAddressBlockMapping API
func CreateGetAddressBlockMappingRequest() (request *GetAddressBlockMappingRequest) {
	request = &GetAddressBlockMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "GetAddressBlockMapping", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAddressBlockMappingResponse creates a response to parse from GetAddressBlockMapping response
func CreateGetAddressBlockMappingResponse() (response *GetAddressBlockMappingResponse) {
	response = &GetAddressBlockMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
