package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDnsGtmMonitor invokes the alidns.UpdateDnsGtmMonitor API synchronously
func (client *Client) UpdateDnsGtmMonitor(request *UpdateDnsGtmMonitorRequest) (response *UpdateDnsGtmMonitorResponse, err error) {
	response = CreateUpdateDnsGtmMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDnsGtmMonitorWithChan invokes the alidns.UpdateDnsGtmMonitor API asynchronously
func (client *Client) UpdateDnsGtmMonitorWithChan(request *UpdateDnsGtmMonitorRequest) (<-chan *UpdateDnsGtmMonitorResponse, <-chan error) {
	responseChan := make(chan *UpdateDnsGtmMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDnsGtmMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDnsGtmMonitorWithCallback invokes the alidns.UpdateDnsGtmMonitor API asynchronously
func (client *Client) UpdateDnsGtmMonitorWithCallback(request *UpdateDnsGtmMonitorRequest, callback func(response *UpdateDnsGtmMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDnsGtmMonitorResponse
		var err error
		defer close(result)
		response, err = client.UpdateDnsGtmMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDnsGtmMonitorRequest is the request struct for api UpdateDnsGtmMonitor
type UpdateDnsGtmMonitorRequest struct {
	*requests.RpcRequest
	MonitorExtendInfo string                            `position:"Query" name:"MonitorExtendInfo"`
	MonitorConfigId   string                            `position:"Query" name:"MonitorConfigId"`
	Timeout           requests.Integer                  `position:"Query" name:"Timeout"`
	UserClientIp      string                            `position:"Query" name:"UserClientIp"`
	EvaluationCount   requests.Integer                  `position:"Query" name:"EvaluationCount"`
	ProtocolType      string                            `position:"Query" name:"ProtocolType"`
	Interval          requests.Integer                  `position:"Query" name:"Interval"`
	Lang              string                            `position:"Query" name:"Lang"`
	IspCityNode       *[]UpdateDnsGtmMonitorIspCityNode `position:"Query" name:"IspCityNode"  type:"Repeated"`
}

// UpdateDnsGtmMonitorIspCityNode is a repeated param struct in UpdateDnsGtmMonitorRequest
type UpdateDnsGtmMonitorIspCityNode struct {
	CityCode string `name:"CityCode"`
	IspCode  string `name:"IspCode"`
}

// UpdateDnsGtmMonitorResponse is the response struct for api UpdateDnsGtmMonitor
type UpdateDnsGtmMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDnsGtmMonitorRequest creates a request to invoke UpdateDnsGtmMonitor API
func CreateUpdateDnsGtmMonitorRequest() (request *UpdateDnsGtmMonitorRequest) {
	request = &UpdateDnsGtmMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "UpdateDnsGtmMonitor", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDnsGtmMonitorResponse creates a response to parse from UpdateDnsGtmMonitor response
func CreateUpdateDnsGtmMonitorResponse() (response *UpdateDnsGtmMonitorResponse) {
	response = &UpdateDnsGtmMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
