package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSilencePolicy invokes the arms.DeleteSilencePolicy API synchronously
func (client *Client) DeleteSilencePolicy(request *DeleteSilencePolicyRequest) (response *DeleteSilencePolicyResponse, err error) {
	response = CreateDeleteSilencePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSilencePolicyWithChan invokes the arms.DeleteSilencePolicy API asynchronously
func (client *Client) DeleteSilencePolicyWithChan(request *DeleteSilencePolicyRequest) (<-chan *DeleteSilencePolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteSilencePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSilencePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSilencePolicyWithCallback invokes the arms.DeleteSilencePolicy API asynchronously
func (client *Client) DeleteSilencePolicyWithCallback(request *DeleteSilencePolicyRequest, callback func(response *DeleteSilencePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSilencePolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteSilencePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSilencePolicyRequest is the request struct for api DeleteSilencePolicy
type DeleteSilencePolicyRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// DeleteSilencePolicyResponse is the response struct for api DeleteSilencePolicy
type DeleteSilencePolicyResponse struct {
	*responses.BaseResponse
	RequestId                    string `json:"RequestId" xml:"RequestId"`
	DeleteSilencePolicyIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
}

// CreateDeleteSilencePolicyRequest creates a request to invoke DeleteSilencePolicy API
func CreateDeleteSilencePolicyRequest() (request *DeleteSilencePolicyRequest) {
	request = &DeleteSilencePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteSilencePolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSilencePolicyResponse creates a response to parse from DeleteSilencePolicy response
func CreateDeleteSilencePolicyResponse() (response *DeleteSilencePolicyResponse) {
	response = &DeleteSilencePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
