package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyCorpIdentify invokes the cloudcallcenter.ApplyCorpIdentify API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/applycorpidentify.html
func (client *Client) ApplyCorpIdentify(request *ApplyCorpIdentifyRequest) (response *ApplyCorpIdentifyResponse, err error) {
	response = CreateApplyCorpIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyCorpIdentifyWithChan invokes the cloudcallcenter.ApplyCorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/applycorpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyCorpIdentifyWithChan(request *ApplyCorpIdentifyRequest) (<-chan *ApplyCorpIdentifyResponse, <-chan error) {
	responseChan := make(chan *ApplyCorpIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyCorpIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyCorpIdentifyWithCallback invokes the cloudcallcenter.ApplyCorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/applycorpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyCorpIdentifyWithCallback(request *ApplyCorpIdentifyRequest, callback func(response *ApplyCorpIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyCorpIdentifyResponse
		var err error
		defer close(result)
		response, err = client.ApplyCorpIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyCorpIdentifyRequest is the request struct for api ApplyCorpIdentify
type ApplyCorpIdentifyRequest struct {
	*requests.RpcRequest
	SpecId                     requests.Integer `position:"Query" name:"SpecId"`
	ManagerContactPhoneNumber  string           `position:"Query" name:"ManagerContactPhoneNumber"`
	LegalPersonName            string           `position:"Query" name:"LegalPersonName"`
	BusinessTypeDesc           string           `position:"Query" name:"BusinessTypeDesc"`
	BusinessType               requests.Integer `position:"Query" name:"BusinessType"`
	BusinessLicensePic         string           `position:"Query" name:"BusinessLicensePic"`
	LegalPersonrCertNumber     string           `position:"Query" name:"LegalPersonrCertNumber"`
	ProcedureDesc              string           `position:"Query" name:"ProcedureDesc"`
	RegisteredFundCode         string           `position:"Query" name:"RegisteredFundCode"`
	ManagerName                string           `position:"Query" name:"ManagerName"`
	ManagerCertPic             string           `position:"Query" name:"ManagerCertPic"`
	RegionNameCity             string           `position:"Query" name:"RegionNameCity"`
	NumberApplicationLetterPic string           `position:"Query" name:"NumberApplicationLetterPic"`
	BusinessLicenseAddress     string           `position:"Query" name:"BusinessLicenseAddress"`
	OrganizationCode           string           `position:"Query" name:"OrganizationCode"`
	SpecName                   string           `position:"Query" name:"SpecName"`
	RegionNameProvince         string           `position:"Query" name:"RegionNameProvince"`
	TelecomUndertakingPic      string           `position:"Query" name:"TelecomUndertakingPic"`
	CorpName                   string           `position:"Query" name:"CorpName"`
	ApplyRemark                string           `position:"Query" name:"ApplyRemark"`
	CorporationCertPic         string           `position:"Query" name:"CorporationCertPic"`
	ManagerCertNumber          string           `position:"Query" name:"ManagerCertNumber"`
}

// ApplyCorpIdentifyResponse is the response struct for api ApplyCorpIdentify
type ApplyCorpIdentifyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateApplyCorpIdentifyRequest creates a request to invoke ApplyCorpIdentify API
func CreateApplyCorpIdentifyRequest() (request *ApplyCorpIdentifyRequest) {
	request = &ApplyCorpIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ApplyCorpIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyCorpIdentifyResponse creates a response to parse from ApplyCorpIdentify response
func CreateApplyCorpIdentifyResponse() (response *ApplyCorpIdentifyResponse) {
	response = &ApplyCorpIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
