package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDialTask invokes the cloudcallcenter.GetDialTask API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getdialtask.html
func (client *Client) GetDialTask(request *GetDialTaskRequest) (response *GetDialTaskResponse, err error) {
	response = CreateGetDialTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetDialTaskWithChan invokes the cloudcallcenter.GetDialTask API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getdialtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDialTaskWithChan(request *GetDialTaskRequest) (<-chan *GetDialTaskResponse, <-chan error) {
	responseChan := make(chan *GetDialTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDialTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDialTaskWithCallback invokes the cloudcallcenter.GetDialTask API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getdialtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDialTaskWithCallback(request *GetDialTaskRequest, callback func(response *GetDialTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDialTaskResponse
		var err error
		defer close(result)
		response, err = client.GetDialTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDialTaskRequest is the request struct for api GetDialTask
type GetDialTaskRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	TaskId     string `position:"Query" name:"TaskId"`
}

// GetDialTaskResponse is the response struct for api GetDialTask
type GetDialTaskResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	StatusCode     string `json:"StatusCode" xml:"StatusCode"`
	StatusDesc     string `json:"StatusDesc" xml:"StatusDesc"`
	Dialer         string `json:"Dialer" xml:"Dialer"`
}

// CreateGetDialTaskRequest creates a request to invoke GetDialTask API
func CreateGetDialTaskRequest() (request *GetDialTaskRequest) {
	request = &GetDialTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetDialTask", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDialTaskResponse creates a response to parse from GetDialTask response
func CreateGetDialTaskResponse() (response *GetDialTaskResponse) {
	response = &GetDialTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
