package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableHostAvailability invokes the cms.EnableHostAvailability API synchronously
func (client *Client) EnableHostAvailability(request *EnableHostAvailabilityRequest) (response *EnableHostAvailabilityResponse, err error) {
	response = CreateEnableHostAvailabilityResponse()
	err = client.DoAction(request, response)
	return
}

// EnableHostAvailabilityWithChan invokes the cms.EnableHostAvailability API asynchronously
func (client *Client) EnableHostAvailabilityWithChan(request *EnableHostAvailabilityRequest) (<-chan *EnableHostAvailabilityResponse, <-chan error) {
	responseChan := make(chan *EnableHostAvailabilityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableHostAvailability(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableHostAvailabilityWithCallback invokes the cms.EnableHostAvailability API asynchronously
func (client *Client) EnableHostAvailabilityWithCallback(request *EnableHostAvailabilityRequest, callback func(response *EnableHostAvailabilityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableHostAvailabilityResponse
		var err error
		defer close(result)
		response, err = client.EnableHostAvailability(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableHostAvailabilityRequest is the request struct for api EnableHostAvailability
type EnableHostAvailabilityRequest struct {
	*requests.RpcRequest
	Id *[]string `position:"Query" name:"Id"  type:"Repeated"`
}

// EnableHostAvailabilityResponse is the response struct for api EnableHostAvailability
type EnableHostAvailabilityResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateEnableHostAvailabilityRequest creates a request to invoke EnableHostAvailability API
func CreateEnableHostAvailabilityRequest() (request *EnableHostAvailabilityRequest) {
	request = &EnableHostAvailabilityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "EnableHostAvailability", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableHostAvailabilityResponse creates a response to parse from EnableHostAvailability response
func CreateEnableHostAvailabilityResponse() (response *EnableHostAvailabilityResponse) {
	response = &EnableHostAvailabilityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
