package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClusterNodePool invokes the cs.ModifyClusterNodePool API synchronously
func (client *Client) ModifyClusterNodePool(request *ModifyClusterNodePoolRequest) (response *ModifyClusterNodePoolResponse, err error) {
	response = CreateModifyClusterNodePoolResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterNodePoolWithChan invokes the cs.ModifyClusterNodePool API asynchronously
func (client *Client) ModifyClusterNodePoolWithChan(request *ModifyClusterNodePoolRequest) (<-chan *ModifyClusterNodePoolResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterNodePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClusterNodePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterNodePoolWithCallback invokes the cs.ModifyClusterNodePool API asynchronously
func (client *Client) ModifyClusterNodePoolWithCallback(request *ModifyClusterNodePoolRequest, callback func(response *ModifyClusterNodePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterNodePoolResponse
		var err error
		defer close(result)
		response, err = client.ModifyClusterNodePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterNodePoolRequest is the request struct for api ModifyClusterNodePool
type ModifyClusterNodePoolRequest struct {
	*requests.RoaRequest
	ClusterId  string `position:"Path" name:"ClusterId"`
	NodepoolId string `position:"Path" name:"NodepoolId"`
}

// ModifyClusterNodePoolResponse is the response struct for api ModifyClusterNodePool
type ModifyClusterNodePoolResponse struct {
	*responses.BaseResponse
	TaskId     string `json:"task_id" xml:"task_id"`
	NodepoolId string `json:"nodepool_id" xml:"nodepool_id"`
}

// CreateModifyClusterNodePoolRequest creates a request to invoke ModifyClusterNodePool API
func CreateModifyClusterNodePoolRequest() (request *ModifyClusterNodePoolRequest) {
	request = &ModifyClusterNodePoolRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "ModifyClusterNodePool", "/clusters/[ClusterId]/nodepools/[NodepoolId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateModifyClusterNodePoolResponse creates a response to parse from ModifyClusterNodePool response
func CreateModifyClusterNodePoolResponse() (response *ModifyClusterNodePoolResponse) {
	response = &ModifyClusterNodePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
