package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDcdnDeliverTask invokes the dcdn.CreateDcdnDeliverTask API synchronously
func (client *Client) CreateDcdnDeliverTask(request *CreateDcdnDeliverTaskRequest) (response *CreateDcdnDeliverTaskResponse, err error) {
	response = CreateCreateDcdnDeliverTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDcdnDeliverTaskWithChan invokes the dcdn.CreateDcdnDeliverTask API asynchronously
func (client *Client) CreateDcdnDeliverTaskWithChan(request *CreateDcdnDeliverTaskRequest) (<-chan *CreateDcdnDeliverTaskResponse, <-chan error) {
	responseChan := make(chan *CreateDcdnDeliverTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDcdnDeliverTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDcdnDeliverTaskWithCallback invokes the dcdn.CreateDcdnDeliverTask API asynchronously
func (client *Client) CreateDcdnDeliverTaskWithCallback(request *CreateDcdnDeliverTaskRequest, callback func(response *CreateDcdnDeliverTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDcdnDeliverTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateDcdnDeliverTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDcdnDeliverTaskRequest is the request struct for api CreateDcdnDeliverTask
type CreateDcdnDeliverTaskRequest struct {
	*requests.RpcRequest
	Reports    string           `position:"Body" name:"Reports"`
	Deliver    string           `position:"Body" name:"Deliver"`
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Schedule   string           `position:"Body" name:"Schedule"`
	Name       string           `position:"Body" name:"Name"`
}

// CreateDcdnDeliverTaskResponse is the response struct for api CreateDcdnDeliverTask
type CreateDcdnDeliverTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDcdnDeliverTaskRequest creates a request to invoke CreateDcdnDeliverTask API
func CreateCreateDcdnDeliverTaskRequest() (request *CreateDcdnDeliverTaskRequest) {
	request = &CreateDcdnDeliverTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "CreateDcdnDeliverTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDcdnDeliverTaskResponse creates a response to parse from CreateDcdnDeliverTask response
func CreateCreateDcdnDeliverTaskResponse() (response *CreateDcdnDeliverTaskResponse) {
	response = &CreateDcdnDeliverTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
