package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLayer7Rule invokes the ddoscoo.DeleteLayer7Rule API synchronously
func (client *Client) DeleteLayer7Rule(request *DeleteLayer7RuleRequest) (response *DeleteLayer7RuleResponse, err error) {
	response = CreateDeleteLayer7RuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLayer7RuleWithChan invokes the ddoscoo.DeleteLayer7Rule API asynchronously
func (client *Client) DeleteLayer7RuleWithChan(request *DeleteLayer7RuleRequest) (<-chan *DeleteLayer7RuleResponse, <-chan error) {
	responseChan := make(chan *DeleteLayer7RuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLayer7Rule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLayer7RuleWithCallback invokes the ddoscoo.DeleteLayer7Rule API asynchronously
func (client *Client) DeleteLayer7RuleWithCallback(request *DeleteLayer7RuleRequest, callback func(response *DeleteLayer7RuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLayer7RuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteLayer7Rule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLayer7RuleRequest is the request struct for api DeleteLayer7Rule
type DeleteLayer7RuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// DeleteLayer7RuleResponse is the response struct for api DeleteLayer7Rule
type DeleteLayer7RuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLayer7RuleRequest creates a request to invoke DeleteLayer7Rule API
func CreateDeleteLayer7RuleRequest() (request *DeleteLayer7RuleRequest) {
	request = &DeleteLayer7RuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DeleteLayer7Rule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLayer7RuleResponse creates a response to parse from DeleteLayer7Rule response
func CreateDeleteLayer7RuleResponse() (response *DeleteLayer7RuleResponse) {
	response = &DeleteLayer7RuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
